/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP224K1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat224;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP224K1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFE56D"));
    private static final int[] PRECOMP_POW2 = new int[]{868209154, -587542221, 579297866, -1014948952, -1470801668, 514782679, -1897982644};
    public int[] x;

    public SecP224K1FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SecP224K1Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecP224K1FieldElement");
    }

    public SecP224K1FieldElement() {
        this.x = Nat224.create();
    }

    public SecP224K1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat224.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat224.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat224.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat224.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP224K1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecP224K1FieldElement secP224K1FieldElement = object;
        Object object = Nat224.create();
        SecP224K1Field.add(secP224K1FieldElement.x, ((SecP224K1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP224K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecP224K1FieldElement secP224K1FieldElement = object;
        Object object = Nat224.create();
        SecP224K1Field.addOne(secP224K1FieldElement.x, (int[])object);
        return new SecP224K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SecP224K1FieldElement secP224K1FieldElement = object;
        Object object = Nat224.create();
        SecP224K1Field.subtract(secP224K1FieldElement.x, ((SecP224K1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP224K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecP224K1FieldElement secP224K1FieldElement = object;
        Object object = Nat224.create();
        SecP224K1Field.multiply(secP224K1FieldElement.x, ((SecP224K1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP224K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat224.create();
        SecP224K1Field.inv(((SecP224K1FieldElement)eCFieldElement).x, nArray);
        SecP224K1Field.multiply(nArray, this.x, nArray);
        return new SecP224K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SecP224K1FieldElement secP224K1FieldElement = object;
        Object object = Nat224.create();
        SecP224K1Field.negate(secP224K1FieldElement.x, (int[])object);
        return new SecP224K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SecP224K1FieldElement secP224K1FieldElement = object;
        Object object = Nat224.create();
        SecP224K1Field.square(secP224K1FieldElement.x, (int[])object);
        return new SecP224K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SecP224K1FieldElement secP224K1FieldElement = object;
        Object object = Nat224.create();
        SecP224K1Field.inv(secP224K1FieldElement.x, (int[])object);
        return new SecP224K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = ((SecP224K1FieldElement)object3).x;
        if (!Nat224.isZero(((SecP224K1FieldElement)object3).x) && !Nat224.isOne(nArray)) {
            int[] nArray2 = Nat224.create();
            Object object = object3 = (Object)nArray2;
            SecP224K1Field.square(nArray, (int[])object3);
            SecP224K1Field.multiply((int[])object, nArray, (int[])object3);
            SecP224K1Field.square((int[])object, (int[])object);
            SecP224K1Field.multiply(nArray2, nArray, (int[])object3);
            int[] nArray3 = Nat224.create();
            SecP224K1Field.square((int[])object3, nArray3);
            SecP224K1Field.multiply(nArray3, nArray, nArray3);
            int[] nArray4 = Nat224.create();
            Object object2 = object3;
            int[] nArray5 = nArray4;
            int[] nArray6 = nArray4;
            SecP224K1Field.squareN(nArray3, 4, nArray4);
            SecP224K1Field.multiply(nArray4, nArray3, nArray4);
            int[] nArray7 = Nat224.create();
            SecP224K1Field.squareN(nArray4, 3, nArray7);
            SecP224K1Field.multiply(nArray7, (int[])object3, nArray7);
            SecP224K1Field.squareN(nArray7, 8, nArray7);
            SecP224K1Field.multiply(nArray7, nArray4, nArray7);
            SecP224K1Field.squareN(nArray7, 4, nArray4);
            SecP224K1Field.multiply(nArray4, nArray3, nArray4);
            SecP224K1Field.squareN(nArray4, 19, nArray3);
            SecP224K1Field.multiply(nArray3, nArray7, nArray3);
            int[] nArray8 = Nat224.create();
            Object object3 = nArray8;
            SecP224K1Field.squareN(nArray3, 42, (int[])object3);
            SecP224K1Field.multiply(nArray8, nArray3, (int[])object3);
            SecP224K1Field.squareN(nArray8, 23, nArray3);
            SecP224K1Field.multiply(nArray3, nArray4, nArray3);
            SecP224K1Field.squareN(nArray3, 84, nArray4);
            SecP224K1Field.multiply(nArray5, (int[])object3, nArray4);
            SecP224K1Field.squareN(nArray6, 20, nArray4);
            SecP224K1Field.multiply(nArray5, nArray7, nArray4);
            SecP224K1Field.squareN(nArray6, 3, nArray4);
            SecP224K1Field.multiply(nArray4, nArray, nArray4);
            SecP224K1Field.squareN(nArray4, 2, nArray4);
            SecP224K1Field.multiply(nArray4, nArray, nArray4);
            SecP224K1Field.squareN(nArray4, 4, nArray4);
            SecP224K1Field.multiply(nArray4, (int[])object2, nArray4);
            SecP224K1Field.square(nArray4, nArray4);
            SecP224K1Field.square(nArray4, (int[])object3);
            if (Nat224.eq(nArray, (int[])object3)) {
                return new SecP224K1FieldElement(nArray4);
            }
            SecP224K1Field.multiply(nArray4, PRECOMP_POW2, nArray4);
            SecP224K1Field.square(nArray4, (int[])object3);
            if (Nat224.eq(nArray, (int[])object3)) {
                return new SecP224K1FieldElement(nArray4);
            }
            return null;
        }
        return object3;
    }

    public boolean equals(Object object) {
        if (object == secP224K1FieldElement2) {
            return true;
        }
        if (!(object instanceof SecP224K1FieldElement)) {
            return false;
        }
        SecP224K1FieldElement secP224K1FieldElement = secP224K1FieldElement2;
        SecP224K1FieldElement secP224K1FieldElement2 = (SecP224K1FieldElement)object;
        return Nat224.eq(secP224K1FieldElement.x, secP224K1FieldElement2.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 7);
    }
}

