/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP256K1Field {
    public static final int[] P = new int[]{-977, -2, -1, -1, -1, -1, -1, -1};
    private static final int[] PExt = new int[]{954529, 1954, 1, 0, 0, 0, 0, 0, -1954, -3, -1, -1, -1, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-954529, -1955, -2, -1, -1, -1, -1, -1, 1953, 2};
    private static final int P7 = -1;
    private static final int PExt15 = -1;
    private static final int PInv33 = 977;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.add(nArray, nArray2, nArray3) != 0 || nArray3[7] == -1 && Nat256.gte(nArray3, P)) {
            Nat.add33To(8, 977, nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat.add(16, nArray, nArray2, nArray3) != 0 || nArray3[15] == -1 && Nat.gte(16, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.incAt(16, nArray3, n);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(8, nArray, nArray2) != 0 || nArray2[7] == -1 && Nat256.gte(nArray2, P)) {
            Nat.add33To(8, 977, nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray = Nat256.fromBigInteger((BigInteger)object);
        object = nArray;
        if (nArray[7] == -1) {
            int[] nArray2 = P;
            if (Nat256.gte((int[])object, P)) {
                Nat256.subFrom(nArray2, (int[])object);
            }
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(8, nArray, 0, nArray2);
        } else {
            int n = Nat256.add(nArray, P, nArray2);
            Nat.shiftDownBit(8, nArray2, n);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int k = 0; k < 8; ++k) {
            n |= nArray[k];
        }
        return (n >>> 1 | n & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat256.createExt();
        Nat256.mul(nArray, nArray2, nArray4);
        SecP256K1Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat256.mulAddTo(nArray, nArray2, nArray3) != 0 || nArray3[15] == -1 && Nat.gte(16, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.incAt(16, nArray3, n);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP256K1Field.isZero(nArray) != 0) {
            Nat256.sub(P, P, nArray2);
        } else {
            Nat256.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[32];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 8);
        } while (Nat.lessThan(8, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP256K1Field.random(secureRandom, nArray);
        } while (SecP256K1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l = Nat256.mul33Add(977, nArray, 8, nArray, 0, nArray2, 0);
        if (Nat256.mul33DWordAdd(977, l, nArray2, 0) != 0 || nArray2[7] == -1 && Nat256.gte(nArray2, P)) {
            Nat.add33To(8, 977, nArray2);
        }
    }

    public static void reduce32(int n, int[] nArray) {
        if (n != 0 && Nat256.mul33WordAdd(977, n, nArray, 0) != 0 || nArray[7] == -1 && Nat256.gte(nArray, P)) {
            Nat.add33To(8, 977, nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        SecP256K1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        SecP256K1Field.reduce(nArray3, nArray2);
        while ((n += -1) > 0) {
            Nat256.square(nArray2, nArray3);
            SecP256K1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.sub(nArray, nArray2, nArray3) != 0) {
            Nat.sub33From(8, 977, nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(16, nArray, nArray2, nArray3) != 0 && Nat.subFrom(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.decAt(16, nArray3, n);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(8, nArray, 0, nArray2) != 0 || nArray2[7] == -1 && Nat256.gte(nArray2, P)) {
            Nat.add33To(8, 977, nArray2);
        }
    }
}

