/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP256R1Field {
    private static final long M = 0xFFFFFFFFL;
    public static final int[] P = new int[]{-1, -1, -1, 0, 0, 0, 1, -1};
    private static final int[] PExt = new int[]{1, 0, 0, -2, -1, -1, -2, 1, -2, 1, -2, 1, 1, -2, 2, -2};
    private static final int P7 = -1;
    private static final int PExt15s1 = Integer.MAX_VALUE;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.add(nArray, nArray2, nArray3) != 0 || nArray3[7] == -1 && Nat256.gte(nArray3, P)) {
            SecP256R1Field.addPInvTo(nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.add(16, nArray, nArray2, nArray3) != 0 || nArray3[15] >>> 1 >= Integer.MAX_VALUE && Nat.gte(16, nArray3, nArray = PExt)) {
            Nat.subFrom(16, PExt, nArray3);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(8, nArray, nArray2) != 0 || nArray2[7] == -1 && Nat256.gte(nArray2, P)) {
            SecP256R1Field.addPInvTo(nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray = Nat256.fromBigInteger((BigInteger)object);
        object = nArray;
        if (nArray[7] == -1) {
            int[] nArray2 = P;
            if (Nat256.gte((int[])object, P)) {
                Nat256.subFrom(nArray2, (int[])object);
            }
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(8, nArray, 0, nArray2);
        } else {
            int n = Nat256.add(nArray, P, nArray2);
            Nat.shiftDownBit(8, nArray2, n);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int k = 0; k < 8; ++k) {
            n |= nArray[k];
        }
        return (n >>> 1 | n & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat256.createExt();
        Nat256.mul(nArray, nArray2, nArray4);
        SecP256R1Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.mulAddTo(nArray, nArray2, nArray3) != 0 || nArray3[15] >>> 1 >= Integer.MAX_VALUE && Nat.gte(16, nArray3, nArray = PExt)) {
            Nat.subFrom(16, PExt, nArray3);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP256R1Field.isZero(nArray) != 0) {
            Nat256.sub(P, P, nArray2);
        } else {
            Nat256.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[32];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 8);
        } while (Nat.lessThan(8, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP256R1Field.random(secureRandom, nArray);
        } while (SecP256R1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l = (long)nArray[8] & 0xFFFFFFFFL;
        long l2 = (long)nArray[9] & 0xFFFFFFFFL;
        long l3 = (long)nArray[10] & 0xFFFFFFFFL;
        long l4 = (long)nArray[11] & 0xFFFFFFFFL;
        long l5 = (long)nArray[12] & 0xFFFFFFFFL;
        long l6 = (long)nArray[13] & 0xFFFFFFFFL;
        long l7 = l6;
        long l8 = l5;
        long l9 = l7;
        long l10 = l4;
        long l11 = l5;
        long l12 = l3;
        long l13 = l4;
        long l14 = l2;
        long l15 = l3;
        long l16 = l;
        l = (long)nArray[14] & 0xFFFFFFFFL;
        l3 = (long)nArray[15] & 0xFFFFFFFFL;
        l4 = l16 - 6L;
        l2 = l4 + l2;
        l5 = l14 + l15;
        l7 = l12 + l13 - l3;
        long l17 = l10 + l11;
        long l18 = l8 + l9;
        long l19 = l6 + l;
        long l20 = l2;
        l2 = l + l3;
        long l21 = l19 - l20;
        long l22 = ((long)nArray[0] & 0xFFFFFFFFL) - l17 - l21 + 0L;
        nArray2[0] = (int)l22;
        l22 >>= 32;
        l22 = ((long)nArray[1] & 0xFFFFFFFFL) + l5 - l18 - l2 + l22;
        nArray2[1] = (int)l22;
        l22 >>= 32;
        l22 = ((long)nArray[2] & 0xFFFFFFFFL) + l7 - l19 + l22;
        nArray2[2] = (int)l22;
        l17 = ((long)nArray[3] & 0xFFFFFFFFL) + (l17 << 1) + l21 - l2 + (l22 >>= 32);
        nArray2[3] = (int)l17;
        l = ((long)nArray[4] & 0xFFFFFFFFL) + (l18 << 1) + l - l5 + (l17 >>= 32);
        nArray2[4] = (int)l;
        l >>= 32;
        l = ((long)nArray[5] & 0xFFFFFFFFL) + (l19 << 1) - l7 + l;
        nArray2[5] = (int)l;
        l >>= 32;
        l = ((long)nArray[6] & 0xFFFFFFFFL) + (l2 << 1) + l21 + l;
        nArray2[6] = (int)l;
        l >>= 32;
        l = ((long)nArray[7] & 0xFFFFFFFFL) + (l3 << 1) + l4 - l7 - l18 + l;
        nArray2[7] = (int)l;
        SecP256R1Field.reduce32((int)((l >> 32) + 6L), nArray2);
    }

    public static void reduce32(int n, int[] nArray) {
        long l = 0L;
        if (n != 0) {
            long l2 = (long)n & 0xFFFFFFFFL;
            l = ((long)nArray[0] & 0xFFFFFFFFL) + l2 + l;
            nArray[0] = (int)l;
            if ((l >>= 32) != 0L) {
                nArray[1] = (int)(l += (long)nArray[1] & 0xFFFFFFFFL);
                l = (l >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
                nArray[2] = (int)l;
                l >>= 32;
            }
            l = ((long)nArray[3] & 0xFFFFFFFFL) - l2 + l;
            nArray[3] = (int)l;
            if ((l >>= 32) != 0L) {
                nArray[4] = (int)(l += (long)nArray[4] & 0xFFFFFFFFL);
                l = (l >> 32) + ((long)nArray[5] & 0xFFFFFFFFL);
                nArray[5] = (int)l;
                l >>= 32;
            }
            l = ((long)nArray[6] & 0xFFFFFFFFL) - l2 + l;
            nArray[6] = (int)l;
            l >>= 32;
            l = ((long)nArray[7] & 0xFFFFFFFFL) + l2 + l;
            nArray[7] = (int)l;
            l >>= 32;
        }
        if (l != 0L || nArray[7] == -1 && Nat256.gte(nArray, P)) {
            SecP256R1Field.addPInvTo(nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        SecP256R1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        SecP256R1Field.reduce(nArray3, nArray2);
        while ((n += -1) > 0) {
            Nat256.square(nArray2, nArray3);
            SecP256R1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.sub(nArray, nArray2, nArray3) != 0) {
            SecP256R1Field.subPInvFrom(nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(16, nArray, nArray2, nArray3) != 0) {
            Nat.addTo(16, PExt, nArray3);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(8, nArray, 0, nArray2) != 0 || nArray2[7] == -1 && Nat256.gte(nArray2, P)) {
            SecP256R1Field.addPInvTo(nArray2);
        }
    }

    private static void addPInvTo(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l;
        if ((l >>= 32) != 0L) {
            nArray[1] = (int)(l += (long)nArray[1] & 0xFFFFFFFFL);
            l = (l >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
            nArray[2] = (int)l;
            l >>= 32;
        }
        l = ((long)nArray[3] & 0xFFFFFFFFL) - 1L + l;
        nArray[3] = (int)l;
        if ((l >>= 32) != 0L) {
            nArray[4] = (int)(l += (long)nArray[4] & 0xFFFFFFFFL);
            l = (l >> 32) + ((long)nArray[5] & 0xFFFFFFFFL);
            nArray[5] = (int)l;
            l >>= 32;
        }
        l = ((long)nArray[6] & 0xFFFFFFFFL) - 1L + l;
        nArray[6] = (int)l;
        nArray[7] = (int)(((long)nArray[7] & 0xFFFFFFFFL) + 1L + (l >>= 32));
    }

    private static void subPInvFrom(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l;
        if ((l >>= 32) != 0L) {
            nArray[1] = (int)(l += (long)nArray[1] & 0xFFFFFFFFL);
            l = (l >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
            nArray[2] = (int)l;
            l >>= 32;
        }
        l = ((long)nArray[3] & 0xFFFFFFFFL) + 1L + l;
        nArray[3] = (int)l;
        if ((l >>= 32) != 0L) {
            nArray[4] = (int)(l += (long)nArray[4] & 0xFFFFFFFFL);
            l = (l >> 32) + ((long)nArray[5] & 0xFFFFFFFFL);
            nArray[5] = (int)l;
            l >>= 32;
        }
        l = ((long)nArray[6] & 0xFFFFFFFFL) + 1L + l;
        nArray[6] = (int)l;
        nArray[7] = (int)(((long)nArray[7] & 0xFFFFFFFFL) - 1L + (l >>= 32));
    }
}

