/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat512;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP521R1Field {
    public static final int[] P = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 511};
    private static final int P16 = 511;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.add(16, nArray, nArray2, nArray3) + nArray[16] + nArray2[16];
        if (n > 511 || n == 511 && Nat.eq(16, nArray3, nArray2 = P)) {
            n = Nat.inc(16, nArray3) + n & 0x1FF;
        }
        nArray3[16] = n;
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int n = Nat.inc(16, nArray, nArray2) + nArray[16];
        if (n > 511 || n == 511 && Nat.eq(16, nArray2, nArray3 = P)) {
            n = Nat.inc(16, nArray2) + n & 0x1FF;
        }
        nArray2[16] = n;
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray;
        if (Nat.eq(17, (int[])(object = (Object)Nat.fromBigInteger(521, (BigInteger)object)), nArray = P)) {
            Nat.zero(17, (int[])object);
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        int n = nArray[16];
        int n2 = Nat.shiftDownBit(16, nArray, n, nArray2);
        nArray2[16] = n >>> 1 | n2 >>> 23;
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int k = 0; k < 17; ++k) {
            n |= nArray[k];
        }
        return (n >>> 1 | n & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat.create(33);
        SecP521R1Field.implMultiply(nArray, nArray2, nArray4);
        SecP521R1Field.reduce(nArray4, nArray3);
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP521R1Field.isZero(nArray) != 0) {
            int[] nArray3 = P;
            Nat.sub(17, nArray3, nArray3, nArray2);
        } else {
            Nat.sub(17, P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[68];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 17);
            nArray[16] = nArray[16] & 0x1FF;
        } while (Nat.lessThan(17, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP521R1Field.random(secureRandom, nArray);
        } while (SecP521R1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int n = nArray[32];
        int n2 = Nat.addTo(16, nArray, nArray2) + ((Nat.shiftDownBits(16, nArray, 16, 9, n, nArray2, 0) >>> 23) + (n >>> 9));
        if (n2 > 511 || n2 == 511 && Nat.eq(16, nArray2, nArray3 = P)) {
            n2 = Nat.inc(16, nArray2) + n2 & 0x1FF;
        }
        nArray2[16] = n2;
    }

    public static void reduce23(int[] nArray) {
        int[] nArray2;
        int n = nArray[16];
        if ((n = Nat.addWordTo(16, n >>> 9, nArray) + (n & 0x1FF)) > 511 || n == 511 && Nat.eq(16, nArray, nArray2 = P)) {
            n = Nat.inc(16, nArray) + n & 0x1FF;
        }
        nArray[16] = n;
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat.create(33);
        SecP521R1Field.implSquare(nArray, nArray3);
        SecP521R1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat.create(33);
        SecP521R1Field.implSquare(nArray, nArray3);
        SecP521R1Field.reduce(nArray3, nArray2);
        while ((n += -1) > 0) {
            SecP521R1Field.implSquare(nArray2, nArray3);
            SecP521R1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.sub(16, nArray, nArray2, nArray3) + nArray[16] - nArray2[16];
        if (n < 0) {
            n = Nat.dec(16, nArray3) + n & 0x1FF;
        }
        nArray3[16] = n;
    }

    public static void twice(int[] nArray, int[] nArray2) {
        int n = nArray[16];
        int n2 = n << 23;
        nArray2[16] = (Nat.shiftUpBit(16, nArray, n2, nArray2) | n << 1) & 0x1FF;
    }

    public static void implMultiply(int[] nArray, int[] nArray2, int[] nArray3) {
        Nat512.mul(nArray, nArray2, nArray3);
        int n = nArray[16];
        int n2 = nArray2[16];
        int n3 = Nat.mul31BothAdd(16, n, nArray2, n2, nArray, nArray3, 16);
        nArray3[32] = n * n2 + n3;
    }

    public static void implSquare(int[] nArray, int[] nArray2) {
        Nat512.square(nArray, nArray2);
        int n = nArray[16];
        int n2 = Nat.mulWordAddTo(16, n << 1, nArray, 0, nArray2, 16);
        nArray2[32] = n * n + n2;
    }
}

