/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT131Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat192;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT131FieldElement
extends ECFieldElement.AbstractF2m {
    public long[] x;

    public SecT131FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.bitLength() <= 131) {
            this.x = SecT131Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecT131FieldElement");
    }

    public SecT131FieldElement() {
        this.x = Nat192.create64();
    }

    public SecT131FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat192.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat192.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat192.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT131Field";
    }

    @Override
    public int getFieldSize() {
        return 131;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecT131FieldElement secT131FieldElement = object;
        Object object = Nat192.create64();
        SecT131Field.add(secT131FieldElement.x, ((SecT131FieldElement)eCFieldElement).x, (long[])object);
        return new SecT131FieldElement((long[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecT131FieldElement secT131FieldElement = object;
        Object object = Nat192.create64();
        SecT131Field.addOne(secT131FieldElement.x, (long[])object);
        return new SecT131FieldElement((long[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecT131FieldElement secT131FieldElement = object;
        Object object = Nat192.create64();
        SecT131Field.multiply(secT131FieldElement.x, ((SecT131FieldElement)eCFieldElement).x, (long[])object);
        return new SecT131FieldElement((long[])object);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement object3) {
        Object object4 = ((SecT131FieldElement)object4).x;
        object = ((SecT131FieldElement)object).x;
        object2 = ((SecT131FieldElement)object2).x;
        object3 = ((SecT131FieldElement)object3).x;
        long[] lArray = Nat.create64(5);
        SecT131Field.multiplyAddToExt((long[])object4, (long[])object, lArray);
        SecT131Field.multiplyAddToExt((long[])object2, (long[])object3, lArray);
        long[] lArray2 = Nat192.create64();
        object4 = lArray2;
        SecT131Field.reduce(lArray, lArray2);
        return new SecT131FieldElement((long[])object4);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        SecT131FieldElement secT131FieldElement = object;
        Object object = Nat192.create64();
        SecT131Field.square(secT131FieldElement.x, (long[])object);
        return new SecT131FieldElement((long[])object);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement object, ECFieldElement object2) {
        Object object3 = ((SecT131FieldElement)object3).x;
        object = ((SecT131FieldElement)object).x;
        object2 = ((SecT131FieldElement)object2).x;
        long[] lArray = Nat.create64(5);
        SecT131Field.squareAddToExt((long[])object3, lArray);
        SecT131Field.multiplyAddToExt((long[])object, (long[])object2, lArray);
        long[] lArray2 = Nat192.create64();
        object3 = lArray2;
        SecT131Field.reduce(lArray, lArray2);
        return new SecT131FieldElement((long[])object3);
    }

    @Override
    public ECFieldElement squarePow(int n) {
        if (n < 1) {
            return object;
        }
        SecT131FieldElement secT131FieldElement = object;
        Object object = Nat192.create64();
        SecT131Field.squareN(secT131FieldElement.x, n, (long[])object);
        return new SecT131FieldElement((long[])object);
    }

    @Override
    public ECFieldElement halfTrace() {
        SecT131FieldElement secT131FieldElement = object;
        Object object = Nat192.create64();
        SecT131Field.halfTrace(secT131FieldElement.x, (long[])object);
        return new SecT131FieldElement((long[])object);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT131Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        SecT131FieldElement secT131FieldElement = object;
        Object object = Nat192.create64();
        SecT131Field.invert(secT131FieldElement.x, (long[])object);
        return new SecT131FieldElement((long[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        SecT131FieldElement secT131FieldElement = object;
        Object object = Nat192.create64();
        SecT131Field.sqrt(secT131FieldElement.x, (long[])object);
        return new SecT131FieldElement((long[])object);
    }

    public int getRepresentation() {
        return 3;
    }

    public int getM() {
        return 131;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 3;
    }

    public int getK3() {
        return 8;
    }

    public boolean equals(Object object) {
        if (object == secT131FieldElement2) {
            return true;
        }
        if (!(object instanceof SecT131FieldElement)) {
            return false;
        }
        SecT131FieldElement secT131FieldElement = secT131FieldElement2;
        SecT131FieldElement secT131FieldElement2 = (SecT131FieldElement)object;
        return Nat192.eq64(secT131FieldElement.x, secT131FieldElement2.x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.x, 0, 3) ^ 0x202F8;
    }
}

