/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT131FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT131R2Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat192;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT131R2Curve
extends ECCurve.AbstractF2m {
    private static final int SECT131R2_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT131R2_AFFINE_ZS;
    public SecT131R2Point infinity;

    public SecT131R2Curve() {
        SecT131R2Curve secT131R2Curve = this;
        super(131, 2, 3, 8);
        secT131R2Curve.infinity = new SecT131R2Point(this, null, null);
        secT131R2Curve.a = secT131R2Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("03E5A88919D7CAFCBF415F07C2176573B2")));
        secT131R2Curve.b = secT131R2Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("04B8266A46C55657AC734CE38F018F2192")));
        secT131R2Curve.order = new BigInteger(1, Hex.decodeStrict("0400000000000000016954A233049BA98F"));
        secT131R2Curve.cofactor = BigInteger.valueOf(2L);
        secT131R2Curve.coord = 6;
    }

    static {
        SecT131FieldElement secT131FieldElement;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecT131FieldElement secT131FieldElement2 = secT131FieldElement;
        secT131FieldElement = new SecT131FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secT131FieldElement2;
        SECT131R2_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecT131R2Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 6;
    }

    @Override
    public int getFieldSize() {
        return 131;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT131FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT131R2Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT131R2Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 131;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 3;
    }

    public int getK3() {
        return 8;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final long[] lArray = new long[n2 * 3 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat192.copy64(((SecT131FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n3);
            Nat192.copy64(((SecT131FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n3 += 3);
            n3 += 3;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                SecT131FieldElement secT131FieldElement;
                SecT131FieldElement secT131FieldElement2 = secT131FieldElement;
                secT131FieldElement = new SecT131FieldElement(lArray2);
                return secT131FieldElement2.SecT131R2Curve.this.createRawPoint(new SecT131FieldElement(lArray3), secT131FieldElement2, SECT131R2_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                long[] lArray4 = Nat192.create64();
                long[] lArray2 = Nat192.create64();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    long l = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 3; ++i2) {
                        long[] lArray3 = lArray;
                        lArray4[i2] = lArray4[i2] ^ lArray[n22 + i2] & l;
                        lArray2[i2] = lArray2[i2] ^ lArray3[n22 + 3 + i2] & l;
                    }
                    n22 += 6;
                }
                return this.createPoint(lArray4, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                long[] lArray4 = Nat192.create64();
                long[] lArray2 = Nat192.create64();
                int n22 = n * 3 * 2;
                for (int k = 0; k < 3; ++k) {
                    long[] lArray3 = lArray;
                    lArray4[k] = lArray3[n22 + k];
                    lArray2[k] = lArray[n22 + 3 + k];
                }
                return this.createPoint(lArray4, lArray2);
            }
        };
    }
}

