/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat192;
import java.math.BigInteger;

public class SecT163Field {
    private static final long M35 = 0x7FFFFFFFFL;
    private static final long M55 = 0x7FFFFFFFFFFFFFL;
    private static final long[] ROOT_Z = new long[]{-5270498306774157648L, 5270498306774195053L, 0x492492492L};

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long l2;
        lArray3[0] = l2 = lArray[0] ^ lArray2[0];
        lArray3[1] = l2 = lArray[1] ^ lArray2[1];
        lArray3[2] = l = lArray[2] ^ lArray2[2];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long l2;
        lArray3[0] = l2 = lArray[0] ^ lArray2[0];
        lArray3[1] = l2 = lArray[1] ^ lArray2[1];
        lArray3[2] = l2 = lArray[2] ^ lArray2[2];
        lArray3[3] = l2 = lArray[3] ^ lArray2[3];
        lArray3[4] = l2 = lArray[4] ^ lArray2[4];
        lArray3[5] = l = lArray[5] ^ lArray2[5];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        long l;
        lArray2[0] = l = lArray[0] ^ 1L;
        lArray2[1] = l = lArray[1];
        lArray2[2] = l = lArray[2];
    }

    private static void addTo(long[] lArray, long[] lArray2) {
        long l;
        long l2;
        long[] lArray3 = lArray2;
        lArray3[0] = l2 = lArray2[0] ^ lArray[0];
        lArray3[1] = l2 = lArray2[1] ^ lArray[1];
        lArray3[2] = l = lArray2[2] ^ lArray[2];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        return Nat.fromBigInteger64(163, bigInteger);
    }

    public static void halfTrace(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat192.createExt64();
        Nat192.copy64(lArray, lArray2);
        for (int k = 1; k < 163; k += 2) {
            SecT163Field.implSquare(lArray2, lArray3);
            SecT163Field.reduce(lArray3, lArray2);
            SecT163Field.implSquare(lArray2, lArray3);
            SecT163Field.reduce(lArray3, lArray2);
            SecT163Field.addTo(lArray, lArray2);
        }
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (!Nat192.isZero64(lArray)) {
            long[] lArray3 = Nat192.create64();
            long[] lArray4 = Nat192.create64();
            long[] lArray5 = lArray3;
            long[] lArray6 = lArray3;
            long[] lArray7 = lArray3;
            SecT163Field.square(lArray, lArray3);
            SecT163Field.squareN(lArray3, 1, lArray4);
            SecT163Field.multiply(lArray3, lArray4, lArray3);
            SecT163Field.squareN(lArray4, 1, lArray4);
            SecT163Field.multiply(lArray7, lArray4, lArray3);
            SecT163Field.squareN(lArray7, 3, lArray4);
            SecT163Field.multiply(lArray3, lArray4, lArray3);
            SecT163Field.squareN(lArray4, 3, lArray4);
            SecT163Field.multiply(lArray6, lArray4, lArray3);
            SecT163Field.squareN(lArray6, 9, lArray4);
            SecT163Field.multiply(lArray3, lArray4, lArray3);
            SecT163Field.squareN(lArray4, 9, lArray4);
            SecT163Field.multiply(lArray5, lArray4, lArray3);
            SecT163Field.squareN(lArray5, 27, lArray4);
            SecT163Field.multiply(lArray3, lArray4, lArray3);
            SecT163Field.squareN(lArray4, 27, lArray4);
            SecT163Field.multiply(lArray3, lArray4, lArray3);
            SecT163Field.squareN(lArray3, 81, lArray4);
            SecT163Field.multiply(lArray3, lArray4, lArray2);
            return;
        }
        throw new IllegalStateException();
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = new long[8];
        SecT163Field.implMultiply(lArray, lArray2, lArray4);
        SecT163Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = lArray;
        lArray = new long[8];
        SecT163Field.implMultiply(lArray4, lArray2, lArray);
        SecT163Field.addExt(lArray3, lArray, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[3];
        long l4 = lArray[4];
        long l5 = lArray[5];
        long l6 = l2;
        l2 = l3 ^ (l5 >>> 35 ^ l5 >>> 32 ^ l5 >>> 29 ^ l5 >>> 28);
        l3 = l6 ^ (l4 << 29 ^ l4 << 32 ^ l4 << 35 ^ l4 << 36);
        l4 = lArray[2] ^ (l5 << 29 ^ l5 << 32 ^ l5 << 35 ^ l5 << 36) ^ (l4 >>> 35 ^ l4 >>> 32 ^ l4 >>> 29 ^ l4 >>> 28);
        long l7 = l ^ (l2 << 29 ^ l2 << 32 ^ l2 << 35 ^ l2 << 36);
        long l8 = l3 ^ (l2 >>> 35 ^ l2 >>> 32 ^ l2 >>> 29 ^ l2 >>> 28);
        l = l4 >>> 35;
        lArray2[0] = l = l7 ^ l ^ l << 3 ^ l << 6 ^ l << 7;
        lArray2[1] = l8;
        lArray2[2] = l8 = l4 & 0x7FFFFFFFFL;
    }

    public static void reduce29(long[] lArray, int n) {
        long l;
        int n2 = n + 2;
        long l2 = lArray[n2];
        long l3 = l = l2 >>> 35;
        lArray[n] = lArray[n] ^ (l3 ^ l3 << 3 ^ l << 6 ^ l << 7);
        lArray[n2] = l2 & 0x7FFFFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l;
        long l2;
        long[] lArray3 = lArray2;
        long[] lArray4 = Nat192.create64();
        long l3 = Interleave.unshuffle(lArray[0]);
        long l4 = Interleave.unshuffle(lArray[1]);
        long l5 = l3 & 0xFFFFFFFFL | l4 << 32;
        lArray4[0] = l4 = l3 >>> 32 | l4 & 0xFFFFFFFF00000000L;
        long l6 = Interleave.unshuffle(lArray[2]);
        l4 = l6 & 0xFFFFFFFFL;
        lArray4[1] = l2 = l6 >>> 32;
        SecT163Field.multiply(lArray4, ROOT_Z, lArray2);
        lArray3[0] = l = lArray2[0] ^ l5;
        lArray3[1] = l = lArray2[1] ^ l4;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat192.createExt64();
        SecT163Field.implSquare(lArray, lArray3);
        SecT163Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        lArray = Nat192.createExt64();
        SecT163Field.implSquare(lArray3, lArray);
        SecT163Field.addExt(lArray2, lArray, lArray2);
    }

    public static void squareN(long[] lArray, int n, long[] lArray2) {
        long[] lArray3 = Nat192.createExt64();
        SecT163Field.implSquare(lArray, lArray3);
        SecT163Field.reduce(lArray3, lArray2);
        while ((n += -1) > 0) {
            SecT163Field.implSquare(lArray2, lArray3);
            SecT163Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)(lArray[0] ^ lArray[2] >>> 29) & 1;
    }

    public static void implCompactExt(long[] lArray) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = lArray[3];
        long l5 = lArray[4];
        long l6 = lArray[5];
        lArray[0] = l ^= l2 << 55;
        lArray[1] = l = l2 >>> 9 ^ l3 << 46;
        lArray[2] = l = l3 >>> 18 ^ l4 << 37;
        lArray[3] = l = l4 >>> 27 ^ l5 << 28;
        lArray[4] = l = l5 >>> 36 ^ l6 << 19;
        lArray[5] = l = l6 >>> 45;
    }

    public static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        l3 = l2 >>> 46 ^ l3 << 18;
        l2 = (l >>> 55 ^ l2 << 9) & 0x7FFFFFFFFFFFFFL;
        long l4 = l & 0x7FFFFFFFFFFFFFL;
        long l5 = lArray2[0];
        long l6 = lArray2[1];
        long l7 = lArray2[2];
        l7 = l6 >>> 46 ^ l7 << 18;
        l6 = (l5 >>> 55 ^ l6 << 9) & 0x7FFFFFFFFFFFFFL;
        long l8 = l5 & 0x7FFFFFFFFFFFFFL;
        long[] lArray4 = new long[10];
        SecT163Field.implMulw(lArray3, l4, l8, lArray4, 0);
        SecT163Field.implMulw(lArray3, l3, l7, lArray4, 2);
        long l9 = l4 ^ l2 ^ l3;
        long l10 = l8 ^ l6 ^ l7;
        SecT163Field.implMulw(lArray3, l9, l10, lArray4, 4);
        l2 = l2 << 1 ^ l3 << 2;
        l7 = l6 << 1 ^ l7 << 2;
        l3 = l4 ^ l2;
        l4 = l8 ^ l7;
        SecT163Field.implMulw(lArray3, l3, l4, lArray4, 6);
        l2 = l9 ^ l2;
        l7 = l10 ^ l7;
        SecT163Field.implMulw(lArray3, l2, l7, lArray4, 8);
        l7 = lArray4[6];
        l2 = l7 ^ lArray4[8];
        l3 = lArray4[7];
        l4 = l3 ^ lArray4[9];
        l7 = l2 << 1 ^ l7;
        l2 = l2 ^ l4 << 1 ^ l3;
        l3 = lArray4[0];
        long l11 = lArray4[1];
        l6 = l11;
        l6 = l6 ^ l3 ^ lArray4[4];
        l8 = l11 ^ lArray4[5];
        long l12 = l4;
        long l13 = l2;
        long l14 = l3 ^ l7;
        l7 = lArray4[2];
        l2 = l14 ^ l7 << 4 ^ l7 << 1;
        l4 = lArray4[3];
        l9 = l6 ^ l13 ^ l4 << 4 ^ l4 << 1;
        l9 ^= l2 >>> 55;
        l2 &= 0x7FFFFFFFFFFFFFL;
        l10 = l8 ^ l12 ^ l9 >>> 55;
        l2 = l2 >>> 1 ^ ((l9 &= 0x7FFFFFFFFFFFFFL) & 1L) << 54;
        l9 = l9 >>> 1 ^ (l10 & 1L) << 54;
        long l15 = l2;
        long l16 = l15 ^ l15 << 1;
        long l17 = l16 ^ l16 << 2;
        long l18 = l17 ^ l17 << 4;
        long l19 = l18 ^ l18 << 8;
        long l20 = l19 ^ l19 << 16;
        l2 = (l20 ^ l20 << 32) & 0x7FFFFFFFFFFFFFL;
        long l21 = l9 ^ l2 >>> 54;
        long l22 = l21 ^ l21 << 1;
        long l23 = l22 ^ l22 << 2;
        long l24 = l23 ^ l23 << 4;
        long l25 = l24 ^ l24 << 8;
        long l26 = l25 ^ l25 << 16;
        l9 = (l26 ^ l26 << 32) & 0x7FFFFFFFFFFFFFL;
        long l27 = l10 >>> 1 ^ l9 >>> 54;
        long l28 = l27 ^ l27 << 1;
        long l29 = l28 ^ l28 << 2;
        long l30 = l29 ^ l29 << 4;
        long l31 = l30 ^ l30 << 8;
        long l32 = l31 ^ l31 << 16;
        l10 = l32 ^ l32 << 32;
        lArray3[0] = l3;
        lArray3[1] = l7 = l6 ^ l2 ^ l7;
        lArray3[2] = l7 = l8 ^ l9 ^ l2 ^ l4;
        lArray3[3] = l7 = l10 ^ l9;
        lArray3[4] = l7 = l10 ^ lArray4[2];
        lArray3[5] = l7 = lArray4[3];
        SecT163Field.implCompactExt(lArray3);
    }

    public static void implMulw(long[] lArray, long l, long l2, long[] lArray2, int n) {
        long l3;
        long l4;
        lArray[1] = l2;
        lArray[2] = l4 = l2 << 1;
        lArray[3] = l3 = l4 ^ l2;
        lArray[4] = l4 <<= 1;
        lArray[5] = l4 ^= l2;
        lArray[6] = l4 = l3 << 1;
        lArray[7] = l2 = l4 ^ l2;
        l2 = 0L;
        l4 = lArray[(int)l & 3];
        int n2 = 47;
        do {
            long l5 = l2;
            int n3 = (int)(l >>> n2);
            l2 = lArray[n3 & 7] ^ lArray[n3 >>> 3 & 7] << 3 ^ lArray[n3 >>> 6 & 7] << 6;
            l4 ^= l2 << n2;
            l2 = l5 ^ l2 >>> -n2;
        } while ((n2 += -9) > 0);
        lArray2[n] = l4 & 0x7FFFFFFFFFFFFFL;
        int n4 = n + 1;
        lArray2[n4] = l = l4 >>> 55 ^ l2 << 9;
    }

    public static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray, 0, 3, lArray2, 0);
    }
}

