/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT163Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat192;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT163FieldElement
extends ECFieldElement.AbstractF2m {
    public long[] x;

    public SecT163FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.bitLength() <= 163) {
            this.x = SecT163Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecT163FieldElement");
    }

    public SecT163FieldElement() {
        this.x = Nat192.create64();
    }

    public SecT163FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat192.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat192.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat192.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT163Field";
    }

    @Override
    public int getFieldSize() {
        return 163;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecT163FieldElement secT163FieldElement = object;
        Object object = Nat192.create64();
        SecT163Field.add(secT163FieldElement.x, ((SecT163FieldElement)eCFieldElement).x, (long[])object);
        return new SecT163FieldElement((long[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecT163FieldElement secT163FieldElement = object;
        Object object = Nat192.create64();
        SecT163Field.addOne(secT163FieldElement.x, (long[])object);
        return new SecT163FieldElement((long[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecT163FieldElement secT163FieldElement = object;
        Object object = Nat192.create64();
        SecT163Field.multiply(secT163FieldElement.x, ((SecT163FieldElement)eCFieldElement).x, (long[])object);
        return new SecT163FieldElement((long[])object);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement object3) {
        Object object4 = ((SecT163FieldElement)object4).x;
        object = ((SecT163FieldElement)object).x;
        object2 = ((SecT163FieldElement)object2).x;
        object3 = ((SecT163FieldElement)object3).x;
        long[] lArray = Nat192.createExt64();
        SecT163Field.multiplyAddToExt((long[])object4, (long[])object, lArray);
        SecT163Field.multiplyAddToExt((long[])object2, (long[])object3, lArray);
        long[] lArray2 = Nat192.create64();
        object4 = lArray2;
        SecT163Field.reduce(lArray, lArray2);
        return new SecT163FieldElement((long[])object4);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        SecT163FieldElement secT163FieldElement = object;
        Object object = Nat192.create64();
        SecT163Field.square(secT163FieldElement.x, (long[])object);
        return new SecT163FieldElement((long[])object);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement object, ECFieldElement object2) {
        Object object3 = ((SecT163FieldElement)object3).x;
        object = ((SecT163FieldElement)object).x;
        object2 = ((SecT163FieldElement)object2).x;
        long[] lArray = Nat192.createExt64();
        SecT163Field.squareAddToExt((long[])object3, lArray);
        SecT163Field.multiplyAddToExt((long[])object, (long[])object2, lArray);
        long[] lArray2 = Nat192.create64();
        object3 = lArray2;
        SecT163Field.reduce(lArray, lArray2);
        return new SecT163FieldElement((long[])object3);
    }

    @Override
    public ECFieldElement squarePow(int n) {
        if (n < 1) {
            return object;
        }
        SecT163FieldElement secT163FieldElement = object;
        Object object = Nat192.create64();
        SecT163Field.squareN(secT163FieldElement.x, n, (long[])object);
        return new SecT163FieldElement((long[])object);
    }

    @Override
    public ECFieldElement halfTrace() {
        SecT163FieldElement secT163FieldElement = object;
        Object object = Nat192.create64();
        SecT163Field.halfTrace(secT163FieldElement.x, (long[])object);
        return new SecT163FieldElement((long[])object);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT163Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        SecT163FieldElement secT163FieldElement = object;
        Object object = Nat192.create64();
        SecT163Field.invert(secT163FieldElement.x, (long[])object);
        return new SecT163FieldElement((long[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        SecT163FieldElement secT163FieldElement = object;
        Object object = Nat192.create64();
        SecT163Field.sqrt(secT163FieldElement.x, (long[])object);
        return new SecT163FieldElement((long[])object);
    }

    public int getRepresentation() {
        return 3;
    }

    public int getM() {
        return 163;
    }

    public int getK1() {
        return 3;
    }

    public int getK2() {
        return 6;
    }

    public int getK3() {
        return 7;
    }

    public boolean equals(Object object) {
        if (object == secT163FieldElement2) {
            return true;
        }
        if (!(object instanceof SecT163FieldElement)) {
            return false;
        }
        SecT163FieldElement secT163FieldElement = secT163FieldElement2;
        SecT163FieldElement secT163FieldElement2 = (SecT163FieldElement)object;
        return Nat192.eq64(secT163FieldElement.x, secT163FieldElement2.x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.x, 0, 3) ^ 0x27FB3;
    }
}

