/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT163FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT163R2Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat192;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT163R2Curve
extends ECCurve.AbstractF2m {
    private static final int SECT163R2_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT163R2_AFFINE_ZS;
    public SecT163R2Point infinity;

    public SecT163R2Curve() {
        SecT163R2Curve secT163R2Curve = this;
        super(163, 3, 6, 7);
        secT163R2Curve.infinity = new SecT163R2Point(this, null, null);
        secT163R2Curve.a = secT163R2Curve.fromBigInteger(BigInteger.valueOf(1L));
        secT163R2Curve.b = secT163R2Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("020A601907B8C953CA1481EB10512F78744A3205FD")));
        secT163R2Curve.order = new BigInteger(1, Hex.decodeStrict("040000000000000000000292FE77E70C12A4234C33"));
        secT163R2Curve.cofactor = BigInteger.valueOf(2L);
        secT163R2Curve.coord = 6;
    }

    static {
        SecT163FieldElement secT163FieldElement;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecT163FieldElement secT163FieldElement2 = secT163FieldElement;
        secT163FieldElement = new SecT163FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secT163FieldElement2;
        SECT163R2_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecT163R2Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 6;
    }

    @Override
    public int getFieldSize() {
        return 163;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT163FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT163R2Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT163R2Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 163;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 3;
    }

    public int getK2() {
        return 6;
    }

    public int getK3() {
        return 7;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final long[] lArray = new long[n2 * 3 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat192.copy64(((SecT163FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n3);
            Nat192.copy64(((SecT163FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n3 += 3);
            n3 += 3;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                SecT163FieldElement secT163FieldElement;
                SecT163FieldElement secT163FieldElement2 = secT163FieldElement;
                secT163FieldElement = new SecT163FieldElement(lArray2);
                return secT163FieldElement2.SecT163R2Curve.this.createRawPoint(new SecT163FieldElement(lArray3), secT163FieldElement2, SECT163R2_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                long[] lArray4 = Nat192.create64();
                long[] lArray2 = Nat192.create64();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    long l = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 3; ++i2) {
                        long[] lArray3 = lArray;
                        lArray4[i2] = lArray4[i2] ^ lArray[n22 + i2] & l;
                        lArray2[i2] = lArray2[i2] ^ lArray3[n22 + 3 + i2] & l;
                    }
                    n22 += 6;
                }
                return this.createPoint(lArray4, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                long[] lArray4 = Nat192.create64();
                long[] lArray2 = Nat192.create64();
                int n22 = n * 3 * 2;
                for (int k = 0; k < 3; ++k) {
                    long[] lArray3 = lArray;
                    lArray4[k] = lArray3[n22 + k];
                    lArray2[k] = lArray[n22 + 3 + k];
                }
                return this.createPoint(lArray4, lArray2);
            }
        };
    }
}

