/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat448;
import java.math.BigInteger;

public class SecT409Field {
    private static final long M25 = 0x1FFFFFFL;
    private static final long M59 = 0x7FFFFFFFFFFFFFFL;

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long l2;
        lArray3[0] = l2 = lArray[0] ^ lArray2[0];
        lArray3[1] = l2 = lArray[1] ^ lArray2[1];
        lArray3[2] = l2 = lArray[2] ^ lArray2[2];
        lArray3[3] = l2 = lArray[3] ^ lArray2[3];
        lArray3[4] = l2 = lArray[4] ^ lArray2[4];
        lArray3[5] = l2 = lArray[5] ^ lArray2[5];
        lArray3[6] = l = lArray[6] ^ lArray2[6];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int k = 0; k < 13; ++k) {
            lArray3[k] = lArray[k] ^ lArray2[k];
        }
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        long l;
        lArray2[0] = l = lArray[0] ^ 1L;
        lArray2[1] = l = lArray[1];
        lArray2[2] = l = lArray[2];
        lArray2[3] = l = lArray[3];
        lArray2[4] = l = lArray[4];
        lArray2[5] = l = lArray[5];
        lArray2[6] = l = lArray[6];
    }

    private static void addTo(long[] lArray, long[] lArray2) {
        long l;
        long l2;
        long[] lArray3 = lArray2;
        lArray3[0] = l2 = lArray2[0] ^ lArray[0];
        lArray3[1] = l2 = lArray2[1] ^ lArray[1];
        lArray3[2] = l2 = lArray2[2] ^ lArray[2];
        lArray3[3] = l2 = lArray2[3] ^ lArray[3];
        lArray3[4] = l2 = lArray2[4] ^ lArray[4];
        lArray3[5] = l2 = lArray2[5] ^ lArray[5];
        lArray3[6] = l = lArray2[6] ^ lArray[6];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        return Nat.fromBigInteger64(409, bigInteger);
    }

    public static void halfTrace(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat.create64(13);
        Nat448.copy64(lArray, lArray2);
        for (int k = 1; k < 409; k += 2) {
            SecT409Field.implSquare(lArray2, lArray3);
            SecT409Field.reduce(lArray3, lArray2);
            SecT409Field.implSquare(lArray2, lArray3);
            SecT409Field.reduce(lArray3, lArray2);
            SecT409Field.addTo(lArray, lArray2);
        }
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (!Nat448.isZero64(lArray)) {
            long[] lArray3 = Nat448.create64();
            long[] lArray4 = Nat448.create64();
            long[] lArray5 = Nat448.create64();
            long[] lArray6 = lArray3;
            SecT409Field.square(lArray, lArray3);
            SecT409Field.squareN(lArray3, 1, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray3);
            SecT409Field.squareN(lArray4, 1, lArray4);
            SecT409Field.multiply(lArray6, lArray4, lArray3);
            SecT409Field.squareN(lArray6, 3, lArray4);
            SecT409Field.multiply(lArray6, lArray4, lArray3);
            SecT409Field.squareN(lArray6, 6, lArray4);
            SecT409Field.multiply(lArray6, lArray4, lArray3);
            SecT409Field.squareN(lArray6, 12, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray5);
            SecT409Field.squareN(lArray5, 24, lArray3);
            SecT409Field.squareN(lArray3, 24, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray3);
            SecT409Field.squareN(lArray3, 48, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray3);
            SecT409Field.squareN(lArray3, 96, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray3);
            SecT409Field.squareN(lArray3, 192, lArray4);
            SecT409Field.multiply(lArray3, lArray4, lArray3);
            SecT409Field.multiply(lArray3, lArray5, lArray2);
            return;
        }
        throw new IllegalStateException();
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat448.createExt64();
        SecT409Field.implMultiply(lArray, lArray2, lArray4);
        SecT409Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = lArray;
        lArray = Nat448.createExt64();
        SecT409Field.implMultiply(lArray4, lArray2, lArray);
        SecT409Field.addExt(lArray3, lArray, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l;
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[3];
        long l6 = lArray[4];
        long l7 = lArray[5];
        long l8 = lArray[7];
        long l9 = lArray[12];
        l7 ^= l9 << 39;
        long l10 = lArray[6] ^ (l9 >>> 25 ^ l9 << 62);
        l8 ^= l9 >>> 2;
        l9 = lArray[11];
        l6 ^= l9 << 39;
        l7 ^= l9 >>> 25 ^ l9 << 62;
        l9 = l10 ^ l9 >>> 2;
        long[] lArray3 = lArray2;
        long l11 = l3;
        l3 = lArray[10];
        l5 ^= l3 << 39;
        long l12 = l6 ^ (l3 >>> 25 ^ l3 << 62);
        l3 = l7 ^ l3 >>> 2;
        l6 = lArray[9];
        l4 ^= l6 << 39;
        l5 ^= l6 >>> 25 ^ l6 << 62;
        l6 = l12 ^ l6 >>> 2;
        long l13 = lArray[8];
        l7 = l13;
        long l14 = l2;
        l2 = l4 ^ (l7 >>> 25 ^ l7 << 62);
        l4 = l5 ^ l7 >>> 2;
        l5 = l14 ^ l8 << 39;
        l7 = l9 >>> 25;
        lArray2[0] = l = l5 ^ l7;
        lArray3[1] = l = l11 ^ l13 << 39 ^ (l8 >>> 25 ^ l8 << 62) ^ l7 << 23;
        lArray3[2] = l2 ^= l8 >>> 2;
        lArray3[3] = l4;
        lArray3[4] = l6;
        lArray2[5] = l3;
        lArray2[6] = l = l9 & 0x1FFFFFFL;
    }

    public static void reduce39(long[] lArray, int n) {
        int n2 = n + 6;
        long l = lArray[n2];
        long[] lArray2 = lArray;
        long l2 = l >>> 25;
        lArray2[n] = lArray[n] ^ l2;
        int n3 = n + 1;
        lArray[n3] = l2 = lArray2[n3] ^ l2 << 23;
        lArray[n2] = l & 0x1FFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l;
        long l2 = Interleave.unshuffle(lArray[0]);
        long l3 = Interleave.unshuffle(lArray[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        l3 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        long l5 = Interleave.unshuffle(lArray[2]);
        long l6 = Interleave.unshuffle(lArray[3]);
        long l7 = l5 & 0xFFFFFFFFL | l6 << 32;
        l6 = l5 >>> 32 | l6 & 0xFFFFFFFF00000000L;
        long l8 = Interleave.unshuffle(lArray[4]);
        long l9 = Interleave.unshuffle(lArray[5]);
        long l10 = l8 & 0xFFFFFFFFL | l9 << 32;
        l9 = l8 >>> 32 | l9 & 0xFFFFFFFF00000000L;
        long l11 = Interleave.unshuffle(lArray[6]);
        long l12 = l11 & 0xFFFFFFFFL;
        long l13 = l11 >>> 32;
        lArray2[0] = l = l4 ^ l3 << 44;
        lArray2[1] = l = l7 ^ l6 << 44 ^ l3 >>> 20;
        lArray2[2] = l = l10 ^ l9 << 44 ^ l6 >>> 20;
        lArray2[3] = l = l12 ^ l13 << 44 ^ l9 >>> 20 ^ l3 << 13;
        lArray2[4] = l = l13 >>> 20 ^ l6 << 13 ^ l3 >>> 51;
        lArray2[5] = l = l9 << 13 ^ l6 >>> 51;
        lArray2[6] = l = l13 << 13 ^ l9 >>> 51;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat.create64(13);
        SecT409Field.implSquare(lArray, lArray3);
        SecT409Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        lArray = Nat.create64(13);
        SecT409Field.implSquare(lArray3, lArray);
        SecT409Field.addExt(lArray2, lArray, lArray2);
    }

    public static void squareN(long[] lArray, int n, long[] lArray2) {
        long[] lArray3 = Nat.create64(13);
        SecT409Field.implSquare(lArray, lArray3);
        SecT409Field.reduce(lArray3, lArray2);
        while ((n += -1) > 0) {
            SecT409Field.implSquare(lArray2, lArray3);
            SecT409Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)lArray[0] & 1;
    }

    public static void implCompactExt(long[] lArray) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = lArray[3];
        long l5 = lArray[4];
        long l6 = lArray[5];
        long l7 = lArray[6];
        long l8 = lArray[7];
        long l9 = lArray[8];
        long l10 = lArray[9];
        long l11 = lArray[10];
        long l12 = lArray[11];
        long l13 = lArray[12];
        long l14 = lArray[13];
        lArray[0] = l ^= l2 << 59;
        lArray[1] = l = l2 >>> 5 ^ l3 << 54;
        lArray[2] = l = l3 >>> 10 ^ l4 << 49;
        lArray[3] = l = l4 >>> 15 ^ l5 << 44;
        lArray[4] = l = l5 >>> 20 ^ l6 << 39;
        lArray[5] = l = l6 >>> 25 ^ l7 << 34;
        lArray[6] = l = l7 >>> 30 ^ l8 << 29;
        lArray[7] = l = l8 >>> 35 ^ l9 << 24;
        lArray[8] = l = l9 >>> 40 ^ l10 << 19;
        lArray[9] = l = l10 >>> 45 ^ l11 << 14;
        lArray[10] = l = l11 >>> 50 ^ l12 << 9;
        lArray[11] = l = l12 >>> 55 ^ l13 << 4 ^ l14 << 63;
        lArray[12] = l = l14 >>> 1;
    }

    public static void implExpand(long[] lArray, long[] lArray2) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = lArray[3];
        long l5 = lArray[4];
        long l6 = lArray[5];
        long l7 = l;
        long l8 = lArray[6];
        lArray2[0] = l &= 0x7FFFFFFFFFFFFFFL;
        lArray2[1] = l = (l7 >>> 59 ^ l2 << 5) & 0x7FFFFFFFFFFFFFFL;
        lArray2[2] = l = (l2 >>> 54 ^ l3 << 10) & 0x7FFFFFFFFFFFFFFL;
        lArray2[3] = l = (l3 >>> 49 ^ l4 << 15) & 0x7FFFFFFFFFFFFFFL;
        lArray2[4] = l = (l4 >>> 44 ^ l5 << 20) & 0x7FFFFFFFFFFFFFFL;
        lArray2[5] = l = (l5 >>> 39 ^ l6 << 25) & 0x7FFFFFFFFFFFFFFL;
        lArray2[6] = l8 = l6 >>> 34 ^ l8 << 30;
    }

    public static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long l2;
        long[] lArray4 = lArray2;
        long[] lArray5 = lArray;
        lArray = new long[7];
        lArray2 = new long[7];
        SecT409Field.implExpand(lArray5, lArray);
        SecT409Field.implExpand(lArray4, lArray2);
        long[] lArray6 = new long[8];
        for (int k = 0; k < 7; ++k) {
            l2 = lArray[k];
            l = lArray2[k];
            int n = k << 1;
            SecT409Field.implMulwAcc(lArray6, l2, l, lArray3, n);
        }
        long l3 = lArray3[0];
        l2 = lArray3[1];
        long l4 = l3 ^ lArray3[2];
        l = l4;
        long l5 = l2;
        lArray3[1] = l2 = l ^ l2;
        l = l5 ^ lArray3[3];
        long l6 = l4 ^ lArray3[4];
        long l7 = l6;
        long l8 = l;
        lArray3[2] = l = l7 ^ l;
        l7 = l8 ^ lArray3[5];
        long l9 = l6 ^ lArray3[6];
        long l10 = l9;
        long l11 = l7;
        lArray3[3] = l7 = l10 ^ l7;
        l10 = l11 ^ lArray3[7];
        long l12 = l9 ^ lArray3[8];
        long l13 = l12;
        long l14 = l10;
        lArray3[4] = l10 = l13 ^ l10;
        l13 = l14 ^ lArray3[9];
        long l15 = l12 ^ lArray3[10];
        long l16 = l15;
        long l17 = l13;
        lArray3[5] = l13 = l16 ^ l13;
        l16 = l17 ^ lArray3[11];
        long l18 = l15 ^ lArray3[12];
        long l19 = l18 ^ l16;
        long l20 = l2;
        long l21 = l3;
        lArray3[6] = l19;
        l3 = l18 ^ (l16 ^ lArray3[13]);
        lArray3[7] = l2 = l21 ^ l3;
        lArray3[8] = l2 = l20 ^ l3;
        lArray3[9] = l2 = l ^ l3;
        lArray3[10] = l2 = l7 ^ l3;
        lArray3[11] = l2 = l10 ^ l3;
        lArray3[12] = l2 = l13 ^ l3;
        lArray3[13] = l3 = l19 ^ l3;
        l3 = lArray[0] ^ lArray[1];
        l2 = lArray2[0] ^ lArray2[1];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 1);
        l3 = lArray[0] ^ lArray[2];
        l2 = lArray2[0] ^ lArray2[2];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 2);
        l3 = lArray[0] ^ lArray[3];
        l2 = lArray2[0] ^ lArray2[3];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 3);
        l3 = lArray[1] ^ lArray[2];
        l2 = lArray2[1] ^ lArray2[2];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 3);
        l3 = lArray[0] ^ lArray[4];
        l2 = lArray2[0] ^ lArray2[4];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 4);
        l3 = lArray[1] ^ lArray[3];
        l2 = lArray2[1] ^ lArray2[3];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 4);
        l3 = lArray[0] ^ lArray[5];
        l2 = lArray2[0] ^ lArray2[5];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 5);
        l3 = lArray[1] ^ lArray[4];
        l2 = lArray2[1] ^ lArray2[4];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 5);
        l3 = lArray[2] ^ lArray[3];
        l2 = lArray2[2] ^ lArray2[3];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 5);
        l3 = lArray[0] ^ lArray[6];
        l2 = lArray2[0] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 6);
        l3 = lArray[1] ^ lArray[5];
        l2 = lArray2[1] ^ lArray2[5];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 6);
        l3 = lArray[2] ^ lArray[4];
        l2 = lArray2[2] ^ lArray2[4];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 6);
        l3 = lArray[1] ^ lArray[6];
        l2 = lArray2[1] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 7);
        l3 = lArray[2] ^ lArray[5];
        l2 = lArray2[2] ^ lArray2[5];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 7);
        l3 = lArray[3] ^ lArray[4];
        l2 = lArray2[3] ^ lArray2[4];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 7);
        l3 = lArray[2] ^ lArray[6];
        l2 = lArray2[2] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 8);
        l3 = lArray[3] ^ lArray[5];
        l2 = lArray2[3] ^ lArray2[5];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 8);
        l3 = lArray[3] ^ lArray[6];
        l2 = lArray2[3] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 9);
        l3 = lArray[4] ^ lArray[5];
        l2 = lArray2[4] ^ lArray2[5];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 9);
        l3 = lArray[4] ^ lArray[6];
        l2 = lArray2[4] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l3, l2, lArray3, 10);
        l3 = lArray[5] ^ lArray[6];
        long l22 = lArray2[5] ^ lArray2[6];
        SecT409Field.implMulwAcc(lArray6, l3, l22, lArray3, 11);
        SecT409Field.implCompactExt(lArray3);
    }

    public static void implMulwAcc(long[] lArray, long l, long l2, long[] lArray2, int n) {
        long l3;
        long l4;
        lArray[1] = l2;
        lArray[2] = l4 = l2 << 1;
        lArray[3] = l3 = l4 ^ l2;
        lArray[4] = l4 <<= 1;
        lArray[5] = l4 ^= l2;
        lArray[6] = l4 = l3 << 1;
        lArray[7] = l2 = l4 ^ l2;
        int n2 = (int)l;
        l4 = 0L;
        long l5 = lArray[n2 & 7] ^ lArray[n2 >>> 3 & 7] << 3;
        int n3 = 54;
        do {
            long l6 = l4;
            int n4 = (int)(l >>> n3);
            l4 = lArray[n4 & 7] ^ lArray[n4 >>> 3 & 7] << 3;
            l5 ^= l4 << n3;
            l4 = l6 ^ l4 >>> -n3;
        } while ((n3 += -6) > 0);
        long[] lArray3 = lArray2;
        lArray3[n] = lArray2[n] ^ l5 & 0x7FFFFFFFFFFFFFFL;
        int n5 = n + 1;
        lArray2[n5] = l = lArray3[n5] ^ (l5 >>> 59 ^ l4 << 5);
    }

    public static void implSquare(long[] lArray, long[] lArray2) {
        long l;
        Interleave.expand64To128(lArray, 0, 6, lArray2, 0);
        lArray2[12] = l = Interleave.expand32to64((int)lArray[6]);
    }
}

