/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat576;
import java.math.BigInteger;

public class SecT571Field {
    private static final long M59 = 0x7FFFFFFFFFFFFFFL;
    private static final long[] ROOT_Z = new long[]{3161836309350906777L, -7642453882179322845L, -3821226941089661423L, 7312758566309945096L, -556661012383879292L, 8945041530681231562L, -4750851271514160027L, 6847946401097695794L, 541669439031730457L};

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int k = 0; k < 9; ++k) {
            lArray3[k] = lArray[k] ^ lArray2[k];
        }
    }

    private static void add(long[] lArray, int n, long[] lArray2, int n2, long[] lArray3, int n3) {
        for (int k = 0; k < 9; ++k) {
            long l;
            int n4 = n3 + k;
            lArray3[n4] = l = lArray[n + k] ^ lArray2[n2 + k];
        }
    }

    public static void addBothTo(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int k = 0; k < 9; ++k) {
            lArray3[k] = lArray3[k] ^ (lArray[k] ^ lArray2[k]);
        }
    }

    private static void addBothTo(long[] lArray, int n, long[] lArray2, int n2, long[] lArray3, int n3) {
        for (int k = 0; k < 9; ++k) {
            long l;
            int n4 = n3 + k;
            lArray3[n4] = l = lArray3[n4] ^ (lArray[n + k] ^ lArray2[n2 + k]);
        }
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int k = 0; k < 18; ++k) {
            lArray3[k] = lArray[k] ^ lArray2[k];
        }
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        long l;
        lArray2[0] = l = lArray[0] ^ 1L;
        for (int k = 1; k < 9; ++k) {
            long l2;
            lArray2[k] = l2 = lArray[k];
        }
    }

    private static void addTo(long[] lArray, long[] lArray2) {
        for (int k = 0; k < 9; ++k) {
            lArray2[k] = lArray2[k] ^ lArray[k];
        }
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        return Nat.fromBigInteger64(571, bigInteger);
    }

    public static void halfTrace(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat576.createExt64();
        Nat576.copy64(lArray, lArray2);
        for (int k = 1; k < 571; k += 2) {
            SecT571Field.implSquare(lArray2, lArray3);
            SecT571Field.reduce(lArray3, lArray2);
            SecT571Field.implSquare(lArray2, lArray3);
            SecT571Field.reduce(lArray3, lArray2);
            SecT571Field.addTo(lArray, lArray2);
        }
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (!Nat576.isZero64(lArray)) {
            long[] lArray3 = Nat576.create64();
            long[] lArray4 = Nat576.create64();
            long[] lArray5 = lArray3;
            long[] lArray6 = lArray3;
            long[] lArray7 = lArray3;
            long[] lArray8 = Nat576.create64();
            long[] lArray9 = lArray3;
            long[] lArray10 = lArray3;
            SecT571Field.square(lArray, lArray8);
            SecT571Field.square(lArray8, lArray3);
            SecT571Field.square(lArray10, lArray4);
            SecT571Field.multiply(lArray10, lArray4, lArray3);
            SecT571Field.squareN(lArray10, 2, lArray4);
            SecT571Field.multiply(lArray10, lArray4, lArray3);
            SecT571Field.multiply(lArray10, lArray8, lArray3);
            SecT571Field.squareN(lArray10, 5, lArray4);
            SecT571Field.multiply(lArray3, lArray4, lArray3);
            SecT571Field.squareN(lArray4, 5, lArray4);
            SecT571Field.multiply(lArray9, lArray4, lArray3);
            SecT571Field.squareN(lArray9, 15, lArray4);
            SecT571Field.multiply(lArray3, lArray4, lArray8);
            SecT571Field.squareN(lArray8, 30, lArray3);
            SecT571Field.squareN(lArray6, 30, lArray4);
            SecT571Field.multiply(lArray7, lArray4, lArray3);
            SecT571Field.squareN(lArray6, 60, lArray4);
            SecT571Field.multiply(lArray7, lArray4, lArray3);
            SecT571Field.squareN(lArray4, 60, lArray4);
            SecT571Field.multiply(lArray5, lArray4, lArray3);
            SecT571Field.squareN(lArray5, 180, lArray4);
            SecT571Field.multiply(lArray3, lArray4, lArray3);
            SecT571Field.squareN(lArray4, 180, lArray4);
            SecT571Field.multiply(lArray3, lArray4, lArray3);
            SecT571Field.multiply(lArray3, lArray8, lArray2);
            return;
        }
        throw new IllegalStateException();
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat576.createExt64();
        SecT571Field.implMultiply(lArray, lArray2, lArray4);
        SecT571Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = lArray;
        lArray = Nat576.createExt64();
        SecT571Field.implMultiply(lArray4, lArray2, lArray);
        SecT571Field.addExt(lArray3, lArray, lArray3);
    }

    public static void multiplyPrecomp(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat576.createExt64();
        SecT571Field.implMultiplyPrecomp(lArray, lArray2, lArray4);
        SecT571Field.reduce(lArray4, lArray3);
    }

    public static void multiplyPrecompAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = lArray;
        lArray = Nat576.createExt64();
        SecT571Field.implMultiplyPrecomp(lArray4, lArray2, lArray);
        SecT571Field.addExt(lArray3, lArray, lArray3);
    }

    public static long[] precompMultiplicand(long[] lArray) {
        long[] lArray2 = lArray;
        lArray = new long[288];
        System.arraycopy(lArray2, 0, lArray, 9, 9);
        int n = 0;
        for (int k = 7; k > 0; --k) {
            int n2 = (n += 18) >>> 1;
            Nat.shiftUpBit64(9, lArray, n2, 0L, lArray, n);
            SecT571Field.reduce5(lArray, n);
            n2 = n + 9;
            SecT571Field.add(lArray, 9, lArray, n, lArray, n2);
        }
        Nat.shiftUpBits64(144, lArray, 0, 4, 0L, lArray, 144);
        return lArray;
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l = lArray[17];
        long l2 = lArray[9] ^ l >>> 59 ^ l >>> 57 ^ l >>> 54 ^ l >>> 49;
        l = lArray[8] ^ l << 5 ^ l << 7 ^ l << 10 ^ l << 15;
        for (int k = 16; k >= 10; --k) {
            long l3;
            long l4 = l;
            l = lArray[k];
            int n = k - 8;
            lArray2[n] = l3 = l4 ^ l >>> 59 ^ l >>> 57 ^ l >>> 54 ^ l >>> 49;
            l = lArray[k - 9] ^ l << 5 ^ l << 7 ^ l << 10 ^ l << 15;
        }
        lArray2[1] = l = l ^ l2 >>> 59 ^ l2 >>> 57 ^ l2 >>> 54 ^ l2 >>> 49;
        l = lArray[0] ^ l2 << 5 ^ l2 << 7 ^ l2 << 10 ^ l2 << 15;
        l2 = lArray2[8];
        long l5 = l2 >>> 59;
        lArray2[0] = l5 = l ^ l5 ^ l5 << 2 ^ l5 << 5 ^ l5 << 10;
        lArray2[8] = l5 = l2 & 0x7FFFFFFFFFFFFFFL;
    }

    public static void reduce5(long[] lArray, int n) {
        long l;
        int n2 = n + 8;
        long l2 = lArray[n2];
        long l3 = l = l2 >>> 59;
        lArray[n] = lArray[n] ^ (l3 ^ l3 << 2 ^ l << 5 ^ l << 10);
        lArray[n2] = l2 & 0x7FFFFFFFFFFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l;
        long[] lArray3 = Nat576.create64();
        long[] lArray4 = Nat576.create64();
        int n = 0;
        for (int k = 0; k < 4; ++k) {
            long l2;
            long l3 = Interleave.unshuffle(lArray[n++]);
            long l4 = l2 = l3;
            l2 = Interleave.unshuffle(lArray[n++]);
            lArray3[k] = l4 & 0xFFFFFFFFL | l2 << 32;
            lArray4[k] = l3 >>> 32 | l2 & 0xFFFFFFFF00000000L;
        }
        long l5 = Interleave.unshuffle(lArray[n]);
        lArray3[4] = l = l5 & 0xFFFFFFFFL;
        lArray4[4] = l = l5 >>> 32;
        SecT571Field.multiply(lArray4, ROOT_Z, lArray2);
        SecT571Field.add(lArray2, lArray3, lArray2);
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat576.createExt64();
        SecT571Field.implSquare(lArray, lArray3);
        SecT571Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        lArray = Nat576.createExt64();
        SecT571Field.implSquare(lArray3, lArray);
        SecT571Field.addExt(lArray2, lArray, lArray2);
    }

    public static void squareN(long[] lArray, int n, long[] lArray2) {
        long[] lArray3 = Nat576.createExt64();
        SecT571Field.implSquare(lArray, lArray3);
        SecT571Field.reduce(lArray3, lArray2);
        while ((n += -1) > 0) {
            SecT571Field.implSquare(lArray2, lArray3);
            SecT571Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        long l = lArray[8];
        return (int)(lArray[0] ^ l >>> 49 ^ l >>> 57) & 1;
    }

    public static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long l2;
        long[] lArray4 = new long[16];
        for (int k = 0; k < 9; ++k) {
            l2 = lArray[k];
            l = lArray2[k];
            int n = k << 1;
            SecT571Field.implMulwAcc(lArray4, l2, l, lArray3, n);
        }
        long l3 = lArray3[0];
        l2 = lArray3[1];
        long l4 = l3 ^ lArray3[2];
        l = l4;
        long l5 = l2;
        lArray3[1] = l2 = l ^ l2;
        l = l5 ^ lArray3[3];
        long l6 = l4 ^ lArray3[4];
        long l7 = l6;
        long l8 = l;
        lArray3[2] = l = l7 ^ l;
        l7 = l8 ^ lArray3[5];
        long l9 = l6 ^ lArray3[6];
        long l10 = l9;
        long l11 = l7;
        lArray3[3] = l7 = l10 ^ l7;
        l10 = l11 ^ lArray3[7];
        long l12 = l9 ^ lArray3[8];
        long l13 = l12;
        long l14 = l10;
        lArray3[4] = l10 = l13 ^ l10;
        l13 = l14 ^ lArray3[9];
        long l15 = l12 ^ lArray3[10];
        long l16 = l15;
        long l17 = l13;
        lArray3[5] = l13 = l16 ^ l13;
        l16 = l17 ^ lArray3[11];
        long l18 = l15 ^ lArray3[12];
        long l19 = l18;
        long l20 = l16;
        lArray3[6] = l16 = l19 ^ l16;
        l19 = l20 ^ lArray3[13];
        long l21 = l18 ^ lArray3[14];
        long l22 = l21;
        long l23 = l19;
        lArray3[7] = l19 = l22 ^ l19;
        l22 = l23 ^ lArray3[15];
        long l24 = l21 ^ lArray3[16];
        long l25 = l24 ^ l22;
        long l26 = l2;
        long l27 = l3;
        lArray3[8] = l25;
        l3 = l24 ^ (l22 ^ lArray3[17]);
        lArray3[9] = l2 = l27 ^ l3;
        lArray3[10] = l2 = l26 ^ l3;
        lArray3[11] = l2 = l ^ l3;
        lArray3[12] = l2 = l7 ^ l3;
        lArray3[13] = l2 = l10 ^ l3;
        lArray3[14] = l2 = l13 ^ l3;
        lArray3[15] = l2 = l16 ^ l3;
        lArray3[16] = l2 = l19 ^ l3;
        lArray3[17] = l3 = l25 ^ l3;
        l3 = lArray[0] ^ lArray[1];
        l2 = lArray2[0] ^ lArray2[1];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 1);
        l3 = lArray[0] ^ lArray[2];
        l2 = lArray2[0] ^ lArray2[2];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 2);
        l3 = lArray[0] ^ lArray[3];
        l2 = lArray2[0] ^ lArray2[3];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 3);
        l3 = lArray[1] ^ lArray[2];
        l2 = lArray2[1] ^ lArray2[2];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 3);
        l3 = lArray[0] ^ lArray[4];
        l2 = lArray2[0] ^ lArray2[4];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 4);
        l3 = lArray[1] ^ lArray[3];
        l2 = lArray2[1] ^ lArray2[3];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 4);
        l3 = lArray[0] ^ lArray[5];
        l2 = lArray2[0] ^ lArray2[5];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 5);
        l3 = lArray[1] ^ lArray[4];
        l2 = lArray2[1] ^ lArray2[4];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 5);
        l3 = lArray[2] ^ lArray[3];
        l2 = lArray2[2] ^ lArray2[3];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 5);
        l3 = lArray[0] ^ lArray[6];
        l2 = lArray2[0] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 6);
        l3 = lArray[1] ^ lArray[5];
        l2 = lArray2[1] ^ lArray2[5];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 6);
        l3 = lArray[2] ^ lArray[4];
        l2 = lArray2[2] ^ lArray2[4];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 6);
        l3 = lArray[0] ^ lArray[7];
        l2 = lArray2[0] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 7);
        l3 = lArray[1] ^ lArray[6];
        l2 = lArray2[1] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 7);
        l3 = lArray[2] ^ lArray[5];
        l2 = lArray2[2] ^ lArray2[5];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 7);
        l3 = lArray[3] ^ lArray[4];
        l2 = lArray2[3] ^ lArray2[4];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 7);
        l3 = lArray[0] ^ lArray[8];
        l2 = lArray2[0] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 8);
        l3 = lArray[1] ^ lArray[7];
        l2 = lArray2[1] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 8);
        l3 = lArray[2] ^ lArray[6];
        l2 = lArray2[2] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 8);
        l3 = lArray[3] ^ lArray[5];
        l2 = lArray2[3] ^ lArray2[5];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 8);
        l3 = lArray[1] ^ lArray[8];
        l2 = lArray2[1] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 9);
        l3 = lArray[2] ^ lArray[7];
        l2 = lArray2[2] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 9);
        l3 = lArray[3] ^ lArray[6];
        l2 = lArray2[3] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 9);
        l3 = lArray[4] ^ lArray[5];
        l2 = lArray2[4] ^ lArray2[5];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 9);
        l3 = lArray[2] ^ lArray[8];
        l2 = lArray2[2] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 10);
        l3 = lArray[3] ^ lArray[7];
        l2 = lArray2[3] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 10);
        l3 = lArray[4] ^ lArray[6];
        l2 = lArray2[4] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 10);
        l3 = lArray[3] ^ lArray[8];
        l2 = lArray2[3] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 11);
        l3 = lArray[4] ^ lArray[7];
        l2 = lArray2[4] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 11);
        l3 = lArray[5] ^ lArray[6];
        l2 = lArray2[5] ^ lArray2[6];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 11);
        l3 = lArray[4] ^ lArray[8];
        l2 = lArray2[4] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 12);
        l3 = lArray[5] ^ lArray[7];
        l2 = lArray2[5] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 12);
        l3 = lArray[5] ^ lArray[8];
        l2 = lArray2[5] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 13);
        l3 = lArray[6] ^ lArray[7];
        l2 = lArray2[6] ^ lArray2[7];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 13);
        l3 = lArray[6] ^ lArray[8];
        l2 = lArray2[6] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l3, l2, lArray3, 14);
        l3 = lArray[7] ^ lArray[8];
        long l28 = lArray2[7] ^ lArray2[8];
        SecT571Field.implMulwAcc(lArray4, l3, l28, lArray3, 15);
    }

    public static void implMultiplyPrecomp(long[] lArray, long[] lArray2, long[] lArray3) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 15;
        for (n4 = 56; n4 >= 0; n4 -= 8) {
            for (n3 = 1; n3 < 9; n3 += 2) {
                int n6 = (int)(lArray[n3] >>> n4);
                n2 = n6 & n5;
                n = ((n6 >>> 4 & n5) + 16) * 9;
                int n7 = n3 - 1;
                SecT571Field.addBothTo(lArray2, n2 *= 9, lArray2, n, lArray3, n7);
            }
            Nat.shiftUpBits64(16, lArray3, 0, 8, 0L);
        }
        for (n4 = 56; n4 >= 0; n4 -= 8) {
            for (n3 = 0; n3 < 9; n3 += 2) {
                int n8 = (int)(lArray[n3] >>> n4);
                n2 = n8 & n5;
                n = ((n8 >>> 4 & n5) + 16) * 9;
                SecT571Field.addBothTo(lArray2, n2 *= 9, lArray2, n, lArray3, n3);
            }
            if (n4 <= 0) continue;
            Nat.shiftUpBits64(18, lArray3, 0, 8, 0L);
        }
    }

    public static void implMulwAcc(long[] lArray, long l, long l2, long[] lArray2, int n) {
        int n2;
        int n3;
        lArray[1] = l2;
        for (n3 = 2; n3 < 16; n3 += 2) {
            long l3;
            long l4;
            lArray[n3] = l4 = lArray[n3 >>> 1] << 1;
            int n4 = n3 + 1;
            lArray[n4] = l3 = l4 ^ l2;
        }
        n3 = (int)l;
        long l5 = 0L;
        long l6 = lArray[n3 & 0xF] ^ lArray[n3 >>> 4 & 0xF] << 4;
        n3 = 56;
        do {
            long l7 = l5;
            int n5 = (int)(l >>> n3);
            l5 = lArray[n5 & 0xF] ^ lArray[n5 >>> 4 & 0xF] << 4;
            l6 ^= l5 << n3;
            l5 = l7 ^ l5 >>> -n3;
        } while ((n3 += -8) > 0);
        for (n2 = 0; n2 < 7; ++n2) {
            l = (l & 0xFEFEFEFEFEFEFEFEL) >>> 1;
            l5 ^= l & l2 << n2 >> 63;
        }
        long[] lArray3 = lArray2;
        lArray3[n] = lArray2[n] ^ l6;
        n2 = n + 1;
        lArray2[n2] = l = lArray3[n2] ^ l5;
    }

    public static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray, 0, 9, lArray2, 0);
    }
}

