/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;

public abstract class X25519Field {
    public static final int SIZE = 10;
    private static final int M24 = 0xFFFFFF;
    private static final int M25 = 0x1FFFFFF;
    private static final int M26 = 0x3FFFFFF;
    private static final int[] P32 = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] ROOT_NEG_ONE = new int[]{34513072, 59165138, 4688974, 3500415, 6194736, 33281959, 54535759, 32551604, 163342, 5703241};

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int k = 0; k < 10; ++k) {
            nArray3[k] = nArray[k] + nArray2[k];
        }
    }

    public static void addOne(int[] nArray) {
        nArray[0] = nArray[0] + 1;
    }

    public static void addOne(int[] nArray, int n) {
        nArray[n] = nArray[n] + 1;
    }

    public static void apm(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        for (int k = 0; k < 10; ++k) {
            int n = nArray[k];
            int n2 = nArray2[k];
            nArray3[k] = n + n2;
            nArray4[k] = n - n2;
        }
    }

    public static void carry(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray2[0];
        int n2 = nArray2[1];
        int n3 = nArray2[2];
        int n4 = nArray2[3];
        int n5 = nArray2[4];
        int n6 = nArray2[5];
        int n7 = nArray2[6];
        int n8 = nArray2[7];
        int n9 = nArray2[8];
        int n10 = n3 + (n2 >> 26);
        n2 &= 0x3FFFFFF;
        n3 = n5 + (n4 >> 26);
        n4 &= 0x3FFFFFF;
        n5 = n8 + (n7 >> 26);
        n7 &= 0x3FFFFFF;
        n8 = nArray[9] + (n9 >> 26);
        int n11 = n3;
        int n12 = n3;
        int n13 = n10;
        n10 = n4 + (n10 >> 25);
        n3 = n13 & 0x1FFFFFF;
        n4 = n6 + (n12 >> 25);
        n6 = n11 & 0x1FFFFFF;
        int n14 = (n9 & 0x3FFFFFF) + (n5 >> 25);
        int n15 = n8;
        n5 &= 0x1FFFFFF;
        int n16 = n = (n15 >> 25) * 38 + n;
        n = n2 + (n >> 26);
        n2 = n16 & 0x3FFFFFF;
        int n17 = n7 + (n4 >> 26);
        int n18 = n10;
        int n19 = n10;
        int n20 = n;
        n10 = n4 & 0x3FFFFFF;
        n = n3 + (n >> 26);
        n3 = n20 & 0x3FFFFFF;
        n4 = n6 + (n19 >> 26);
        n5 = n18 & 0x3FFFFFF;
        n6 = n5 + (n17 >> 26);
        n7 = n17 & 0x3FFFFFF;
        n8 = (n15 & 0x1FFFFFF) + (n14 >> 26);
        int n21 = n14 & 0x3FFFFFF;
        nArray2[0] = n2;
        nArray2[1] = n3;
        nArray2[2] = n;
        nArray2[3] = n5;
        nArray2[4] = n4;
        nArray2[5] = n10;
        nArray2[6] = n7;
        nArray2[7] = n6;
        nArray2[8] = n21;
        nArray[9] = n8;
    }

    public static void cmov(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        for (int k = 0; k < 10; ++k) {
            int n4 = n3 + k;
            int n5 = nArray2[n4];
            nArray2[n4] = n5 ^ (n5 ^ nArray[n2 + k]) & n;
        }
    }

    public static void cnegate(int n, int[] nArray) {
        n = 0 - n;
        for (int k = 0; k < 10; ++k) {
            nArray[k] = (nArray[k] ^ n) - n;
        }
    }

    public static void copy(int[] nArray, int n, int[] nArray2, int n2) {
        for (int k = 0; k < 10; ++k) {
            int n3 = n2 + k;
            nArray2[n3] = nArray[n + k];
        }
    }

    public static int[] create() {
        return new int[10];
    }

    public static int[] createTable(int n) {
        return new int[n * 10];
    }

    public static void cswap(int n, int[] nArray, int[] nArray2) {
        n = 0 - n;
        for (int k = 0; k < 10; ++k) {
            int n2 = nArray[k];
            int n3 = nArray2[k];
            int n4 = n2;
            n2 = n & (n2 ^ n3);
            nArray[k] = n4 ^ n2;
            nArray2[k] = n3 ^ n2;
        }
    }

    public static void decode(int[] nArray, int n, int[] nArray2) {
        X25519Field.decode128(nArray, n, nArray2, 0);
        X25519Field.decode128(nArray, n + 4, nArray2, 5);
        nArray2[9] = nArray2[9] & 0xFFFFFF;
    }

    public static void decode(byte[] byArray, int n, int[] nArray) {
        X25519Field.decode128(byArray, n, nArray, 0);
        X25519Field.decode128(byArray, n + 16, nArray, 5);
        nArray[9] = nArray[9] & 0xFFFFFF;
    }

    private static void decode128(int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = nArray[n + 0];
        n = nArray[n + 1];
        int n6 = nArray[n4 + 2];
        int n7 = nArray[n3 + 3];
        int n8 = n2 + 0;
        nArray2[n8] = n5 & 0x3FFFFFF;
        n8 = n2 + 1;
        nArray2[n8] = (n << 6 | n5 >>> 26) & 0x3FFFFFF;
        n5 = n2 + 2;
        nArray2[n5] = (n6 << 12 | n >>> 20) & 0x1FFFFFF;
        n5 = n2 + 3;
        nArray2[n5] = (n7 << 19 | n6 >>> 13) & 0x3FFFFFF;
        n5 = n2 + 4;
        nArray2[n5] = n7 >>> 7;
    }

    private static void decode128(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = X25519Field.decode32(byArray, n + 0);
        n = X25519Field.decode32(byArray, n + 4);
        int n6 = X25519Field.decode32(byArray, n4 + 8);
        int n7 = X25519Field.decode32(byArray, n3 + 12);
        int n8 = n2 + 0;
        nArray[n8] = n5 & 0x3FFFFFF;
        n8 = n2 + 1;
        nArray[n8] = (n << 6 | n5 >>> 26) & 0x3FFFFFF;
        n5 = n2 + 2;
        nArray[n5] = (n6 << 12 | n >>> 20) & 0x1FFFFFF;
        n5 = n2 + 3;
        nArray[n5] = (n7 << 19 | n6 >>> 13) & 0x3FFFFFF;
        n5 = n2 + 4;
        nArray[n5] = n7 >>> 7;
    }

    private static int decode32(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        n = n + 1;
        return n2 | (byArray[n] & 0xFF) << 8 | (byArray[++n] & 0xFF) << 16 | byArray[n + 1] << 24;
    }

    public static void encode(int[] nArray, int[] nArray2, int n) {
        X25519Field.encode128(nArray, 0, nArray2, n);
        int n2 = n + 4;
        X25519Field.encode128(nArray, 5, nArray2, n2);
    }

    public static void encode(int[] nArray, byte[] byArray, int n) {
        X25519Field.encode128(nArray, 0, byArray, n);
        int n2 = n + 16;
        X25519Field.encode128(nArray, 5, byArray, n2);
    }

    private static void encode128(int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = nArray[n + 0];
        int n4 = nArray[n + 1];
        int n5 = nArray[n + 2];
        int n6 = nArray[n + 3];
        int n7 = nArray[n + 4];
        n = n2 + 0;
        nArray2[n] = n3 | n4 << 26;
        n = n2 + 1;
        nArray2[n] = n4 >>> 6 | n5 << 20;
        n = n2 + 2;
        nArray2[n] = n5 >>> 12 | n6 << 13;
        n = n2 + 3;
        nArray2[n] = n6 >>> 19 | n7 << 7;
    }

    private static void encode128(int[] nArray, int n, byte[] byArray, int n2) {
        int n3 = nArray[n + 0];
        int n4 = nArray[n + 1];
        int n5 = nArray[n + 2];
        int n6 = nArray[n + 3];
        int n7 = nArray[n + 4];
        X25519Field.encode32(n3 | n4 << 26, byArray, n2 + 0);
        X25519Field.encode32(n4 >>> 6 | n5 << 20, byArray, n2 + 4);
        X25519Field.encode32(n5 >>> 12 | n6 << 13, byArray, n2 + 8);
        X25519Field.encode32(n6 >>> 19 | n7 << 7, byArray, n2 + 12);
    }

    private static void encode32(int n, byte[] byArray, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = n;
        byArray[n2] = (byte)n;
        n = n2 + 1;
        byArray[n] = (byte)(n5 >>> 8);
        byArray[++n] = (byte)(n4 >>> 16);
        byArray[++n] = (byte)(n3 >>> 24);
    }

    public static void inv(int[] nArray, int[] nArray2) {
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = new int[8];
        X25519Field.copy(nArray, 0, nArray3, 0);
        X25519Field.normalize(nArray3);
        X25519Field.encode(nArray3, nArray4, 0);
        Mod.modOddInverse(P32, nArray4, nArray4);
        X25519Field.decode(nArray4, 0, nArray2);
    }

    public static void invVar(int[] nArray, int[] nArray2) {
        int[] nArray3 = X25519Field.create();
        int[] nArray4 = new int[8];
        X25519Field.copy(nArray, 0, nArray3, 0);
        X25519Field.normalize(nArray3);
        X25519Field.encode(nArray3, nArray4, 0);
        Mod.modOddInverseVar(P32, nArray4, nArray4);
        X25519Field.decode(nArray4, 0, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int k = 0; k < 10; ++k) {
            n |= nArray[k];
        }
        return (n >>> 1 | n & 1) - 1 >> 31;
    }

    public static boolean isZeroVar(int[] nArray) {
        return X25519Field.isZero(nArray) != 0;
    }

    public static void mul(int[] nArray, int n, int[] nArray2) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = nArray[5];
        int n8 = nArray[6];
        int n9 = nArray[7];
        int n10 = nArray[8];
        long l = n;
        long l2 = (long)n4 * l;
        n = (int)l2 & 0x1FFFFFF;
        long l3 = l2 >> 25;
        long l4 = (long)n6 * l;
        n4 = (int)l4 & 0x1FFFFFF;
        long l5 = l4 >> 25;
        long l6 = (long)n9 * l;
        n6 = (int)l6 & 0x1FFFFFF;
        long l7 = l6 >> 25;
        long l8 = (long)nArray[9] * l;
        long l9 = (l8 >> 25) * 38L;
        l9 = (long)n2 * l + l9;
        nArray2[0] = (int)l9 & 0x3FFFFFF;
        long l10 = (long)n7 * l + l5;
        nArray2[5] = (int)l10 & 0x3FFFFFF;
        l10 >>= 26;
        long l11 = (long)n3 * l + (l9 >>= 26);
        l9 = l11;
        nArray2[1] = (int)l9 & 0x3FFFFFF;
        l9 = (long)n5 * l + l3;
        nArray2[3] = (int)l9 & 0x3FFFFFF;
        l9 >>= 26;
        l10 = (long)n8 * l + l10;
        nArray2[6] = (int)l10 & 0x3FFFFFF;
        long l12 = (long)n10 * l + l7;
        nArray2[8] = (int)l12 & 0x3FFFFFF;
        nArray2[2] = n + (int)(l11 >> 26);
        nArray2[4] = n4 + (int)l9;
        nArray2[7] = n6 + (int)(l10 >>= 26);
        nArray2[9] = ((int)l8 & 0x1FFFFFF) + (int)(l12 >>= 26);
    }

    public static void mul(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray[0];
        int n2 = nArray2[0];
        int n3 = nArray[1];
        int n4 = nArray2[1];
        int n5 = nArray[2];
        int n6 = nArray2[2];
        int n7 = nArray[3];
        int n8 = nArray2[3];
        int n9 = nArray[4];
        int n10 = n9;
        int n11 = n8;
        int n12 = n7;
        int n13 = n6;
        int n14 = n;
        int n15 = n10;
        int n16 = n7;
        int n17 = n;
        int n18 = nArray2[4];
        int n19 = nArray[5];
        n = nArray2[5];
        n7 = nArray[6];
        n10 = nArray2[6];
        int n20 = nArray[7];
        int n21 = nArray2[7];
        int n22 = nArray[8];
        int n23 = nArray2[8];
        int n24 = nArray[9];
        int n25 = nArray2[9];
        long l = n17;
        long l2 = n2;
        long l3 = l * l2;
        long l4 = n4;
        long l5 = l * l4;
        long l6 = n3;
        l5 = l6 * l2 + l5;
        long l7 = n6;
        long l8 = l * l7;
        l8 = l6 * l4 + l8;
        long l9 = n5;
        l8 = l9 * l2 + l8;
        long l10 = l6 * l7;
        l10 = l9 * l4 + l10 << 1;
        long l11 = n8;
        long l12 = l * l11;
        long l13 = n16;
        long l14 = l;
        l = a.a(l13, l2, l12, l10);
        l10 = l9 * l7 << 1;
        l12 = n18;
        long l15 = l14 * l12;
        l15 = l6 * l11 + l15;
        l15 = l13 * l4 + l15;
        long l16 = n15;
        long l17 = l4;
        l2 = a.a(l16, l2, l15, l10);
        l4 = l6 * l12;
        l4 = l9 * l11 + l4;
        l4 = l13 * l7 + l4;
        l4 = l16 * l17 + l4 << 1;
        l6 = l9 * l12;
        l6 = l16 * l7 + l6 << 1;
        l6 = l13 * l11 + l6;
        l7 = l13 * l12;
        l7 = l16 * l11 + l7;
        long l18 = l16 * l12 << 1;
        long l19 = l7;
        long l20 = l6;
        long l21 = l4;
        long l22 = l;
        l = n19;
        l4 = n;
        l6 = l * l4;
        l7 = n10;
        l9 = l * l7;
        l10 = n7;
        l9 = l10 * l4 + l9;
        l11 = n21;
        l12 = l * l11;
        l12 = l10 * l7 + l12;
        l13 = n20;
        l12 = l13 * l4 + l12;
        l15 = l10 * l11;
        l15 = l13 * l7 + l15 << 1;
        l16 = n23;
        long l23 = l * l16;
        long l24 = n22;
        long l25 = l;
        l = a.a(l24, l4, l23, l15);
        l15 = l13 * l11 << 1;
        l23 = n25;
        long l26 = l25 * l23;
        l26 = l10 * l16 + l26;
        l26 = l24 * l7 + l26;
        long l27 = n24;
        long l28 = l7;
        l4 = a.a(l27, l4, l26, l15);
        l7 = l10 * l23;
        l7 = l13 * l16 + l7;
        l7 = l24 * l11 + l7;
        l7 = l27 * l28 + l7;
        l10 = l13 * l23;
        l10 = l27 * l11 + l10 << 1;
        l10 = l24 * l16 + l10;
        l11 = l24 * l23;
        l11 = l27 * l16 + l11;
        l3 -= l7 * 76L;
        l5 -= l10 * 38L;
        l7 = l8 - l11 * 38L;
        l8 = l22 - l27 * l23 * 76L;
        l6 = l21 - l6;
        l9 = l20 - l9;
        l10 = l19 - l12;
        l = l18 - l;
        n19 = n14 + n19;
        n = n2 + n;
        n6 = n3 + n7;
        n7 = n4 + n10;
        n8 = n5 + n20;
        n10 = n13 + n21;
        n20 = n12 + n22;
        n21 = n11 + n23;
        n18 += n25;
        long l29 = n19;
        long l30 = n;
        long l31 = l29 * l30;
        long l32 = n7;
        l11 = l29 * l32;
        l12 = n6;
        long l33 = l12 * l30 + l11;
        l11 = n10;
        l13 = l29 * l11;
        l13 = l12 * l32 + l13;
        l15 = n8;
        l13 = l15 * l30 + l13;
        l16 = l12 * l11;
        l16 = l15 * l32 + l16 << 1;
        l23 = n21;
        l24 = l29 * l23;
        l26 = n20;
        long l34 = l29;
        long l35 = a.a(l26, l30, l24, l16);
        l29 = l15 * l11 << 1;
        l16 = n18;
        l24 = l34 * l16;
        l24 = l12 * l23 + l24;
        l24 = l26 * l32 + l24;
        l27 = n9 + n24;
        long l36 = a.a(l27, l30, l24, l29);
        long l37 = l35;
        l35 = l12 * l16;
        l35 = l15 * l23 + l35;
        l35 = l26 * l11 + l35;
        l35 = l27 * l32 + l35 << 1;
        l30 = l15 * l16;
        l30 = l27 * l11 + l30 << 1;
        l30 = l26 * l23 + l30;
        l29 = l26 * l16;
        l29 = l27 * l23 + l29;
        l32 = l27 * l16 << 1;
        long l38 = l37 - l8 + l;
        n = (int)l38 & 0x3FFFFFF;
        l11 = l38 >> 26;
        l11 = l36 - l2 - l4 + l11;
        l35 = ((l11 >> 25) + l35 - l6) * 38L + l3;
        nArray3[0] = (int)l35 & 0x3FFFFFF;
        l35 >>= 26;
        l35 = (l30 - l9) * 38L + l5 + l35;
        nArray3[1] = (int)l35 & 0x3FFFFFF;
        l35 >>= 26;
        l35 = (l29 - l10) * 38L + l7 + l35;
        nArray3[2] = (int)l35 & 0x1FFFFFF;
        l35 >>= 25;
        l35 = (l32 - l) * 38L + l8 + l35;
        nArray3[3] = (int)l35 & 0x3FFFFFF;
        l35 >>= 26;
        l35 = a.a(l4, 38L, l2, l35);
        nArray3[4] = (int)l35 & 0x1FFFFFF;
        l35 >>= 25;
        l35 = l31 - l3 + l6 + l35;
        nArray3[5] = (int)l35 & 0x3FFFFFF;
        l35 >>= 26;
        l35 = l33 - l5 + l9 + l35;
        nArray3[6] = (int)l35 & 0x3FFFFFF;
        l35 >>= 26;
        l35 = l13 - l7 + l10 + l35;
        nArray3[7] = (int)l35 & 0x1FFFFFF;
        l35 = (l35 >> 25) + (long)n;
        nArray3[8] = (int)l35 & 0x3FFFFFF;
        nArray3[9] = ((int)l11 & 0x1FFFFFF) + (int)(l35 >> 26);
    }

    public static void negate(int[] nArray, int[] nArray2) {
        for (int k = 0; k < 10; ++k) {
            nArray2[k] = -nArray[k];
        }
    }

    public static void normalize(int[] nArray) {
        int n = nArray[9] >>> 23 & 1;
        X25519Field.reduce(nArray, n);
        X25519Field.reduce(nArray, -n);
    }

    public static void one(int[] nArray) {
        nArray[0] = 1;
        for (int k = 1; k < 10; ++k) {
            nArray[k] = 0;
        }
    }

    private static void powPm5d8(int[] nArray, int[] nArray2, int[] nArray3) {
        X25519Field.sqr(nArray, nArray2);
        X25519Field.mul(nArray, nArray2, nArray2);
        int[] nArray4 = X25519Field.create();
        X25519Field.sqr(nArray2, nArray4);
        X25519Field.mul(nArray, nArray4, nArray4);
        X25519Field.sqr(nArray4, 2, nArray4);
        X25519Field.mul(nArray2, nArray4, nArray4);
        nArray2 = X25519Field.create();
        X25519Field.sqr(nArray4, 5, nArray2);
        X25519Field.mul(nArray4, nArray2, nArray2);
        int[] nArray5 = X25519Field.create();
        X25519Field.sqr(nArray2, 5, nArray5);
        X25519Field.mul(nArray4, nArray5, nArray5);
        X25519Field.sqr(nArray5, 10, nArray4);
        X25519Field.mul(nArray2, nArray4, nArray4);
        X25519Field.sqr(nArray4, 25, nArray2);
        X25519Field.mul(nArray4, nArray2, nArray2);
        X25519Field.sqr(nArray2, 25, nArray5);
        X25519Field.mul(nArray4, nArray5, nArray5);
        X25519Field.sqr(nArray5, 50, nArray4);
        X25519Field.mul(nArray2, nArray4, nArray4);
        X25519Field.sqr(nArray4, 125, nArray2);
        X25519Field.mul(nArray4, nArray2, nArray2);
        X25519Field.sqr(nArray2, 2, nArray4);
        X25519Field.mul(nArray4, nArray, nArray3);
    }

    private static void reduce(int[] nArray, int n) {
        int n2 = nArray[9];
        long l = (long)(((n2 >> 24) + n) * 19) + (long)nArray[0];
        nArray[0] = (int)l & 0x3FFFFFF;
        l = (l >> 26) + (long)nArray[1];
        nArray[1] = (int)l & 0x3FFFFFF;
        l = (l >> 26) + (long)nArray[2];
        nArray[2] = (int)l & 0x1FFFFFF;
        l = (l >> 25) + (long)nArray[3];
        nArray[3] = (int)l & 0x3FFFFFF;
        l = (l >> 26) + (long)nArray[4];
        nArray[4] = (int)l & 0x1FFFFFF;
        l = (l >> 25) + (long)nArray[5];
        nArray[5] = (int)l & 0x3FFFFFF;
        l = (l >> 26) + (long)nArray[6];
        nArray[6] = (int)l & 0x3FFFFFF;
        l = (l >> 26) + (long)nArray[7];
        nArray[7] = (int)l & 0x1FFFFFF;
        l = (l >> 25) + (long)nArray[8];
        nArray[8] = (int)l & 0x3FFFFFF;
        nArray[9] = (n2 & 0xFFFFFF) + (int)(l >> 26);
    }

    public static void sqr(int[] nArray, int[] nArray2) {
        long l;
        long l2;
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = n;
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = nArray[5];
        int n8 = nArray[6];
        int n9 = nArray[7];
        int n10 = nArray[8];
        int n11 = nArray[9];
        int n12 = n2 * 2;
        int n13 = n;
        n = n5 * 2;
        int n14 = n6 * 2;
        long l3 = l2 = (long)n13;
        long l4 = l3 * l3;
        long l5 = n12;
        long l6 = l2 * l5;
        long l7 = n4 * 2;
        long l8 = l7;
        long l9 = l5;
        long l10 = l2 * l8;
        long l11 = n2;
        long l12 = l2;
        long l13 = l2;
        long l14 = l11;
        long l15 = l14 * l14 + l10;
        long l16 = l5 * l8;
        l2 = n;
        l16 = l13 * l2 + l16;
        l5 = (long)n4 * l8;
        l8 = n14;
        l5 = l12 * l8 + l5;
        l5 = l11 * l2 + l5;
        l10 = l9 * l8;
        l2 = l7 * l2 + l10;
        l10 = l7 * l8;
        l11 = n5;
        int n15 = n7;
        long l17 = l11;
        l10 = l17 * l17 + l10;
        long l18 = (long)n6 * l8;
        long l19 = l11 *= l8;
        long l20 = l10;
        long l21 = l2;
        int n16 = n8 * 2;
        int n17 = n7;
        n7 = n10 * 2;
        n14 = n11 * 2;
        long l22 = l2 = (long)n17;
        l8 = l22 * l22;
        l10 = n16;
        l11 = l2 * l10;
        long l23 = n9 * 2;
        long l24 = l23;
        long l25 = l10;
        long l26 = l2 * l24;
        long l27 = n8;
        long l28 = l2;
        long l29 = l2;
        long l30 = l27;
        long l31 = l30 * l30 + l26;
        l2 = l10 * l24;
        l10 = n7;
        l2 = l29 * l10 + l2;
        l24 = (long)n9 * l24;
        l26 = n14;
        l24 = l28 * l26 + l24;
        l24 = l27 * l10 + l24;
        l27 = l25 * l26;
        l10 = l23 * l10 + l27;
        l27 = l23 * l26;
        long l32 = l = (long)n10;
        l27 = l32 * l32 + l27;
        long l33 = l15;
        l15 = l4 - l10 * 38L;
        l4 = l6 - l27 * 38L;
        l6 = l33 - (l *= l26) * 38L;
        l10 = l16 - (long)n11 * l26 * 38L;
        l8 = l21 - l8;
        l11 = l20 - l11;
        l31 = l19 - l31;
        l2 = l18 - l2;
        n7 = n3 + n15;
        int n18 = n2 + n8;
        n8 = n18;
        int n19 = n7;
        int n20 = n6;
        n6 = n4 + n9;
        n4 = n5 + n10;
        n5 = n20 + n11;
        n7 = n8 * 2;
        n8 = n6 * 2;
        n9 = n4 * 2;
        n10 = n5 * 2;
        long l34 = l26 = (long)n19;
        long l35 = l34 * l34;
        l27 = n7;
        l = l26 * l27;
        long l36 = n8;
        long l37 = l26 * l36;
        long l38 = n18;
        long l39 = l38;
        long l40 = l26;
        long l41 = l26;
        long l42 = l39;
        long l43 = l42 * l42 + l37;
        l26 = l27 * l36;
        l37 = n9;
        l26 = l41 * l37 + l26;
        l39 = (long)n6 * l36;
        long l44 = n10;
        l39 = l40 * l44 + l39;
        long l45 = l38 * l37 + l39;
        long l46 = l26;
        long l47 = l27 * l44;
        l47 = l36 * l37 + l47;
        l26 = l36 * l44;
        long l48 = l27 = (long)n4;
        l26 = l48 * l48 + l26;
        l27 *= l44;
        l36 = (long)n5 * l44;
        long l49 = l46 - l10 + l2;
        n6 = (int)l49 & 0x3FFFFFF;
        l37 = l49 >> 26;
        l37 = l45 - l5 - l24 + l37;
        long l50 = l15;
        l15 = ((l37 >> 25) + l47 - l8) * 38L + l15;
        nArray2[0] = (int)l15 & 0x3FFFFFF;
        l15 >>= 26;
        l15 = (l26 - l11) * 38L + l4 + l15;
        nArray2[1] = (int)l15 & 0x3FFFFFF;
        l15 >>= 26;
        l15 = (l27 - l31) * 38L + l6 + l15;
        nArray2[2] = (int)l15 & 0x1FFFFFF;
        l15 >>= 25;
        l15 = (l36 - l2) * 38L + l10 + l15;
        nArray2[3] = (int)l15 & 0x3FFFFFF;
        l15 >>= 26;
        l15 = a.a(l24, 38L, l5, l15);
        nArray2[4] = (int)l15 & 0x1FFFFFF;
        l15 >>= 25;
        l15 = l35 - l50 + l8 + l15;
        nArray2[5] = (int)l15 & 0x3FFFFFF;
        l15 >>= 26;
        l15 = l - l4 + l11 + l15;
        nArray2[6] = (int)l15 & 0x3FFFFFF;
        l15 >>= 26;
        l15 = l43 - l6 + l31 + l15;
        nArray2[7] = (int)l15 & 0x1FFFFFF;
        l15 = (l15 >> 25) + (long)n6;
        nArray2[8] = (int)l15 & 0x3FFFFFF;
        nArray2[9] = ((int)l37 & 0x1FFFFFF) + (int)(l15 >> 26);
    }

    public static void sqr(int[] nArray, int n, int[] nArray2) {
        X25519Field.sqr(nArray, nArray2);
        while ((n += -1) > 0) {
            X25519Field.sqr(nArray2, nArray2);
        }
    }

    public static boolean sqrtRatioVar(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = X25519Field.create();
        int[] nArray5 = X25519Field.create();
        X25519Field.mul(nArray, nArray2, nArray4);
        X25519Field.sqr(nArray2, nArray5);
        X25519Field.mul(nArray4, nArray5, nArray4);
        X25519Field.sqr(nArray5, nArray5);
        X25519Field.mul(nArray5, nArray4, nArray5);
        int[] nArray6 = X25519Field.create();
        int[] nArray7 = X25519Field.create();
        X25519Field.powPm5d8(nArray5, nArray6, nArray7);
        X25519Field.mul(nArray7, nArray4, nArray7);
        nArray4 = X25519Field.create();
        X25519Field.sqr(nArray7, nArray4);
        X25519Field.mul(nArray4, nArray2, nArray4);
        X25519Field.sub(nArray4, nArray, nArray6);
        X25519Field.normalize(nArray6);
        if (X25519Field.isZeroVar(nArray6)) {
            X25519Field.copy(nArray7, 0, nArray3, 0);
            return true;
        }
        X25519Field.add(nArray4, nArray, nArray6);
        X25519Field.normalize(nArray6);
        if (X25519Field.isZeroVar(nArray6)) {
            X25519Field.mul(nArray7, ROOT_NEG_ONE, nArray3);
            return true;
        }
        return false;
    }

    public static void sub(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int k = 0; k < 10; ++k) {
            nArray3[k] = nArray[k] - nArray2[k];
        }
    }

    public static void subOne(int[] nArray) {
        nArray[0] = nArray[0] - 1;
    }

    public static void zero(int[] nArray) {
        for (int k = 0; k < 10; ++k) {
            nArray[k] = 0;
        }
    }
}

