/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;

public abstract class X448Field {
    public static final int SIZE = 16;
    private static final int M28 = 0xFFFFFFF;
    private static final long U32 = 0xFFFFFFFFL;
    private static final int[] P32 = new int[]{-1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1};

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int k = 0; k < 16; ++k) {
            nArray3[k] = nArray[k] + nArray2[k];
        }
    }

    public static void addOne(int[] nArray) {
        nArray[0] = nArray[0] + 1;
    }

    public static void addOne(int[] nArray, int n) {
        nArray[n] = nArray[n] + 1;
    }

    public static void carry(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray2[0];
        int n2 = nArray2[1];
        int n3 = nArray2[2];
        int n4 = nArray2[3];
        int n5 = nArray2[4];
        int n6 = nArray2[5];
        int n7 = nArray2[6];
        int n8 = nArray2[7];
        int n9 = nArray2[8];
        int n10 = nArray2[9];
        int n11 = nArray2[10];
        int n12 = nArray2[11];
        int n13 = nArray2[12];
        int n14 = n9;
        int n15 = n9;
        int n16 = n5;
        int n17 = n5;
        int n18 = n;
        int n19 = n;
        int n20 = nArray[14];
        n = nArray[15];
        n2 += n19 >>> 28;
        n5 = n18 & 0xFFFFFFF;
        n6 += n17 >>> 28;
        n9 = n16 & 0xFFFFFFF;
        n10 += n15 >>> 28;
        int n21 = n14 & 0xFFFFFFF;
        int n22 = nArray[13] + (n13 >>> 28);
        int n23 = n12;
        int n24 = n6;
        int n25 = n2;
        n2 = n3 + (n2 >>> 28);
        n3 = n25 & 0xFFFFFFF;
        n6 = n7 + (n6 >>> 28);
        n7 = n24 & 0xFFFFFFF;
        n11 += n10 >>> 28;
        int n26 = n6;
        int n27 = n8;
        int n28 = n6;
        int n29 = n2;
        int n30 = n4;
        int n31 = n2;
        int n32 = n20;
        n20 = n10 & 0xFFFFFFF;
        n2 = n32 + (n22 >>> 28);
        n4 = n22 & 0xFFFFFFF;
        n6 = n30 + (n31 >>> 28);
        n8 = n29 & 0xFFFFFFF;
        n10 = n27 + (n28 >>> 28);
        n12 = n26 & 0xFFFFFFF;
        n22 = n23 + (n11 >>> 28);
        int n33 = n21;
        int n34 = n5;
        int n35 = n;
        n = n11 & 0xFFFFFFF;
        int n36 = n35 + (n2 >>> 28);
        n2 &= 0xFFFFFFF;
        n5 = n36 >>> 28;
        n11 = n36 & 0xFFFFFFF;
        n21 = n34 + n5;
        int n37 = n33 + n5;
        n5 = n9 + (n6 >>> 28);
        n6 &= 0xFFFFFFF;
        n9 = n37 + (n10 >>> 28);
        n10 &= 0xFFFFFFF;
        int n38 = (n13 & 0xFFFFFFF) + (n22 >>> 28);
        int n39 = n9;
        int n40 = n20;
        int n41 = n5;
        n20 = n22 & 0xFFFFFFF;
        n3 += n21 >>> 28;
        n4 = n21 & 0xFFFFFFF;
        n5 = n7 + (n5 >>> 28);
        n7 = n41 & 0xFFFFFFF;
        n9 = n40 + (n9 >>> 28);
        n21 = n39 & 0xFFFFFFF;
        n22 = n4 + (n38 >>> 28);
        int n42 = n38 & 0xFFFFFFF;
        nArray2[0] = n4;
        nArray2[1] = n3;
        nArray2[2] = n8;
        nArray2[3] = n6;
        nArray2[4] = n7;
        nArray2[5] = n5;
        nArray2[6] = n12;
        nArray2[7] = n10;
        nArray2[8] = n21;
        nArray2[9] = n9;
        nArray2[10] = n;
        nArray2[11] = n20;
        nArray2[12] = n42;
        nArray2[13] = n22;
        nArray2[14] = n2;
        nArray[15] = n11;
    }

    public static void cmov(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        for (int k = 0; k < 16; ++k) {
            int n4 = n3 + k;
            int n5 = nArray2[n4];
            nArray2[n4] = n5 ^ (n5 ^ nArray[n2 + k]) & n;
        }
    }

    public static void cnegate(int n, int[] nArray) {
        int[] nArray2 = X448Field.create();
        X448Field.sub(nArray2, nArray, nArray2);
        X448Field.cmov(-n, nArray2, 0, nArray, 0);
    }

    public static void copy(int[] nArray, int n, int[] nArray2, int n2) {
        for (int k = 0; k < 16; ++k) {
            int n3 = n2 + k;
            nArray2[n3] = nArray[n + k];
        }
    }

    public static int[] create() {
        return new int[16];
    }

    public static int[] createTable(int n) {
        return new int[n * 16];
    }

    public static void cswap(int n, int[] nArray, int[] nArray2) {
        n = 0 - n;
        for (int k = 0; k < 16; ++k) {
            int n2 = nArray[k];
            int n3 = nArray2[k];
            int n4 = n2;
            n2 = n & (n2 ^ n3);
            nArray[k] = n4 ^ n2;
            nArray2[k] = n3 ^ n2;
        }
    }

    public static void decode(int[] nArray, int n, int[] nArray2) {
        X448Field.decode224(nArray, n, nArray2, 0);
        X448Field.decode224(nArray, n + 7, nArray2, 8);
    }

    public static void decode(byte[] byArray, int n, int[] nArray) {
        X448Field.decode56(byArray, n, nArray, 0);
        X448Field.decode56(byArray, n + 7, nArray, 2);
        X448Field.decode56(byArray, n + 14, nArray, 4);
        X448Field.decode56(byArray, n + 21, nArray, 6);
        X448Field.decode56(byArray, n + 28, nArray, 8);
        X448Field.decode56(byArray, n + 35, nArray, 10);
        X448Field.decode56(byArray, n + 42, nArray, 12);
        X448Field.decode56(byArray, n + 49, nArray, 14);
    }

    private static void decode224(int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = n;
        int n6 = n;
        int n7 = n;
        int n8 = nArray[n + 0];
        n = nArray[n + 1];
        int n9 = nArray[n7 + 2];
        int n10 = nArray[n6 + 3];
        int n11 = nArray[n5 + 4];
        int n12 = nArray[n4 + 5];
        int n13 = nArray[n3 + 6];
        int n14 = n8;
        int n15 = n8;
        n8 = n2 + 0;
        nArray2[n8] = n15 & 0xFFFFFFF;
        n8 = n2 + 1;
        nArray2[n8] = (n14 >>> 28 | n << 4) & 0xFFFFFFF;
        n8 = n2 + 2;
        nArray2[n8] = (n >>> 24 | n9 << 8) & 0xFFFFFFF;
        n8 = n2 + 3;
        nArray2[n8] = (n9 >>> 20 | n10 << 12) & 0xFFFFFFF;
        n8 = n2 + 4;
        nArray2[n8] = (n10 >>> 16 | n11 << 16) & 0xFFFFFFF;
        n8 = n2 + 5;
        nArray2[n8] = (n11 >>> 12 | n12 << 20) & 0xFFFFFFF;
        n8 = n2 + 6;
        nArray2[n8] = (n12 >>> 8 | n13 << 24) & 0xFFFFFFF;
        n8 = n2 + 7;
        nArray2[n8] = n13 >>> 4;
    }

    private static int decode24(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[++n] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16;
    }

    private static int decode32(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        n = n + 1;
        return n2 | (byArray[n] & 0xFF) << 8 | (byArray[++n] & 0xFF) << 16 | byArray[n + 1] << 24;
    }

    private static void decode56(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = X448Field.decode32(byArray, n);
        int n4 = X448Field.decode24(byArray, n + 4);
        nArray[n2] = n3 & 0xFFFFFFF;
        n = n2 + 1;
        nArray[n] = n3 >>> 28 | n4 << 4;
    }

    public static void encode(int[] nArray, int[] nArray2, int n) {
        X448Field.encode224(nArray, 0, nArray2, n);
        int n2 = n + 7;
        X448Field.encode224(nArray, 8, nArray2, n2);
    }

    public static void encode(int[] nArray, byte[] byArray, int n) {
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        X448Field.encode56(nArray2, 0, byArray, n);
        int n2 = n + 7;
        X448Field.encode56(nArray3, 2, byArray, n2);
        n2 = n + 14;
        X448Field.encode56(nArray2, 4, byArray, n2);
        n2 = n + 21;
        X448Field.encode56(nArray3, 6, byArray, n2);
        n2 = n + 28;
        X448Field.encode56(nArray2, 8, byArray, n2);
        n2 = n + 35;
        X448Field.encode56(nArray3, 10, byArray, n2);
        n2 = n + 42;
        X448Field.encode56(nArray2, 12, byArray, n2);
        n2 = n + 49;
        X448Field.encode56(nArray3, 14, byArray, n2);
    }

    private static void encode224(int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = nArray[n + 0];
        int n4 = nArray[n + 1];
        int n5 = nArray[n + 2];
        int n6 = nArray[n + 3];
        int n7 = nArray[n + 4];
        int n8 = nArray[n + 5];
        int n9 = nArray[n + 6];
        int n10 = nArray[n + 7];
        n = n2 + 0;
        nArray2[n] = n3 | n4 << 28;
        n = n2 + 1;
        nArray2[n] = n4 >>> 4 | n5 << 24;
        n = n2 + 2;
        nArray2[n] = n5 >>> 8 | n6 << 20;
        n = n2 + 3;
        nArray2[n] = n6 >>> 12 | n7 << 16;
        n = n2 + 4;
        nArray2[n] = n7 >>> 16 | n8 << 12;
        n = n2 + 5;
        nArray2[n] = n8 >>> 20 | n9 << 8;
        n = n2 + 6;
        nArray2[n] = n9 >>> 24 | n10 << 4;
    }

    private static void encode24(int n, byte[] byArray, int n2) {
        int n3 = n;
        int n4 = n;
        byArray[n2] = (byte)n;
        n = n2 + 1;
        byArray[n] = (byte)(n4 >>> 8);
        byArray[++n] = (byte)(n3 >>> 16);
    }

    private static void encode32(int n, byte[] byArray, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = n;
        byArray[n2] = (byte)n;
        n = n2 + 1;
        byArray[n] = (byte)(n5 >>> 8);
        byArray[++n] = (byte)(n4 >>> 16);
        byArray[++n] = (byte)(n3 >>> 24);
    }

    private static void encode56(int[] nArray, int n, byte[] byArray, int n2) {
        int n3 = nArray[n];
        int n4 = nArray[n + 1];
        X448Field.encode32(n3 | n4 << 28, byArray, n2);
        X448Field.encode24(n4 >>> 4, byArray, n2 + 4);
    }

    public static void inv(int[] nArray, int[] nArray2) {
        int[] nArray3 = X448Field.create();
        int[] nArray4 = new int[14];
        X448Field.copy(nArray, 0, nArray3, 0);
        X448Field.normalize(nArray3);
        X448Field.encode(nArray3, nArray4, 0);
        Mod.modOddInverse(P32, nArray4, nArray4);
        X448Field.decode(nArray4, 0, nArray2);
    }

    public static void invVar(int[] nArray, int[] nArray2) {
        int[] nArray3 = X448Field.create();
        int[] nArray4 = new int[14];
        X448Field.copy(nArray, 0, nArray3, 0);
        X448Field.normalize(nArray3);
        X448Field.encode(nArray3, nArray4, 0);
        Mod.modOddInverseVar(P32, nArray4, nArray4);
        X448Field.decode(nArray4, 0, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int k = 0; k < 16; ++k) {
            n |= nArray[k];
        }
        return (n >>> 1 | n & 1) - 1 >> 31;
    }

    public static boolean isZeroVar(int[] nArray) {
        return X448Field.isZero(nArray) != 0;
    }

    public static void mul(int[] nArray, int n, int[] nArray2) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = nArray[5];
        int n8 = nArray[6];
        int n9 = nArray[7];
        int n10 = nArray[8];
        int n11 = nArray[9];
        int n12 = nArray[10];
        int n13 = nArray[11];
        int n14 = nArray[12];
        int n15 = nArray[13];
        int n16 = nArray[14];
        int n17 = nArray[15];
        long l = n;
        long l2 = (long)n3 * l;
        n = (int)l2 & 0xFFFFFFF;
        long l3 = l2 >>> 28;
        long l4 = (long)n7 * l;
        n3 = (int)l4 & 0xFFFFFFF;
        long l5 = l4 >>> 28;
        long l6 = (long)n11 * l;
        n7 = (int)l6 & 0xFFFFFFF;
        long l7 = l6 >>> 28;
        long l8 = (long)n15 * l;
        long l9 = l8 >>> 28;
        long l10 = (long)n4 * l + l3;
        nArray2[2] = (int)l10 & 0xFFFFFFF;
        l10 >>>= 28;
        long l11 = (long)n8 * l + l5;
        nArray2[6] = (int)l11 & 0xFFFFFFF;
        l11 >>>= 28;
        long l12 = (long)n12 * l + l7;
        nArray2[10] = (int)l12 & 0xFFFFFFF;
        l12 >>>= 28;
        l9 = (long)n16 * l + l9;
        nArray2[14] = (int)l9 & 0xFFFFFFF;
        l9 >>>= 28;
        l10 = (long)n5 * l + l10;
        nArray2[3] = (int)l10 & 0xFFFFFFF;
        l10 >>>= 28;
        long l13 = (long)n9 * l + l11;
        l11 = l13;
        nArray2[7] = (int)l11 & 0xFFFFFFF;
        l11 = (long)n13 * l + l12;
        nArray2[11] = (int)l11 & 0xFFFFFFF;
        l11 >>>= 28;
        l9 = (long)n17 * l + l9;
        nArray2[15] = (int)l9 & 0xFFFFFFF;
        l12 = (l13 >>> 28) + (l9 >>>= 28);
        l10 = (long)n6 * l + l10;
        nArray2[4] = (int)l10 & 0xFFFFFFF;
        l10 >>>= 28;
        l12 = (long)n10 * l + l12;
        nArray2[8] = (int)l12 & 0xFFFFFFF;
        l12 >>>= 28;
        l11 = (long)n14 * l + l11;
        nArray2[12] = (int)l11 & 0xFFFFFFF;
        l11 >>>= 28;
        l9 = (long)n2 * l + l9;
        nArray2[0] = (int)l9 & 0xFFFFFFF;
        nArray2[1] = n + (int)(l9 >>> 28);
        nArray2[5] = n3 + (int)l10;
        nArray2[9] = n7 + (int)l12;
        nArray2[13] = ((int)l8 & 0xFFFFFFF) + (int)l11;
    }

    public static void mul(int[] nArray, int[] nArray2, int[] nArray3) {
        long l;
        int[] nArray4 = nArray3;
        int[] nArray5 = nArray3;
        int n = nArray[0];
        int n2 = n;
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = nArray[5];
        int n8 = nArray[6];
        int n9 = nArray[7];
        int n10 = nArray[8];
        int n11 = nArray[9];
        int n12 = nArray[10];
        int n13 = nArray[11];
        int n14 = nArray[12];
        int n15 = nArray[13];
        int n16 = nArray[14];
        int n17 = nArray[15];
        int n18 = nArray2[0];
        int n19 = nArray2[1];
        int n20 = nArray2[2];
        int n21 = nArray2[3];
        int n22 = nArray2[4];
        int n23 = nArray2[5];
        int n24 = nArray2[6];
        int n25 = nArray2[7];
        int n26 = n2;
        int n27 = nArray2[8];
        n2 = nArray2[9];
        int n28 = nArray2[10];
        int n29 = nArray2[11];
        int n30 = nArray2[12];
        int n31 = nArray2[13];
        int n32 = nArray2[14];
        int n33 = nArray2[15];
        int n34 = n26 + n10;
        int n35 = n3 + n11;
        int n36 = n4 + n12;
        int n37 = n5 + n13;
        int n38 = n6 + n14;
        int n39 = n7 + n15;
        int n40 = n8 + n16;
        int n41 = n9 + n17;
        int n42 = n18 + n27;
        int n43 = n19 + n2;
        int n44 = n20 + n28;
        int n45 = n21 + n29;
        int n46 = n22 + n30;
        int n47 = n23 + n31;
        int n48 = n24 + n32;
        int n49 = n25 + n33;
        long l2 = n;
        long l3 = n18;
        long l4 = l2 * l3;
        long l5 = n9;
        long l6 = n19;
        long l7 = l5 * l6;
        long l8 = n8;
        long l9 = n20;
        l7 = l8 * l9 + l7;
        long l10 = n7;
        long l11 = n21;
        l7 = l10 * l11 + l7;
        long l12 = n6;
        long l13 = n22;
        l7 = l12 * l13 + l7;
        long l14 = n5;
        long l15 = n23;
        l7 = l14 * l15 + l7;
        long l16 = n4;
        long l17 = n24;
        l7 = l16 * l17 + l7;
        long l18 = n3;
        long l19 = n25;
        long l20 = l18 * l19 + l7;
        long l21 = n10;
        long l22 = n27;
        long l23 = l21 * l22;
        long l24 = n17;
        l7 = n2;
        long l25 = l24 * l7;
        long l26 = n16;
        long l27 = n28;
        l25 = l26 * l27 + l25;
        long l28 = n15;
        long l29 = n29;
        l25 = l28 * l29 + l25;
        long l30 = n14;
        long l31 = n30;
        l25 = l30 * l31 + l25;
        long l32 = n13;
        long l33 = n31;
        l25 = l32 * l33 + l25;
        long l34 = n12;
        long l35 = n32;
        l25 = l34 * l35 + l25;
        long l36 = n11;
        long l37 = n33;
        long l38 = l36 * l37 + l25;
        long l39 = l23;
        l23 = n34;
        long l40 = n42;
        long l41 = l23 * l40;
        long l42 = n41;
        long l43 = n43;
        long l44 = l42 * l43;
        l25 = n40;
        long l45 = n44;
        l44 = l25 * l45 + l44;
        long l46 = n39;
        long l47 = n45;
        l44 = l46 * l47 + l44;
        long l48 = n38;
        long l49 = n46;
        l44 = l48 * l49 + l44;
        long l50 = n37;
        long l51 = n47;
        l44 = l50 * l51 + l44;
        long l52 = n36;
        long l53 = n48;
        l44 = l52 * l53 + l44;
        long l54 = n35;
        long l55 = n49;
        l44 = l54 * l55 + l44;
        long l56 = l20 = l4 + l39 + l44 - l20;
        n2 = (int)l56 & 0xFFFFFFF;
        l20 = l56 >>> 28;
        long l57 = l38 + l41 - l4 + l44;
        int n50 = (int)l57 & 0xFFFFFFF;
        l41 = l57 >>> 28;
        l44 = l18 * l3;
        l44 = l2 * l6 + l44;
        long l58 = l5 * l9;
        l58 = l8 * l11 + l58;
        l58 = l10 * l13 + l58;
        l58 = l12 * l15 + l58;
        l58 = l14 * l17 + l58;
        l58 = l16 * l19 + l58;
        long l59 = l36 * l22;
        l59 = l21 * l7 + l59;
        long l60 = l24 * l27;
        l60 = l26 * l29 + l60;
        l60 = l28 * l31 + l60;
        l60 = l30 * l33 + l60;
        l60 = l32 * l35 + l60;
        l60 = l34 * l37 + l60;
        long l61 = l54 * l40;
        l61 = l23 * l43 + l61;
        long l62 = l42 * l45;
        l62 = l25 * l47 + l62;
        l62 = l46 * l49 + l62;
        l62 = l48 * l51 + l62;
        l62 = l50 * l53 + l62;
        l62 = l52 * l55 + l62;
        long l63 = l44 + l59 + l62 - l58 + l20;
        l20 = l63;
        l20 >>>= 28;
        l41 = l60 + l61 - l44 + l62 + l41;
        long l64 = l23;
        long l65 = l21;
        long l66 = l22;
        long l67 = l19;
        long l68 = l15;
        long l69 = l11;
        long l70 = l6;
        long l71 = l5;
        long l72 = l3;
        long l73 = l21;
        long l74 = l22;
        long l75 = l5;
        long l76 = l19;
        long l77 = l15;
        long l78 = l11;
        long l79 = l6;
        long l80 = l3;
        long l81 = l21;
        long l82 = l22;
        long l83 = l19;
        long l84 = l5;
        long l85 = l11;
        long l86 = l6;
        long l87 = l3;
        long l88 = l21;
        long l89 = l22;
        long l90 = l19;
        long l91 = l5;
        long l92 = l6;
        long l93 = l3;
        long l94 = l21;
        long l95 = l22;
        long l96 = l19;
        long l97 = l5;
        long l98 = l3;
        long l99 = l22;
        l22 = l41 >>> 28;
        l3 = l16 * l3;
        l3 = l18 * l6 + l3;
        l3 = l2 * l9 + l3;
        long l100 = l5 * l11;
        l100 = l8 * l13 + l100;
        l100 = l10 * l15 + l100;
        l100 = l12 * l17 + l100;
        l100 = l14 * l19 + l100;
        long l101 = l34 * l99;
        l101 = l36 * l7 + l101;
        l101 = l21 * l27 + l101;
        l21 = l24 * l29;
        l21 = l26 * l31 + l21;
        l21 = l28 * l33 + l21;
        l21 = l30 * l35 + l21;
        long l102 = l32 * l37 + l21;
        long l103 = l101;
        l101 = l52 * l40;
        l101 = l54 * l43 + l101;
        l101 = l23 * l45 + l101;
        l21 = l42 * l47;
        l21 = l25 * l49 + l21;
        l21 = l46 * l51 + l21;
        l21 = l48 * l53 + l21;
        l21 = l50 * l55 + l21;
        long l104 = l100 = l3 + l103 + l21 - l100 + l20;
        int n51 = (int)l104 & 0xFFFFFFF;
        l5 = l104 >>> 28;
        long l105 = l102 + l101 - l3 + l21 + l22;
        int n52 = (int)l105 & 0xFFFFFFF;
        l3 = l105 >>> 28;
        l19 = l14 * l98;
        l19 = l16 * l6 + l19;
        l19 = l18 * l9 + l19;
        l19 = l2 * l11 + l19;
        l20 = l97 * l13;
        l20 = l8 * l15 + l20;
        l20 = l10 * l17 + l20;
        l20 = l12 * l96 + l20;
        l21 = l32 * l95;
        l21 = l34 * l7 + l21;
        l21 = l36 * l27 + l21;
        l21 = l94 * l29 + l21;
        l6 = l24 * l31;
        l6 = l26 * l33 + l6;
        l6 = l28 * l35 + l6;
        long l106 = l30 * l37 + l6;
        long l107 = l21;
        l21 = l50 * l40;
        l21 = l52 * l43 + l21;
        l21 = l54 * l45 + l21;
        l21 = l23 * l47 + l21;
        l6 = l42 * l49;
        l6 = l25 * l51 + l6;
        l6 = l46 * l53 + l6;
        l6 = l48 * l55 + l6;
        long l108 = l5 = l19 + l107 + l6 - l20 + l5;
        n27 = (int)l108 & 0xFFFFFFF;
        l5 = l108 >>> 28;
        long l109 = l106 + l21 - l19 + l6 + l3;
        int n53 = (int)l109 & 0xFFFFFFF;
        l19 = l109 >>> 28;
        l20 = l12 * l93;
        l20 = l14 * l92 + l20;
        l20 = l16 * l9 + l20;
        l20 = l18 * l11 + l20;
        l20 = l2 * l13 + l20;
        l21 = l91 * l15;
        l21 = l8 * l17 + l21;
        l21 = l10 * l90 + l21;
        l6 = l30 * l89;
        l6 = l32 * l7 + l6;
        l6 = l34 * l27 + l6;
        l6 = l36 * l29 + l6;
        l6 = l88 * l31 + l6;
        l11 = l24 * l33;
        l11 = l26 * l35 + l11;
        long l110 = l28 * l37 + l11;
        long l111 = l6;
        l6 = l48 * l40;
        l6 = l50 * l43 + l6;
        l6 = l52 * l45 + l6;
        l6 = l54 * l47 + l6;
        l6 = l23 * l49 + l6;
        l11 = l42 * l51;
        l11 = l25 * l53 + l11;
        l11 = l46 * l55 + l11;
        long l112 = l5 = l20 + l111 + l11 - l21 + l5;
        n5 = (int)l112 & 0xFFFFFFF;
        l5 = l112 >>> 28;
        long l113 = l110 + l6 - l20 + l11 + l19;
        int n54 = (int)l113 & 0xFFFFFFF;
        long l114 = l113 >>> 28;
        long l115 = l10 * l87;
        l115 = l12 * l86 + l115;
        l115 = l14 * l9 + l115;
        l115 = l16 * l85 + l115;
        l115 = l18 * l13 + l115;
        l115 = l2 * l15 + l115;
        l6 = l84 * l17;
        l6 = l8 * l83 + l6;
        l11 = l28 * l82;
        l11 = l30 * l7 + l11;
        l11 = l32 * l27 + l11;
        l11 = l34 * l29 + l11;
        l11 = l36 * l31 + l11;
        l11 = l81 * l33 + l11;
        l15 = l24 * l35;
        long l116 = l26 * l37 + l15;
        long l117 = l11;
        l11 = l46 * l40;
        l11 = l48 * l43 + l11;
        l11 = l50 * l45 + l11;
        l11 = l52 * l47 + l11;
        l11 = l54 * l49 + l11;
        l11 = l23 * l51 + l11;
        l15 = l42 * l53;
        l15 = l25 * l55 + l15;
        long l118 = l5 = l115 + l117 + l15 - l6 + l5;
        int n55 = (int)l118 & 0xFFFFFFF;
        l6 = l118 >>> 28;
        long l119 = l116 + l11 - l115 + l15 + l114;
        int n56 = (int)l119 & 0xFFFFFFF;
        l114 = l119 >>> 28;
        l115 = l8 * l80;
        l115 = l10 * l79 + l115;
        l115 = l12 * l9 + l115;
        l115 = l14 * l78 + l115;
        l115 = l16 * l13 + l115;
        l115 = l18 * l77 + l115;
        l115 = l2 * l17 + l115;
        l11 = l75 * l76;
        l15 = l26 * l74;
        l15 = l28 * l7 + l15;
        l15 = l30 * l27 + l15;
        l15 = l32 * l29 + l15;
        l15 = l34 * l31 + l15;
        l15 = l36 * l33 + l15;
        long l120 = l15 = l73 * l35 + l15;
        long l121 = l25 * l40;
        l121 = l46 * l43 + l121;
        l121 = l48 * l45 + l121;
        l121 = l50 * l47 + l121;
        l121 = l52 * l49 + l121;
        l121 = l54 * l51 + l121;
        l121 = l23 * l53 + l121;
        l15 = l42 * l55;
        long l122 = l = l115 + l120 + l15 - l11 + l6;
        int n57 = (int)l122 & 0xFFFFFFF;
        l23 = l122 >>> 28;
        long l123 = l24 * l37 + l121 - l115 + l15 + l114;
        int n58 = (int)l123 & 0xFFFFFFF;
        l20 = l123 >>> 28;
        l6 = l71 * l72;
        l6 = l8 * l70 + l6;
        l6 = l10 * l9 + l6;
        l6 = l12 * l69 + l6;
        l6 = l14 * l13 + l6;
        l6 = l16 * l68 + l6;
        l6 = l18 * l17 + l6;
        l6 = l2 * l67 + l6;
        l11 = l24 * l66;
        l11 = l26 * l7 + l11;
        l11 = l28 * l27 + l11;
        l11 = l30 * l29 + l11;
        l11 = l32 * l31 + l11;
        l11 = l34 * l33 + l11;
        l11 = l36 * l35 + l11;
        l11 = l65 * l37 + l11;
        l15 = l42 * l40;
        l15 = l25 * l43 + l15;
        l15 = l46 * l45 + l15;
        l15 = l48 * l47 + l15;
        l15 = l50 * l49 + l15;
        l15 = l52 * l51 + l15;
        l15 = l54 * l53 + l15;
        long l124 = l6;
        long l125 = l124 + l11 + l23;
        int n59 = (int)l125 & 0xFFFFFFF;
        l23 = l125 >>> 28;
        long l126 = l64 * l55 + l15 - l124 + l20;
        int n60 = (int)l126 & 0xFFFFFFF;
        l6 = l126 >>> 28;
        int n61 = n2;
        long l127 = l23 + l6 + (long)n50;
        n2 = (int)l127 & 0xFFFFFFF;
        l23 = l127 >>> 28;
        long l128 = l23;
        long l129 = l6 += (long)n61;
        n50 = (int)l129 & 0xFFFFFFF;
        l23 = l129 >>> 28;
        int n62 = ((int)l41 & 0xFFFFFFF) + (int)l128;
        int n63 = ((int)l63 & 0xFFFFFFF) + (int)l23;
        nArray4[0] = n50;
        nArray5[1] = n63;
        nArray4[2] = n51;
        nArray5[3] = n27;
        nArray4[4] = n5;
        nArray5[5] = n55;
        nArray4[6] = n57;
        nArray5[7] = n59;
        nArray4[8] = n2;
        nArray5[9] = n62;
        nArray4[10] = n52;
        nArray5[11] = n53;
        nArray4[12] = n54;
        nArray5[13] = n56;
        nArray4[14] = n58;
        nArray5[15] = n60;
    }

    public static void negate(int[] nArray, int[] nArray2) {
        X448Field.sub(X448Field.create(), nArray, nArray2);
    }

    public static void normalize(int[] nArray) {
        X448Field.reduce(nArray, 1);
        X448Field.reduce(nArray, -1);
    }

    public static void one(int[] nArray) {
        nArray[0] = 1;
        for (int k = 1; k < 16; ++k) {
            nArray[k] = 0;
        }
    }

    private static void powPm3d4(int[] nArray, int[] nArray2) {
        int[] nArray3 = nArray;
        int[] nArray4 = nArray;
        int[] nArray5 = X448Field.create();
        X448Field.sqr(nArray3, nArray5);
        X448Field.mul(nArray4, nArray5, nArray5);
        int[] nArray6 = X448Field.create();
        X448Field.sqr(nArray5, nArray6);
        X448Field.mul(nArray, nArray6, nArray6);
        int[] nArray7 = X448Field.create();
        nArray = nArray7;
        X448Field.sqr(nArray6, 3, nArray);
        X448Field.mul(nArray6, nArray, nArray);
        nArray = X448Field.create();
        X448Field.sqr(nArray7, 3, nArray);
        X448Field.mul(nArray6, nArray, nArray);
        nArray5 = X448Field.create();
        X448Field.sqr(nArray, 9, nArray5);
        X448Field.mul(nArray, nArray5, nArray5);
        nArray = X448Field.create();
        X448Field.sqr(nArray5, nArray);
        X448Field.mul(nArray3, nArray, nArray);
        nArray6 = X448Field.create();
        X448Field.sqr(nArray, 18, nArray6);
        X448Field.mul(nArray5, nArray6, nArray6);
        int[] nArray8 = X448Field.create();
        nArray = nArray8;
        X448Field.sqr(nArray6, 37, nArray);
        X448Field.mul(nArray6, nArray, nArray);
        nArray = X448Field.create();
        X448Field.sqr(nArray8, 37, nArray);
        X448Field.mul(nArray6, nArray, nArray);
        nArray5 = X448Field.create();
        X448Field.sqr(nArray, 111, nArray5);
        X448Field.mul(nArray, nArray5, nArray5);
        nArray = X448Field.create();
        X448Field.sqr(nArray5, nArray);
        X448Field.mul(nArray4, nArray, nArray);
        nArray6 = X448Field.create();
        X448Field.sqr(nArray, 223, nArray6);
        X448Field.mul(nArray6, nArray5, nArray2);
    }

    private static void reduce(int[] nArray, int n) {
        int n2 = nArray[15];
        int n3 = n2 & 0xFFFFFFF;
        long l = (n2 >>> 28) + n;
        long l2 = l;
        for (n = 0; n < 8; ++n) {
            nArray[n] = (int)(l2 += (long)nArray[n] & 0xFFFFFFFFL) & 0xFFFFFFF;
            l2 >>= 28;
        }
        l = l2 + l;
        for (n = 8; n < 15; ++n) {
            nArray[n] = (int)(l += (long)nArray[n] & 0xFFFFFFFFL) & 0xFFFFFFF;
            l >>= 28;
        }
        nArray[15] = n3 + (int)l;
    }

    public static void sqr(int[] nArray, int[] nArray2) {
        long l;
        long l2;
        int[] nArray3 = nArray2;
        int[] nArray4 = nArray2;
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = n2;
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = nArray[5];
        int n8 = nArray[6];
        int n9 = nArray[7];
        int n10 = nArray[8];
        int n11 = nArray[9];
        int n12 = nArray[10];
        int n13 = nArray[11];
        int n14 = nArray[12];
        int n15 = n14;
        int n16 = nArray[13];
        int n17 = n16;
        int n18 = nArray[14];
        int n19 = n18;
        int n20 = nArray[15];
        int n21 = n20;
        int n22 = n10;
        int n23 = n6;
        int n24 = n7;
        int n25 = n8;
        int n26 = n9;
        int n27 = n;
        int n28 = n8;
        int n29 = n19;
        int n30 = n7;
        int n31 = n17;
        int n32 = n6;
        int n33 = n15;
        int n34 = n3;
        int n35 = n;
        int n36 = n10;
        int n37 = n19;
        int n38 = n17;
        int n39 = n15;
        int n40 = n10;
        int n41 = n8;
        int n42 = n7;
        int n43 = n6;
        n *= 2;
        n3 *= 2;
        n6 = n4 * 2;
        n7 = n5 * 2;
        n8 = n43 * 2;
        n10 = n42 * 2;
        n15 = n41 * 2;
        n17 = n40 * 2;
        n19 = n11 * 2;
        int n44 = n12 * 2;
        int n45 = n13 * 2;
        int n46 = n39 * 2;
        int n47 = n38 * 2;
        int n48 = n37 * 2;
        int n49 = n35 + n36;
        int n50 = n34 + n11;
        int n51 = n4 + n12;
        int n52 = n5 + n13;
        int n53 = n32 + n33;
        int n54 = n30 + n31;
        int n55 = n28 + n29;
        n21 = n9 + n21;
        n9 = n49 * 2;
        int n56 = n50 * 2;
        int n57 = n51 * 2;
        int n58 = n52 * 2;
        int n59 = n53 * 2;
        int n60 = n54 * 2;
        int n61 = n55 * 2;
        long l3 = n27;
        long l4 = l3 * l3;
        long l5 = n26;
        long l6 = n3;
        long l7 = l5 * l6;
        long l8 = n25;
        long l9 = n6;
        l7 = l8 * l9 + l7;
        long l10 = n24;
        long l11 = n7;
        l7 = l10 * l11 + l7;
        long l12 = n23;
        l7 = l12 * l12 + l7;
        long l13 = n22;
        long l14 = l13 * l13;
        long l15 = n20;
        long l16 = n19;
        long l17 = l15 * l16;
        long l18 = n18;
        long l19 = n44;
        l17 = l18 * l19 + l17;
        long l20 = n16;
        long l21 = n45;
        l17 = l20 * l21 + l17;
        long l22 = n14;
        long l23 = l22 * l22 + l17;
        long l24 = l14;
        long l25 = n49;
        long l26 = l25 * l25;
        l14 = n21;
        long l27 = (long)n56 & 0xFFFFFFFFL;
        l17 = l14 * l27;
        long l28 = n55;
        long l29 = (long)n57 & 0xFFFFFFFFL;
        l17 = l28 * l29 + l17;
        long l30 = n54;
        long l31 = (long)n58 & 0xFFFFFFFFL;
        l17 = l30 * l31 + l17;
        long l32 = n53;
        l17 = l32 * l32 + l17;
        l7 = l4 + l24 + l17 - l7;
        long l33 = l26;
        long l34 = l7;
        n21 = (int)l34 & 0xFFFFFFF;
        l26 = l34 >>> 28;
        long l35 = l23 + l33 - l4 + l17;
        n3 = (int)l35 & 0xFFFFFFF;
        l4 = l35 >>> 28;
        l7 = n2;
        l17 = n;
        long l36 = l7 * l17;
        long l37 = l5 * l9;
        l37 = l8 * l11 + l37;
        long l38 = n8;
        l37 = l10 * l38 + l37;
        long l39 = n11;
        long l40 = n17;
        long l41 = l39 * l40;
        long l42 = l15 * l19;
        l42 = l18 * l21 + l42;
        long l43 = n46;
        l42 = l20 * l43 + l42;
        long l44 = n50;
        long l45 = (long)n9 & 0xFFFFFFFFL;
        long l46 = l44 * l45;
        long l47 = l14 * l29;
        l47 = l28 * l31 + l47;
        long l48 = (long)n59 & 0xFFFFFFFFL;
        l47 = l30 * l48 + l47;
        long l49 = l36 + l41 + l47 - l37 + l26;
        l37 = l49;
        l37 >>>= 28;
        long l50 = l42 + l46 - l36 + l47 + l4;
        l26 = l50;
        long l51 = l31;
        long l52 = l45;
        long l53 = l21;
        long l54 = l19;
        long l55 = l11;
        long l56 = l15;
        long l57 = l38;
        long l58 = l26 >>> 28;
        l26 = n4;
        long l59 = l20;
        long l60 = l39;
        long l61 = l10;
        long l62 = l7;
        long l63 = l26 * l17;
        l63 = l62 * l62 + l63;
        l11 = l5 * l11;
        l11 = l8 * l38 + l11;
        l11 = l61 * l61 + l11;
        long l64 = n12;
        l38 = l64 * l40;
        l38 = l60 * l60 + l38;
        l4 = l15 * l21;
        l4 = l18 * l43 + l4;
        long l65 = l59 * l59 + l4;
        long l66 = l38;
        long l67 = l30;
        long l68 = l31;
        long l69 = l44;
        l38 = n51;
        l31 = l38 * l45;
        l31 = l69 * l69 + l31;
        l4 = l14 * l68;
        l4 = l28 * l48 + l4;
        l4 = l67 * l67 + l4;
        long l70 = l11 = l63 + l66 + l4 - l11 + l37;
        n = (int)l70 & 0xFFFFFFF;
        l11 = l70 >>> 28;
        long l71 = l65 + l31 - l63 + l4 + l58;
        int n62 = (int)l71 & 0xFFFFFFF;
        l58 = l71 >>> 28;
        l37 = n5;
        l31 = l37 * l17;
        l31 = l26 * l6 + l31;
        l4 = l5 * l57;
        l7 = n10;
        l4 = l8 * l7 + l4;
        l21 = n13;
        long l72 = l19;
        long l73 = l5;
        long l74 = l37;
        long l75 = l19;
        long l76 = l37;
        long l77 = l18;
        long l78 = l64;
        long l79 = l8;
        long l80 = l26;
        long l81 = l37;
        long l82 = l64;
        l64 = l21 * l40;
        l64 = l82 * l16 + l64;
        long l83 = l15 * l43;
        l19 = n47;
        long l84 = l18 * l19 + l83;
        long l85 = l64;
        l64 = n52;
        l83 = l64 * l45;
        l83 = l38 * l27 + l83;
        l37 = l14 * l48;
        long l86 = (long)n60 & 0xFFFFFFFFL;
        l37 = l28 * l86 + l37;
        long l87 = l2 = l31 + l85 + l37 - l4 + l11;
        int n63 = (int)l87 & 0xFFFFFFF;
        l11 = l87 >>> 28;
        long l88 = l84 + l83 - l31 + l37 + l58;
        int n64 = (int)l88 & 0xFFFFFFF;
        l83 = l88 >>> 28;
        l37 = l12 * l17;
        l37 = l81 * l6 + l37;
        l37 = l80 * l80 + l37;
        long l89 = l5 * l7;
        l89 = l79 * l79 + l89;
        l26 = l22 * l40;
        l26 = l21 * l16 + l26;
        l26 = l78 * l78 + l26;
        l19 = l15 * l19;
        long l90 = l77 * l77 + l19;
        long l91 = l28;
        long l92 = l38;
        l19 = l32 * l45;
        l19 = l64 * l27 + l19;
        l19 = l92 * l92 + l19;
        l86 = l14 * l86;
        l86 = l91 * l91 + l86;
        l11 = l37 + l26 + l86 - l89 + l11;
        long l93 = l19;
        long l94 = l11;
        int n65 = (int)l94 & 0xFFFFFFF;
        l19 = l94 >>> 28;
        long l95 = l90 + l93 - l37 + l86 + l83;
        n7 = (int)l95 & 0xFFFFFFF;
        l83 = l95 >>> 28;
        l37 = l10 * l17;
        l37 = l12 * l6 + l37;
        l37 = l76 * l9 + l37;
        l86 = l5 * (long)n15;
        l38 = l20 * l40;
        l38 = l22 * l16 + l38;
        long l96 = l38 = l21 * l75 + l38;
        l38 = l30 * l45;
        l38 = l32 * l27 + l38;
        l38 = l64 * l29 + l38;
        l89 = l14 * ((long)n61 & 0xFFFFFFFFL);
        long l97 = l19 = l37 + l96 + l89 - l86 + l19;
        n11 = (int)l97 & 0xFFFFFFF;
        l19 = l97 >>> 28;
        long l98 = l15 * (long)n48 + l38 - l37 + l89 + l83;
        int n66 = (int)l98 & 0xFFFFFFF;
        l37 = l98 >>> 28;
        l86 = l8 * l17;
        l86 = l10 * l6 + l86;
        l86 = l12 * l9 + l86;
        l86 = l74 * l74 + l86;
        l38 = l73 * l73;
        l89 = l18 * l40;
        l89 = l20 * l16 + l89;
        l89 = l22 * l72 + l89;
        l89 = l21 * l21 + l89;
        long l99 = l14;
        long l100 = l64;
        l45 = l28 * l45;
        l45 = l30 * l27 + l45;
        l45 = l32 * l29 + l45;
        l45 = l100 * l100 + l45;
        l64 = l99 * l99;
        long l101 = l = l86 + l89 + l64 - l38 + l19;
        int n67 = (int)l101 & 0xFFFFFFF;
        l = l101 >>> 28;
        long l102 = l56 * l56 + l45 - l86 + l64 + l37;
        n9 = (int)l102 & 0xFFFFFFF;
        l64 = l102 >>> 28;
        long l103 = l5 * l17;
        l103 = l8 * l6 + l103;
        l103 = l10 * l9 + l103;
        l103 = l12 * l55 + l103;
        long l104 = l15 * l40;
        l104 = l18 * l16 + l104;
        l104 = l20 * l54 + l104;
        l104 = l22 * l53 + l104;
        long l105 = l14 * l52;
        l105 = l28 * l27 + l105;
        l105 = l30 * l29 + l105;
        long l106 = l103;
        long l107 = l106 + l104 + l;
        int n68 = (int)l107 & 0xFFFFFFF;
        l19 = l107 >>> 28;
        long l108 = l32 * l51 + l105 - l106 + l64;
        int n69 = (int)l108 & 0xFFFFFFF;
        l37 = l108 >>> 28;
        int n70 = n21;
        long l109 = l19 + l37 + (long)n3;
        n21 = (int)l109 & 0xFFFFFFF;
        l19 = l109 >>> 28;
        long l110 = l19;
        long l111 = l37 += (long)n70;
        n3 = (int)l111 & 0xFFFFFFF;
        l19 = l111 >>> 28;
        n13 = ((int)l50 & 0xFFFFFFF) + (int)l110;
        int n71 = ((int)l49 & 0xFFFFFFF) + (int)l19;
        nArray3[0] = n3;
        nArray4[1] = n71;
        nArray3[2] = n;
        nArray4[3] = n63;
        nArray3[4] = n65;
        nArray4[5] = n11;
        nArray3[6] = n67;
        nArray4[7] = n68;
        nArray3[8] = n21;
        nArray4[9] = n13;
        nArray3[10] = n62;
        nArray4[11] = n64;
        nArray3[12] = n7;
        nArray4[13] = n66;
        nArray3[14] = n9;
        nArray4[15] = n69;
    }

    public static void sqr(int[] nArray, int n, int[] nArray2) {
        X448Field.sqr(nArray, nArray2);
        while ((n += -1) > 0) {
            X448Field.sqr(nArray2, nArray2);
        }
    }

    public static boolean sqrtRatioVar(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = X448Field.create();
        int[] nArray5 = X448Field.create();
        X448Field.sqr(nArray, nArray4);
        X448Field.mul(nArray4, nArray2, nArray4);
        X448Field.sqr(nArray4, nArray5);
        X448Field.mul(nArray4, nArray, nArray4);
        X448Field.mul(nArray5, nArray, nArray5);
        X448Field.mul(nArray5, nArray2, nArray5);
        int[] nArray6 = X448Field.create();
        X448Field.powPm3d4(nArray5, nArray6);
        X448Field.mul(nArray6, nArray4, nArray6);
        nArray4 = X448Field.create();
        X448Field.sqr(nArray6, nArray4);
        X448Field.mul(nArray4, nArray2, nArray4);
        X448Field.sub(nArray, nArray4, nArray4);
        X448Field.normalize(nArray4);
        if (X448Field.isZeroVar(nArray4)) {
            X448Field.copy(nArray6, 0, nArray3, 0);
            return true;
        }
        return false;
    }

    public static void sub(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int[] nArray4 = nArray3;
        int[] nArray5 = nArray3;
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = nArray[5];
        int n8 = nArray[6];
        int n9 = nArray[7];
        int n10 = nArray[8];
        int n11 = nArray[9];
        int n12 = nArray[10];
        int n13 = n = nArray[11];
        int n14 = n12;
        int n15 = n11;
        int n16 = n10;
        int n17 = n9;
        int n18 = n8;
        int n19 = n7;
        int n20 = n6;
        int n21 = n5;
        int n22 = n4;
        int n23 = n3;
        int n24 = n2;
        int n25 = nArray[13];
        int n26 = nArray[14];
        n2 = nArray[15];
        n3 = nArray2[0];
        n4 = nArray2[1];
        n5 = nArray2[2];
        n6 = nArray2[3];
        n7 = nArray2[4];
        n8 = nArray2[5];
        n9 = nArray2[6];
        n10 = nArray2[7];
        n11 = nArray2[8];
        n12 = nArray2[9];
        n = nArray2[10];
        int n27 = nArray2[11];
        int n28 = nArray2[12];
        int n29 = nArray2[13];
        int n30 = nArray2[14];
        int n31 = nArray2[15];
        n3 = n24 + 0x1FFFFFFE - n3;
        n4 = n23 + 0x1FFFFFFE - n4;
        n5 = n22 + 0x1FFFFFFE - n5;
        n6 = n21 + 0x1FFFFFFE - n6;
        n7 = n20 + 0x1FFFFFFE - n7;
        n8 = n19 + 0x1FFFFFFE - n8;
        n9 = n18 + 0x1FFFFFFE - n9;
        n10 = n17 + 0x1FFFFFFE - n10;
        n11 = n16 + 0x1FFFFFFC - n11;
        n12 = n15 + 0x1FFFFFFE - n12;
        n = n14 + 0x1FFFFFFE - n;
        n27 = n13 + 0x1FFFFFFE - n27;
        int n32 = n8;
        int n33 = n4;
        n25 = n25 + 0x1FFFFFFE - n29;
        n26 = n26 + 0x1FFFFFFE - n30;
        n2 = n2 + 0x1FFFFFFE - n31;
        n4 = n5 + (n4 >>> 28);
        n5 = n33 & 0xFFFFFFF;
        n8 = n9 + (n8 >>> 28);
        n9 = n32 & 0xFFFFFFF;
        n += n12 >>> 28;
        int n34 = n8;
        int n35 = n8;
        int n36 = n4;
        int n37 = n4;
        int n38 = n25;
        int n39 = n25;
        n25 = n12 & 0xFFFFFFF;
        n26 += n39 >>> 28;
        n4 = n38 & 0xFFFFFFF;
        n6 += n37 >>> 28;
        n8 = n36 & 0xFFFFFFF;
        n10 += n35 >>> 28;
        n12 = n34 & 0xFFFFFFF;
        n27 += n >>> 28;
        int n40 = n11;
        int n41 = n3;
        int n42 = n2;
        n2 = n & 0xFFFFFFF;
        int n43 = n42 + (n26 >>> 28);
        n26 &= 0xFFFFFFF;
        n3 = n43 >>> 28;
        n11 = n43 & 0xFFFFFFF;
        n = n41 + n3;
        int n44 = n40 + n3;
        n3 = n7 + (n6 >>> 28);
        n6 &= 0xFFFFFFF;
        n7 = n44 + (n10 >>> 28);
        n10 &= 0xFFFFFFF;
        int n45 = nArray[12] + 0x1FFFFFFE - n28 + (n27 >>> 28);
        int n46 = n7;
        int n47 = n25;
        int n48 = n7;
        int n49 = n3;
        int n50 = n3;
        n25 = n27 & 0xFFFFFFF;
        n3 = n5 + (n >>> 28);
        n4 = n & 0xFFFFFFF;
        n5 = n9 + (n50 >>> 28);
        n7 = n49 & 0xFFFFFFF;
        n9 = n47 + (n48 >>> 28);
        n = n46 & 0xFFFFFFF;
        n27 = n4 + (n45 >>> 28);
        n28 = n45 & 0xFFFFFFF;
        nArray4[0] = n4;
        nArray5[1] = n3;
        nArray4[2] = n8;
        nArray5[3] = n6;
        nArray4[4] = n7;
        nArray5[5] = n5;
        nArray4[6] = n12;
        nArray5[7] = n10;
        nArray4[8] = n;
        nArray5[9] = n9;
        nArray4[10] = n2;
        nArray5[11] = n25;
        nArray4[12] = n28;
        nArray5[13] = n27;
        nArray4[14] = n26;
        nArray5[15] = n11;
    }

    public static void subOne(int[] nArray) {
        int[] nArray2 = X448Field.create();
        int[] nArray3 = nArray2;
        nArray2[0] = 1;
        X448Field.sub(nArray, nArray3, nArray);
    }

    public static void zero(int[] nArray) {
        for (int k = 0; k < 16; ++k) {
            nArray[k] = 0;
        }
    }
}

