/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.util.Random;

public abstract class Mod {
    private static final int M30 = 0x3FFFFFFF;
    private static final long M32L = 0xFFFFFFFFL;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = nArray.length;
        if (Nat.add(n, nArray2, nArray3, nArray4) != 0) {
            Nat.subFrom(n, nArray, nArray4);
        }
    }

    public static void checkedModOddInverse(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Mod.modOddInverse(nArray, nArray2, nArray3) != 0) {
            return;
        }
        throw new ArithmeticException("Inverse does not exist.");
    }

    public static void checkedModOddInverseVar(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Mod.modOddInverseVar(nArray, nArray2, nArray3)) {
            return;
        }
        throw new ArithmeticException("Inverse does not exist.");
    }

    public static int inverse32(int n) {
        int n2 = n;
        n = (2 - n2 * n2) * n;
        n = (2 - n2 * n) * n;
        n = (2 - n2 * n) * n;
        return (2 - n2 * n) * n;
    }

    public static void invert(int[] nArray, int[] nArray2, int[] nArray3) {
        Mod.checkedModOddInverseVar(nArray, nArray2, nArray3);
    }

    public static int modOddInverse(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        n = (n << 5) - Integers.numberOfLeadingZeros(nArray[n - 1]);
        int n2 = (n + 29) / 30;
        int n3 = -Mod.inverse32(nArray[0]) << 2;
        int[] nArray4 = new int[4];
        int[] nArray5 = new int[n2];
        int[] nArray6 = new int[n2];
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        int[] nArray9 = new int[n2];
        nArray6[0] = 1;
        Mod.encode30(n, nArray2, 0, nArray8, 0);
        Mod.encode30(n, nArray, 0, nArray9, 0);
        System.arraycopy(nArray9, 0, nArray7, 0, n2);
        int n4 = -1;
        int n5 = Mod.getMaximumDivsteps(n);
        for (int k = 0; k < n5; k += 30) {
            int n6 = n2;
            int n7 = n4;
            n4 = nArray7[0];
            n4 = Mod.divsteps30(n7, n4, nArray8[0], nArray4);
            Mod.updateDE30(n6, nArray5, nArray6, nArray4, n3, nArray9);
            Mod.updateFG30(n6, nArray7, nArray8, nArray4);
        }
        int n8 = n2;
        n4 = nArray7[n2 - 1] >> 31;
        Mod.cnegate30(n8, n4, nArray7);
        Mod.cadd30(n8, Mod.cadd30(n8, Mod.csub30(n8, ~Mod.cnegate30(n8, n4, nArray5), nArray5, nArray9), nArray5, nArray9), nArray5, nArray9);
        Mod.decode30(n, nArray5, 0, nArray3, 0);
        return Nat.equalTo(n2, nArray7, 1) & Nat.equalToZero(n2, nArray8);
    }

    public static boolean modOddInverseVar(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        n = (n << 5) - Integers.numberOfLeadingZeros(nArray[n - 1]);
        int n2 = (n + 29) / 30;
        int n3 = -Mod.inverse32(nArray[0]) << 2;
        int[] nArray4 = new int[4];
        int[] nArray5 = new int[n2];
        int[] nArray6 = new int[n2];
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        int n4 = n2;
        int[] nArray9 = new int[n4];
        nArray6[0] = 1;
        Mod.encode30(n, nArray2, 0, nArray8, 0);
        Mod.encode30(n, nArray, 0, nArray9, 0);
        System.arraycopy(nArray9, 0, nArray7, 0, n2);
        int n5 = n4 - 1;
        int n6 = -1 - (Integers.numberOfLeadingZeros(nArray8[n5] | 1) - (n2 * 30 + 2 - n));
        int n7 = Mod.getMaximumDivsteps(n);
        int n8 = 0;
        int n9 = n2;
        while (!Nat.isZero(n9, nArray8)) {
            if (n8 >= n7) {
                return false;
            }
            int n10 = n9;
            int n11 = n6;
            n8 += 30;
            n6 = nArray7[0];
            n6 = Mod.divsteps30Var(n11, n6, nArray8[0], nArray4);
            Mod.updateDE30(n2, nArray5, nArray6, nArray4, n3, nArray9);
            Mod.updateFG30(n10, nArray7, nArray8, nArray4);
            int n12 = n10 - 1;
            int n13 = nArray7[n12];
            n12 = nArray8[n12];
            int n14 = n9 - 2;
            int n15 = n13;
            int n16 = n12;
            if ((n14 >> 31 | n15 ^ n15 >> 31 | n16 ^ n16 >> 31) != 0) continue;
            nArray7[n14] = nArray7[n14] | n13 << 30;
            nArray8[n14] = nArray8[n14] | n12 << 30;
            --n9;
        }
        if (nArray7[n9 - 1] >> 31 != 0) {
            Mod.negate30(n9, nArray7);
            Mod.negate30(n2, nArray5);
        }
        if (!Nat.isOne(n9, nArray7)) {
            return false;
        }
        if ((nArray5[n5] >> 31 < 0 ? Mod.add30(n2, nArray5, nArray9) : Mod.sub30(n2, nArray5, nArray9)) < 0) {
            Mod.add30(n2, nArray5, nArray9);
        }
        Mod.decode30(n, nArray5, 0, nArray3, 0);
        return true;
    }

    public static int[] random(int[] nArray) {
        Random random;
        int n = nArray.length;
        Random random2 = random;
        random = new Random();
        int[] nArray2 = Nat.create(n);
        int n2 = n - 1;
        int n3 = nArray[n2];
        int n4 = n3 | n3 >>> 1;
        int n5 = n4 | n4 >>> 2;
        int n6 = n5 | n5 >>> 4;
        int n7 = n6 | n6 >>> 8;
        int n8 = n7 | n7 >>> 16;
        do {
            for (int k = 0; k != n; ++k) {
                nArray2[k] = random2.nextInt();
            }
            nArray2[n2] = nArray2[n2] & n8;
        } while (Nat.gte(n, nArray2, nArray));
        return nArray2;
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = nArray.length;
        if (Nat.sub(n, nArray2, nArray3, nArray4) != 0) {
            Nat.addTo(n, nArray, nArray4);
        }
    }

    private static int add30(int n, int[] nArray, int[] nArray2) {
        int n2 = n;
        n = 0;
        int n3 = n2 - 1;
        for (int k = 0; k < n3; ++k) {
            n = nArray[k] + nArray2[k] + n;
            nArray[k] = n & 0x3FFFFFFF;
            n >>= 30;
        }
        nArray[n3] = n = nArray[n3] + nArray2[n3] + n;
        return n >> 30;
    }

    private static int cadd30(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = n;
        n = 0;
        int n4 = n3 - 1;
        for (int k = 0; k < n4; ++k) {
            n = nArray[k] + (nArray2[k] & n2) + n;
            nArray[k] = n & 0x3FFFFFFF;
            n >>= 30;
        }
        nArray[n4] = n = nArray[n4] + (nArray2[n4] & n2) + n;
        return n >> 30;
    }

    private static int cnegate30(int n, int n2, int[] nArray) {
        int n3 = n;
        n = 0;
        int n4 = n3 - 1;
        for (int k = 0; k < n4; ++k) {
            n = (nArray[k] ^ n2) - n2 + n;
            nArray[k] = n & 0x3FFFFFFF;
            n >>= 30;
        }
        nArray[n4] = n = (nArray[n4] ^ n2) - n2 + n;
        return n >> 30;
    }

    private static int csub30(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = n;
        n = 0;
        int n4 = n3 - 1;
        for (int k = 0; k < n4; ++k) {
            n = nArray[k] - (nArray2[k] & n2) + n;
            nArray[k] = n & 0x3FFFFFFF;
            n >>= 30;
        }
        nArray[n4] = n = nArray[n4] - (nArray2[n4] & n2) + n;
        return n >> 30;
    }

    private static void decode30(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = 0;
        long l = 0L;
        while (n > 0) {
            while (n4 < Math.min(32, n)) {
                l |= (long)nArray[n2++] << n4;
                n4 += 30;
            }
            int n5 = n3 + 1;
            nArray2[n3] = (int)l;
            long l2 = l >>> 32;
            n4 -= 32;
            n -= 32;
            l = l2;
            n3 = n5;
        }
    }

    private static int divsteps30(int n, int n2, int n3, int[] nArray) {
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        for (int k = 0; k < 30; ++k) {
            int n8 = n5;
            int n9 = n7;
            int n10 = n5;
            n5 = n >> 31;
            n7 = -(n3 & 1);
            int n11 = (n2 ^ n5) - n5;
            int n12 = (n4 ^ n5) - n5;
            n3 += n11 & n7;
            n6 += n12 & n7;
            n11 = n9 + ((n10 ^ n5) - n5 & n7);
            int n13 = n4;
            int n14 = n2;
            int n15 = n;
            n = n5 & n7;
            n2 = (n15 ^ n) - (n + 1);
            n4 = n14 + (n3 & n);
            n5 = n13 + (n6 & n);
            int n16 = n8 + (n11 & n);
            n3 >>= 1;
            n = n5 << 1;
            n5 = n16 << 1;
            int n17 = n;
            int n18 = n2;
            n2 = n4;
            n = n18;
            n7 = n11;
            n4 = n17;
        }
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        nArray2[0] = n4;
        nArray3[1] = n5;
        nArray2[2] = n6;
        nArray3[3] = n7;
        return n;
    }

    private static int divsteps30Var(int n, int n2, int n3, int[] nArray) {
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        int n8 = 30;
        while (true) {
            int n9;
            int n10 = n8;
            int n11 = n;
            int n12 = n3;
            n = Integers.numberOfTrailingZeros(n12 | -1 << n8);
            n3 = n12 >> n;
            n4 <<= n;
            n5 <<= n;
            n8 = n11 - n;
            if ((n = n10 - n) <= 0) {
                int[] nArray2 = nArray;
                int[] nArray3 = nArray;
                nArray2[0] = n4;
                nArray3[1] = n5;
                nArray2[2] = n6;
                nArray3[3] = n7;
                return n8;
            }
            if (n8 < 0) {
                int n13 = n5;
                int n14 = n4;
                int n15 = n2;
                n2 = -n8;
                n4 = -n15;
                n5 = -n14;
                n8 = -n13;
                n9 = n2 + 1;
                if (n9 > n) {
                    n9 = n;
                }
                int n16 = n3;
                n9 = -1 >>> 32 - n9 & 0x3F;
                int n17 = n16 * n4;
                n9 = (n16 * n16 - 2) * n17 & n9;
                int n18 = n5;
                int n19 = n6;
                n6 = n7;
                n5 = n19;
                n7 = n18;
            } else {
                n9 = n8 + 1;
                if (n9 > n) {
                    n9 = n;
                }
                int n20 = n2;
                n9 = -1 >>> 32 - n9 & 0xF;
                n9 = -(n20 + ((n20 + 1 & 4) << 1)) * n3 & n9;
                int n21 = n3;
                int n22 = n2;
                int n23 = n6;
                n2 = n8;
                n6 = n5;
                n8 = n7;
                n5 = n4;
                n7 = n23;
                n3 = n22;
                n4 = n21;
            }
            n4 = n3 * n9 + n4;
            n7 = n5 * n9 + n7;
            n8 = n6 * n9 + n8;
            int n24 = n4;
            int n25 = n;
            int n26 = n5;
            int n27 = n6;
            int n28 = n2;
            int n29 = n7;
            n7 = n8;
            n6 = n29;
            n2 = n3;
            n = n28;
            n5 = n27;
            n4 = n26;
            n8 = n25;
            n3 = n24;
        }
    }

    private static void encode30(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = 0;
        long l = 0L;
        while (n > 0) {
            if (n4 < Math.min(30, n)) {
                l |= ((long)nArray[n2++] & 0xFFFFFFFFL) << n4;
                n4 += 32;
            }
            nArray2[n3++] = (int)l & 0x3FFFFFFF;
            l >>>= 30;
            n4 -= 30;
            n -= 30;
        }
    }

    private static int getMaximumDivsteps(int n) {
        int n2 = n;
        n = n2 * 49;
        int n3 = n2 < 46 ? 80 : 47;
        return (n + n3) / 17;
    }

    private static int negate30(int n, int[] nArray) {
        int n2 = n;
        n = 0;
        int n3 = n2 - 1;
        for (int k = 0; k < n3; ++k) {
            nArray[k] = (n -= nArray[k]) & 0x3FFFFFFF;
            n >>= 30;
        }
        nArray[n3] = n -= nArray[n3];
        return n >> 30;
    }

    private static int sub30(int n, int[] nArray, int[] nArray2) {
        int n2 = n;
        n = 0;
        int n3 = n2 - 1;
        for (int k = 0; k < n3; ++k) {
            n = nArray[k] - nArray2[k] + n;
            nArray[k] = n & 0x3FFFFFFF;
            n >>= 30;
        }
        nArray[n3] = n = nArray[n3] - nArray2[n3] + n;
        return n >> 30;
    }

    private static void updateDE30(int n, int[] nArray, int[] nArray2, int[] nArray3, int n2, int[] nArray4) {
        int n3 = n2;
        int n4 = nArray3[0];
        n2 = nArray3[1];
        int n5 = nArray3[2];
        int n6 = n2;
        int n7 = n4;
        n4 = nArray[0];
        n2 = nArray2[0];
        long l = n7;
        long l2 = n4;
        long l3 = l * l2;
        long l4 = n6;
        long l5 = n2;
        l3 = l4 * l5 + l3;
        long l6 = n5;
        l2 = l6 * l2;
        long l7 = nArray3[3];
        l5 = l7 * l5 + l2;
        int n8 = n3 * (int)l3 >> 2;
        int n9 = n3 * (int)l5 >> 2;
        int n10 = nArray4[0];
        long l8 = n8;
        l3 = (long)n10 * l8 + l3;
        long l9 = n9;
        long l10 = (long)n10 * l9 + l5;
        l5 = l3 >> 30;
        l3 = l10 >> 30;
        for (int k = 1; k < n; ++k) {
            int n11 = nArray[k];
            long l11 = n11;
            long l12 = l * l11;
            long l13 = nArray2[k];
            l5 = a.a(l4, l13, l12, l5);
            l11 = l6 * l11;
            l3 = a.a(l7, l13, l11, l3);
            int n12 = nArray4[k];
            l5 = (long)n12 * l8 + l5;
            l3 = (long)n12 * l9 + l3;
            n11 = k - 1;
            nArray[n11] = (int)l5 & 0x3FFFFFFF;
            l5 >>= 30;
            nArray2[n11] = (int)l3 & 0x3FFFFFFF;
            l3 >>= 30;
        }
        nArray[--n] = (int)l5;
        nArray2[n] = (int)l3;
    }

    private static void updateFG30(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        int n2 = nArray3[0];
        int n3 = nArray3[1];
        int n4 = nArray3[2];
        int n5 = n3;
        int n6 = n2;
        n2 = nArray[0];
        n3 = nArray2[0];
        long l = n6;
        long l2 = n2;
        long l3 = l * l2;
        long l4 = n5;
        long l5 = n3;
        l3 = l4 * l5 + l3;
        long l6 = n4;
        l2 = l6 * l2;
        long l7 = nArray3[3];
        long l8 = l7 * l5 + l2;
        l2 = l3 >> 30;
        l3 = l8 >> 30;
        for (n2 = 1; n2 < n; ++n2) {
            n3 = nArray[n2];
            l5 = n3;
            long l9 = l * l5;
            long l10 = nArray2[n2];
            l2 = a.a(l4, l10, l9, l2);
            l5 = l6 * l5;
            l3 = a.a(l7, l10, l5, l3);
            n3 = n2 - 1;
            nArray[n3] = (int)l2 & 0x3FFFFFFF;
            l2 >>= 30;
            nArray2[n3] = (int)l3 & 0x3FFFFFFF;
            l3 >>= 30;
        }
        nArray[--n] = (int)l2;
        nArray2[n] = (int)l3;
    }
}

