/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat192 {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int[] nArray, int[] nArray2, int[] nArray3) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l;
        l >>>= 32;
        l = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + l;
        nArray3[1] = (int)l;
        l >>>= 32;
        l = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + l;
        nArray3[2] = (int)l;
        l >>>= 32;
        l = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + l;
        nArray3[3] = (int)l;
        l >>>= 32;
        l = ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL) + l;
        nArray3[4] = (int)l;
        long l2 = ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL) + (l >>>= 32);
        nArray3[5] = (int)l2;
        return (int)(l2 >>> 32);
    }

    public static int addBothTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)nArray3[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l;
        l >>>= 32;
        l = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + ((long)nArray3[1] & 0xFFFFFFFFL) + l;
        nArray3[1] = (int)l;
        l >>>= 32;
        l = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + ((long)nArray3[2] & 0xFFFFFFFFL) + l;
        nArray3[2] = (int)l;
        l >>>= 32;
        l = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + ((long)nArray3[3] & 0xFFFFFFFFL) + l;
        nArray3[3] = (int)l;
        l >>>= 32;
        l = ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL) + ((long)nArray3[4] & 0xFFFFFFFFL) + l;
        nArray3[4] = (int)l;
        long l2 = ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL) + ((long)nArray3[5] & 0xFFFFFFFFL) + (l >>>= 32);
        nArray3[5] = (int)l2;
        return (int)(l2 >>> 32);
    }

    public static int addTo(int[] nArray, int[] nArray2) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray2[0] = (int)l;
        l >>>= 32;
        l = ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + l;
        nArray2[1] = (int)l;
        l >>>= 32;
        l = ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + l;
        nArray2[2] = (int)l;
        l >>>= 32;
        l = ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + l;
        nArray2[3] = (int)l;
        l >>>= 32;
        l = ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL) + l;
        nArray2[4] = (int)l;
        l >>>= 32;
        l = ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL) + l;
        nArray2[5] = (int)l;
        return (int)(l >>> 32);
    }

    public static int addTo(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        long l = (long)n3 & 0xFFFFFFFFL;
        n3 = n2 + 0;
        l = ((long)nArray[n + 0] & 0xFFFFFFFFL) + ((long)nArray2[n3] & 0xFFFFFFFFL) + l;
        nArray2[n3] = (int)l;
        l >>>= 32;
        n3 = n2 + 1;
        l = ((long)nArray[n + 1] & 0xFFFFFFFFL) + ((long)nArray2[n3] & 0xFFFFFFFFL) + l;
        nArray2[n3] = (int)l;
        l >>>= 32;
        n3 = n2 + 2;
        l = ((long)nArray[n + 2] & 0xFFFFFFFFL) + ((long)nArray2[n3] & 0xFFFFFFFFL) + l;
        nArray2[n3] = (int)l;
        l >>>= 32;
        n3 = n2 + 3;
        l = ((long)nArray[n + 3] & 0xFFFFFFFFL) + ((long)nArray2[n3] & 0xFFFFFFFFL) + l;
        nArray2[n3] = (int)l;
        l >>>= 32;
        n3 = n2 + 4;
        l = ((long)nArray[n + 4] & 0xFFFFFFFFL) + ((long)nArray2[n3] & 0xFFFFFFFFL) + l;
        nArray2[n3] = (int)l;
        l >>>= 32;
        l = ((long)nArray[n + 5] & 0xFFFFFFFFL) + ((long)nArray2[n2 += 5] & 0xFFFFFFFFL) + l;
        nArray2[n2] = (int)l;
        return (int)(l >>> 32);
    }

    public static int addToEachOther(int[] nArray, int n, int[] nArray2, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n + 0;
        int n9 = n2 + 0;
        long l = ((long)nArray[n8] & 0xFFFFFFFFL) + ((long)nArray2[n9] & 0xFFFFFFFFL) + 0L;
        nArray[n8] = n8 = (int)l;
        nArray2[n9] = n8;
        long l2 = l >>> 32;
        int n10 = n + 1;
        int n11 = n2 + 1;
        l2 = ((long)nArray[n10] & 0xFFFFFFFFL) + ((long)nArray2[n11] & 0xFFFFFFFFL) + l2;
        nArray[n10] = n7 = (int)l2;
        nArray2[n11] = n7;
        long l3 = l2 >>> 32;
        n10 = n + 2;
        n11 = n2 + 2;
        l3 = ((long)nArray[n10] & 0xFFFFFFFFL) + ((long)nArray2[n11] & 0xFFFFFFFFL) + l3;
        nArray[n10] = n6 = (int)l3;
        nArray2[n11] = n6;
        long l4 = l3 >>> 32;
        n10 = n + 3;
        n11 = n2 + 3;
        l4 = ((long)nArray[n10] & 0xFFFFFFFFL) + ((long)nArray2[n11] & 0xFFFFFFFFL) + l4;
        nArray[n10] = n5 = (int)l4;
        nArray2[n11] = n5;
        long l5 = l4 >>> 32;
        n10 = n + 4;
        n11 = n2 + 4;
        l5 = ((long)nArray[n10] & 0xFFFFFFFFL) + ((long)nArray2[n11] & 0xFFFFFFFFL) + l5;
        nArray[n10] = n4 = (int)l5;
        nArray2[n11] = n4;
        long l6 = l5 >>> 32;
        l6 = ((long)nArray[n += 5] & 0xFFFFFFFFL) + ((long)nArray2[n2 += 5] & 0xFFFFFFFFL) + l6;
        nArray[n] = n3 = (int)l6;
        nArray2[n2] = n3;
        return (int)(l6 >>> 32);
    }

    public static void copy(int[] nArray, int[] nArray2) {
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        nArray2[2] = nArray[2];
        nArray2[3] = nArray[3];
        nArray2[4] = nArray[4];
        nArray2[5] = nArray[5];
    }

    public static void copy(int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = n2 + 0;
        nArray2[n3] = nArray[n + 0];
        n3 = n2 + 1;
        nArray2[n3] = nArray[n + 1];
        n3 = n2 + 2;
        nArray2[n3] = nArray[n + 2];
        n3 = n2 + 3;
        nArray2[n3] = nArray[n + 3];
        n3 = n2 + 4;
        nArray2[n3] = nArray[n + 4];
        n3 = n2 + 5;
        nArray2[n3] = nArray[n + 5];
    }

    public static void copy64(long[] lArray, long[] lArray2) {
        long l;
        lArray2[0] = l = lArray[0];
        lArray2[1] = l = lArray[1];
        lArray2[2] = l = lArray[2];
    }

    public static void copy64(long[] lArray, int n, long[] lArray2, int n2) {
        long l;
        int n3 = n2 + 0;
        lArray2[n3] = l = lArray[n + 0];
        n3 = n2 + 1;
        lArray2[n3] = l = lArray[n + 1];
        n3 = n2 + 2;
        lArray2[n3] = l = lArray[n + 2];
    }

    public static int[] create() {
        return new int[6];
    }

    public static long[] create64() {
        return new long[3];
    }

    public static int[] createExt() {
        return new int[12];
    }

    public static long[] createExt64() {
        return new long[6];
    }

    public static boolean diff(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3, int n3) {
        boolean bl = Nat192.gte(nArray, n, nArray2, n2);
        if (bl) {
            Nat192.sub(nArray, n, nArray2, n2, nArray3, n3);
        } else {
            Nat192.sub(nArray2, n2, nArray, n, nArray3, n3);
        }
        return bl;
    }

    public static boolean eq(int[] nArray, int[] nArray2) {
        for (int k = 5; k >= 0; --k) {
            if (nArray[k] == nArray2[k]) continue;
            return false;
        }
        return true;
    }

    public static boolean eq64(long[] lArray, long[] lArray2) {
        for (int k = 2; k >= 0; --k) {
            if (lArray[k] == lArray2[k]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        if (bigInteger.signum() >= 0 && bigInteger.bitLength() <= 192) {
            int[] nArray = Nat192.create();
            for (int k = 0; k < 6; ++k) {
                nArray[k] = bigInteger.intValue();
                bigInteger = bigInteger.shiftRight(32);
            }
            return nArray;
        }
        throw new IllegalArgumentException();
    }

    public static long[] fromBigInteger64(BigInteger bigInteger) {
        if (bigInteger.signum() >= 0 && bigInteger.bitLength() <= 192) {
            long[] lArray = Nat192.create64();
            for (int k = 0; k < 3; ++k) {
                long l;
                lArray[k] = l = bigInteger.longValue();
                bigInteger = bigInteger.shiftRight(64);
            }
            return lArray;
        }
        throw new IllegalArgumentException();
    }

    public static int getBit(int[] nArray, int n) {
        if (n == 0) {
            return nArray[0] & 1;
        }
        int n2 = n >> 5;
        if (n2 >= 0 && n2 < 6) {
            int n3 = n & 0x1F;
            return nArray[n2] >>> n3 & 1;
        }
        return 0;
    }

    public static boolean gte(int[] nArray, int[] nArray2) {
        for (int k = 5; k >= 0; --k) {
            int n = nArray[k] ^ Integer.MIN_VALUE;
            int n2 = nArray2[k] ^ Integer.MIN_VALUE;
            if (n < n2) {
                return false;
            }
            if (n <= n2) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int[] nArray, int n, int[] nArray2, int n2) {
        for (int k = 5; k >= 0; --k) {
            int n3 = nArray[n + k] ^ Integer.MIN_VALUE;
            int n4 = nArray2[n2 + k] ^ Integer.MIN_VALUE;
            if (n3 < n4) {
                return false;
            }
            if (n3 <= n4) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] nArray) {
        if (nArray[0] != 1) {
            return false;
        }
        for (int k = 1; k < 6; ++k) {
            if (nArray[k] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isOne64(long[] lArray) {
        if (lArray[0] != 1L) {
            return false;
        }
        for (int k = 1; k < 3; ++k) {
            if (lArray[k] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] nArray) {
        for (int k = 0; k < 6; ++k) {
            if (nArray[k] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] lArray) {
        for (int k = 0; k < 3; ++k) {
            if (lArray[k] == 0L) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] nArray, int[] nArray2, int[] nArray3) {
        long l;
        long l2 = (long)nArray2[0] & 0xFFFFFFFFL;
        long l3 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[4] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[5] & 0xFFFFFFFFL;
        long l8 = (long)nArray[0] & 0xFFFFFFFFL;
        long l9 = l = l8;
        long l10 = l;
        long l11 = l;
        long l12 = l;
        l = l * l2 + 0L;
        nArray3[0] = (int)l;
        l >>>= 32;
        l = l12 * l3 + l;
        nArray3[1] = (int)l;
        l >>>= 32;
        l = l11 * l4 + l;
        nArray3[2] = (int)l;
        l >>>= 32;
        l = l10 * l5 + l;
        nArray3[3] = (int)l;
        l >>>= 32;
        l = l9 * l6 + l;
        nArray3[4] = (int)l;
        l >>>= 32;
        l = l8 * l7 + l;
        nArray3[5] = (int)l;
        nArray3[6] = (int)(l >>> 32);
        int n = 1;
        while (n < 6) {
            long l13 = (long)nArray[n] & 0xFFFFFFFFL;
            long l14 = l = l13;
            long l15 = l;
            long l16 = l;
            long l17 = l;
            int n2 = n + 0;
            long l18 = l * l2 + ((long)nArray3[n2] & 0xFFFFFFFFL) + 0L;
            nArray3[n2] = (int)l18;
            l = l18 >>> 32;
            int n3 = n + 1;
            l = l17 * l3 + ((long)nArray3[n3] & 0xFFFFFFFFL) + l;
            nArray3[n3] = (int)l;
            l >>>= 32;
            int n4 = n + 2;
            l = l16 * l4 + ((long)nArray3[n4] & 0xFFFFFFFFL) + l;
            nArray3[n4] = (int)l;
            l >>>= 32;
            n4 = n + 3;
            l = l15 * l5 + ((long)nArray3[n4] & 0xFFFFFFFFL) + l;
            nArray3[n4] = (int)l;
            l >>>= 32;
            n4 = n + 4;
            l = l14 * l6 + ((long)nArray3[n4] & 0xFFFFFFFFL) + l;
            nArray3[n4] = (int)l;
            l >>>= 32;
            n4 = n + 5;
            l = l13 * l7 + ((long)nArray3[n4] & 0xFFFFFFFFL) + l;
            nArray3[n4] = (int)l;
            nArray3[n += 6] = (int)(l >>> 32);
            n = n3;
        }
    }

    public static void mul(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3, int n3) {
        long l;
        long l2 = (long)nArray2[n2 + 0] & 0xFFFFFFFFL;
        long l3 = (long)nArray2[n2 + 1] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[n2 + 2] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n2 + 3] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n2 + 4] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[n2 + 5] & 0xFFFFFFFFL;
        long l8 = (long)nArray[n + 0] & 0xFFFFFFFFL;
        long l9 = l = l8;
        long l10 = l;
        long l11 = l;
        long l12 = l;
        l = l * l2 + 0L;
        int n4 = n3 + 0;
        nArray3[n4] = (int)l;
        long l13 = l >>> 32;
        l13 = l12 * l3 + l13;
        int n5 = n3 + 1;
        nArray3[n5] = (int)l13;
        long l14 = l13 >>> 32;
        l14 = l11 * l4 + l14;
        int n6 = n3 + 2;
        nArray3[n6] = (int)l14;
        long l15 = l14 >>> 32;
        l15 = l10 * l5 + l15;
        int n7 = n3 + 3;
        nArray3[n7] = (int)l15;
        long l16 = l15 >>> 32;
        l16 = l9 * l6 + l16;
        int n8 = n3 + 4;
        nArray3[n8] = (int)l16;
        long l17 = l16 >>> 32;
        l17 = l8 * l7 + l17;
        int n9 = n3 + 5;
        nArray3[n9] = (int)l17;
        n9 = n3 + 6;
        nArray3[n9] = (int)(l17 >>> 32);
        for (n9 = 1; n9 < 6; ++n9) {
            long l18 = (long)nArray[n + n9] & 0xFFFFFFFFL;
            int n10 = ++n3 + 0;
            long l19 = l18 * l2 + ((long)nArray3[n10] & 0xFFFFFFFFL) + 0L;
            nArray3[n10] = (int)l19;
            long l20 = l19 >>> 32;
            int n11 = n3 + 1;
            l20 = l18 * l3 + ((long)nArray3[n11] & 0xFFFFFFFFL) + l20;
            nArray3[n11] = (int)l20;
            l20 >>>= 32;
            n11 = n3 + 2;
            l20 = l18 * l4 + ((long)nArray3[n11] & 0xFFFFFFFFL) + l20;
            nArray3[n11] = (int)l20;
            l20 >>>= 32;
            n11 = n3 + 3;
            l20 = l18 * l5 + ((long)nArray3[n11] & 0xFFFFFFFFL) + l20;
            nArray3[n11] = (int)l20;
            l20 >>>= 32;
            n11 = n3 + 4;
            l20 = l18 * l6 + ((long)nArray3[n11] & 0xFFFFFFFFL) + l20;
            nArray3[n11] = (int)l20;
            l20 >>>= 32;
            n11 = n3 + 5;
            l20 = l18 * l7 + ((long)nArray3[n11] & 0xFFFFFFFFL) + l20;
            nArray3[n11] = (int)l20;
            int n12 = n3 + 6;
            nArray3[n12] = (int)(l20 >>> 32);
        }
    }

    public static int mulAddTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l = (long)nArray2[0] & 0xFFFFFFFFL;
        long l2 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l3 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[4] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[5] & 0xFFFFFFFFL;
        long l7 = 0L;
        int n = 0;
        while (n < 6) {
            long l8;
            long l9 = (long)nArray[n] & 0xFFFFFFFFL;
            long l10 = l8 = l9;
            long l11 = l8;
            long l12 = l8;
            long l13 = l8;
            int n2 = n + 0;
            long l14 = l8 * l + ((long)nArray3[n2] & 0xFFFFFFFFL) + 0L;
            nArray3[n2] = (int)l14;
            l8 = l14 >>> 32;
            int n3 = n + 1;
            l8 = l13 * l2 + ((long)nArray3[n3] & 0xFFFFFFFFL) + l8;
            nArray3[n3] = (int)l8;
            l8 >>>= 32;
            int n4 = n + 2;
            l8 = l12 * l3 + ((long)nArray3[n4] & 0xFFFFFFFFL) + l8;
            nArray3[n4] = (int)l8;
            l8 >>>= 32;
            n4 = n + 3;
            l8 = l11 * l4 + ((long)nArray3[n4] & 0xFFFFFFFFL) + l8;
            nArray3[n4] = (int)l8;
            l8 >>>= 32;
            n4 = n + 4;
            l8 = l10 * l5 + ((long)nArray3[n4] & 0xFFFFFFFFL) + l8;
            nArray3[n4] = (int)l8;
            l8 >>>= 32;
            n4 = n + 5;
            l8 = l9 * l6 + ((long)nArray3[n4] & 0xFFFFFFFFL) + l8;
            nArray3[n4] = (int)l8;
            l7 = (l8 >>> 32) + ((long)nArray3[n += 6] & 0xFFFFFFFFL) + l7;
            nArray3[n] = (int)l7;
            l7 >>>= 32;
            n = n3;
        }
        return (int)l7;
    }

    public static int mulAddTo(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3, int n3) {
        long l = (long)nArray2[n2 + 0] & 0xFFFFFFFFL;
        long l2 = (long)nArray2[n2 + 1] & 0xFFFFFFFFL;
        long l3 = (long)nArray2[n2 + 2] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[n2 + 3] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n2 + 4] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n2 + 5] & 0xFFFFFFFFL;
        long l7 = 0L;
        for (int k = 0; k < 6; ++k) {
            long l8;
            long l9 = (long)nArray[n + k] & 0xFFFFFFFFL;
            long l10 = l8 = l9;
            long l11 = l8;
            long l12 = l8;
            long l13 = l8;
            int n4 = n3 + 0;
            long l14 = l8 * l + ((long)nArray3[n4] & 0xFFFFFFFFL) + 0L;
            nArray3[n4] = (int)l14;
            l8 = l14 >>> 32;
            int n5 = n3 + 1;
            l8 = l13 * l2 + ((long)nArray3[n5] & 0xFFFFFFFFL) + l8;
            nArray3[n5] = (int)l8;
            l8 >>>= 32;
            int n6 = n3 + 2;
            l8 = l12 * l3 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l8;
            nArray3[n6] = (int)l8;
            l8 >>>= 32;
            n6 = n3 + 3;
            l8 = l11 * l4 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l8;
            nArray3[n6] = (int)l8;
            l8 >>>= 32;
            n6 = n3 + 4;
            l8 = l10 * l5 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l8;
            nArray3[n6] = (int)l8;
            l8 >>>= 32;
            n6 = n3 + 5;
            l8 = l9 * l6 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l8;
            nArray3[n6] = (int)l8;
            l7 = (l8 >>> 32) + ((long)nArray3[n3 += 6] & 0xFFFFFFFFL) + l7;
            nArray3[n3] = (int)l7;
            l7 >>>= 32;
            n3 = n5;
        }
        return (int)l7;
    }

    public static long mul33Add(int n, int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = l;
        int n5 = n2;
        long l3 = l2;
        int n6 = n2;
        long l4 = l2;
        int n7 = n2;
        long l5 = l2;
        int n8 = n2;
        long l6 = l2;
        int n9 = n2;
        long l7 = (long)nArray[n2 + 0] & 0xFFFFFFFFL;
        l2 = l2 * l7 + ((long)nArray2[n3 + 0] & 0xFFFFFFFFL) + 0L;
        n2 = n4 + 0;
        nArray3[n2] = (int)l2;
        long l8 = (long)nArray[n9 + 1] & 0xFFFFFFFFL;
        l7 = l6 * l8 + l7 + ((long)nArray2[n3 + 1] & 0xFFFFFFFFL) + (l2 >>>= 32);
        int n10 = n4 + 1;
        nArray3[n10] = (int)l7;
        long l9 = l7 >>> 32;
        l2 = (long)nArray[n8 + 2] & 0xFFFFFFFFL;
        l9 = l5 * l2 + l8 + ((long)nArray2[n3 + 2] & 0xFFFFFFFFL) + l9;
        int n11 = n4 + 2;
        nArray3[n11] = (int)l9;
        long l10 = l9 >>> 32;
        l8 = (long)nArray[n7 + 3] & 0xFFFFFFFFL;
        l10 = l4 * l8 + l2 + ((long)nArray2[n3 + 3] & 0xFFFFFFFFL) + l10;
        int n12 = n4 + 3;
        nArray3[n12] = (int)l10;
        long l11 = l10 >>> 32;
        l2 = (long)nArray[n6 + 4] & 0xFFFFFFFFL;
        l11 = l3 * l2 + l8 + ((long)nArray2[n3 + 4] & 0xFFFFFFFFL) + l11;
        int n13 = n4 + 4;
        nArray3[n13] = (int)l11;
        long l12 = l11 >>> 32;
        l8 = (long)nArray[n5 + 5] & 0xFFFFFFFFL;
        l12 = l * l8 + l2 + ((long)nArray2[n3 + 5] & 0xFFFFFFFFL) + l12;
        int n14 = n4 + 5;
        nArray3[n14] = (int)l12;
        return (l12 >>> 32) + l8;
    }

    public static int mulWordAddExt(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        long l = (long)n & 0xFFFFFFFFL;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        n = n3 + 0;
        long l2 = l * ((long)nArray[n2 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n] & 0xFFFFFFFFL) + 0L;
        nArray2[n] = (int)l2;
        long l3 = l2 >>> 32;
        long l4 = l * ((long)nArray[n2 + 1] & 0xFFFFFFFFL);
        n2 = n3 + 1;
        l3 = l4 + ((long)nArray2[n2] & 0xFFFFFFFFL) + l3;
        nArray2[n2] = (int)l3;
        l3 >>>= 32;
        n2 = n3 + 2;
        l3 = l * ((long)nArray[n7 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n2] & 0xFFFFFFFFL) + l3;
        nArray2[n2] = (int)l3;
        l3 >>>= 32;
        n2 = n3 + 3;
        l3 = l * ((long)nArray[n6 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n2] & 0xFFFFFFFFL) + l3;
        nArray2[n2] = (int)l3;
        l3 >>>= 32;
        n2 = n3 + 4;
        l3 = l * ((long)nArray[n5 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n2] & 0xFFFFFFFFL) + l3;
        nArray2[n2] = (int)l3;
        l3 >>>= 32;
        n2 = n3 + 5;
        l3 = l * ((long)nArray[n4 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n2] & 0xFFFFFFFFL) + l3;
        nArray2[n2] = (int)l3;
        return (int)(l3 >>> 32);
    }

    public static int mul33DWordAdd(int n, long l, int[] nArray, int n2) {
        long l2 = (long)n & 0xFFFFFFFFL;
        long l3 = l & 0xFFFFFFFFL;
        int n3 = n2 + 0;
        long l4 = l2 * l3 + ((long)nArray[n3] & 0xFFFFFFFFL) + 0L;
        nArray[n3] = (int)l4;
        long l5 = l >>> 32;
        int n4 = n2 + 1;
        l = l2 * l5 + l3 + ((long)nArray[n4] & 0xFFFFFFFFL) + (l4 >>>= 32);
        nArray[n4] = (int)l;
        long l6 = l >>> 32;
        n3 = n2 + 2;
        l6 = l5 + ((long)nArray[n3] & 0xFFFFFFFFL) + l6;
        nArray[n3] = (int)l6;
        int n5 = n2 + 3;
        l = (l6 >>> 32) + ((long)nArray[n5] & 0xFFFFFFFFL);
        nArray[n5] = (int)l;
        return l >>> 32 == 0L ? 0 : Nat.incAt(6, nArray, n2, 4);
    }

    public static int mul33WordAdd(int n, int n2, int[] nArray, int n3) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        long l3 = l2;
        int n4 = n3 + 0;
        l3 = l3 * l + ((long)nArray[n4] & 0xFFFFFFFFL) + 0L;
        nArray[n4] = (int)l3;
        long l4 = l3 >>> 32;
        int n5 = n3 + 1;
        l4 = l2 + ((long)nArray[n5] & 0xFFFFFFFFL) + l4;
        nArray[n5] = (int)l4;
        int n6 = n3 + 2;
        long l5 = (l4 >>> 32) + ((long)nArray[n6] & 0xFFFFFFFFL);
        nArray[n6] = (int)l5;
        return l5 >>> 32 == 0L ? 0 : Nat.incAt(6, nArray, n3, 3);
    }

    public static int mulWordDwordAdd(int n, long l, int[] nArray, int n2) {
        long l2 = (long)n & 0xFFFFFFFFL;
        long l3 = l;
        n = n2 + 0;
        l = l2 * (l & 0xFFFFFFFFL) + ((long)nArray[n] & 0xFFFFFFFFL) + 0L;
        nArray[n] = (int)l;
        long l4 = l >>> 32;
        int n3 = n2 + 1;
        l4 = l2 * (l3 >>> 32) + ((long)nArray[n3] & 0xFFFFFFFFL) + l4;
        nArray[n3] = (int)l4;
        int n4 = n2 + 2;
        l = (l4 >>> 32) + ((long)nArray[n4] & 0xFFFFFFFFL);
        nArray[n4] = (int)l;
        return l >>> 32 == 0L ? 0 : Nat.incAt(6, nArray, n2, 3);
    }

    public static int mulWord(int n, int[] nArray, int[] nArray2, int n2) {
        long l = 0L;
        long l2 = (long)n & 0xFFFFFFFFL;
        n = 0;
        do {
            l = l2 * ((long)nArray[n] & 0xFFFFFFFFL) + l;
            int n3 = n2 + n;
            nArray2[n3] = (int)l;
            l >>>= 32;
        } while (++n < 6);
        return (int)l;
    }

    public static void square(int[] nArray, int[] nArray2) {
        long l = (long)nArray[0] & 0xFFFFFFFFL;
        int n = 0;
        int n2 = 5;
        int n3 = 12;
        while (true) {
            int n4 = n2 + -1;
            long l2 = (long)nArray[n2] & 0xFFFFFFFFL;
            long l3 = l2 * l2;
            int n5 = n;
            n = n3 + -1;
            nArray2[n] = n5 << 31 | (int)(l3 >>> 33);
            n3 = n + -1;
            nArray2[n3] = (int)(l3 >>> 1);
            n = (int)l3;
            if (n4 <= 0) {
                long l4 = l;
                long l5 = l4 * l4;
                long l6 = (long)(n << 31) & 0xFFFFFFFFL | l5 >>> 33;
                nArray2[0] = (int)l5;
                n3 = (int)(l5 >>> 32) & 1;
                long l7 = (long)nArray[1] & 0xFFFFFFFFL;
                long l8 = l7 * l + l6;
                int n6 = (int)l8;
                nArray2[1] = n6 << 1 | n3;
                int n7 = n6 >>> 31;
                l5 = ((long)nArray2[2] & 0xFFFFFFFFL) + (l8 >>> 32);
                long l9 = (long)nArray[2] & 0xFFFFFFFFL;
                long l10 = (long)nArray2[3] & 0xFFFFFFFFL;
                long l11 = l9 * l + l5;
                int n8 = (int)l11;
                nArray2[2] = n8 << 1 | n7;
                n7 = n8 >>> 31;
                l5 = a.a(l9, l7, l11 >>> 32, l10);
                long l12 = ((long)nArray2[4] & 0xFFFFFFFFL) + (l5 >>> 32);
                l10 = l12;
                l5 &= 0xFFFFFFFFL;
                long l13 = (long)nArray[3] & 0xFFFFFFFFL;
                l10 = ((long)nArray2[5] & 0xFFFFFFFFL) + (l10 >>> 32);
                long l14 = l12 & 0xFFFFFFFFL;
                long l15 = ((long)nArray2[6] & 0xFFFFFFFFL) + (l10 >>> 32);
                l10 &= 0xFFFFFFFFL;
                long l16 = l13 * l + l5;
                int n9 = (int)l16;
                nArray2[3] = n9 << 1 | n7;
                n7 = n9 >>> 31;
                l5 = a.a(l13, l7, l16 >>> 32, l14);
                l10 = a.a(l13, l9, l5 >>> 32, l10);
                l5 &= 0xFFFFFFFFL;
                long l17 = l15 + (l10 >>> 32);
                l14 = l17;
                l10 &= 0xFFFFFFFFL;
                long l18 = (long)nArray[4] & 0xFFFFFFFFL;
                l14 = ((long)nArray2[7] & 0xFFFFFFFFL) + (l14 >>> 32);
                long l19 = l17 & 0xFFFFFFFFL;
                long l20 = ((long)nArray2[8] & 0xFFFFFFFFL) + (l14 >>> 32);
                l14 &= 0xFFFFFFFFL;
                long l21 = l18 * l + l5;
                int n10 = (int)l21;
                nArray2[4] = n10 << 1 | n7;
                n7 = n10 >>> 31;
                l5 = a.a(l18, l7, l21 >>> 32, l10);
                l10 = a.a(l18, l9, l5 >>> 32, l19);
                l5 &= 0xFFFFFFFFL;
                l14 = a.a(l18, l13, l10 >>> 32, l14);
                l10 &= 0xFFFFFFFFL;
                long l22 = l20 + (l14 >>> 32);
                l19 = l22;
                l14 &= 0xFFFFFFFFL;
                long l23 = (long)nArray[5] & 0xFFFFFFFFL;
                l19 = ((long)nArray2[9] & 0xFFFFFFFFL) + (l19 >>> 32);
                long l24 = l22 & 0xFFFFFFFFL;
                long l25 = l;
                l = l19 & 0xFFFFFFFFL;
                long l26 = l23 * l25 + l5;
                int n11 = (int)l26;
                nArray2[5] = n11 << 1 | n7;
                int n12 = n11 >>> 31;
                long l27 = a.a(l23, l7, l26 >>> 32, l10);
                long l28 = a.a(l23, l9, l27 >>> 32, l14);
                l3 = a.a(l23, l13, l28 >>> 32, l24);
                l = a.a(l23, l18, l3 >>> 32, l);
                long l29 = ((long)nArray2[10] & 0xFFFFFFFFL) + (l19 >>> 32) + (l >>> 32);
                int n13 = (int)l27;
                nArray2[6] = n13 << 1 | n12;
                n12 = n13 >>> 31;
                int n14 = (int)l28;
                nArray2[7] = n14 << 1 | n12;
                n12 = n14 >>> 31;
                int n15 = (int)l3;
                nArray2[8] = n15 << 1 | n12;
                n12 = n15 >>> 31;
                int n16 = (int)l;
                nArray2[9] = n16 << 1 | n12;
                n12 = n16 >>> 31;
                int n17 = (int)l29;
                nArray2[10] = n17 << 1 | n12;
                n12 = n17 >>> 31;
                nArray2[11] = nArray2[11] + (int)(l29 >>> 32) << 1 | n12;
                return;
            }
            n2 = n4;
        }
    }

    public static void square(int[] nArray, int n, int[] nArray2, int n2) {
        long l = (long)nArray[n + 0] & 0xFFFFFFFFL;
        int n3 = 0;
        int n4 = 5;
        int n5 = 12;
        while (true) {
            int n6 = n4 + -1;
            long l2 = (long)nArray[n + n4] & 0xFFFFFFFFL;
            long l3 = l2 * l2;
            int n7 = n3;
            n3 = n5 + -1;
            n4 = n2 + n3;
            nArray2[n4] = n7 << 31 | (int)(l3 >>> 33);
            n5 = n3 + -1;
            n3 = n2 + n5;
            nArray2[n3] = (int)(l3 >>> 1);
            n3 = (int)l3;
            if (n6 <= 0) {
                long l4 = l;
                long l5 = l4 * l4;
                long l6 = (long)(n3 << 31) & 0xFFFFFFFFL | l5 >>> 33;
                n5 = n2 + 0;
                nArray2[n5] = (int)l5;
                n5 = (int)(l5 >>> 32) & 1;
                long l7 = (long)nArray[n + 1] & 0xFFFFFFFFL;
                int n8 = n2 + 2;
                long l8 = l7 * l + l6;
                int n9 = (int)l8;
                int n10 = n2 + 1;
                nArray2[n10] = n9 << 1 | n5;
                n10 = n9 >>> 31;
                l5 = ((long)nArray2[n8] & 0xFFFFFFFFL) + (l8 >>> 32);
                long l9 = (long)nArray[n + 2] & 0xFFFFFFFFL;
                int n11 = n2 + 3;
                long l10 = (long)nArray2[n11] & 0xFFFFFFFFL;
                int n12 = n2 + 4;
                long l11 = l9 * l + l5;
                int n13 = (int)l11;
                nArray2[n8] = n13 << 1 | n10;
                n10 = n13 >>> 31;
                long l12 = a.a(l9, l7, l11 >>> 32, l10);
                long l13 = ((long)nArray2[n12] & 0xFFFFFFFFL) + (l12 >>> 32);
                l10 = l13;
                l12 &= 0xFFFFFFFFL;
                long l14 = (long)nArray[n + 3] & 0xFFFFFFFFL;
                n8 = n2 + 5;
                l10 = ((long)nArray2[n8] & 0xFFFFFFFFL) + (l10 >>> 32);
                long l15 = l13 & 0xFFFFFFFFL;
                int n14 = n2 + 6;
                long l16 = ((long)nArray2[n14] & 0xFFFFFFFFL) + (l10 >>> 32);
                l10 &= 0xFFFFFFFFL;
                long l17 = l14 * l + l12;
                int n15 = (int)l17;
                nArray2[n11] = n15 << 1 | n10;
                n10 = n15 >>> 31;
                long l18 = a.a(l14, l7, l17 >>> 32, l15);
                long l19 = a.a(l14, l9, l18 >>> 32, l10);
                l18 &= 0xFFFFFFFFL;
                long l20 = l16 + (l19 >>> 32);
                l15 = l20;
                l19 &= 0xFFFFFFFFL;
                long l21 = (long)nArray[n + 4] & 0xFFFFFFFFL;
                int n16 = n2 + 7;
                l15 = ((long)nArray2[n16] & 0xFFFFFFFFL) + (l15 >>> 32);
                long l22 = l20 & 0xFFFFFFFFL;
                int n17 = n2 + 8;
                long l23 = ((long)nArray2[n17] & 0xFFFFFFFFL) + (l15 >>> 32);
                l15 &= 0xFFFFFFFFL;
                long l24 = l21 * l + l18;
                int n18 = (int)l24;
                nArray2[n12] = n18 << 1 | n10;
                n10 = n18 >>> 31;
                long l25 = a.a(l21, l7, l24 >>> 32, l19);
                l19 = a.a(l21, l9, l25 >>> 32, l22);
                l25 &= 0xFFFFFFFFL;
                l15 = a.a(l21, l14, l19 >>> 32, l15);
                l19 &= 0xFFFFFFFFL;
                long l26 = l23 + (l15 >>> 32);
                l22 = l26;
                long l27 = l15 & 0xFFFFFFFFL;
                l15 = (long)nArray[n + 5] & 0xFFFFFFFFL;
                n12 = n2 + 9;
                l22 = ((long)nArray2[n12] & 0xFFFFFFFFL) + (l22 >>> 32);
                long l28 = l26 & 0xFFFFFFFFL;
                int n19 = n2 + 10;
                long l29 = l;
                l = l22 & 0xFFFFFFFFL;
                long l30 = l15 * l29 + l25;
                int n20 = (int)l30;
                nArray2[n8] = n20 << 1 | n10;
                n10 = n20 >>> 31;
                long l31 = a.a(l15, l7, l30 >>> 32, l19);
                l27 = a.a(l15, l9, l31 >>> 32, l27);
                l7 = a.a(l15, l14, l27 >>> 32, l28);
                l = a.a(l15, l21, l7 >>> 32, l);
                long l32 = ((long)nArray2[n19] & 0xFFFFFFFFL) + (l22 >>> 32) + (l >>> 32);
                int n21 = (int)l31;
                nArray2[n14] = n21 << 1 | n10;
                n = (int)l27;
                nArray2[n16] = n << 1 | (n21 >>>= 31);
                n21 = n >>> 31;
                n = (int)l7;
                nArray2[n17] = n << 1 | n21;
                n21 = n >>> 31;
                n = (int)l;
                nArray2[n12] = n << 1 | n21;
                n21 = n >>> 31;
                n = (int)l32;
                nArray2[n19] = n << 1 | n21;
                n21 = n >>> 31;
                n = n2 + 11;
                nArray2[n] = nArray2[n] + (int)(l32 >>> 32) << 1 | n21;
                return;
            }
            n4 = n6;
        }
    }

    public static int sub(int[] nArray, int[] nArray2, int[] nArray3) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l;
        l >>= 32;
        l = ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL) + l;
        nArray3[1] = (int)l;
        l >>= 32;
        l = ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL) + l;
        nArray3[2] = (int)l;
        l >>= 32;
        l = ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL) + l;
        nArray3[3] = (int)l;
        l >>= 32;
        l = ((long)nArray[4] & 0xFFFFFFFFL) - ((long)nArray2[4] & 0xFFFFFFFFL) + l;
        nArray3[4] = (int)l;
        long l2 = ((long)nArray[5] & 0xFFFFFFFFL) - ((long)nArray2[5] & 0xFFFFFFFFL) + (l >>= 32);
        nArray3[5] = (int)l2;
        return (int)(l2 >> 32);
    }

    public static int sub(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3, int n3) {
        long l = ((long)nArray[n + 0] & 0xFFFFFFFFL) - ((long)nArray2[n2 + 0] & 0xFFFFFFFFL) + 0L;
        int n4 = n3 + 0;
        nArray3[n4] = (int)l;
        long l2 = l >> 32;
        l2 = ((long)nArray[n + 1] & 0xFFFFFFFFL) - ((long)nArray2[n2 + 1] & 0xFFFFFFFFL) + l2;
        int n5 = n3 + 1;
        nArray3[n5] = (int)l2;
        long l3 = l2 >> 32;
        l3 = ((long)nArray[n + 2] & 0xFFFFFFFFL) - ((long)nArray2[n2 + 2] & 0xFFFFFFFFL) + l3;
        int n6 = n3 + 2;
        nArray3[n6] = (int)l3;
        long l4 = l3 >> 32;
        l4 = ((long)nArray[n + 3] & 0xFFFFFFFFL) - ((long)nArray2[n2 + 3] & 0xFFFFFFFFL) + l4;
        int n7 = n3 + 3;
        nArray3[n7] = (int)l4;
        long l5 = l4 >> 32;
        l5 = ((long)nArray[n + 4] & 0xFFFFFFFFL) - ((long)nArray2[n2 + 4] & 0xFFFFFFFFL) + l5;
        int n8 = n3 + 4;
        nArray3[n8] = (int)l5;
        long l6 = l5 >> 32;
        l6 = ((long)nArray[n + 5] & 0xFFFFFFFFL) - ((long)nArray2[n2 + 5] & 0xFFFFFFFFL) + l6;
        int n9 = n3 + 5;
        nArray3[n9] = (int)l6;
        return (int)(l6 >> 32);
    }

    public static int subBothFrom(int[] nArray, int[] nArray2, int[] nArray3) {
        long l = ((long)nArray3[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL) + 0L;
        nArray3[0] = (int)l;
        l >>= 32;
        l = ((long)nArray3[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL) + l;
        nArray3[1] = (int)l;
        l >>= 32;
        l = ((long)nArray3[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL) + l;
        nArray3[2] = (int)l;
        l >>= 32;
        l = ((long)nArray3[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL) + l;
        nArray3[3] = (int)l;
        l >>= 32;
        l = ((long)nArray3[4] & 0xFFFFFFFFL) - ((long)nArray[4] & 0xFFFFFFFFL) - ((long)nArray2[4] & 0xFFFFFFFFL) + l;
        nArray3[4] = (int)l;
        long l2 = ((long)nArray3[5] & 0xFFFFFFFFL) - ((long)nArray[5] & 0xFFFFFFFFL) - ((long)nArray2[5] & 0xFFFFFFFFL) + (l >>= 32);
        nArray3[5] = (int)l2;
        return (int)(l2 >> 32);
    }

    public static int subFrom(int[] nArray, int[] nArray2) {
        long l = ((long)nArray2[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL) + 0L;
        nArray2[0] = (int)l;
        l >>= 32;
        l = ((long)nArray2[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL) + l;
        nArray2[1] = (int)l;
        l >>= 32;
        l = ((long)nArray2[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL) + l;
        nArray2[2] = (int)l;
        l >>= 32;
        l = ((long)nArray2[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL) + l;
        nArray2[3] = (int)l;
        l >>= 32;
        l = ((long)nArray2[4] & 0xFFFFFFFFL) - ((long)nArray[4] & 0xFFFFFFFFL) + l;
        nArray2[4] = (int)l;
        l >>= 32;
        l = ((long)nArray2[5] & 0xFFFFFFFFL) - ((long)nArray[5] & 0xFFFFFFFFL) + l;
        nArray2[5] = (int)l;
        return (int)(l >> 32);
    }

    public static int subFrom(int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = n2 + 0;
        long l = ((long)nArray2[n3] & 0xFFFFFFFFL) - ((long)nArray[n + 0] & 0xFFFFFFFFL) + 0L;
        nArray2[n3] = (int)l;
        long l2 = l >> 32;
        int n4 = n2 + 1;
        l2 = ((long)nArray2[n4] & 0xFFFFFFFFL) - ((long)nArray[n + 1] & 0xFFFFFFFFL) + l2;
        nArray2[n4] = (int)l2;
        l2 >>= 32;
        n4 = n2 + 2;
        l2 = ((long)nArray2[n4] & 0xFFFFFFFFL) - ((long)nArray[n + 2] & 0xFFFFFFFFL) + l2;
        nArray2[n4] = (int)l2;
        l2 >>= 32;
        n4 = n2 + 3;
        l2 = ((long)nArray2[n4] & 0xFFFFFFFFL) - ((long)nArray[n + 3] & 0xFFFFFFFFL) + l2;
        nArray2[n4] = (int)l2;
        l2 >>= 32;
        n4 = n2 + 4;
        l2 = ((long)nArray2[n4] & 0xFFFFFFFFL) - ((long)nArray[n + 4] & 0xFFFFFFFFL) + l2;
        nArray2[n4] = (int)l2;
        long l3 = ((long)nArray2[n2 += 5] & 0xFFFFFFFFL) - ((long)nArray[n + 5] & 0xFFFFFFFFL) + (l2 >>= 32);
        nArray2[n2] = (int)l3;
        return (int)(l3 >> 32);
    }

    public static BigInteger toBigInteger(int[] nArray) {
        byte[] byArray = new byte[24];
        for (int k = 0; k < 6; ++k) {
            int n = nArray[k];
            if (n == 0) continue;
            Pack.intToBigEndian(n, byArray, 5 - k << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static BigInteger toBigInteger64(long[] lArray) {
        byte[] byArray = new byte[24];
        for (int k = 0; k < 3; ++k) {
            long l = lArray[k];
            if (l == 0L) continue;
            Pack.longToBigEndian(l, byArray, 2 - k << 3);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] nArray) {
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        nArray2[0] = 0;
        nArray3[1] = 0;
        nArray2[2] = 0;
        nArray3[3] = 0;
        nArray2[4] = 0;
        nArray3[5] = 0;
    }
}

