/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageSigner;

public class DigestingMessageSigner
implements Signer {
    private final Digest messDigest;
    private final MessageSigner messSigner;
    private boolean forSigning;

    public DigestingMessageSigner(MessageSigner messageSigner, Digest digest) {
        this.messSigner = messageSigner;
        this.messDigest = digest;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!bl && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        DigestingMessageSigner digestingMessageSigner = this;
        digestingMessageSigner.reset();
        digestingMessageSigner.messSigner.init(bl, cipherParameters);
    }

    @Override
    public byte[] generateSignature() {
        if (((DigestingMessageSigner)object).forSigning) {
            DigestingMessageSigner digestingMessageSigner = object;
            Object object = new byte[digestingMessageSigner.messDigest.getDigestSize()];
            digestingMessageSigner.messDigest.doFinal((byte[])object, 0);
            return digestingMessageSigner.messSigner.generateSignature((byte[])object);
        }
        throw new IllegalStateException("DigestingMessageSigner not initialised for signature generation.");
    }

    @Override
    public void update(byte by) {
        this.messDigest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.messDigest.update(byArray, n, n2);
    }

    @Override
    public void reset() {
        this.messDigest.reset();
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        if (!((DigestingMessageSigner)object).forSigning) {
            DigestingMessageSigner digestingMessageSigner = object;
            Object object = new byte[digestingMessageSigner.messDigest.getDigestSize()];
            digestingMessageSigner.messDigest.doFinal((byte[])object, 0);
            return digestingMessageSigner.messSigner.verifySignature((byte[])object, byArray);
        }
        throw new IllegalStateException("DigestingMessageSigner not initialised for verification");
    }
}

