/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.AESEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Exceptions;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

abstract class FrodoMatrixGenerator {
    public int n;
    public int q;

    public FrodoMatrixGenerator(int n, int n2) {
        this.n = n;
        this.q = n2;
    }

    public abstract short[] genMatrix(byte[] var1);

    public static class Aes128MatrixGenerator
    extends FrodoMatrixGenerator {
        public BufferedBlockCipher cipher;

        public Aes128MatrixGenerator(int n, int n2) {
            super(n, n2);
            AESEngine aESEngine;
            BufferedBlockCipher bufferedBlockCipher;
            BufferedBlockCipher bufferedBlockCipher2 = bufferedBlockCipher;
            AESEngine aESEngine2 = aESEngine;
            aESEngine = new AESEngine();
            bufferedBlockCipher = new BufferedBlockCipher(aESEngine2);
            v2.cipher = bufferedBlockCipher2;
        }

        @Override
        public short[] genMatrix(byte[] byArray) {
            int n = this.n;
            short[] sArray = new short[n * n];
            byte[] byArray2 = new byte[16];
            byte[] byArray3 = new byte[16];
            for (int k = 0; k < this.n; ++k) {
                for (int i2 = 0; i2 < this.n; i2 += 8) {
                    System.arraycopy(Pack.shortToLittleEndian((short)(k & 0xFFFF)), 0, byArray2, 0, 2);
                    System.arraycopy(Pack.shortToLittleEndian((short)(i2 & 0xFFFF)), 0, byArray2, 2, 2);
                    this.aes128(byArray3, byArray, byArray2);
                    for (int i3 = 0; i3 < 8; ++i3) {
                        int n2 = k * this.n + i2 + i3;
                        sArray[n2] = (short)(Pack.littleEndianToShort(byArray3, i3 * 2) % this.q);
                    }
                }
            }
            return sArray;
        }

        public void aes128(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            KeyParameter keyParameter;
            Aes128MatrixGenerator aes128MatrixGenerator;
            Aes128MatrixGenerator aes128MatrixGenerator2;
            Aes128MatrixGenerator aes128MatrixGenerator3;
            try {
                Aes128MatrixGenerator aes128MatrixGenerator4 = keyParameter2;
                aes128MatrixGenerator3 = aes128MatrixGenerator4;
                aes128MatrixGenerator2 = aes128MatrixGenerator4;
                aes128MatrixGenerator = aes128MatrixGenerator4;
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw Exceptions.illegalStateException(((Object)invalidCipherTextException).toString(), invalidCipherTextException);
            }
            KeyParameter keyParameter2 = keyParameter;
            keyParameter = new KeyParameter(byArray2);
            aes128MatrixGenerator2.cipher.init(true, keyParameter2);
            BufferedBlockCipher bufferedBlockCipher = aes128MatrixGenerator.cipher;
            int n = 0;
            n = bufferedBlockCipher.processBytes(byArray3, n, byArray3.length, byArray, 0);
            aes128MatrixGenerator3.cipher.doFinal(byArray, n);
        }
    }

    public static class Shake128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Shake128MatrixGenerator(int n, int n2) {
            super(n, n2);
        }

        @Override
        public short[] genMatrix(byte[] byArray) {
            int n = this.n;
            short[] sArray = new short[n * n];
            int n2 = n * 16 / 8;
            byte[] byArray2 = new byte[n2];
            for (short s = 0; s < this.n; s = (short)(s + 1)) {
                int n3;
                SHAKEDigest sHAKEDigest;
                byte[] byArray3 = Arrays.concatenate(Pack.shortToLittleEndian(s), byArray);
                SHAKEDigest sHAKEDigest2 = sHAKEDigest;
                sHAKEDigest2(128);
                sHAKEDigest2.update(byArray3, 0, byArray3.length);
                sHAKEDigest.doFinal(byArray2, 0, n2);
                int n4 = 0;
                while (n4 < (n3 = this.n)) {
                    int n5 = n4;
                    int n6 = n4;
                    n4 = s * n3 + n4;
                    sArray[n4] = (short)(Pack.littleEndianToShort(byArray2, n6 * 2) % this.q);
                    n4 = (short)(n5 + 1);
                }
            }
            return sArray;
        }
    }
}

