/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSLeaf;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSRootCalc;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSRootSig;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.Treehash;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.util.Vector;

public class GMSSPrivateKeyParameters
extends GMSSKeyParameters {
    private int[] index;
    private byte[][] currentSeeds;
    private byte[][] nextNextSeeds;
    private byte[][][] currentAuthPaths;
    private byte[][][] nextAuthPaths;
    private Treehash[][] currentTreehash;
    private Treehash[][] nextTreehash;
    private Vector[] currentStack;
    private Vector[] nextStack;
    private Vector[][] currentRetain;
    private Vector[][] nextRetain;
    private byte[][][] keep;
    private GMSSLeaf[] nextNextLeaf;
    private GMSSLeaf[] upperLeaf;
    private GMSSLeaf[] upperTreehashLeaf;
    private int[] minTreehash;
    private GMSSParameters gmssPS;
    private byte[][] nextRoot;
    private GMSSRootCalc[] nextNextRoot;
    private byte[][] currentRootSig;
    private GMSSRootSig[] nextRootSig;
    private GMSSDigestProvider digestProvider;
    private boolean used;
    private int[] heightOfTrees;
    private int[] otsIndex;
    private int[] K;
    private int numLayer;
    private Digest messDigestTrees;
    private int mdLength;
    private GMSSRandom gmssRandom;
    private int[] numLeafs;

    public GMSSPrivateKeyParameters(byte[][] byArray, byte[][] byArray2, byte[][][] byArray3, byte[][][] byArray4, Treehash[][] treehashArray, Treehash[][] treehashArray2, Vector[] vectorArray, Vector[] vectorArray2, Vector[][] vectorArray3, Vector[][] vectorArray4, byte[][] byArray5, byte[][] byArray6, GMSSParameters gMSSParameters, GMSSDigestProvider gMSSDigestProvider) {
        this(null, byArray, byArray2, byArray3, byArray4, null, treehashArray, treehashArray2, vectorArray, vectorArray2, vectorArray3, vectorArray4, null, null, null, null, byArray5, null, byArray6, null, gMSSParameters, gMSSDigestProvider);
    }

    public GMSSPrivateKeyParameters(int[] nArray, byte[][] byArray, byte[][] object, byte[][][] object2, byte[][][] byArray2, byte[][][] object3, Treehash[][] treehashArray, Treehash[][] treehashArray2, Vector[] vectorArray, Vector[] vectorArray2, Vector[][] vectorArray3, Vector[][] vectorArray4, GMSSLeaf[] gMSSLeafArray, GMSSLeaf[] gMSSLeafArray2, GMSSLeaf[] gMSSLeafArray3, int[] nArray2, byte[][] byArray3, GMSSRootCalc[] gMSSRootCalcArray, byte[][] byArray4, GMSSRootSig[] gMSSRootSigArray, GMSSParameters object4, GMSSDigestProvider gMSSDigestProvider) {
        int n;
        int n2;
        GMSSParameters gMSSParameters = object4;
        GMSSParameters gMSSParameters2 = object4;
        GMSSParameters gMSSParameters3 = object4;
        GMSSParameters gMSSParameters4 = object4;
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this;
        super(true, (GMSSParameters)object4);
        this.used = false;
        object4 = gMSSDigestProvider.get();
        gMSSPrivateKeyParameters.messDigestTrees = object4;
        gMSSPrivateKeyParameters.mdLength = object4.getDigestSize();
        this.gmssPS = gMSSParameters4;
        this.otsIndex = gMSSParameters3.getWinternitzParameter();
        this.K = gMSSParameters2.getK();
        this.heightOfTrees = gMSSParameters.getHeightOfTrees();
        this.numLayer = n2 = this.gmssPS.getNumOfLayers();
        if (nArray == null) {
            this.index = new int[n2];
            for (int k = 0; k < this.numLayer; ++k) {
                this.index[k] = 0;
            }
        } else {
            this.index = nArray;
        }
        this.currentSeeds = byArray;
        this.nextNextSeeds = object;
        this.currentAuthPaths = Arrays.clone(object2);
        this.nextAuthPaths = byArray2;
        if (object3 == null) {
            this.keep = new byte[this.numLayer][][];
            for (int k = 0; k < this.numLayer; ++k) {
                this.keep[k] = new byte[(int)Math.floor(this.heightOfTrees[k] / 2)][this.mdLength];
            }
        } else {
            this.keep = object3;
        }
        if (vectorArray == null) {
            this.currentStack = new Vector[this.numLayer];
            for (int k = 0; k < this.numLayer; ++k) {
                Vector vector;
                object = vector;
                vector = new Vector();
                this.currentStack[k] = object;
            }
        } else {
            this.currentStack = vectorArray;
        }
        if (vectorArray2 == null) {
            this.nextStack = new Vector[this.numLayer - 1];
            for (int k = 0; k < this.numLayer - 1; ++k) {
                Vector vector;
                object = vector;
                vector = new Vector();
                this.nextStack[k] = object;
            }
        } else {
            this.nextStack = vectorArray2;
        }
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters2 = this;
        gMSSPrivateKeyParameters2.currentTreehash = treehashArray;
        gMSSPrivateKeyParameters2.nextTreehash = treehashArray2;
        gMSSPrivateKeyParameters2.currentRetain = vectorArray3;
        gMSSPrivateKeyParameters2.nextRetain = vectorArray4;
        gMSSPrivateKeyParameters2.nextRoot = byArray3;
        gMSSPrivateKeyParameters2.digestProvider = gMSSDigestProvider;
        if (gMSSRootCalcArray == null) {
            this.nextNextRoot = new GMSSRootCalc[this.numLayer - 1];
            int n3 = 0;
            while (n3 < this.numLayer - 1) {
                GMSSRootCalc gMSSRootCalc;
                object = gMSSRootCalc;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters3 = this;
                int n4 = gMSSPrivateKeyParameters3.heightOfTrees[n3];
                int n5 = gMSSPrivateKeyParameters3.K[n3];
                object3 = gMSSPrivateKeyParameters3.digestProvider;
                gMSSRootCalc = new GMSSRootCalc(n4, n5, (GMSSDigestProvider)object3);
                this.nextNextRoot[n3++] = object;
            }
        } else {
            this.nextNextRoot = gMSSRootCalcArray;
        }
        this.currentRootSig = byArray4;
        this.numLeafs = new int[this.numLayer];
        for (n = 0; n < this.numLayer; ++n) {
            this.numLeafs[n] = 1 << this.heightOfTrees[n];
        }
        this.gmssRandom = new GMSSRandom(this.messDigestTrees);
        n = this.numLayer;
        if (n > 1) {
            if (gMSSLeafArray == null) {
                this.nextNextLeaf = new GMSSLeaf[n - 2];
                n = 0;
                while (n < this.numLayer - 2) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters4 = this;
                    int n6 = n + 1;
                    int n7 = gMSSPrivateKeyParameters4.otsIndex[n6];
                    int n8 = gMSSPrivateKeyParameters4.numLeafs[n + 2];
                    byte[] byArray5 = gMSSPrivateKeyParameters4.nextNextSeeds[n];
                    this.nextNextLeaf[n] = new GMSSLeaf(gMSSDigestProvider.get(), n7, n8, byArray5);
                    n = n6;
                }
            } else {
                this.nextNextLeaf = gMSSLeafArray;
            }
        } else {
            this.nextNextLeaf = new GMSSLeaf[0];
        }
        if (gMSSLeafArray2 == null) {
            this.upperLeaf = new GMSSLeaf[this.numLayer - 1];
            n = 0;
            while (n < this.numLayer - 1) {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters5 = this;
                int n9 = gMSSPrivateKeyParameters5.otsIndex[n];
                int n10 = n + 1;
                int n11 = gMSSPrivateKeyParameters5.numLeafs[n10];
                byte[] byArray6 = gMSSPrivateKeyParameters5.currentSeeds[n];
                this.upperLeaf[n] = new GMSSLeaf(gMSSDigestProvider.get(), n9, n11, byArray6);
                n = n10;
            }
        } else {
            this.upperLeaf = gMSSLeafArray2;
        }
        if (gMSSLeafArray3 == null) {
            this.upperTreehashLeaf = new GMSSLeaf[this.numLayer - 1];
            n = 0;
            while (n < this.numLayer - 1) {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters6 = this;
                int n12 = gMSSPrivateKeyParameters6.otsIndex[n];
                this.upperTreehashLeaf[n] = new GMSSLeaf(gMSSDigestProvider.get(), n12, gMSSPrivateKeyParameters6.numLeafs[++n]);
            }
        } else {
            this.upperTreehashLeaf = gMSSLeafArray3;
        }
        if (nArray2 == null) {
            this.minTreehash = new int[this.numLayer - 1];
            for (n = 0; n < this.numLayer - 1; ++n) {
                this.minTreehash[n] = -1;
            }
        } else {
            this.minTreehash = nArray2;
        }
        int n13 = this.mdLength;
        byte[] byArray7 = new byte[n13];
        byte[] cfr_ignored_0 = new byte[n13];
        if (gMSSRootSigArray == null) {
            this.nextRootSig = new GMSSRootSig[this.numLayer - 1];
            int n14 = 0;
            while (n14 < this.numLayer - 1) {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters7 = this;
                int n15 = this.mdLength;
                System.arraycopy(byArray[n14], 0, byArray7, 0, n15);
                gMSSPrivateKeyParameters7.gmssRandom.nextSeed(byArray7);
                object2 = gMSSPrivateKeyParameters7.gmssRandom.nextSeed(byArray7);
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters8 = this;
                int n16 = gMSSPrivateKeyParameters8.otsIndex[n14];
                int n17 = n14 + 1;
                gMSSPrivateKeyParameters7.nextRootSig[n14] = new GMSSRootSig(gMSSDigestProvider.get(), n16, gMSSPrivateKeyParameters8.heightOfTrees[n17]);
                gMSSPrivateKeyParameters7.nextRootSig[n14].initSign((byte[])object2, byArray3[n14]);
                n14 = n17;
            }
        } else {
            this.nextRootSig = gMSSRootSigArray;
        }
    }

    private GMSSPrivateKeyParameters(GMSSPrivateKeyParameters gMSSPrivateKeyParameters) {
        super(true, gMSSPrivateKeyParameters.getParameters());
        this.used = false;
        this.index = Arrays.clone(gMSSPrivateKeyParameters.index);
        this.currentSeeds = Arrays.clone(gMSSPrivateKeyParameters.currentSeeds);
        this.nextNextSeeds = Arrays.clone(gMSSPrivateKeyParameters.nextNextSeeds);
        this.currentAuthPaths = Arrays.clone(gMSSPrivateKeyParameters.currentAuthPaths);
        this.nextAuthPaths = Arrays.clone(gMSSPrivateKeyParameters.nextAuthPaths);
        this.currentTreehash = gMSSPrivateKeyParameters.currentTreehash;
        this.nextTreehash = gMSSPrivateKeyParameters.nextTreehash;
        this.currentStack = gMSSPrivateKeyParameters.currentStack;
        this.nextStack = gMSSPrivateKeyParameters.nextStack;
        this.currentRetain = gMSSPrivateKeyParameters.currentRetain;
        this.nextRetain = gMSSPrivateKeyParameters.nextRetain;
        this.keep = Arrays.clone(gMSSPrivateKeyParameters.keep);
        this.nextNextLeaf = gMSSPrivateKeyParameters.nextNextLeaf;
        this.upperLeaf = gMSSPrivateKeyParameters.upperLeaf;
        this.upperTreehashLeaf = gMSSPrivateKeyParameters.upperTreehashLeaf;
        this.minTreehash = gMSSPrivateKeyParameters.minTreehash;
        this.gmssPS = gMSSPrivateKeyParameters.gmssPS;
        this.nextRoot = Arrays.clone(gMSSPrivateKeyParameters.nextRoot);
        this.nextNextRoot = gMSSPrivateKeyParameters.nextNextRoot;
        this.currentRootSig = gMSSPrivateKeyParameters.currentRootSig;
        this.nextRootSig = gMSSPrivateKeyParameters.nextRootSig;
        this.digestProvider = gMSSPrivateKeyParameters.digestProvider;
        this.heightOfTrees = gMSSPrivateKeyParameters.heightOfTrees;
        this.otsIndex = gMSSPrivateKeyParameters.otsIndex;
        this.K = gMSSPrivateKeyParameters.K;
        this.numLayer = gMSSPrivateKeyParameters.numLayer;
        this.messDigestTrees = gMSSPrivateKeyParameters.messDigestTrees;
        this.mdLength = gMSSPrivateKeyParameters.mdLength;
        this.gmssRandom = gMSSPrivateKeyParameters.gmssRandom;
        this.numLeafs = gMSSPrivateKeyParameters.numLeafs;
    }

    private void nextKey(int n) {
        int n2 = this.numLayer;
        if (n == n2 - 1) {
            this.index[n] = this.index[n] + 1;
        }
        if (this.index[n] == this.numLeafs[n]) {
            if (n2 != 1) {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this;
                gMSSPrivateKeyParameters.nextTree(n);
                gMSSPrivateKeyParameters.index[n] = 0;
            }
        } else {
            this.updateKey(n);
        }
    }

    private void nextTree(int n) {
        if (n > 0) {
            int n2 = n - 1;
            this.index[n2] = this.index[n2] + 1;
            int n3 = 1;
            int n4 = n;
            do {
                if (this.index[--n4] >= this.numLeafs[n4]) continue;
                n3 = 0;
            } while (n3 != 0 && n4 > 0);
            if (n3 == 0) {
                int n5;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this;
                gMSSPrivateKeyParameters.gmssRandom.nextSeed(this.currentSeeds[n]);
                gMSSPrivateKeyParameters.nextRootSig[n2].updateSign();
                if (n > 1) {
                    n3 = n2 - 1;
                    this.nextNextLeaf[n3] = this.nextNextLeaf[n3].nextLeaf();
                }
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters2 = this;
                gMSSPrivateKeyParameters2.upperLeaf[n2] = gMSSPrivateKeyParameters2.upperLeaf[n2].nextLeaf();
                if (gMSSPrivateKeyParameters2.minTreehash[n2] >= 0) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters3 = this;
                    gMSSPrivateKeyParameters3.upperTreehashLeaf[n2] = gMSSPrivateKeyParameters3.upperTreehashLeaf[n2].nextLeaf();
                    byte[] byArray = gMSSPrivateKeyParameters3.upperTreehashLeaf[n2].getLeaf();
                    try {
                        gMSSPrivateKeyParameters3.currentTreehash[n2][this.minTreehash[n2]].update(this.gmssRandom, byArray);
                        gMSSPrivateKeyParameters3.currentTreehash[n2][this.minTreehash[n2]].wasFinished();
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters4 = this;
                gMSSPrivateKeyParameters4.updateNextNextAuthRoot(n);
                gMSSPrivateKeyParameters4.currentRootSig[n2] = this.nextRootSig[n2].getSig();
                for (n5 = 0; n5 < this.heightOfTrees[n] - this.K[n]; ++n5) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters5 = this;
                    Treehash[] treehashArray = gMSSPrivateKeyParameters5.currentTreehash[n];
                    Treehash[][] treehashArray2 = gMSSPrivateKeyParameters5.nextTreehash;
                    treehashArray[n5] = treehashArray2[n2][n5];
                    gMSSPrivateKeyParameters5.nextTreehash[n2][n5] = this.nextNextRoot[n2].getTreehash()[n5];
                }
                for (n5 = 0; n5 < this.heightOfTrees[n]; ++n5) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters6 = this;
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters7 = this;
                    byte[] byArray = gMSSPrivateKeyParameters7.currentAuthPaths[n][n5];
                    int n6 = gMSSPrivateKeyParameters7.mdLength;
                    System.arraycopy(gMSSPrivateKeyParameters6.nextAuthPaths[n2][n5], 0, byArray, 0, n6);
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters8 = this;
                    byArray = gMSSPrivateKeyParameters8.nextAuthPaths[n2][n5];
                    n6 = gMSSPrivateKeyParameters8.mdLength;
                    System.arraycopy(gMSSPrivateKeyParameters6.nextNextRoot[n2].getAuthPath()[n5], 0, byArray, 0, n6);
                }
                for (n5 = 0; n5 < this.K[n] - 1; ++n5) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters9 = this;
                    Vector[] vectorArray = gMSSPrivateKeyParameters9.currentRetain[n];
                    Vector[][] vectorArray2 = gMSSPrivateKeyParameters9.nextRetain;
                    vectorArray[n5] = vectorArray2[n2][n5];
                    gMSSPrivateKeyParameters9.nextRetain[n2][n5] = this.nextNextRoot[n2].getRetain()[n5];
                }
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters10 = this;
                Object[] objectArray = gMSSPrivateKeyParameters10.currentStack;
                Vector[] vectorArray = gMSSPrivateKeyParameters10.nextStack;
                objectArray[n] = vectorArray[n2];
                gMSSPrivateKeyParameters10.nextStack[n2] = this.nextNextRoot[n2].getStack();
                gMSSPrivateKeyParameters10.nextRoot[n2] = this.nextNextRoot[n2].getRoot();
                n = gMSSPrivateKeyParameters10.mdLength;
                byte[] cfr_ignored_0 = new byte[n];
                objectArray = new byte[n];
                System.arraycopy(gMSSPrivateKeyParameters10.currentSeeds[n2], 0, objectArray, 0, n);
                gMSSPrivateKeyParameters10.gmssRandom.nextSeed((byte[])objectArray);
                gMSSPrivateKeyParameters10.gmssRandom.nextSeed((byte[])objectArray);
                byte[] byArray = gMSSPrivateKeyParameters10.gmssRandom.nextSeed((byte[])objectArray);
                gMSSPrivateKeyParameters10.nextRootSig[n2].initSign(byArray, this.nextRoot[n2]);
                this.nextKey(n2);
            }
        }
    }

    private void updateKey(int n) {
        this.computeAuthPaths(n);
        if (n > 0) {
            int n2;
            if (n > 1) {
                n2 = n - 1 - 1;
                this.nextNextLeaf[n2] = this.nextNextLeaf[n2].nextLeaf();
            }
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this;
            n2 = n - 1;
            this.upperLeaf[n2] = this.upperLeaf[n2].nextLeaf();
            int n3 = gMSSPrivateKeyParameters.index[n];
            int n4 = (int)Math.floor((double)(gMSSPrivateKeyParameters.getNumLeafs(n) * 2) / (double)(this.heightOfTrees[n2] - this.K[n2]));
            if (n3 % n4 == 1) {
                if (n3 > 1 && this.minTreehash[n2] >= 0) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters2 = this;
                    byte[] byArray = gMSSPrivateKeyParameters2.upperTreehashLeaf[n2].getLeaf();
                    try {
                        gMSSPrivateKeyParameters2.currentTreehash[n2][this.minTreehash[n2]].update(this.gmssRandom, byArray);
                        gMSSPrivateKeyParameters2.currentTreehash[n2][this.minTreehash[n2]].wasFinished();
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters3 = this;
                gMSSPrivateKeyParameters3.minTreehash[n2] = this.getMinTreehashIndex(n2);
                n3 = gMSSPrivateKeyParameters3.minTreehash[n2];
                if (n3 >= 0) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters4 = this;
                    byte[] byArray = gMSSPrivateKeyParameters4.currentTreehash[n2][n3].getSeedActive();
                    gMSSPrivateKeyParameters4.upperTreehashLeaf[n2] = new GMSSLeaf(this.digestProvider.get(), this.otsIndex[n2], n4, byArray);
                    gMSSPrivateKeyParameters4.upperTreehashLeaf[n2] = gMSSPrivateKeyParameters4.upperTreehashLeaf[n2].nextLeaf();
                }
            } else if (this.minTreehash[n2] >= 0) {
                this.upperTreehashLeaf[n2] = this.upperTreehashLeaf[n2].nextLeaf();
            }
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters5 = this;
            gMSSPrivateKeyParameters5.nextRootSig[n2].updateSign();
            if (gMSSPrivateKeyParameters5.index[n] == 1) {
                this.nextNextRoot[n2].initialize(new Vector());
            }
            this.updateNextNextAuthRoot(n);
        }
    }

    private int getMinTreehashIndex(int n) {
        int n2 = -1;
        for (int k = 0; k < this.heightOfTrees[n] - this.K[n]; ++k) {
            if (!this.currentTreehash[n][k].wasInitialized() || this.currentTreehash[n][k].wasFinished() || n2 != -1 && this.currentTreehash[n][k].getLowestNodeHeight() >= this.currentTreehash[n][n2].getLowestNodeHeight()) continue;
            n2 = k;
        }
        return n2;
    }

    private void computeAuthPaths(int n) {
        int n2;
        int n3;
        int n4;
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this;
        int n5 = gMSSPrivateKeyParameters.index[n];
        int n6 = gMSSPrivateKeyParameters.heightOfTrees[n];
        int n7 = gMSSPrivateKeyParameters.K[n];
        for (n4 = 0; n4 < (n3 = n6 - n7); ++n4) {
            this.currentTreehash[n][n4].updateNextSeed(this.gmssRandom);
        }
        n7 = this.heightOfPhi(n5);
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters2 = this;
        byte[] cfr_ignored_0 = new byte[gMSSPrivateKeyParameters2.mdLength];
        byte[] byArray = gMSSPrivateKeyParameters2.gmssRandom.nextSeed(this.currentSeeds[n]);
        n4 = n5 >>> n7 + 1 & 1;
        int n8 = this.mdLength;
        byte[] byArray2 = new byte[n8];
        int n9 = n6 - 1;
        if (n7 < n9 && n4 == 0) {
            System.arraycopy(this.currentAuthPaths[n][n7], 0, byArray2, 0, n8);
        }
        n8 = this.mdLength;
        byte[] cfr_ignored_1 = new byte[n8];
        if (n7 == 0) {
            Object object;
            if (n == this.numLayer - 1) {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters3 = this;
                object = gMSSPrivateKeyParameters3.digestProvider.get();
                object = new WinternitzOTSignature(byArray, (Digest)object, gMSSPrivateKeyParameters3.otsIndex[n]).getPublicKey();
            } else {
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters4 = this;
                object = new byte[n8];
                System.arraycopy(gMSSPrivateKeyParameters4.currentSeeds[n], 0, object, 0, n8);
                gMSSPrivateKeyParameters4.gmssRandom.nextSeed((byte[])object);
                byArray = gMSSPrivateKeyParameters4.upperLeaf[n].getLeaf();
                gMSSPrivateKeyParameters4.upperLeaf[n].initLeafCalc((byte[])object);
                object = byArray;
            }
            Object object2 = object;
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters5 = this;
            object = gMSSPrivateKeyParameters5.currentAuthPaths[n][0];
            n2 = gMSSPrivateKeyParameters5.mdLength;
            System.arraycopy(object2, 0, object, 0, n2);
        } else {
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters6 = this;
            n2 = n8 << 1;
            byte[] byArray3 = new byte[n2];
            int n10 = n7 - 1;
            System.arraycopy(gMSSPrivateKeyParameters6.currentAuthPaths[n][n10], 0, byArray3, 0, n8);
            int n11 = n8 = this.mdLength;
            System.arraycopy(gMSSPrivateKeyParameters6.keep[n][(int)Math.floor(n10 / 2)], 0, byArray3, n11, n11);
            gMSSPrivateKeyParameters6.messDigestTrees.update(byArray3, 0, n2);
            gMSSPrivateKeyParameters6.currentAuthPaths[n][n7] = new byte[this.messDigestTrees.getDigestSize()];
            gMSSPrivateKeyParameters6.messDigestTrees.doFinal(this.currentAuthPaths[n][n7], 0);
            for (n2 = 0; n2 < n7; ++n2) {
                int n12;
                if (n2 < n3) {
                    if (this.currentTreehash[n][n2].wasFinished()) {
                        GMSSPrivateKeyParameters gMSSPrivateKeyParameters7 = this;
                        GMSSPrivateKeyParameters gMSSPrivateKeyParameters8 = this;
                        byte[] byArray4 = gMSSPrivateKeyParameters8.currentAuthPaths[n][n2];
                        int n13 = gMSSPrivateKeyParameters8.mdLength;
                        System.arraycopy(gMSSPrivateKeyParameters7.currentTreehash[n][n2].getFirstNode(), 0, byArray4, 0, n13);
                        gMSSPrivateKeyParameters7.currentTreehash[n][n2].destroy();
                    } else {
                        System.err.println("Treehash (" + n + "," + n2 + ") not finished when needed in AuthPathComputation");
                    }
                }
                if (n2 < n9 && n2 >= n3 && this.currentRetain[n][n12 = n2 - n3].size() > 0) {
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters9 = this;
                    GMSSPrivateKeyParameters gMSSPrivateKeyParameters10 = this;
                    byArray3 = gMSSPrivateKeyParameters10.currentAuthPaths[n][n2];
                    n10 = gMSSPrivateKeyParameters10.mdLength;
                    System.arraycopy(gMSSPrivateKeyParameters9.currentRetain[n][n12].lastElement(), 0, byArray3, 0, n10);
                    Vector vector = gMSSPrivateKeyParameters9.currentRetain[n][n12];
                    vector.removeElementAt(vector.size() - 1);
                }
                if (n2 >= n3 || (1 << n2) * 3 + n5 >= this.numLeafs[n]) continue;
                this.currentTreehash[n][n2].initialize();
            }
        }
        if (n7 < n9 && n4 == 0) {
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters11 = this;
            byte[] byArray5 = gMSSPrivateKeyParameters11.keep[n][(int)Math.floor(n7 / 2)];
            n2 = gMSSPrivateKeyParameters11.mdLength;
            System.arraycopy(byArray2, 0, byArray5, 0, n2);
        }
        if (n == this.numLayer - 1) {
            for (int k = 1; k <= n3 / 2; ++k) {
                WinternitzOTSignature winternitzOTSignature;
                int n14 = this.getMinTreehashIndex(n);
                if (n14 < 0) continue;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters12 = this;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters13 = gMSSPrivateKeyParameters12;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters14 = gMSSPrivateKeyParameters12;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters15 = gMSSPrivateKeyParameters12;
                Object object = new byte[gMSSPrivateKeyParameters12.mdLength];
                byte[] byArray6 = gMSSPrivateKeyParameters13.currentTreehash[n][n14].getSeedActive();
                n4 = 0;
                n8 = 0;
                int n15 = this.mdLength;
                System.arraycopy(byArray6, n4, object, n8, n15);
                object = gMSSPrivateKeyParameters14.gmssRandom.nextSeed((byte[])object);
                WinternitzOTSignature winternitzOTSignature2 = winternitzOTSignature;
                WinternitzOTSignature winternitzOTSignature3 = winternitzOTSignature;
                byte[] byArray7 = object;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters16 = this;
                GMSSPrivateKeyParameters gMSSPrivateKeyParameters17 = gMSSPrivateKeyParameters16;
                object = gMSSPrivateKeyParameters16.digestProvider.get();
                winternitzOTSignature2(byArray7, (Digest)object, gMSSPrivateKeyParameters17.otsIndex[n]);
                object = winternitzOTSignature3.getPublicKey();
                try {
                    gMSSPrivateKeyParameters15.currentTreehash[n][n14].update(this.gmssRandom, (byte[])object);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        } else {
            this.minTreehash[n] = this.getMinTreehashIndex(n);
        }
    }

    private int heightOfPhi(int n) {
        if (n == 0) {
            return -1;
        }
        int n2 = 0;
        int n3 = 1;
        while (n % n3 == 0) {
            n3 *= 2;
            ++n2;
        }
        return n2 - 1;
    }

    private void updateNextNextAuthRoot(int n) {
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = object2;
        byte[] cfr_ignored_0 = new byte[gMSSPrivateKeyParameters.mdLength];
        int n2 = n - 1;
        Object object = gMSSPrivateKeyParameters.gmssRandom.nextSeed(((GMSSPrivateKeyParameters)object2).nextNextSeeds[n2]);
        if (n == gMSSPrivateKeyParameters.numLayer - 1) {
            WinternitzOTSignature winternitzOTSignature;
            WinternitzOTSignature winternitzOTSignature2 = winternitzOTSignature;
            byte[] byArray = object;
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters2 = object2;
            object = gMSSPrivateKeyParameters2.digestProvider.get();
            winternitzOTSignature = new WinternitzOTSignature(byArray, (Digest)object, gMSSPrivateKeyParameters2.otsIndex[n]);
            Object object2 = ((GMSSPrivateKeyParameters)object2).nextNextSeeds[n2];
            ((GMSSPrivateKeyParameters)object2).nextNextRoot[n2].update((byte[])object2, winternitzOTSignature2.getPublicKey());
        } else {
            GMSSPrivateKeyParameters gMSSPrivateKeyParameters3 = object2;
            gMSSPrivateKeyParameters3.nextNextRoot[n2].update(((GMSSPrivateKeyParameters)object2).nextNextSeeds[n2], ((GMSSPrivateKeyParameters)object2).nextNextLeaf[n2].getLeaf());
            gMSSPrivateKeyParameters3.nextNextLeaf[n2].initLeafCalc(((GMSSPrivateKeyParameters)object2).nextNextSeeds[n2]);
        }
    }

    public boolean isUsed() {
        return this.used;
    }

    public void markUsed() {
        this.used = true;
    }

    public GMSSPrivateKeyParameters nextKey() {
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = new GMSSPrivateKeyParameters(this);
        gMSSPrivateKeyParameters.nextKey(this.gmssPS.getNumOfLayers() - 1);
        return gMSSPrivateKeyParameters;
    }

    public int[] getIndex() {
        return this.index;
    }

    public int getIndex(int n) {
        return this.index[n];
    }

    public byte[][] getCurrentSeeds() {
        return Arrays.clone(this.currentSeeds);
    }

    public byte[][][] getCurrentAuthPaths() {
        return Arrays.clone(this.currentAuthPaths);
    }

    public byte[] getSubtreeRootSig(int n) {
        return this.currentRootSig[n];
    }

    public GMSSDigestProvider getName() {
        return this.digestProvider;
    }

    public int getNumLeafs(int n) {
        return this.numLeafs[n];
    }
}

