/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;

public class WinternitzOTSignature {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[][] privateKeyOTS;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int checksumsize;

    public WinternitzOTSignature(byte[] byArray, Digest object, int n) {
        int n2;
        WinternitzOTSignature winternitzOTSignature = this;
        this.w = n;
        winternitzOTSignature.messDigestOTS = object;
        winternitzOTSignature.gmssRandom = new GMSSRandom((Digest)object);
        this.mdsize = winternitzOTSignature.messDigestOTS.getDigestSize();
        this.messagesize = n2 = ((this.mdsize << 3) + n - 1) / n;
        int n3 = winternitzOTSignature.getLog((n2 << n) + 1);
        this.checksumsize = n2 = n3;
        n2 = this.messagesize;
        winternitzOTSignature.keysize = n2 = (n3 + n - 1) / n + n2;
        winternitzOTSignature.privateKeyOTS = new byte[n2][];
        n2 = winternitzOTSignature.mdsize;
        object = new byte[n2];
        System.arraycopy(byArray, 0, object, 0, n2);
        for (n2 = 0; n2 < this.keysize; ++n2) {
            this.privateKeyOTS[n2] = this.gmssRandom.nextSeed((byte[])object);
        }
    }

    private void hashPrivateKeyBlock(int n, int n2, byte[] byArray, int n3) {
        if (n2 < 1) {
            int n4 = this.mdsize;
            System.arraycopy(this.privateKeyOTS[n], 0, byArray, n3, n4);
        } else {
            WinternitzOTSignature winternitzOTSignature = this;
            WinternitzOTSignature winternitzOTSignature2 = this;
            byte[] byArray2 = winternitzOTSignature2.privateKeyOTS[n];
            int n5 = winternitzOTSignature2.mdsize;
            winternitzOTSignature.messDigestOTS.update(byArray2, 0, n5);
            winternitzOTSignature.messDigestOTS.doFinal(byArray, n3);
            while ((n2 += -1) > 0) {
                WinternitzOTSignature winternitzOTSignature3 = this;
                winternitzOTSignature3.messDigestOTS.update(byArray, n3, this.mdsize);
                winternitzOTSignature3.messDigestOTS.doFinal(byArray, n3);
            }
        }
    }

    public byte[][] getPrivateKey() {
        return this.privateKeyOTS;
    }

    public byte[] getPublicKey() {
        WinternitzOTSignature winternitzOTSignature = this;
        int n = winternitzOTSignature.keysize * this.mdsize;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = (1 << winternitzOTSignature.w) - 1;
        for (int k = 0; k < this.keysize; ++k) {
            WinternitzOTSignature winternitzOTSignature2 = this;
            winternitzOTSignature2.hashPrivateKeyBlock(k, n3, byArray, n2);
            n2 += winternitzOTSignature2.mdsize;
        }
        WinternitzOTSignature winternitzOTSignature3 = this;
        winternitzOTSignature3.messDigestOTS.update(byArray, 0, n);
        byte[] byArray2 = new byte[winternitzOTSignature3.mdsize];
        this.messDigestOTS.doFinal(byArray2, 0);
        return byArray2;
    }

    public byte[] getSignature(byte[] byArray) {
        byte[] byArray2;
        block18: {
            int n;
            int n2;
            int n3;
            int n4;
            byte[] byArray3;
            int n5;
            block19: {
                int n6;
                block17: {
                    WinternitzOTSignature winternitzOTSignature = this;
                    int n7 = winternitzOTSignature.keysize;
                    n5 = winternitzOTSignature.mdsize;
                    byArray2 = new byte[n7 * n5];
                    byArray3 = new byte[n5];
                    n4 = 0;
                    n3 = 0;
                    winternitzOTSignature.messDigestOTS.update(byArray, 0, byArray.length);
                    winternitzOTSignature.messDigestOTS.doFinal(byArray3, 0);
                    n2 = winternitzOTSignature.w;
                    if (8 % n2 != 0) break block17;
                    int n8 = 8 / n2;
                    n2 = (1 << n2) - 1;
                    for (int k = 0; k < n5; ++k) {
                        for (int i2 = 0; i2 < n8; ++i2) {
                            int n9 = n4++;
                            int n10 = n3;
                            n3 = byArray3[k] & n2;
                            int n11 = n10 + n3;
                            int n12 = n9 * this.mdsize;
                            this.hashPrivateKeyBlock(n9, n3, byArray2, n12);
                            byArray3[k] = (byte)(byArray3[k] >>> this.w);
                            n3 = n11;
                        }
                    }
                    n5 = (this.messagesize << this.w) - n3;
                    int n13 = 0;
                    while (n13 < this.checksumsize) {
                        int n14 = n13;
                        int n15 = n5;
                        WinternitzOTSignature winternitzOTSignature2 = this;
                        int n16 = n4++;
                        n13 = n16 * this.mdsize;
                        winternitzOTSignature2.hashPrivateKeyBlock(n16, n5 &= n2, byArray2, n13);
                        n5 = winternitzOTSignature2.w;
                        n13 = n15 >>> n5;
                        int n17 = n5 = n14 + n5;
                        n5 = n13;
                        n13 = n17;
                    }
                    break block18;
                }
                if (n2 >= 8) break block19;
                n5 = this.mdsize / n2;
                n2 = (1 << n2) - 1;
                int n18 = 0;
                for (int k = 0; k < n5; ++k) {
                    int n19;
                    long l = 0L;
                    for (n19 = 0; n19 < this.w; ++n19) {
                        l ^= (long)((byArray3[n18] & 0xFF) << (n19 << 3));
                        ++n18;
                    }
                    for (n19 = 0; n19 < 8; ++n19) {
                        WinternitzOTSignature winternitzOTSignature = this;
                        int n20 = n4++;
                        int n21 = n3;
                        n3 = (int)l & n2;
                        int n22 = n21 + n3;
                        n6 = n20 * this.mdsize;
                        winternitzOTSignature.hashPrivateKeyBlock(n20, n3, byArray2, n6);
                        long l2 = l >>> winternitzOTSignature.w;
                        l = l2;
                        n3 = n22;
                    }
                }
                n5 = this.mdsize % this.w;
                long l = 0L;
                for (n6 = 0; n6 < n5; ++n6) {
                    l ^= (long)((byArray3[n18] & 0xFF) << (n6 << 3));
                    ++n18;
                }
                n5 <<= 3;
                int n23 = 0;
                while (n23 < n5) {
                    int n24 = n23;
                    WinternitzOTSignature winternitzOTSignature = this;
                    int n25 = n4++;
                    n23 = (int)l & n2;
                    n3 += n23;
                    n18 = n25 * this.mdsize;
                    winternitzOTSignature.hashPrivateKeyBlock(n25, n23, byArray2, n18);
                    n23 = winternitzOTSignature.w;
                    l >>>= n23;
                    n23 = n24 + n23;
                }
                n5 = (this.messagesize << this.w) - n3;
                n23 = 0;
                while (n23 < this.checksumsize) {
                    int n26 = n23;
                    int n27 = n5;
                    WinternitzOTSignature winternitzOTSignature = this;
                    int n28 = n4++;
                    n23 = n28 * this.mdsize;
                    winternitzOTSignature.hashPrivateKeyBlock(n28, n5 &= n2, byArray2, n23);
                    n5 = winternitzOTSignature.w;
                    n23 = n27 >>> n5;
                    int n29 = n5 = n26 + n5;
                    n5 = n23;
                    n23 = n29;
                }
                break block18;
            }
            if (n2 >= 57) break block18;
            n5 = this.mdsize;
            int n30 = (n5 << 3) - n2;
            n2 = (1 << n2) - 1;
            byte[] byArray4 = new byte[n5];
            int n31 = 0;
            while (n31 <= n30) {
                long l;
                int n32 = n31;
                int n33 = n31;
                int n34 = n33 % 8;
                int n35 = n32 + this.w;
                n = n35 + 7 >>> 3;
                long l3 = 0L;
                int n36 = 0;
                for (n31 = (v783858) >>> 3; n31 < n; ++n31) {
                    l3 ^= (long)((byArray3[n31] & 0xFF) << (n36 << 3));
                    ++n36;
                }
                n3 = (int)((long)n3 + l);
                n = this.mdsize;
                System.arraycopy(this.privateKeyOTS[n4], 0, byArray4, 0, n);
                for (l = l3 >>> n34 & (long)n2; l > 0L; --l) {
                    WinternitzOTSignature winternitzOTSignature = this;
                    winternitzOTSignature.messDigestOTS.update(byArray4, 0, n5);
                    winternitzOTSignature.messDigestOTS.doFinal(byArray4, 0);
                }
                n31 = this.mdsize;
                n34 = n4 * n31;
                System.arraycopy(byArray4, 0, byArray2, n34, n31);
                ++n4;
                n31 = n35;
            }
            n30 = n31 >>> 3;
            if (n30 < this.mdsize) {
                long l;
                int n37;
                n31 %= 8;
                long l4 = 0L;
                n = 0;
                while (n30 < (n37 = this.mdsize)) {
                    l4 ^= (long)((byArray3[n30] & 0xFF) << (n << 3));
                    ++n;
                    ++n30;
                }
                int n38 = (int)((long)n3 + l);
                System.arraycopy(this.privateKeyOTS[n4], 0, byArray4, 0, n37);
                for (l = l4 >>> n31 & (long)n2; l > 0L; --l) {
                    WinternitzOTSignature winternitzOTSignature = this;
                    winternitzOTSignature.messDigestOTS.update(byArray4, 0, n5);
                    winternitzOTSignature.messDigestOTS.doFinal(byArray4, 0);
                }
                n3 = this.mdsize;
                n30 = n4 * n3;
                System.arraycopy(byArray4, 0, byArray2, n30, n3);
                ++n4;
                n3 = n38;
            }
            int n39 = (this.messagesize << this.w) - n3;
            n3 = 0;
            while (n3 < this.checksumsize) {
                n30 = this.mdsize;
                System.arraycopy(this.privateKeyOTS[n4], 0, byArray4, 0, n30);
                for (long k = (long)(n39 & n2); k > 0L; --k) {
                    WinternitzOTSignature winternitzOTSignature = this;
                    winternitzOTSignature.messDigestOTS.update(byArray4, 0, n5);
                    winternitzOTSignature.messDigestOTS.doFinal(byArray4, 0);
                }
                int n40 = n3;
                int n41 = n39;
                n39 = this.mdsize;
                n3 = n4 * n39;
                System.arraycopy(byArray4, 0, byArray2, n3, n39);
                n39 = this.w;
                n3 = n41 >>> n39;
                ++n4;
                int n42 = n39 = n40 + n39;
                n39 = n3;
                n3 = n42;
            }
        }
        return byArray2;
    }

    public int getLog(int n) {
        int n2 = 1;
        int n3 = 2;
        while (n3 < n) {
            n3 <<= 1;
            ++n2;
        }
        return n2;
    }
}

