/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;

public class McElieceParameters
implements CipherParameters {
    public static final int DEFAULT_M = 11;
    public static final int DEFAULT_T = 50;
    private int m;
    private int t;
    private int n;
    private int fieldPoly;
    private Digest digest;

    public McElieceParameters() {
        this(11, 50);
    }

    public McElieceParameters(Digest digest) {
        this(11, 50, digest);
    }

    public McElieceParameters(int n) {
        this(n, null);
    }

    public McElieceParameters(int n, Digest digest) {
        if (n >= 1) {
            int n2;
            McElieceParameters mcElieceParameters = this;
            mcElieceParameters.m = 0;
            mcElieceParameters.n = 1;
            while ((n2 = this.n) < n) {
                this.n = n2 << 1;
                ++this.m;
            }
            McElieceParameters mcElieceParameters2 = this;
            this.t = n = n2 >>> 1;
            int n3 = this.m;
            mcElieceParameters2.t = n / n3;
            mcElieceParameters2.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(n3);
            this.digest = digest;
            return;
        }
        throw new IllegalArgumentException("key size must be positive");
    }

    public McElieceParameters(int n, int n2) {
        this(n, n2, null);
    }

    public McElieceParameters(int n, int n2, Digest digest) {
        if (n >= 1) {
            if (n <= 32) {
                int n3;
                McElieceParameters mcElieceParameters = this;
                mcElieceParameters.m = n;
                mcElieceParameters.n = n3 = 1 << n;
                if (n2 >= 0) {
                    if (n2 <= n3) {
                        this.t = n2;
                        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(n);
                        this.digest = digest;
                        return;
                    }
                    throw new IllegalArgumentException("t must be less than n = 2^m");
                }
                throw new IllegalArgumentException("t must be positive");
            }
            throw new IllegalArgumentException("m is too large");
        }
        throw new IllegalArgumentException("m must be positive");
    }

    public McElieceParameters(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public McElieceParameters(int n, int n2, int n3, Digest digest) {
        this.m = n;
        if (n >= 1) {
            if (n <= 32) {
                int n4;
                McElieceParameters mcElieceParameters = this;
                mcElieceParameters.n = n4 = 1 << n;
                mcElieceParameters.t = n2;
                if (n2 >= 0) {
                    if (n2 <= n4) {
                        if (PolynomialRingGF2.degree(n3) == n && PolynomialRingGF2.isIrreducible(n3)) {
                            McElieceParameters mcElieceParameters2 = this;
                            mcElieceParameters2.fieldPoly = n3;
                            mcElieceParameters2.digest = digest;
                            return;
                        }
                        throw new IllegalArgumentException("polynomial is not a field polynomial for GF(2^m)");
                    }
                    throw new IllegalArgumentException("t must be less than n = 2^m");
                }
                throw new IllegalArgumentException("t must be positive");
            }
            throw new IllegalArgumentException(" m is too large");
        }
        throw new IllegalArgumentException("m must be positive");
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public int getFieldPoly() {
        return this.fieldPoly;
    }
}

