/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.ChaCha20;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.NTT;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.Precomp;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.Reduce;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

class Poly {
    public static void add(short[] sArray, short[] sArray2, short[] sArray3) {
        for (int k = 0; k < 1024; ++k) {
            sArray3[k] = Reduce.barrett((short)(sArray[k] + sArray2[k]));
        }
    }

    public static void fromBytes(short[] sArray, byte[] byArray) {
        for (int k = 0; k < 256; ++k) {
            int n = k * 7;
            int n2 = byArray[n + 0] & 0xFF;
            int n3 = byArray[n + 1] & 0xFF;
            int n4 = byArray[n + 2] & 0xFF;
            int n5 = byArray[n + 3] & 0xFF;
            int n6 = byArray[n + 4] & 0xFF;
            int n7 = byArray[n + 5] & 0xFF;
            int n8 = n3;
            int n9 = n2;
            int n10 = n3;
            n = byArray[n + 6] & 0xFF;
            n2 = k * 4;
            n3 = n2 + 0;
            sArray[n3] = (short)(n9 | (n10 & 0x3F) << 8);
            n3 = n2 + 1;
            sArray[n3] = (short)(n8 >>> 6 | n4 << 2 | (n5 & 0xF) << 10);
            n3 = n2 + 2;
            sArray[n3] = (short)(n5 >>> 4 | n6 << 4 | (n7 & 3) << 12);
            sArray[n2 += 3] = (short)(n7 >>> 2 | n << 6);
        }
    }

    public static void fromNTT(short[] sArray) {
        short[] sArray2 = sArray;
        NTT.bitReverse(sArray2);
        NTT.core(sArray2, Precomp.OMEGAS_INV_MONTGOMERY);
        NTT.mulCoefficients(sArray, Precomp.PSIS_INV_MONTGOMERY);
    }

    public static void getNoise(short[] sArray, byte[] byArray, byte by) {
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[8];
        byArray = byArray3;
        byArray3[0] = by;
        byte[] byArray4 = new byte[4096];
        ChaCha20.process(byArray2, byArray, byArray4, 0, 4096);
        for (int k = 0; k < 1024; ++k) {
            int n = Pack.bigEndianToInt(byArray4, k * 4);
            int n2 = 0;
            for (int i2 = 0; i2 < 8; ++i2) {
                n2 += n >> i2 & 0x1010101;
            }
            n = (n2 >>> 16) + (n2 >>> 8) & 0xFF;
            sArray[k] = (short)(((n2 >>> 24) + (n2 >>> 0) & 0xFF) + 12289 - n);
        }
    }

    public static void pointWise(short[] sArray, short[] sArray2, short[] sArray3) {
        for (int k = 0; k < 1024; ++k) {
            sArray3[k] = Reduce.montgomery((sArray[k] & 0xFFFF) * (Reduce.montgomery((sArray2[k] & 0xFFFF) * 3186) & 0xFFFF));
        }
    }

    public static void toBytes(byte[] byArray, short[] sArray) {
        for (int k = 0; k < 256; ++k) {
            int n;
            int n2 = k * 4;
            int n3 = n = n2;
            int n4 = n;
            n = Poly.normalize(sArray[n + 0]);
            int n5 = Poly.normalize(sArray[n4 + 1]);
            short s = Poly.normalize(sArray[n3 + 2]);
            short s2 = Poly.normalize(sArray[n2 + 3]);
            int n6 = n5;
            int n7 = n5;
            int n8 = n;
            int n9 = n;
            n = k * 7;
            int n10 = n + 0;
            byArray[n10] = (byte)n9;
            n10 = n + 1;
            byArray[n10] = (byte)(n8 >> 8 | n5 << 6);
            n5 = n + 2;
            byArray[n5] = (byte)(n7 >> 2);
            n5 = n + 3;
            byArray[n5] = (byte)(n6 >> 10 | s << 4);
            n5 = n + 4;
            byArray[n5] = (byte)(s >> 4);
            n5 = n + 5;
            byArray[n5] = (byte)(s >> 12 | s2 << 2);
            byArray[n += 6] = (byte)(s2 >> 6);
        }
    }

    public static void toNTT(short[] sArray) {
        NTT.mulCoefficients(sArray, Precomp.PSIS_BITREV_MONTGOMERY);
        NTT.core(sArray, Precomp.OMEGAS_MONTGOMERY);
    }

    public static void uniform(short[] sArray, byte[] byArray) {
        SHAKEDigest sHAKEDigest;
        SHAKEDigest sHAKEDigest2 = sHAKEDigest;
        sHAKEDigest2(128);
        int n = byArray.length;
        sHAKEDigest.update(byArray, 0, n);
        int n2 = 0;
        block0: while (true) {
            n = 256;
            byte[] byArray2 = new byte[256];
            sHAKEDigest2.doOutput(byArray2, 0, n);
            int n3 = 0;
            while (true) {
                if (n3 >= n) continue block0;
                int n4 = byArray2[n3] & 0xFF | (byArray2[n3 + 1] & 0xFF) << 8;
                if (n4 < 61445) {
                    int n5 = n2 + 1;
                    sArray[n2] = (short)n4;
                    if (n5 == 1024) {
                        return;
                    }
                    n2 = n5;
                }
                n3 += 2;
            }
            break;
        }
    }

    private static short normalize(short s) {
        s = Reduce.barrett(s);
        int n = s - 12289;
        s = (short)(n >> 31);
        return (short)(n ^ (s ^ n) & s);
    }
}

