/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.SparseTernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NTRUSigningPrivateKeyParameters
extends AsymmetricKeyParameter {
    private List<Basis> bases;
    private NTRUSigningPublicKeyParameters publicKey;

    public NTRUSigningPrivateKeyParameters(byte[] byArray, NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters) {
        ByteArrayInputStream byteArrayInputStream;
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters = byteArrayInputStream2;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        nTRUSigningPrivateKeyParameters(byteArrayInputStream2, nTRUSigningKeyGenerationParameters);
    }

    public NTRUSigningPrivateKeyParameters(InputStream inputStream, NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters) {
        super(true);
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters;
        ArrayList<Basis> arrayList;
        ArrayList<Basis> arrayList2 = arrayList;
        arrayList = new ArrayList<Basis>();
        ((NTRUSigningPrivateKeyParameters)asymmetricKeyParameter).bases = arrayList2;
        for (int k = 0; k <= nTRUSigningKeyGenerationParameters.B; ++k) {
            boolean bl = k != 0;
            Basis basis = new Basis(inputStream, nTRUSigningKeyGenerationParameters, bl);
            ((NTRUSigningPrivateKeyParameters)asymmetricKeyParameter).add(basis);
        }
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters = asymmetricKeyParameter;
        AsymmetricKeyParameter asymmetricKeyParameter = nTRUSigningPublicKeyParameters;
        nTRUSigningPublicKeyParameters = new NTRUSigningPublicKeyParameters(inputStream, nTRUSigningKeyGenerationParameters.getSigningParameters());
        nTRUSigningPrivateKeyParameters.publicKey = asymmetricKeyParameter;
    }

    public NTRUSigningPrivateKeyParameters(List<Basis> list, NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters) {
        super(true);
        ArrayList<Basis> arrayList;
        ArrayList<Basis> arrayList2 = arrayList;
        arrayList = new ArrayList<Basis>(list);
        v1.bases = arrayList2;
        v1.publicKey = nTRUSigningPublicKeyParameters;
    }

    private void add(Basis basis) {
        this.bases.add(basis);
    }

    public Basis getBasis(int n) {
        return this.bases.get(n);
    }

    public NTRUSigningPublicKeyParameters getPublicKey() {
        return this.publicKey;
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        for (int k = 0; k < this.bases.size(); ++k) {
            Basis basis = this.bases.get(k);
            boolean bl = k != 0;
            basis.encode(byteArrayOutputStream2, bl);
        }
        ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2;
        byteArrayOutputStream3.write(this.publicKey.getEncoded());
        return byteArrayOutputStream3.toByteArray();
    }

    public void writeTo(OutputStream outputStream) {
        outputStream.write(this.getEncoded());
    }

    public int hashCode() {
        int n = 31;
        List<Basis> list = this.bases;
        if (list == null) {
            return n;
        }
        int n2 = list.hashCode() + n;
        Iterator<Basis> iterator = this.bases.iterator();
        while (iterator.hasNext()) {
            n2 = iterator.next().hashCode() + n2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (NTRUSigningPrivateKeyParameters)object;
        List<Basis> list = this.bases;
        boolean bl2 = list == null;
        if (bl2 != (bl = ((NTRUSigningPrivateKeyParameters)object).bases == null)) {
            return false;
        }
        if (list == null) {
            return true;
        }
        if (list.size() != ((NTRUSigningPrivateKeyParameters)object).bases.size()) {
            return false;
        }
        for (int k = 0; k < this.bases.size(); ++k) {
            Basis basis = this.bases.get(k);
            Basis basis2 = ((NTRUSigningPrivateKeyParameters)object).bases.get(k);
            if (!basis.f.equals(basis2.f)) {
                return false;
            }
            if (!basis.fPrime.equals(basis2.fPrime)) {
                return false;
            }
            if (k != 0 && !basis.h.equals(basis2.h)) {
                return false;
            }
            if (basis.params.equals(basis2.params)) continue;
            return false;
        }
        return true;
    }

    public static class Basis {
        public Polynomial f;
        public Polynomial fPrime;
        public IntegerPolynomial h;
        public NTRUSigningKeyGenerationParameters params;

        public Basis(Polynomial polynomial, Polynomial polynomial2, IntegerPolynomial integerPolynomial, NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters) {
            this.f = polynomial;
            this.fPrime = polynomial2;
            this.h = integerPolynomial;
            this.params = nTRUSigningKeyGenerationParameters;
        }

        public Basis(InputStream inputStream, NTRUSigningKeyGenerationParameters object, boolean bl) {
            NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = object;
            int n = nTRUSigningKeyGenerationParameters.N;
            int n2 = nTRUSigningKeyGenerationParameters.q;
            int n3 = nTRUSigningKeyGenerationParameters.d1;
            int n4 = nTRUSigningKeyGenerationParameters.d2;
            int n5 = nTRUSigningKeyGenerationParameters.d3;
            int n6 = nTRUSigningKeyGenerationParameters.sparse;
            this.params = nTRUSigningKeyGenerationParameters;
            if (((NTRUSigningKeyGenerationParameters)object).polyType == 1) {
                n6 = n5 + 1;
                this.f = ProductFormPolynomial.fromBinary(inputStream, n, n3, n4, n6, n5);
            } else {
                TernaryPolynomial ternaryPolynomial;
                IntegerPolynomial integerPolynomial = IntegerPolynomial.fromBinary3Tight(inputStream, n);
                if (n6 != 0) {
                    SparseTernaryPolynomial sparseTernaryPolynomial;
                    ternaryPolynomial = sparseTernaryPolynomial;
                    sparseTernaryPolynomial = new SparseTernaryPolynomial(integerPolynomial);
                } else {
                    DenseTernaryPolynomial denseTernaryPolynomial;
                    ternaryPolynomial = denseTernaryPolynomial;
                    denseTernaryPolynomial = new DenseTernaryPolynomial(integerPolynomial);
                }
                this.f = ternaryPolynomial;
            }
            if (((NTRUSigningKeyGenerationParameters)object).basisType == 0) {
                object = IntegerPolynomial.fromBinary(inputStream, n, n2);
                n3 = 0;
                while (true) {
                    int[] nArray = ((IntegerPolynomial)object).coeffs;
                    if (n3 >= ((IntegerPolynomial)object).coeffs.length) break;
                    nArray[n3] = nArray[n3] - n2 / 2;
                    ++n3;
                }
                this.fPrime = object;
            } else if (((NTRUSigningKeyGenerationParameters)object).polyType == 1) {
                int n7 = n5 + 1;
                this.fPrime = ProductFormPolynomial.fromBinary(inputStream, n, n3, n4, n7, n5);
            } else {
                this.fPrime = IntegerPolynomial.fromBinary3Tight(inputStream, n);
            }
            if (bl) {
                this.h = IntegerPolynomial.fromBinary(inputStream, n, n2);
            }
        }

        private byte[] getEncoded(Polynomial polynomial) {
            if (polynomial instanceof ProductFormPolynomial) {
                return ((ProductFormPolynomial)polynomial).toBinary();
            }
            return polynomial.toIntegerPolynomial().toBinary3Tight();
        }

        public void encode(OutputStream outputStream, boolean bl) {
            Basis basis = this;
            int n = basis.params.q;
            outputStream.write(basis.getEncoded(basis.f));
            if (this.params.basisType == 0) {
                IntegerPolynomial integerPolynomial = this.fPrime.toIntegerPolynomial();
                int n2 = 0;
                while (true) {
                    int[] nArray = integerPolynomial.coeffs;
                    if (n2 >= integerPolynomial.coeffs.length) break;
                    int n3 = nArray[n2];
                    nArray[n2] = n / 2 + n3;
                    ++n2;
                }
                outputStream.write(integerPolynomial.toBinary(n));
            } else {
                Basis basis2 = this;
                outputStream.write(basis2.getEncoded(basis2.fPrime));
            }
            if (bl) {
                outputStream.write(this.h.toBinary(n));
            }
        }

        public int hashCode() {
            int n = 31;
            Polynomial polynomial = this.f;
            int n2 = polynomial == null ? 0 : polynomial.hashCode();
            n = (n + n2) * 31;
            Polynomial polynomial2 = this.fPrime;
            int n3 = polynomial2 == null ? 0 : polynomial2.hashCode();
            n = (n + n3) * 31;
            IntegerPolynomial integerPolynomial = this.h;
            int n4 = integerPolynomial == null ? 0 : integerPolynomial.hashCode();
            int n5 = (n + n4) * 31;
            NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = this.params;
            int n6 = nTRUSigningKeyGenerationParameters == null ? 0 : nTRUSigningKeyGenerationParameters.hashCode();
            return n5 + n6;
        }

        public boolean equals(Object object) {
            if (nTRUSigningKeyGenerationParameters == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof Basis)) {
                return false;
            }
            object = (Basis)object;
            Polynomial polynomial = ((Basis)((Object)nTRUSigningKeyGenerationParameters)).f;
            if (polynomial == null ? ((Basis)object).f != null : !polynomial.equals(((Basis)object).f)) {
                return false;
            }
            polynomial = ((Basis)((Object)nTRUSigningKeyGenerationParameters)).fPrime;
            if (polynomial == null ? ((Basis)object).fPrime != null : !polynomial.equals(((Basis)object).fPrime)) {
                return false;
            }
            polynomial = ((Basis)((Object)nTRUSigningKeyGenerationParameters)).h;
            if (polynomial == null ? ((Basis)object).h != null : !((IntegerPolynomial)polynomial).equals(((Basis)object).h)) {
                return false;
            }
            NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = ((Basis)((Object)nTRUSigningKeyGenerationParameters)).params;
            return !(nTRUSigningKeyGenerationParameters == null ? ((Basis)object).params != null : !nTRUSigningKeyGenerationParameters.equals(((Basis)object).params));
        }
    }
}

