/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;

final class KeyedHashFunctions {
    private final Digest digest;
    private final int digestSize;

    public KeyedHashFunctions(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n) {
        if (aSN1ObjectIdentifier != null) {
            this.digest = DigestUtil.getDigest(aSN1ObjectIdentifier);
            this.digestSize = n;
            return;
        }
        throw new NullPointerException("digest == null");
    }

    private byte[] coreDigest(int n, byte[] object, byte[] byArray) {
        KeyedHashFunctions keyedHashFunctions = this;
        Object object2 = this = (Object)XMSSUtil.toBytesBigEndian(n, ((KeyedHashFunctions)this).digestSize);
        keyedHashFunctions.digest.update((byte[])object2, 0, ((Object)object2).length);
        keyedHashFunctions.digest.update((byte[])object, 0, ((byte[])object).length);
        keyedHashFunctions.digest.update(byArray, 0, byArray.length);
        int n2 = keyedHashFunctions.digestSize;
        byte[] byArray2 = new byte[n2];
        Digest digest = keyedHashFunctions.digest;
        object = digest;
        if (digest instanceof Xof) {
            ((Xof)object).doFinal(byArray2, 0, n2);
        } else {
            object.doFinal(byArray2, 0);
        }
        return byArray2;
    }

    public byte[] F(byte[] byArray, byte[] byArray2) {
        int n = this.digestSize;
        if (byArray.length == n) {
            if (byArray2.length == n) {
                return this.coreDigest(0, byArray, byArray2);
            }
            throw new IllegalArgumentException("wrong in length");
        }
        throw new IllegalArgumentException("wrong key length");
    }

    public byte[] H(byte[] byArray, byte[] byArray2) {
        int n = this.digestSize;
        if (byArray.length == n) {
            if (byArray2.length == n * 2) {
                return this.coreDigest(1, byArray, byArray2);
            }
            throw new IllegalArgumentException("wrong in length");
        }
        throw new IllegalArgumentException("wrong key length");
    }

    public byte[] HMsg(byte[] byArray, byte[] byArray2) {
        if (byArray.length == this.digestSize * 3) {
            return this.coreDigest(2, byArray, byArray2);
        }
        throw new IllegalArgumentException("wrong key length");
    }

    public byte[] PRF(byte[] byArray, byte[] byArray2) {
        if (byArray.length == this.digestSize) {
            if (byArray2.length == 32) {
                return this.coreDigest(3, byArray, byArray2);
            }
            throw new IllegalArgumentException("wrong address length");
        }
        throw new IllegalArgumentException("wrong key length");
    }
}

