/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import java.io.IOException;

public final class XMSSMTPrivateKeyParameters
extends XMSSMTKeyParameters
implements XMSSStoreableObjectInterface,
Encodable {
    private final XMSSMTParameters params;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private volatile long index;
    private volatile BDSStateMap bdsState;
    private volatile boolean used;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XMSSMTPrivateKeyParameters(Builder builder) {
        super(true, builder.params.getTreeDigest());
        XMSSMTParameters xMSSMTParameters;
        this.params = xMSSMTParameters = builder.params;
        if (xMSSMTParameters == null) throw new NullPointerException("params == null");
        int n = xMSSMTParameters.getTreeDigestSize();
        byte[] byArray = builder.privateKey;
        if (byArray != null) {
            int n2;
            if (builder.xmss == null) throw new NullPointerException("xmss == null");
            int n3 = xMSSMTParameters.getHeight();
            n3 = (n3 + 7) / 8;
            int n4 = 0;
            this.index = XMSSUtil.bytesToXBigEndian(byArray, 0, n3);
            if (!XMSSUtil.isIndexValid(n2, this.index)) throw new IllegalArgumentException("index out of bounds");
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset(byArray, n3 += n4, n);
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset(byArray, n3 += n, n);
            this.publicSeed = XMSSUtil.extractBytesAtOffset(byArray, n3 += n, n);
            this.root = XMSSUtil.extractBytesAtOffset(byArray, n3 += n, n);
            int n5 = n3 + n;
            try {
                this.bdsState = ((BDSStateMap)XMSSUtil.deserialize(XMSSUtil.extractBytesAtOffset(byArray, n5, byArray.length - n5), BDSStateMap.class)).withWOTSDigest(builder.xmss.getTreeDigestOID());
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
        } else {
            this.index = builder.index;
            byArray = builder.secretKeySeed;
            if (byArray != null) {
                if (byArray.length != n) throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                this.secretKeySeed = byArray;
            } else {
                this.secretKeySeed = new byte[n];
            }
            byte[] byArray2 = builder.secretKeyPRF;
            if (byArray2 != null) {
                if (byArray2.length != n) throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                this.secretKeyPRF = byArray2;
            } else {
                this.secretKeyPRF = new byte[n];
            }
            byArray2 = builder.publicSeed;
            if (byArray2 != null) {
                if (byArray2.length != n) throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                this.publicSeed = byArray2;
            } else {
                this.publicSeed = new byte[n];
            }
            byte[] byArray3 = builder.root;
            if (byArray3 != null) {
                if (byArray3.length != n) throw new IllegalArgumentException("size of root needs to be equal size of digest");
                this.root = byArray3;
            } else {
                this.root = new byte[n];
            }
            BDSStateMap bDSStateMap = builder.bdsState;
            if (bDSStateMap != null) {
                this.bdsState = bDSStateMap;
            } else {
                long l = builder.index;
                if (XMSSUtil.isIndexValid(xMSSMTParameters.getHeight(), l) && byArray2 != null && byArray != null) {
                    BDSStateMap bDSStateMap2;
                    bDSStateMap = bDSStateMap2;
                    l = builder.index;
                    bDSStateMap2 = new BDSStateMap(xMSSMTParameters, l, byArray2, byArray);
                    this.bdsState = bDSStateMap;
                } else {
                    this.bdsState = new BDSStateMap(builder.maxIndex + 1L);
                }
            }
            if (builder.maxIndex < 0L || builder.maxIndex == this.bdsState.getMaxIndex()) return;
            throw new IllegalArgumentException("maxIndex set but not reflected in state");
        }
    }

    public /* synthetic */ XMSSMTPrivateKeyParameters(Builder builder, 1 var2_2) {
        this(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncoded() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            // ** MonitorExit[this] (shouldn't be in output)
            return xMSSMTPrivateKeyParameters.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            int n;
            byte[] byArray;
            int n2 = xMSSMTPrivateKeyParameters.params.getTreeDigestSize();
            int n3 = (xMSSMTPrivateKeyParameters.params.getHeight() + 7) / 8;
            {
                byArray = new byte[n3 + n2 + n2 + n2 + n2];
                n = 0;
            }
            {
                XMSSUtil.copyBytesAtOffset(byArray, XMSSUtil.toBytesBigEndian(this.index, n3), n);
            }
            {
                XMSSUtil.copyBytesAtOffset(byArray, this.secretKeySeed, n3 += n);
            }
            {
                XMSSUtil.copyBytesAtOffset(byArray, this.secretKeyPRF, n3 += n2);
            }
            {
                XMSSUtil.copyBytesAtOffset(byArray, this.publicSeed, n3 += n2);
                n2 = n3 + n2;
                XMSSUtil.copyBytesAtOffset(byArray, this.root, n2);
                try {
                    // ** MonitorExit[this] (shouldn't be in output)
                    return Arrays.concatenate(byArray, XMSSUtil.serialize(this.bdsState));
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("error serializing bds state: " + iOException.getMessage(), iOException);
                }
            }
        }
    }

    public long getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsagesRemaining() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            long l = xMSSMTPrivateKeyParameters.bdsState.getMaxIndex() - this.getIndex();
            // ** MonitorExit[this] (shouldn't be in output)
            return l + 1L;
        }
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    public BDSStateMap getBDSState() {
        return this.bdsState;
    }

    public XMSSMTParameters getParameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMSSMTPrivateKeyParameters getNextKey() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            // ** MonitorExit[this] (shouldn't be in output)
            return xMSSMTPrivateKeyParameters.extractKeyShard(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMSSMTPrivateKeyParameters rollKey() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters2;
            if (xMSSMTPrivateKeyParameters.getIndex() < this.bdsState.getMaxIndex()) {
                XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters3 = this;
                xMSSMTPrivateKeyParameters2 = xMSSMTPrivateKeyParameters3;
                XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters4 = this;
                XMSSMTParameters xMSSMTParameters = xMSSMTPrivateKeyParameters4.params;
                long l = xMSSMTPrivateKeyParameters4.index;
                byte[] byArray = xMSSMTPrivateKeyParameters4.publicSeed;
                byte[] byArray2 = xMSSMTPrivateKeyParameters4.secretKeySeed;
                xMSSMTPrivateKeyParameters3.bdsState.updateState(xMSSMTParameters, l, byArray, byArray2);
                ++xMSSMTPrivateKeyParameters3.index;
            } else {
                XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters5 = this;
                xMSSMTPrivateKeyParameters2 = xMSSMTPrivateKeyParameters5;
                xMSSMTPrivateKeyParameters5.index = xMSSMTPrivateKeyParameters5.bdsState.getMaxIndex() + 1L;
                xMSSMTPrivateKeyParameters5.bdsState = new BDSStateMap(this.bdsState.getMaxIndex());
            }
            xMSSMTPrivateKeyParameters2.used = false;
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters6 = this;
            // ** MonitorExit[v5] (shouldn't be in output)
            return xMSSMTPrivateKeyParameters6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMSSMTPrivateKeyParameters extractKeyShard(int n) {
        if (n < 1) throw new IllegalArgumentException("cannot ask for a shard with 0 keys");
        synchronized (this) {
            BDSStateMap bDSStateMap;
            long l = n;
            if (l > this.getUsagesRemaining()) throw new IllegalArgumentException("usageCount exceeds usages remaining");
            Builder builder = new Builder(this.params).withSecretKeySeed(this.secretKeySeed).withSecretKeyPRF(this.secretKeyPRF).withPublicSeed(this.publicSeed).withRoot(this.root).withIndex(this.getIndex());
            BDSStateMap bDSStateMap2 = bDSStateMap;
            BDSStateMap bDSStateMap3 = bDSStateMap;
            BDSStateMap bDSStateMap4 = this.bdsState;
            long l2 = this.getIndex();
            bDSStateMap2(bDSStateMap4, l2 + l - 1L);
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = builder.withBDSState(bDSStateMap3).build();
            for (int k = 0; k != n; ++k) {
                this.rollKey();
            }
            return xMSSMTPrivateKeyParameters;
        }
    }

    public static class Builder {
        private final XMSSMTParameters params;
        private long index = 0L;
        private long maxIndex = -1L;
        private byte[] secretKeySeed = null;
        private byte[] secretKeyPRF = null;
        private byte[] publicSeed = null;
        private byte[] root = null;
        private BDSStateMap bdsState = null;
        private byte[] privateKey = null;
        private XMSSParameters xmss = null;

        public Builder(XMSSMTParameters xMSSMTParameters) {
            this.params = xMSSMTParameters;
        }

        public Builder withIndex(long l) {
            this.index = l;
            return this;
        }

        public Builder withMaxIndex(long l) {
            this.maxIndex = l;
            return this;
        }

        public Builder withSecretKeySeed(byte[] byArray) {
            this.secretKeySeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] byArray) {
            this.secretKeyPRF = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicSeed(byte[] byArray) {
            this.publicSeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withRoot(byte[] byArray) {
            this.root = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withBDSState(BDSStateMap bDSStateMap) {
            if (bDSStateMap.getMaxIndex() == 0L) {
                int n = this.params.getHeight();
                this.bdsState = new BDSStateMap(bDSStateMap, (1L << n) - 1L);
            } else {
                this.bdsState = bDSStateMap;
            }
            return this;
        }

        public Builder withPrivateKey(byte[] byArray) {
            Builder builder = this;
            builder.privateKey = XMSSUtil.cloneArray(byArray);
            builder.xmss = builder.params.getXMSSParameters();
            return builder;
        }

        public XMSSMTPrivateKeyParameters build() {
            return new XMSSMTPrivateKeyParameters(this, null);
        }
    }
}

