/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.McElieceCCA2PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import java.io.IOException;
import java.security.PublicKey;

public class BCMcElieceCCA2PublicKey
implements CipherParameters,
PublicKey {
    private static final long serialVersionUID = 1L;
    private McElieceCCA2PublicKeyParameters params;

    public BCMcElieceCCA2PublicKey(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.params = mcElieceCCA2PublicKeyParameters;
    }

    @Override
    public String getAlgorithm() {
        return "McEliece-CCA2";
    }

    public int getN() {
        return this.params.getN();
    }

    public int getK() {
        return this.params.getK();
    }

    public int getT() {
        return this.params.getT();
    }

    public GF2Matrix getG() {
        return this.params.getG();
    }

    public String toString() {
        return e.a(e.a(e.a("McEliecePublicKey:\n", " length of the code         : ").append(this.params.getN()).append("\n").toString(), " error correction capability: ").append(this.params.getT()).append("\n").toString(), " generator matrix           : ").append(this.params.getG().toString()).toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BCMcElieceCCA2PublicKey) {
            object = (BCMcElieceCCA2PublicKey)object;
            return this.params.getN() == ((BCMcElieceCCA2PublicKey)object).getN() && this.params.getT() == ((BCMcElieceCCA2PublicKey)object).getT() && this.params.getG().equals(((BCMcElieceCCA2PublicKey)object).getG());
        }
        return false;
    }

    public int hashCode() {
        BCMcElieceCCA2PublicKey bCMcElieceCCA2PublicKey = this;
        int n = bCMcElieceCCA2PublicKey.params.getN();
        n = (bCMcElieceCCA2PublicKey.params.getT() * 37 + n) * 37;
        return bCMcElieceCCA2PublicKey.params.getG().hashCode() + n;
    }

    @Override
    public byte[] getEncoded() {
        AlgorithmIdentifier algorithmIdentifier;
        McElieceCCA2PublicKey mcElieceCCA2PublicKey;
        McElieceCCA2PublicKey mcElieceCCA2PublicKey2 = mcElieceCCA2PublicKey;
        BCMcElieceCCA2PublicKey bCMcElieceCCA2PublicKey = this;
        int n = bCMcElieceCCA2PublicKey.params.getT();
        GF2Matrix gF2Matrix = bCMcElieceCCA2PublicKey.params.getG();
        AlgorithmIdentifier algorithmIdentifier2 = Utils.getDigAlgId(bCMcElieceCCA2PublicKey.params.getDigest());
        mcElieceCCA2PublicKey = new McElieceCCA2PublicKey(this.params.getN(), n, gF2Matrix, algorithmIdentifier2);
        AlgorithmIdentifier algorithmIdentifier3 = algorithmIdentifier;
        algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
        try {
            return new SubjectPublicKeyInfo(algorithmIdentifier3, mcElieceCCA2PublicKey2).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    public AsymmetricKeyParameter getKeyParams() {
        return this.params;
    }
}

