/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.McElieceCCA2PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class McElieceCCA2KeyFactorySpi
extends KeyFactorySpi
implements AsymmetricKeyInfoConverter {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PublicKey engineGeneratePublic(KeySpec keySpec) {
        Object object;
        if (!(keySpec instanceof X509EncodedKeySpec)) {
            throw new InvalidKeySpecException(b.b.a("Unsupported key specification: ").append(keySpec.getClass()).append(".").toString());
        }
        try {
            object = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(((X509EncodedKeySpec)keySpec).getEncoded()));
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(((Object)iOException).toString());
        }
        try {
            if (PQCObjectIdentifiers.mcElieceCca2.equals(((SubjectPublicKeyInfo)object).getAlgorithm().getAlgorithm())) {
                Object object2 = object = McElieceCCA2PublicKey.getInstance(((SubjectPublicKeyInfo)object).parsePublicKey());
                int n = ((McElieceCCA2PublicKey)object2).getN();
                int n2 = ((McElieceCCA2PublicKey)object2).getT();
                GF2Matrix gF2Matrix = ((McElieceCCA2PublicKey)object2).getG();
                object = Utils.getDigest(((McElieceCCA2PublicKey)object).getDigest()).getAlgorithmName();
                return new BCMcElieceCCA2PublicKey(new McElieceCCA2PublicKeyParameters(n, n2, gF2Matrix, (String)object));
            }
            throw new InvalidKeySpecException("Unable to recognise OID in McEliece private key");
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(b.a(iOException, b.b.a("Unable to decode X509EncodedKeySpec: ")));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        Object object;
        if (!(keySpec instanceof PKCS8EncodedKeySpec)) {
            throw new InvalidKeySpecException(b.b.a("Unsupported key specification: ").append(keySpec.getClass()).append(".").toString());
        }
        try {
            object = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(j.a("Unable to decode PKCS8EncodedKeySpec: ", iOException));
        }
        try {
            if (PQCObjectIdentifiers.mcElieceCca2.equals(((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getAlgorithm())) {
                Object object2 = object = McElieceCCA2PrivateKey.getInstance(((PrivateKeyInfo)object).parsePrivateKey());
                int n = ((McElieceCCA2PrivateKey)object2).getN();
                int n2 = ((McElieceCCA2PrivateKey)object2).getK();
                GF2mField gF2mField = ((McElieceCCA2PrivateKey)object2).getField();
                PolynomialGF2mSmallM polynomialGF2mSmallM = ((McElieceCCA2PrivateKey)object2).getGoppaPoly();
                Permutation permutation = ((McElieceCCA2PrivateKey)object2).getP();
                object = Utils.getDigest(((McElieceCCA2PrivateKey)object).getDigest()).getAlgorithmName();
                return new BCMcElieceCCA2PrivateKey(new McElieceCCA2PrivateKeyParameters(n, n2, gF2mField, polynomialGF2mSmallM, permutation, (String)object));
            }
            throw new InvalidKeySpecException("Unable to recognise OID in McEliece public key");
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KeySpec getKeySpec(Key key, Class clazz) {
        if (key instanceof BCMcElieceCCA2PrivateKey) {
            if (!PKCS8EncodedKeySpec.class.isAssignableFrom(clazz)) throw new InvalidKeySpecException("Unknown key specification: " + clazz + ".");
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (!(key instanceof BCMcElieceCCA2PublicKey)) throw new InvalidKeySpecException(b.b.a("Unsupported key type: ").append(key.getClass()).append(".").toString());
        if (!X509EncodedKeySpec.class.isAssignableFrom(clazz)) throw new InvalidKeySpecException("Unknown key specification: " + clazz + ".");
        return new X509EncodedKeySpec(key.getEncoded());
    }

    public Key translateKey(Key key) {
        if (!(key instanceof BCMcElieceCCA2PrivateKey) && !(key instanceof BCMcElieceCCA2PublicKey)) {
            throw new InvalidKeyException("Unsupported key type.");
        }
        return key;
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Object object = object2 = McElieceCCA2PublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
        int n = ((McElieceCCA2PublicKey)object).getN();
        int n2 = ((McElieceCCA2PublicKey)object).getT();
        GF2Matrix gF2Matrix = ((McElieceCCA2PublicKey)object).getG();
        Object object2 = Utils.getDigest(((McElieceCCA2PublicKey)object2).getDigest()).getAlgorithmName();
        return new BCMcElieceCCA2PublicKey(new McElieceCCA2PublicKeyParameters(n, n2, gF2Matrix, (String)object2));
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) {
        Object object = this = McElieceCCA2PrivateKey.getInstance(privateKeyInfo.parsePrivateKey().toASN1Primitive());
        int n = ((McElieceCCA2PrivateKey)object).getN();
        int n2 = ((McElieceCCA2PrivateKey)object).getK();
        GF2mField gF2mField = ((McElieceCCA2PrivateKey)object).getField();
        PolynomialGF2mSmallM polynomialGF2mSmallM = ((McElieceCCA2PrivateKey)object).getGoppaPoly();
        Permutation permutation = ((McElieceCCA2PrivateKey)object).getP();
        return new BCMcElieceCCA2PrivateKey(new McElieceCCA2PrivateKeyParameters(n, n2, gF2mField, polynomialGF2mSmallM, permutation, null));
    }

    public KeySpec engineGetKeySpec(Key key, Class clazz) {
        return null;
    }

    @Override
    public Key engineTranslateKey(Key key) {
        return null;
    }
}

