/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.saber;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.interfaces.SABERKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.SABERParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;

public class BCSABERPublicKey
implements PublicKey,
SABERKey {
    private static final long serialVersionUID = 1L;
    private transient SABERPublicKeyParameters params;

    public BCSABERPublicKey(SABERPublicKeyParameters sABERPublicKeyParameters) {
        this.params = sABERPublicKeyParameters;
    }

    public BCSABERPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        BCSABERPublicKey bCSABERPublicKey = this;
        bCSABERPublicKey.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.params = (SABERPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.init(SubjectPublicKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    public boolean equals(Object object) {
        if (object == bCSABERPublicKey2) {
            return true;
        }
        if (object instanceof BCSABERPublicKey) {
            BCSABERPublicKey bCSABERPublicKey = bCSABERPublicKey2;
            BCSABERPublicKey bCSABERPublicKey2 = (BCSABERPublicKey)object;
            return Arrays.areEqual(bCSABERPublicKey.params.getEncoded(), bCSABERPublicKey2.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "SABER";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public SABERParameterSpec getParameterSpec() {
        return SABERParameterSpec.fromName(this.params.getParameters().getName());
    }

    public SABERPublicKeyParameters getKeyParams() {
        return this.params;
    }
}

