/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.spec.AlgorithmParameterSpec;

public class RainbowParameterSpec
implements AlgorithmParameterSpec {
    private static final int[] DEFAULT_VI = new int[]{6, 12, 17, 22, 33};
    private int[] vi;

    public RainbowParameterSpec() {
        this.vi = DEFAULT_VI;
    }

    public RainbowParameterSpec(int[] nArray) {
        RainbowParameterSpec rainbowParameterSpec = this;
        rainbowParameterSpec.vi = nArray;
        rainbowParameterSpec.checkParams();
    }

    private void checkParams() {
        int[] nArray = this.vi;
        if (this.vi != null) {
            if (nArray.length > 1) {
                block3: {
                    int[] nArray2;
                    int n = 0;
                    do {
                        nArray2 = this.vi;
                        if (n >= this.vi.length - 1) break block3;
                    } while (nArray2[n] < nArray2[++n]);
                    throw new IllegalArgumentException("v[i] has to be smaller than v[i+1]");
                }
                return;
            }
            throw new IllegalArgumentException("Rainbow needs at least 1 layer, such that v1 < v2.");
        }
        throw new IllegalArgumentException("no layers defined.");
    }

    public int getNumOfLayers() {
        return this.vi.length - 1;
    }

    public int getDocumentLength() {
        Object object = ((RainbowParameterSpec)object).vi;
        return ((RainbowParameterSpec)object).vi[((RainbowParameterSpec)object).vi.length - 1] - object[0];
    }

    public int[] getVi() {
        return Arrays.clone(this.vi);
    }
}

