/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.BigDecimalPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Constants;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;

public class BigIntPolynomial {
    private static final double LOG_10_2 = Math.log10(2.0);
    public BigInteger[] coeffs;

    public BigIntPolynomial(int n) {
        this.coeffs = new BigInteger[n];
        for (int k = 0; k < n; ++k) {
            this.coeffs[k] = Constants.BIGINT_ZERO;
        }
    }

    public BigIntPolynomial(BigInteger[] bigIntegerArray) {
        this.coeffs = bigIntegerArray;
    }

    public BigIntPolynomial(IntegerPolynomial integerPolynomial) {
        this.coeffs = new BigInteger[integerPolynomial.coeffs.length];
        int n = 0;
        while (true) {
            BigInteger[] bigIntegerArray = this.coeffs;
            if (n >= this.coeffs.length) break;
            bigIntegerArray[n] = BigInteger.valueOf(integerPolynomial.coeffs[n]);
            ++n;
        }
    }

    public static BigIntPolynomial generateRandomSmall(int n, int n2, int n3) {
        BigIntPolynomial bigIntPolynomial;
        ArrayList<BigInteger> arrayList;
        ArrayList<BigInteger> arrayList2 = arrayList;
        arrayList = new ArrayList<BigInteger>();
        for (int k = 0; k < n2; ++k) {
            arrayList2.add(Constants.BIGINT_ONE);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList2.add(BigInteger.valueOf(-1L));
        }
        while (arrayList2.size() < n) {
            arrayList2.add(Constants.BIGINT_ZERO);
        }
        Collections.shuffle(arrayList2, CryptoServicesRegistrar.getSecureRandom());
        BigIntPolynomial bigIntPolynomial2 = bigIntPolynomial;
        bigIntPolynomial = new BigIntPolynomial(n);
        for (n = 0; n < arrayList2.size(); ++n) {
            bigIntPolynomial2.coeffs[n] = (BigInteger)arrayList2.get(n);
        }
        return bigIntPolynomial2;
    }

    private BigIntPolynomial multRecursive(BigIntPolynomial bigIntPolynomial) {
        BigIntPolynomial bigIntPolynomial2;
        BigInteger[] bigIntegerArray;
        BigIntPolynomial bigIntPolynomial3;
        BigIntPolynomial bigIntPolynomial4;
        BigIntPolynomial bigIntPolynomial5;
        Object object = this.coeffs;
        Object object2 = bigIntPolynomial.coeffs;
        int n = bigIntPolynomial.coeffs.length;
        if (n <= 1) {
            object = Arrays.clone((BigInteger[])object);
            for (int k = 0; k < this.coeffs.length; ++k) {
                object[k] = object[k].multiply(bigIntPolynomial.coeffs[0]);
            }
            return new BigIntPolynomial((BigInteger[])object);
        }
        int n2 = n / 2;
        bigIntPolynomial = bigIntPolynomial5;
        bigIntPolynomial5 = new BigIntPolynomial(Arrays.copyOf((BigInteger[])object, n2));
        BigIntPolynomial bigIntPolynomial6 = bigIntPolynomial4;
        bigIntPolynomial4 = new BigIntPolynomial(Arrays.copyOfRange((BigInteger[])object, n2, n));
        object = bigIntPolynomial3;
        bigIntPolynomial3 = new BigIntPolynomial(Arrays.copyOf((BigInteger[])object2, n2));
        BigInteger[] bigIntegerArray2 = bigIntegerArray;
        bigIntegerArray = new BigIntPolynomial(Arrays.copyOfRange((BigInteger[])object2, n2, n));
        BigIntPolynomial bigIntPolynomial7 = (BigIntPolynomial)bigIntPolynomial5.clone();
        object2 = bigIntPolynomial7;
        BigIntPolynomial bigIntPolynomial8 = bigIntPolynomial;
        Object object3 = object;
        ((BigIntPolynomial)object2).add(bigIntPolynomial6);
        bigIntPolynomial = (BigIntPolynomial)((BigIntPolynomial)object3).clone();
        bigIntPolynomial.add((BigIntPolynomial)bigIntegerArray2);
        object = bigIntPolynomial8.multRecursive((BigIntPolynomial)object3);
        object2 = bigIntPolynomial6.multRecursive((BigIntPolynomial)bigIntegerArray2);
        bigIntPolynomial = bigIntPolynomial7.multRecursive(bigIntPolynomial);
        bigIntPolynomial.sub((BigIntPolynomial)object);
        bigIntPolynomial.sub((BigIntPolynomial)object2);
        bigIntPolynomial6 = bigIntPolynomial2;
        bigIntPolynomial2 = new BigIntPolynomial(n * 2 - 1);
        n = 0;
        while (true) {
            bigIntegerArray2 = ((BigIntPolynomial)object).coeffs;
            if (n >= ((BigIntPolynomial)object).coeffs.length) break;
            bigIntPolynomial6.coeffs[n] = bigIntegerArray2[n];
            ++n;
        }
        int n3 = 0;
        while (true) {
            BigInteger[] bigIntegerArray3 = bigIntPolynomial.coeffs;
            if (n3 >= bigIntPolynomial.coeffs.length) break;
            int n4 = n2 + n3;
            bigIntPolynomial6.coeffs[n4] = bigIntPolynomial6.coeffs[n4].add(bigIntegerArray3[n3]);
            ++n3;
        }
        int n5 = 0;
        while (true) {
            BigInteger[] bigIntegerArray4 = ((BigIntPolynomial)object2).coeffs;
            if (n5 >= ((BigIntPolynomial)object2).coeffs.length) break;
            int n6 = n2 * 2 + n5;
            bigIntPolynomial6.coeffs[n6] = bigIntPolynomial6.coeffs[n6].add(bigIntegerArray4[n5]);
            ++n5;
        }
        return bigIntPolynomial6;
    }

    private BigInteger maxCoeffAbs() {
        Object object = this.coeffs[0].abs();
        int n = 1;
        while (true) {
            Object object2 = this.coeffs;
            if (n >= this.coeffs.length) break;
            if ((object2 = object2[n].abs()).compareTo((BigInteger)object) > 0) {
                object = object2;
            }
            ++n;
        }
        return object;
    }

    public BigIntPolynomial mult(BigIntPolynomial bigIntPolynomial) {
        int n = bigIntPolynomial2.coeffs.length;
        if (bigIntPolynomial.coeffs.length == n) {
            BigIntPolynomial bigIntPolynomial2 = bigIntPolynomial2.multRecursive(bigIntPolynomial);
            if (bigIntPolynomial2.coeffs.length > n) {
                BigInteger[] bigIntegerArray;
                int n2 = n;
                while (true) {
                    bigIntegerArray = bigIntPolynomial2.coeffs;
                    if (n2 >= bigIntPolynomial2.coeffs.length) break;
                    int n3 = n2 - n;
                    bigIntegerArray[n3] = bigIntegerArray[n3].add(bigIntegerArray[n2]);
                    ++n2;
                }
                bigIntPolynomial2.coeffs = Arrays.copyOf(bigIntegerArray, n);
            }
            return bigIntPolynomial2;
        }
        throw new IllegalArgumentException("Number of coefficients must be the same");
    }

    public void add(BigIntPolynomial bigIntPolynomial, BigInteger bigInteger) {
        BigIntPolynomial bigIntPolynomial2 = this;
        bigIntPolynomial2.add(bigIntPolynomial);
        bigIntPolynomial2.mod(bigInteger);
    }

    public void add(BigIntPolynomial bigIntPolynomial) {
        BigInteger[] bigIntegerArray = bigIntPolynomial.coeffs;
        BigInteger[] bigIntegerArray2 = this.coeffs;
        if (bigIntPolynomial.coeffs.length > this.coeffs.length) {
            int n = bigIntegerArray2.length;
            this.coeffs = Arrays.copyOf(bigIntegerArray2, bigIntegerArray.length);
            while (true) {
                bigIntegerArray2 = this.coeffs;
                if (n >= this.coeffs.length) break;
                bigIntegerArray2[n] = Constants.BIGINT_ZERO;
                ++n;
            }
        }
        int n = 0;
        while (true) {
            bigIntegerArray2 = bigIntPolynomial.coeffs;
            if (n >= bigIntPolynomial.coeffs.length) break;
            this.coeffs[n] = this.coeffs[n].add(bigIntegerArray2[n]);
            ++n;
        }
    }

    public void sub(BigIntPolynomial bigIntPolynomial) {
        BigInteger[] bigIntegerArray = bigIntPolynomial.coeffs;
        BigInteger[] bigIntegerArray2 = this.coeffs;
        if (bigIntPolynomial.coeffs.length > this.coeffs.length) {
            int n = bigIntegerArray2.length;
            this.coeffs = Arrays.copyOf(bigIntegerArray2, bigIntegerArray.length);
            while (true) {
                bigIntegerArray2 = this.coeffs;
                if (n >= this.coeffs.length) break;
                bigIntegerArray2[n] = Constants.BIGINT_ZERO;
                ++n;
            }
        }
        int n = 0;
        while (true) {
            bigIntegerArray2 = bigIntPolynomial.coeffs;
            if (n >= bigIntPolynomial.coeffs.length) break;
            this.coeffs[n] = this.coeffs[n].subtract(bigIntegerArray2[n]);
            ++n;
        }
    }

    public void mult(BigInteger bigInteger) {
        int n = 0;
        while (true) {
            BigInteger[] bigIntegerArray = this.coeffs;
            if (n >= this.coeffs.length) break;
            bigIntegerArray[n] = bigIntegerArray[n].multiply(bigInteger);
            ++n;
        }
    }

    public void mult(int n) {
        this.mult(BigInteger.valueOf(n));
    }

    public void div(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.add(Constants.BIGINT_ONE).divide(BigInteger.valueOf(2L));
        int n = 0;
        while (true) {
            BigInteger[] bigIntegerArray = this.coeffs;
            if (n >= this.coeffs.length) break;
            BigInteger bigInteger3 = bigIntegerArray[n].compareTo(Constants.BIGINT_ZERO) > 0 ? this.coeffs[n].add(bigInteger2) : this.coeffs[n].add(bigInteger2.negate());
            bigIntegerArray[n] = bigInteger3;
            this.coeffs[n] = this.coeffs[n].divide(bigInteger);
            ++n;
        }
    }

    public BigDecimalPolynomial div(BigDecimal bigDecimal, int n) {
        BigDecimalPolynomial bigDecimalPolynomial;
        int n2 = (int)((double)this.maxCoeffAbs().bitLength() * LOG_10_2) + 1;
        bigDecimal = Constants.BIGDEC_ONE.divide(bigDecimal, n2 + n + 1, 6);
        BigDecimalPolynomial bigDecimalPolynomial2 = bigDecimalPolynomial;
        bigDecimalPolynomial = new BigDecimalPolynomial(this.coeffs.length);
        for (int k = 0; k < this.coeffs.length; ++k) {
            bigDecimalPolynomial2.coeffs[k] = new BigDecimal(this.coeffs[k]).multiply(bigDecimal).setScale(n, 6);
        }
        return bigDecimalPolynomial2;
    }

    public int getMaxCoeffLength() {
        return (int)((double)this.maxCoeffAbs().bitLength() * LOG_10_2) + 1;
    }

    public void mod(BigInteger bigInteger) {
        int n = 0;
        while (true) {
            BigInteger[] bigIntegerArray = this.coeffs;
            if (n >= this.coeffs.length) break;
            bigIntegerArray[n] = bigIntegerArray[n].mod(bigInteger);
            ++n;
        }
    }

    public BigInteger sumCoeffs() {
        BigInteger bigInteger = Constants.BIGINT_ZERO;
        int n = 0;
        while (true) {
            BigInteger[] bigIntegerArray = this.coeffs;
            if (n >= this.coeffs.length) break;
            bigInteger = bigInteger.add(bigIntegerArray[n]);
            ++n;
        }
        return bigInteger;
    }

    public Object clone() {
        return new BigIntPolynomial((BigInteger[])this.coeffs.clone());
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.coeffs);
    }

    public boolean equals(Object object) {
        if (bigIntPolynomial2 == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (bigIntPolynomial2.getClass() != object.getClass()) {
            return false;
        }
        BigIntPolynomial bigIntPolynomial = bigIntPolynomial2;
        BigIntPolynomial bigIntPolynomial2 = (BigIntPolynomial)object;
        return Arrays.areEqual(bigIntPolynomial.coeffs, bigIntPolynomial2.coeffs);
    }

    public BigInteger[] getCoeffs() {
        return Arrays.clone(this.coeffs);
    }
}

