/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.InputStream;
import java.math.BigInteger;

public class ArrayEncoder {
    private static final int[] COEFF1_TABLE = new int[]{0, 0, 0, 1, 1, 1, -1, -1};
    private static final int[] COEFF2_TABLE = new int[]{0, 1, -1, 0, 1, -1, 0, 1};
    private static final int[] BIT1_TABLE = new int[]{1, 1, 1, 0, 0, 0, 1, 0, 1};
    private static final int[] BIT2_TABLE = new int[]{1, 1, 1, 1, 0, 0, 0, 1, 0};
    private static final int[] BIT3_TABLE = new int[]{1, 0, 1, 0, 0, 1, 1, 1, 0};

    public static byte[] encodeModQ(int[] nArray, int n) {
        n = 31 - Integer.numberOfLeadingZeros(n);
        byte[] byArray = new byte[(nArray.length * n + 7) / 8];
        int n2 = 0;
        int n3 = 0;
        for (int k = 0; k < nArray.length; ++k) {
            for (int i2 = 0; i2 < n; ++i2) {
                int n4 = nArray[k] >> i2 & 1;
                byArray[n3] = (byte)(byArray[n3] | n4 << n2);
                if (n2 == 7) {
                    n2 = 0;
                    ++n3;
                    continue;
                }
                ++n2;
            }
        }
        return byArray;
    }

    public static int[] decodeModQ(byte[] byArray, int n, int n2) {
        int[] nArray = new int[n];
        n2 = 31 - Integer.numberOfLeadingZeros(n2);
        int n3 = n * n2;
        int n4 = 0;
        for (int k = 0; k < n3; ++k) {
            if (k > 0 && k % n2 == 0) {
                ++n4;
            }
            int n5 = ArrayEncoder.getBit(byArray, k);
            nArray[n4] = nArray[n4] + (n5 << k % n2);
        }
        return nArray;
    }

    public static int[] decodeModQ(InputStream inputStream, int n, int n2) {
        return ArrayEncoder.decodeModQ(Util.readFullLength(inputStream, ((31 - Integer.numberOfLeadingZeros(n2)) * n + 7) / 8), n, n2);
    }

    public static int[] decodeMod3Sves(byte[] byArray, int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length * 8) {
            int n4 = ArrayEncoder.getBit(byArray, n3++);
            int n5 = n3++;
            int n6 = n4;
            n4 = ArrayEncoder.getBit(byArray, n3++);
            int n7 = n6 * 4;
            n4 = ArrayEncoder.getBit(byArray, n5) * 2 + n7 + n4;
            nArray[n2++] = COEFF1_TABLE[n4];
            n7 = n2 + 1;
            nArray[n2] = COEFF2_TABLE[n4];
            if (n7 > n - 2) break;
            n2 = n7;
        }
        return nArray;
    }

    public static byte[] encodeMod3Sves(int[] nArray) {
        byte[] byArray = new byte[((nArray.length * 3 + 1) / 2 + 7) / 8];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length / 2 * 2) {
            int n4 = nArray[n3++] + 1;
            int n5 = nArray[n3++] + 1;
            if (n4 == 0 && n5 == 0) {
                throw new IllegalStateException("Illegal encoding!");
            }
            n4 = n4 * 3 + n5;
            int[] nArray2 = new int[3];
            int[] nArray3 = nArray2;
            nArray2[0] = BIT1_TABLE[n4];
            nArray2[1] = BIT2_TABLE[n4];
            nArray2[2] = BIT3_TABLE[n4];
            for (n4 = 0; n4 < 3; ++n4) {
                byArray[n2] = (byte)(byArray[n2] | nArray3[n4] << n);
                if (n == 7) {
                    n = 0;
                    ++n2;
                    continue;
                }
                ++n;
            }
        }
        return byArray;
    }

    public static byte[] encodeMod3Tight(int[] nArray) {
        Object object = BigInteger.ZERO;
        for (int k = nArray.length - 1; k >= 0; --k) {
            object = ((BigInteger)object).multiply(BigInteger.valueOf(3L)).add(BigInteger.valueOf(nArray[k] + 1));
        }
        int n = (BigInteger.valueOf(3L).pow(nArray.length).bitLength() + 7) / 8;
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        if (byArray.length < n) {
            byte[] byArray2 = new byte[n];
            Object object2 = object;
            int n2 = ((Object)object2).length;
            System.arraycopy(object2, 0, byArray2, n -= ((Object)object).length, n2);
            return byArray2;
        }
        if (((Object)object).length > n) {
            Object object3 = object;
            object = Arrays.copyOfRange((byte[])object3, 1, ((Object)object3).length);
        }
        return object;
    }

    public static int[] decodeMod3Tight(byte[] objectArray, int n) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigInteger;
        bigInteger = new BigInteger(1, (byte[])objectArray);
        objectArray = new int[n];
        for (int k = 0; k < n; ++k) {
            int n2;
            objectArray[k] = n2 = bigInteger2.mod(BigInteger.valueOf(3L)).intValue() - 1;
            if (n2 > 1) {
                objectArray[k] = n2 - 3;
            }
            bigInteger2 = bigInteger2.divide(BigInteger.valueOf(3L));
        }
        return objectArray;
    }

    public static int[] decodeMod3Tight(InputStream inputStream, int n) {
        double d2 = n;
        return ArrayEncoder.decodeMod3Tight(Util.readFullLength(inputStream, (int)Math.ceil(Math.log(3.0) * d2 / Math.log(2.0) / 8.0)), n);
    }

    private static int getBit(byte[] byArray, int n) {
        return (byArray[n / 8] & 0xFF) >> n % 8 & 1;
    }
}

