/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class Base32Encoder
implements Encoder {
    private static final byte[] DEAULT_ENCODING_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};
    private static final byte DEFAULT_PADDING = 61;
    private final byte[] encodingTable;
    private final byte padding;
    private final byte[] decodingTable;

    public Base32Encoder() {
        Base32Encoder base32Encoder = this;
        base32Encoder.decodingTable = new byte[128];
        base32Encoder.encodingTable = DEAULT_ENCODING_TABLE;
        base32Encoder.padding = (byte)61;
        base32Encoder.initialiseDecodingTable();
    }

    public Base32Encoder(byte[] byArray, byte by) {
        this.decodingTable = new byte[128];
        if (byArray.length == 32) {
            this.encodingTable = Arrays.clone(byArray);
            this.padding = by;
            this.initialiseDecodingTable();
            return;
        }
        throw new IllegalArgumentException("encoding table needs to be length 32");
    }

    private void encodeBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n;
        int n4 = n3 + 1;
        int n5 = byArray[n3];
        n = byArray[n4++] & 0xFF;
        int n6 = byArray[n4++] & 0xFF;
        int n7 = byArray[n4++] & 0xFF;
        n4 = byArray[n4] & 0xFF;
        int n8 = n2 + 1;
        byte[] byArray3 = this.encodingTable;
        int n9 = n;
        int n10 = n;
        int n11 = n5;
        byArray2[n2] = byArray3[n5 >>> 3 & 0x1F];
        n5 = n8 + 1;
        byArray2[n8] = byArray3[(n11 << 2 | n >>> 6) & 0x1F];
        n = n5 + 1;
        byArray2[n5] = byArray3[n10 >>> 1 & 0x1F];
        n5 = n + 1;
        byArray2[n] = byArray3[(n9 << 4 | n6 >>> 4) & 0x1F];
        n = n5 + 1;
        byArray2[n5] = byArray3[(n6 << 1 | n7 >>> 7) & 0x1F];
        n5 = n + 1;
        byArray2[n] = byArray3[n7 >>> 2 & 0x1F];
        n = n5 + 1;
        byArray2[n5] = byArray3[(n7 << 3 | n4 >>> 5) & 0x1F];
        byArray2[n] = this.encodingTable[n4 & 0x1F];
    }

    private boolean ignore(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ';
    }

    private int nextI(byte[] byArray, int n, int n2) {
        while (n < n2 && this.ignore((char)byArray[n])) {
            ++n;
        }
        return n;
    }

    private int decodeLastBlock(OutputStream outputStream, char c2, char object, char object2, char object3, char object4, char object5, char object6, char c3) {
        Object object7;
        byte by = ((Base32Encoder)object7).padding;
        if (c3 == by) {
            if (object6 != by) {
                object7 = ((Base32Encoder)object7).decodingTable;
                Object object8 = object7[object];
                if (((c2 = ((Base32Encoder)object7).decodingTable[c2]) | object8 | (object = (Object)object7[object2]) | (object2 = (Object)object7[object3]) | (object3 = (Object)object7[object4]) | (object4 = (Object)object7[object5]) | (object5 = (Object)object7[object6])) >= 0) {
                    outputStream.write(c2 << 3 | object8 >> 2);
                    outputStream.write(object8 << 6 | object << 1 | object2 >> 4);
                    outputStream.write(object2 << 4 | object3 >> 1);
                    outputStream.write(object3 << 7 | object4 << 2 | object5 >> 3);
                    return 4;
                }
                throw new IOException("invalid characters encountered at end of base32 data");
            }
            if (object5 == by) {
                if (object4 != by) {
                    object7 = ((Base32Encoder)object7).decodingTable;
                    Object object9 = object7[object];
                    if (((c2 = ((Base32Encoder)object7).decodingTable[c2]) | object9 | (object = (Object)object7[object2]) | (object2 = (Object)object7[object3]) | (object3 = (Object)object7[object4])) >= 0) {
                        outputStream.write(c2 << 3 | object9 >> 2);
                        outputStream.write(object9 << 6 | object << 1 | object2 >> 4);
                        outputStream.write(object2 << 4 | object3 >> 1);
                        return 3;
                    }
                    throw new IOException("invalid characters encountered at end of base32 data");
                }
                if (object3 != by) {
                    object7 = ((Base32Encoder)object7).decodingTable;
                    Object object10 = object7[object];
                    if (((c2 = ((Base32Encoder)object7).decodingTable[c2]) | object10 | (object = (Object)object7[object2]) | (object2 = (Object)object7[object3])) >= 0) {
                        outputStream.write(c2 << 3 | object10 >> 2);
                        outputStream.write(object10 << 6 | object << 1 | object2 >> 4);
                        return 2;
                    }
                    throw new IOException("invalid characters encountered at end of base32 data");
                }
                if (object2 == by) {
                    object7 = ((Base32Encoder)object7).decodingTable;
                    Object object11 = object7[object];
                    if (((c2 = ((Base32Encoder)object7).decodingTable[c2]) | object11) >= 0) {
                        outputStream.write(c2 << 3 | object11 >> 2);
                        return 1;
                    }
                    throw new IOException("invalid characters encountered at end of base32 data");
                }
                throw new IOException("invalid characters encountered at end of base32 data");
            }
            throw new IOException("invalid characters encountered at end of base32 data");
        }
        object7 = ((Base32Encoder)object7).decodingTable;
        Object object12 = object7[object];
        if (((c2 = ((Base32Encoder)object7).decodingTable[c2]) | object12 | (object = (Object)object7[object2]) | (object2 = (Object)object7[object3]) | (object3 = (Object)object7[object4]) | (object4 = (Object)object7[object5]) | (object5 = (Object)object7[object6]) | (object6 = (Object)object7[c3])) >= 0) {
            outputStream.write(c2 << 3 | object12 >> 2);
            outputStream.write(object12 << 6 | object << 1 | object2 >> 4);
            outputStream.write(object2 << 4 | object3 >> 1);
            outputStream.write(object3 << 7 | object4 << 2 | object5 >> 3);
            outputStream.write(object5 << 5 | object6);
            return 5;
        }
        throw new IOException("invalid characters encountered at end of base32 data");
    }

    public void initialiseDecodingTable() {
        byte[] byArray;
        int n = 0;
        while (true) {
            byArray = this.decodingTable;
            if (n >= this.decodingTable.length) break;
            byArray[n] = -1;
            ++n;
        }
        n = 0;
        while (true) {
            byArray = this.encodingTable;
            if (n >= this.encodingTable.length) break;
            byte by = byArray[n];
            this.decodingTable[by] = (byte)n;
            ++n;
        }
    }

    public int encode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2 - 4;
        int n5 = n3;
        int n6 = n;
        while (n6 < n4) {
            this.encodeBlock(byArray, n6, byArray2, n5);
            n6 += 5;
            n5 += 8;
        }
        if ((n = n2 - (n6 - n)) > 0) {
            byte[] byArray3 = byArray;
            byArray = new byte[5];
            System.arraycopy(byArray3, n6, byArray, 0, n);
            this.encodeBlock(byArray, 0, byArray2, n5);
            switch (n) {
                default: {
                    break;
                }
                case 4: {
                    int n7 = n5 + 7;
                    byArray2[n7] = this.padding;
                    break;
                }
                case 3: {
                    byte by;
                    int n8 = n5 + 5;
                    byArray2[n8] = by = this.padding;
                    byArray2[n5 + 6] = by;
                    byArray2[n5 + 7] = by;
                    break;
                }
                case 2: {
                    byte by;
                    int n9 = n5 + 4;
                    byArray2[n9] = by = this.padding;
                    byArray2[n5 + 5] = by;
                    byArray2[n5 + 6] = by;
                    byArray2[n5 + 7] = by;
                    break;
                }
                case 1: {
                    byte by;
                    int n10 = n5 + 2;
                    byArray2[n10] = by = this.padding;
                    byArray2[n5 + 3] = by;
                    byArray2[n5 + 4] = by;
                    byArray2[n5 + 5] = by;
                    byArray2[n5 + 6] = by;
                    byArray2[n5 + 7] = by;
                }
            }
            n5 += 8;
        }
        return n5 - n3;
    }

    public int getEncodedLength(int n) {
        return (n + 4) / 5 * 8;
    }

    public int getMaxDecodedLength(int n) {
        return n / 8 * 5;
    }

    @Override
    public int encode(byte[] byArray, int n, int n2, OutputStream outputStream) {
        if (n2 < 0) {
            return 0;
        }
        byte[] byArray2 = new byte[72];
        int n3 = n2;
        while (n3 > 0) {
            int n4 = n3;
            int n5 = n;
            n3 = Math.min(45, n3);
            n = this.encode(byArray, n, n3, byArray2, 0);
            outputStream.write(byArray2, 0, n);
            n = n5 + n3;
            n3 = n4 - n3;
        }
        return (n2 + 2) / 3 * 4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int decode(byte[] byArray, int n, int n2, OutputStream outputStream) {
        void var4_8;
        void var10_18;
        void c3;
        int n3;
        char c2;
        int n4 = 55;
        byte[] byArray2 = new byte[55];
        int n5 = 0;
        int n6 = 0;
        for (c2 = n3 + c2; c2 > n3 && this.ignore((char)c3[c2 - true]); --c2) {
        }
        if (c2 == '\u0000') {
            return 0;
        }
        int n7 = 0;
        for (var10_18 = c2; var10_18 > n3 && n7 != 8; --var10_18) {
            if (this.ignore((char)c3[var10_18 - true])) continue;
            ++n7;
        }
        n3 = this.nextI((byte[])c3, n3, (int)var10_18);
        while (n3 < var10_18) {
            byte by;
            n7 = this.decodingTable[c3[n3++]];
            Base32Encoder base32Encoder = this;
            Base32Encoder base32Encoder2 = this;
            Base32Encoder base32Encoder3 = this;
            Base32Encoder base32Encoder4 = this;
            Base32Encoder base32Encoder5 = this;
            Base32Encoder base32Encoder6 = this;
            n3 = base32Encoder6.nextI((byte[])c3, n3, (int)var10_18);
            byte by2 = base32Encoder6.decodingTable[c3[n3++]];
            n3 = base32Encoder5.nextI((byte[])c3, n3, (int)var10_18);
            byte by3 = base32Encoder5.decodingTable[c3[n3++]];
            n3 = base32Encoder4.nextI((byte[])c3, n3, (int)var10_18);
            byte by4 = base32Encoder4.decodingTable[c3[n3++]];
            n3 = base32Encoder3.nextI((byte[])c3, n3, (int)var10_18);
            byte by5 = base32Encoder3.decodingTable[c3[n3++]];
            n3 = base32Encoder2.nextI((byte[])c3, n3, (int)var10_18);
            byte by6 = base32Encoder2.decodingTable[c3[n3++]];
            n3 = base32Encoder.nextI((byte[])c3, n3, (int)var10_18);
            byte by7 = base32Encoder.decodingTable[c3[n3++]];
            n3 = this.nextI((byte[])c3, n3, (int)var10_18);
            if ((n7 | by2 | by3 | by4 | by5 | by6 | by7 | (by = this.decodingTable[c3[n3++]])) >= 0) {
                byArray2[n5++] = (byte)(n7 << 3 | by2 >> 2);
                n7 = n5 + 1;
                byArray2[n5] = (byte)(by2 << 6 | by3 << 1 | by4 >> 4);
                n5 = n7 + 1;
                byArray2[n7] = (byte)(by4 << 4 | by5 >> 1);
                n7 = n5 + 1;
                byArray2[n5] = (byte)(by5 << 7 | by6 << 2 | by7 >> 3);
                n5 = n7 + 1;
                byArray2[n7] = (byte)(by7 << 5 | by);
                if (n5 == n4) {
                    var4_8.write(byArray2);
                    n5 = 0;
                }
                n6 += 5;
                n3 = this.nextI((byte[])c3, n3, (int)var10_18);
                continue;
            }
            throw new IOException("invalid characters encountered in base32 data");
        }
        if (n5 > 0) {
            var4_8.write(byArray2, 0, n5);
        }
        void v6 = c3;
        int c22 = this.nextI((byte[])c3, n3, c2);
        int n8 = this.nextI((byte[])c3, c22 + 1, c2);
        n3 = this.nextI((byte[])c3, n8 + 1, c2);
        int n9 = this.nextI((byte[])c3, n3 + 1, c2);
        n4 = this.nextI((byte[])c3, n9 + 1, c2);
        int n10 = this.nextI((byte[])c3, n4 + 1, c2);
        n5 = this.nextI((byte[])c3, n10 + 1, c2);
        c2 = this.nextI((byte[])c3, n5 + 1, c2);
        char c4 = (char)v6[c22];
        char c5 = (char)v6[n8];
        n3 = (char)v6[n3];
        char c6 = (char)v6[n9];
        n4 = (char)v6[n4];
        char c7 = (char)v6[n10];
        n5 = (char)v6[n5];
        c2 = (char)v6[c2];
        return n6 + this.decodeLastBlock((OutputStream)var4_8, c4, c5, (char)n3, c6, (char)n4, c7, (char)n5, c2);
    }

    @Override
    public int decode(String string, OutputStream outputStream) {
        byte[] byArray = Strings.toByteArray(string);
        return this.decode(byArray, 0, byArray.length, outputStream);
    }
}

