/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class HexEncoder
implements Encoder {
    public final byte[] encodingTable;
    public final byte[] decodingTable;

    public HexEncoder() {
        HexEncoder hexEncoder = this;
        hexEncoder.encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        hexEncoder.decodingTable = new byte[128];
        hexEncoder.initialiseDecodingTable();
    }

    private static boolean ignore(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ';
    }

    public void initialiseDecodingTable() {
        byte[] byArray;
        int n = 0;
        while (true) {
            byArray = this.decodingTable;
            if (n >= this.decodingTable.length) break;
            byArray[n] = -1;
            ++n;
        }
        n = 0;
        while (true) {
            byArray = this.encodingTable;
            if (n >= this.encodingTable.length) break;
            byte by = byArray[n];
            this.decodingTable[by] = (byte)n;
            ++n;
        }
        byte[] byArray2 = this.decodingTable;
        byArray2[65] = this.decodingTable[97];
        byArray2[66] = this.decodingTable[98];
        byArray2[67] = this.decodingTable[99];
        byArray2[68] = this.decodingTable[100];
        byArray2[69] = this.decodingTable[101];
        byArray2[70] = this.decodingTable[102];
    }

    public int encode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        n2 = n + n2;
        int n4 = n3;
        while (n < n2) {
            int n5 = byArray[n++] & 0xFF;
            int n6 = n4 + 1;
            byte[] byArray3 = this.encodingTable;
            byArray2[n4] = byArray3[n5 >>> 4];
            n4 = n6 + 1;
            byArray2[n6] = byArray3[n5 & 0xF];
        }
        return n4 - n3;
    }

    @Override
    public int encode(byte[] byArray, int n, int n2, OutputStream outputStream) {
        byte[] byArray2 = new byte[72];
        while (n2 > 0) {
            int n3 = n2;
            int n4 = n;
            n2 = Math.min(36, n2);
            n = this.encode(byArray, n, n2, byArray2, 0);
            outputStream.write(byArray2, 0, n);
            n = n4 + n2;
            n2 = n3 - n2;
        }
        return n2 * 2;
    }

    @Override
    public int decode(byte[] byArray, int n, int n2, OutputStream outputStream) {
        int n3 = 0;
        int n4 = 36;
        byte[] byArray2 = new byte[36];
        int n5 = 0;
        for (n2 = n + n2; n2 > n && HexEncoder.ignore((char)byArray[n2 - 1]); --n2) {
        }
        while (n < n2) {
            byte by;
            while (n < n2 && HexEncoder.ignore((char)byArray[n])) {
                ++n;
            }
            byte by2 = this.decodingTable[byArray[n++]];
            while (n < n2 && HexEncoder.ignore((char)byArray[n])) {
                ++n;
            }
            if ((by2 | (by = this.decodingTable[byArray[n++]])) >= 0) {
                int n6 = n5 + 1;
                byArray2[n5] = (byte)(by2 << 4 | by);
                if (n6 == n4) {
                    outputStream.write(byArray2);
                    n5 = 0;
                } else {
                    n5 = n6;
                }
                ++n3;
                continue;
            }
            throw new IOException("invalid characters encountered in Hex data");
        }
        if (n5 > 0) {
            outputStream.write(byArray2, 0, n5);
        }
        return n3;
    }

    @Override
    public int decode(String string, OutputStream outputStream) {
        int n;
        int n2 = 0;
        int n3 = 36;
        byte[] byArray = new byte[36];
        int n4 = 0;
        for (n = string.length(); n > 0 && HexEncoder.ignore(string.charAt(n - 1)); --n) {
        }
        int n5 = 0;
        while (n5 < n) {
            byte by;
            while (n5 < n && HexEncoder.ignore(string.charAt(n5))) {
                ++n5;
            }
            byte by2 = this.decodingTable[string.charAt(n5++)];
            while (n5 < n && HexEncoder.ignore(string.charAt(n5))) {
                ++n5;
            }
            if ((by2 | (by = this.decodingTable[string.charAt(n5++)])) >= 0) {
                int n6 = n4 + 1;
                byArray[n4] = (byte)(by2 << 4 | by);
                if (n6 == n3) {
                    outputStream.write(byArray);
                    n4 = 0;
                } else {
                    n4 = n6;
                }
                ++n2;
                continue;
            }
            throw new IOException("invalid characters encountered in Hex string");
        }
        if (n4 > 0) {
            outputStream.write(byArray, 0, n4);
        }
        return n2;
    }

    public byte[] decodeStrict(String string, int n, int n2) {
        if (string != null) {
            if (n >= 0 && n2 >= 0 && n <= string.length() - n2) {
                if ((n2 & 1) == 0) {
                    byte[] byArray = new byte[n2 >>>= 1];
                    for (int k = 0; k < n2; ++k) {
                        int n3 = n++;
                        int n4 = this.decodingTable[string.charAt(n++)];
                        n4 = this.decodingTable[string.charAt(n3)] << 4 | n4;
                        if (n4 >= 0) {
                            byArray[k] = (byte)n4;
                            continue;
                        }
                        throw new IOException("invalid characters encountered in Hex string");
                    }
                    return byArray;
                }
                throw new IOException("a hexadecimal encoding must have an even number of characters");
            }
            throw new IndexOutOfBoundsException("invalid offset and/or length specified");
        }
        throw new NullPointerException("'str' cannot be null");
    }
}

