/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Holder;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.IssuerSerial;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.ObjectDigestInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.PrincipalUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.X509Principal;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Selector;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class AttributeCertificateHolder
implements CertSelector,
Selector {
    public final Holder holder;

    public AttributeCertificateHolder(ASN1Sequence aSN1Sequence) {
        this.holder = Holder.getInstance(aSN1Sequence);
    }

    public AttributeCertificateHolder(X509Principal aSN1Object, BigInteger bigInteger) {
        ASN1Integer aSN1Integer;
        GeneralName generalName;
        IssuerSerial issuerSerial;
        Holder holder;
        Holder holder2 = holder;
        IssuerSerial issuerSerial2 = issuerSerial;
        ASN1Object aSN1Object2 = generalName;
        generalName = new GeneralName((X509Name)aSN1Object);
        aSN1Object = GeneralNames.getInstance(new DERSequence(aSN1Object2));
        aSN1Object2 = aSN1Integer;
        aSN1Integer = new ASN1Integer(bigInteger);
        issuerSerial = new IssuerSerial((GeneralNames)aSN1Object, (ASN1Integer)aSN1Object2);
        holder = new Holder(issuerSerial2);
        v4.holder = holder2;
    }

    public AttributeCertificateHolder(X500Principal x500Principal, BigInteger bigInteger) {
        this(X509Util.convertPrincipal(x500Principal), bigInteger);
    }

    public AttributeCertificateHolder(X509Certificate x509Certificate) {
        try {
            X509Principal x509Principal = PrincipalUtil.getIssuerX509Principal(x509Certificate);
            this.holder = new Holder(new IssuerSerial(this.generateGeneralNames(x509Principal), new ASN1Integer(x509Certificate.getSerialNumber())));
            return;
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }

    public AttributeCertificateHolder(X509Principal x509Principal) {
        this.holder = new Holder(this.generateGeneralNames(x509Principal));
    }

    public AttributeCertificateHolder(X500Principal x500Principal) {
        this(X509Util.convertPrincipal(x500Principal));
    }

    public AttributeCertificateHolder(int n, String object, String object2, byte[] object3) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        AlgorithmIdentifier algorithmIdentifier;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2;
        ObjectDigestInfo objectDigestInfo;
        Holder holder;
        Holder holder2 = holder;
        ObjectDigestInfo objectDigestInfo2 = objectDigestInfo;
        byte[] byArray = object3;
        object3 = aSN1ObjectIdentifier2;
        aSN1ObjectIdentifier2 = new ASN1ObjectIdentifier((String)object2);
        object2 = algorithmIdentifier;
        ASN1ObjectIdentifier aSN1ObjectIdentifier3 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier((String)object);
        algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier3);
        object = Arrays.clone(byArray);
        objectDigestInfo = new ObjectDigestInfo(n, (ASN1ObjectIdentifier)object3, (AlgorithmIdentifier)object2, (byte[])object);
        holder = new Holder(objectDigestInfo2);
        v6.holder = holder2;
    }

    private GeneralNames generateGeneralNames(X509Principal x509Principal) {
        return GeneralNames.getInstance(new DERSequence(new GeneralName(x509Principal)));
    }

    private boolean matchesDN(X509Principal x509Principal, GeneralNames generalNames) {
        GeneralName[] generalNameArray = generalNames.getNames();
        for (int k = 0; k != generalNameArray.length; ++k) {
            GeneralName generalName = generalNameArray[k];
            if (generalName.getTagNo() != 4) continue;
            try {
                if (!new X509Principal(generalName.getName().toASN1Primitive().getEncoded()).equals(x509Principal)) continue;
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private Object[] getNames(GeneralName[] generalNameArray) {
        ArrayList arrayList;
        Cloneable cloneable = arrayList;
        arrayList = new ArrayList(generalNameArray.length);
        for (int k = 0; k != generalNameArray.length; ++k) {
            if (generalNameArray[k].getTagNo() != 4) continue;
            try {
                ((ArrayList)cloneable).add(new X500Principal(generalNameArray[k].getName().toASN1Primitive().getEncoded()));
            }
            catch (IOException iOException) {
                throw new RuntimeException("badly formed Name object");
            }
        }
        Cloneable cloneable2 = cloneable;
        return ((ArrayList)cloneable2).toArray(new Object[((ArrayList)cloneable2).size()]);
    }

    private Principal[] getPrincipals(GeneralNames object) {
        ArrayList arrayList;
        Object[] objectArray = objectArray.getNames(((GeneralNames)object).getNames());
        object = arrayList;
        arrayList = new ArrayList();
        for (int k = 0; k != objectArray.length; ++k) {
            Object object2 = objectArray[k];
            if (!(object2 instanceof Principal)) continue;
            ((ArrayList)object).add(object2);
        }
        Object object3 = object;
        return ((ArrayList)object3).toArray(new Principal[((ArrayList)object3).size()]);
    }

    public int getDigestedObjectType() {
        if (this.holder.getObjectDigestInfo() != null) {
            return this.holder.getObjectDigestInfo().getDigestedObjectType().intValueExact();
        }
        return -1;
    }

    public String getDigestAlgorithm() {
        if (this.holder.getObjectDigestInfo() != null) {
            return this.holder.getObjectDigestInfo().getDigestAlgorithm().getAlgorithm().getId();
        }
        return null;
    }

    public byte[] getObjectDigest() {
        if (this.holder.getObjectDigestInfo() != null) {
            return this.holder.getObjectDigestInfo().getObjectDigest().getBytes();
        }
        return null;
    }

    public String getOtherObjectTypeID() {
        if (this.holder.getObjectDigestInfo() != null) {
            this.holder.getObjectDigestInfo().getOtherObjectTypeID().getId();
        }
        return null;
    }

    public Principal[] getEntityNames() {
        if (this.holder.getEntityName() != null) {
            AttributeCertificateHolder attributeCertificateHolder = this;
            return attributeCertificateHolder.getPrincipals(attributeCertificateHolder.holder.getEntityName());
        }
        return null;
    }

    public Principal[] getIssuer() {
        if (this.holder.getBaseCertificateID() != null) {
            AttributeCertificateHolder attributeCertificateHolder = this;
            return attributeCertificateHolder.getPrincipals(attributeCertificateHolder.holder.getBaseCertificateID().getIssuer());
        }
        return null;
    }

    public BigInteger getSerialNumber() {
        if (this.holder.getBaseCertificateID() != null) {
            return this.holder.getBaseCertificateID().getSerial().getValue();
        }
        return null;
    }

    @Override
    public Object clone() {
        return new AttributeCertificateHolder((ASN1Sequence)this.holder.toASN1Primitive());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean match(Certificate var1_1) {
        block16: {
            block17: {
                block15: {
                    block12: {
                        block14: {
                            block13: {
                                if (!(var1_1 instanceof X509Certificate)) {
                                    return false;
                                }
                                var2_2 = (X509Certificate)var1_1;
                                try {
                                    if (this.holder.getBaseCertificateID() == null) break block12;
                                }
                                catch (CertificateEncodingException v0) {
                                    return false;
                                }
                                if (!this.holder.getBaseCertificateID().getSerial().hasValue(var2_2.getSerialNumber())) break block13;
                                if (!this.matchesDN(PrincipalUtil.getIssuerX509Principal((X509Certificate)var2_2), this.holder.getBaseCertificateID().getIssuer())) break block13;
                                v1 = true;
                                break block14;
                            }
                            v1 = false;
                        }
                        return v1;
                    }
                    if (this.holder.getEntityName() == null) break block15;
                    if (!this.matchesDN(PrincipalUtil.getSubjectX509Principal((X509Certificate)var2_2), this.holder.getEntityName())) break block15;
                    return true;
                }
                if (this.holder.getObjectDigestInfo() == null) break block16;
                v2 = this;
                v3 = v2;
                var2_2 = MessageDigest.getInstance(v2.getDigestAlgorithm(), "BC");
                var3_3 = v3.getDigestedObjectType();
                if (var3_3 == 0) ** GOTO lbl38
                if (var3_3 != 1) ** GOTO lbl39
                var2_2.update(var1_1.getEncoded());
                break block17;
lbl38:
                // 1 sources

                var2_2.update(var1_1.getPublicKey().getEncoded());
            }
            Arrays.areEqual(var2_2.digest(), this.getObjectDigest());
            return false;
            catch (Exception v4) {
                return false;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == attributeCertificateHolder2) {
            return true;
        }
        if (!(object instanceof AttributeCertificateHolder)) {
            return false;
        }
        AttributeCertificateHolder attributeCertificateHolder = attributeCertificateHolder2;
        AttributeCertificateHolder attributeCertificateHolder2 = (AttributeCertificateHolder)object;
        return attributeCertificateHolder.holder.equals(attributeCertificateHolder2.holder);
    }

    public int hashCode() {
        return this.holder.hashCode();
    }

    public boolean match(Object object) {
        if (!(object instanceof X509Certificate)) {
            return false;
        }
        return this.match((Certificate)object);
    }
}

