/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CertificatePair;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509CertificateObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.ExtCertificateEncodingException;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class X509CertificatePair {
    private final JcaJceHelper bcHelper;
    private X509Certificate forward;
    private X509Certificate reverse;

    public X509CertificatePair(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        BCJcaJceHelper bCJcaJceHelper;
        BCJcaJceHelper bCJcaJceHelper2 = bCJcaJceHelper;
        bCJcaJceHelper = new BCJcaJceHelper();
        v1.bcHelper = bCJcaJceHelper2;
        v1.forward = x509Certificate;
        v1.reverse = x509Certificate2;
    }

    public X509CertificatePair(CertificatePair certificatePair) {
        this.bcHelper = new BCJcaJceHelper();
        if (certificatePair.getForward() != null) {
            this.forward = new X509CertificateObject(certificatePair.getForward());
        }
        if (certificatePair.getReverse() != null) {
            this.reverse = new X509CertificateObject(certificatePair.getReverse());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getEncoded() {
        Certificate certificate = null;
        Certificate certificate2 = null;
        try {
            if (this.forward != null && (certificate = Certificate.getInstance(new ASN1InputStream(this.forward.getEncoded()).readObject())) == null) {
                throw new CertificateEncodingException("unable to get encoding for forward");
            }
            if (this.reverse == null) return new CertificatePair(certificate, certificate2).getEncoded("DER");
            certificate2 = Certificate.getInstance(new ASN1InputStream(this.reverse.getEncoded()).readObject());
            if (certificate2 != null) {
                return new CertificatePair(certificate, certificate2).getEncoded("DER");
            }
            throw new CertificateEncodingException("unable to get encoding for reverse");
        }
        catch (IOException iOException) {
            throw new ExtCertificateEncodingException(((Object)iOException).toString(), iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExtCertificateEncodingException(((Object)illegalArgumentException).toString(), illegalArgumentException);
        }
    }

    public X509Certificate getForward() {
        return this.forward;
    }

    public X509Certificate getReverse() {
        return this.reverse;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof X509CertificatePair)) {
            return false;
        }
        object = (X509CertificatePair)object;
        boolean bl = true;
        boolean bl2 = true;
        X509Certificate x509Certificate = ((X509CertificatePair)((Object)x509Certificate2)).forward;
        if (x509Certificate != null) {
            bl2 = ((Object)x509Certificate).equals(((X509CertificatePair)object).forward);
        } else if (((X509CertificatePair)object).forward != null) {
            bl2 = false;
        }
        X509Certificate x509Certificate2 = ((X509CertificatePair)((Object)x509Certificate2)).reverse;
        if (x509Certificate2 != null) {
            bl = ((Object)x509Certificate2).equals(((X509CertificatePair)object).reverse);
        } else if (((X509CertificatePair)object).reverse != null) {
            bl = false;
        }
        return bl2 && bl;
    }

    public int hashCode() {
        int n = -1;
        X509Certificate x509Certificate = ((X509CertificatePair)this).forward;
        if (x509Certificate != null) {
            n = ((Object)x509Certificate).hashCode() ^ n;
        }
        if ((this = ((X509CertificatePair)this).reverse) != null) {
            n = n * 17 ^ this.hashCode();
        }
        return n;
    }
}

