/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import com.fis.ekyc.nfc.build_in.cvc.AbstractSequence;
import com.fis.ekyc.nfc.build_in.cvc.AlgorithmUtil;
import com.fis.ekyc.nfc.build_in.cvc.ByteField;
import com.fis.ekyc.nfc.build_in.cvc.CAReferenceField;
import com.fis.ekyc.nfc.build_in.cvc.CVCPublicKey;
import com.fis.ekyc.nfc.build_in.cvc.CVCTagEnum;
import com.fis.ekyc.nfc.build_in.cvc.CVCertificate;
import com.fis.ekyc.nfc.build_in.cvc.Signable;
import com.fis.ekyc.nfc.build_in.cvc.exception.ConstructionException;
import com.fis.ekyc.nfc.build_in.cvc.util.BCECUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;

public class CVCAuthenticatedRequest
extends AbstractSequence
implements Signable {
    private static final long serialVersionUID = 1L;
    private static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.CV_CERTIFICATE, CVCTagEnum.CA_REFERENCE, CVCTagEnum.SIGNATURE};

    public CVCAuthenticatedRequest() {
        super(CVCTagEnum.REQ_AUTHENTICATION);
    }

    public CVCAuthenticatedRequest(CVCertificate cVCertificate, CAReferenceField cAReferenceField) {
        CVCAuthenticatedRequest cVCAuthenticatedRequest = this;
        cVCAuthenticatedRequest();
        cVCAuthenticatedRequest.addSubfield(cVCertificate);
        cVCAuthenticatedRequest.addSubfield(cAReferenceField);
    }

    @Override
    public CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    public void setSignature(byte[] byArray) {
        this.addSubfield(new ByteField(CVCTagEnum.SIGNATURE, byArray));
    }

    @Override
    public byte[] getTBS() {
        DataOutputStream dataOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = dataOutputStream;
        CVCAuthenticatedRequest cVCAuthenticatedRequest = this;
        CVCAuthenticatedRequest cVCAuthenticatedRequest2 = cVCAuthenticatedRequest;
        dataOutputStream2(byteArrayOutputStream2);
        cVCAuthenticatedRequest.getRequest().encode(dataOutputStream2);
        cVCAuthenticatedRequest2.getAuthorityReference().encode(dataOutputStream2);
        try {
            ((OutputStream)dataOutputStream).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ConstructionException(iOException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ConstructionException(noSuchFieldException);
        }
    }

    public CVCertificate getRequest() {
        return (CVCertificate)this.getSubfield(CVCTagEnum.CV_CERTIFICATE);
    }

    public CAReferenceField getAuthorityReference() {
        return (CAReferenceField)this.getSubfield(CVCTagEnum.CA_REFERENCE);
    }

    public byte[] getSignature() {
        return ((ByteField)this.getSubfield(CVCTagEnum.SIGNATURE)).getData();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verify(PublicKey publicKey) {
        Signature signature;
        String string;
        try {
            string = AlgorithmUtil.getAlgorithmName(publicKey instanceof CVCPublicKey ? ((CVCPublicKey)publicKey).getObjectIdentifier() : this.getRequest().getCertificateBody().getPublicKey().getObjectIdentifier());
            signature = Signature.getInstance(string, "BC");
        }
        catch (ConstructionException constructionException) {
            throw new CertificateException("CV-Certificate is corrupt", constructionException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("CV-Certificate is corrupt", noSuchFieldException);
        }
        {
            signature.initVerify(publicKey);
            signature.update(this.getTBS());
            if (signature.verify(BCECUtil.convertCVCSigToX962(string, this.getSignature()))) {
                return;
            }
            throw new SignatureException("Signature verification failed!");
        }
    }

    public String toString() {
        return this.getAsText("", true);
    }
}

