/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.cbeff;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlock;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlockDecoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.CBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ComplexCBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ISO781611;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.SimpleCBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.StandardBiometricHeader;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.logging.Logger;

public class ISO781611Decoder
implements ISO781611 {
    private static final Logger LOGGER = Logger.getLogger("org.com.htc.sdk.jmrtd");
    private BiometricDataBlockDecoder<?> bdbDecoder;

    public ISO781611Decoder(BiometricDataBlockDecoder<?> biometricDataBlockDecoder) {
        this.bdbDecoder = biometricDataBlockDecoder;
    }

    private ComplexCBEFFInfo readBITGroup(InputStream inputStream) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        int n = tLVInputStream.readTag();
        if (n == 32609) {
            return this.readBITGroup(n, tLVInputStream.readLength(), inputStream);
        }
        throw new IllegalArgumentException(h.a(n, h.a.a(32609, b.a("Expected tag "), ", found ")));
    }

    private ComplexCBEFFInfo readBITGroup(int n, int n2, InputStream inputStream) {
        ComplexCBEFFInfo complexCBEFFInfo;
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        ComplexCBEFFInfo complexCBEFFInfo2 = complexCBEFFInfo;
        complexCBEFFInfo = new ComplexCBEFFInfo();
        if (n == 32609) {
            n = tLVInputStream.readTag();
            if (n == 2) {
                n = tLVInputStream.readLength();
                if (n == 1) {
                    n = tLVInputStream.readValue()[0] & 0xFF;
                    for (int k = 0; k < n; ++k) {
                        complexCBEFFInfo2.add(this.readBIT(inputStream, k));
                    }
                    return complexCBEFFInfo2;
                }
                throw new IllegalArgumentException(a.a("BIOMETRIC_INFO_COUNT should have length 1, found length ", n));
            }
            throw new IllegalArgumentException(h.a(n, h.a.a(2, b.a("Expected tag BIOMETRIC_INFO_COUNT_TAG ("), ") in CBEFF structure, found ")));
        }
        throw new IllegalArgumentException(h.a(n, h.a.a(32609, b.a("Expected tag "), ", found ")));
    }

    private CBEFFInfo readBIT(InputStream inputStream, int n) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        TLVInputStream tLVInputStream3 = tLVInputStream;
        int n2 = tLVInputStream3.readTag();
        return this.readBIT(n2, tLVInputStream3.readLength(), inputStream, n);
    }

    private CBEFFInfo readBIT(int n, int n2, InputStream inputStream, int n3) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        if (n == 32608) {
            n = tLVInputStream.readTag();
            int n4 = tLVInputStream.readLength();
            if (n == 125) {
                ((ISO781611Decoder)((Object)biometricDataBlock)).readStaticallyProtectedBIT(inputStream, n, n4, n3);
                return null;
            }
            if ((n & 0xA0) == 160) {
                ISO781611Decoder iSO781611Decoder = biometricDataBlock;
                BiometricDataBlock biometricDataBlock = iSO781611Decoder.readBiometricDataBlock(inputStream, iSO781611Decoder.readBHT(inputStream, n, n4, n3), n3);
                return new SimpleCBEFFInfo<Object>(biometricDataBlock);
            }
            throw new IllegalArgumentException(h.a(n, b.a("Unsupported template tag: ")));
        }
        throw new IllegalArgumentException(h.a.a(32608, b.a("Expected tag BIOMETRIC_INFORMATION_TEMPLATE_TAG ("), "), found ").append(Integer.toHexString(n)).append(", index is ").append(n3).toString());
    }

    private StandardBiometricHeader readBHT(InputStream inputStream, int n, int n2, int n3) {
        HashMap<Integer, byte[]> hashMap;
        Object object;
        if (inputStream instanceof TLVInputStream) {
            object = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream;
            object = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
        }
        int n4 = 161;
        if (n != 161) {
            LOGGER.warning(h.a.a(n4, b.a("Expected tag "), ", found ").append(Integer.toHexString(n)).toString());
        }
        HashMap<Integer, byte[]> hashMap2 = hashMap;
        hashMap = new HashMap<Integer, byte[]>();
        n = 0;
        while (n < n2) {
            int n5 = ((TLVInputStream)object).readTag();
            n = TLVUtil.getTagLength(n5) + n;
            byte[] byArray = ((TLVInputStream)object).readValue();
            n3 = TLVUtil.getLengthLength(((TLVInputStream)object).readLength()) + n + byArray.length;
            hashMap2.put(n5, byArray);
            n = n3;
        }
        return new StandardBiometricHeader(hashMap2);
    }

    private void readStaticallyProtectedBIT(InputStream inputStream, int n, int n2, int n3) {
        TLVInputStream tLVInputStream;
        TLVInputStream tLVInputStream2 = tLVInputStream;
        ISO781611Decoder iSO781611Decoder = this;
        TLVInputStream tLVInputStream3 = tLVInputStream2;
        tLVInputStream3(new ByteArrayInputStream(this.decodeSMTValue(inputStream)));
        try {
            n2 = tLVInputStream3.readTag();
        }
        catch (Throwable throwable) {
            tLVInputStream2.close();
            throw throwable;
        }
        StandardBiometricHeader standardBiometricHeader = iSO781611Decoder.readBHT(tLVInputStream3, n2, tLVInputStream3.readLength(), n3);
        iSO781611Decoder.readBiometricDataBlock(new ByteArrayInputStream(this.decodeSMTValue(inputStream)), standardBiometricHeader, n3);
        tLVInputStream.close();
    }

    private byte[] decodeSMTValue(InputStream inputStream) {
        Object object;
        if (inputStream instanceof TLVInputStream) {
            object = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream;
            object = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
        }
        int n = ((TLVInputStream)object).readTag();
        ((TLVInputStream)object).readLength();
        if (n != 129) {
            if (n != 133) {
                if (n != 142 && n != 158) {
                    LOGGER.info(b.a("Unsupported data object tag ").append(Integer.toHexString(n)).toString());
                    return null;
                }
                return null;
            }
            throw new AccessControlException("Access denied. Biometric Information Template is statically protected.");
        }
        return ((TLVInputStream)object).readValue();
    }

    private BiometricDataBlock readBiometricDataBlock(InputStream inputStream, StandardBiometricHeader standardBiometricHeader, int n) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        int n2 = tLVInputStream.readTag();
        if (n2 != 24366 && n2 != 32558) {
            throw new IllegalArgumentException(h.a(n2, h.a.a(32558, h.a.a(24366, b.a("Expected tag BIOMETRIC_DATA_BLOCK_TAG ("), ") or BIOMETRIC_DATA_BLOCK_TAG_ALT ("), "), found ")));
        }
        int n3 = tLVInputStream.readLength();
        return this.bdbDecoder.decode(inputStream, standardBiometricHeader, n, n3);
    }

    public ComplexCBEFFInfo decode(InputStream inputStream) {
        return this.readBITGroup(inputStream);
    }
}

