/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.io.SplittableInputStream;
import com.fis.ekyc.nfc.build_in.eidparser.lds.ImageInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractImageInfo
implements ImageInfo {
    private static final long serialVersionUID = 2870092217269116309L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private int type;
    private String mimeType;
    private byte[] imageBytes;
    private transient SplittableInputStream splittableInputStream;
    private int imagePositionInInputStream;
    private int imageLength;
    private int width;
    private int height;

    public AbstractImageInfo() {
        this(-1, 0, 0, null);
    }

    public AbstractImageInfo(int n) {
        this(n, 0, 0, null);
    }

    public AbstractImageInfo(int n, String string2) {
        this(n, 0, 0, string2);
    }

    private AbstractImageInfo(int n, int n2, int n3, String string2) {
        this.type = n;
        this.mimeType = string2;
        this.width = n2;
        this.height = n3;
    }

    public AbstractImageInfo(int n, int n2, int n3, InputStream inputStream, long l, String string2) {
        AbstractImageInfo abstractImageInfo = this;
        abstractImageInfo(n, n2, n3, string2);
        abstractImageInfo.readImage(inputStream, l);
    }

    private byte[] getImageBytes() {
        byte[] byArray = new byte[((AbstractImageInfo)((Object)inputStream)).getImageLength()];
        InputStream inputStream = ((AbstractImageInfo)((Object)inputStream)).getImageInputStream();
        new DataInputStream(inputStream).readFully(byArray);
        return byArray;
    }

    private static String typeToString(int n) {
        switch (n) {
            default: {
                throw new NumberFormatException(h.a(n, b.a("Unknown type: ")));
            }
            case 3: {
                return "Iris";
            }
            case 2: {
                return "Finger";
            }
            case 1: {
                return "Signature or usual mark";
            }
            case 0: {
                return "Portrait";
            }
            case -1: 
        }
        return "Unknown";
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getImageLength() {
        if (((AbstractImageInfo)object).splittableInputStream != null) {
            return ((AbstractImageInfo)object).imageLength;
        }
        Object object = ((AbstractImageInfo)object).imageBytes;
        if (((AbstractImageInfo)object).imageBytes != null) {
            return ((Object)object).length;
        }
        throw new IllegalStateException("Cannot get length of null");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [type: " + AbstractImageInfo.typeToString(this.type) + ", size: " + this.getImageLength() + "]";
    }

    public int hashCode() {
        String string2;
        AbstractImageInfo abstractImageInfo = this;
        int n = abstractImageInfo.type * 5 + -591263623;
        int n2 = 5;
        return this.getImageLength() * 7 + 11 + (((string2 = abstractImageInfo.mimeType) == null ? 1337 : string2.hashCode()) * n2 + 7 + n);
    }

    public boolean equals(Object object) {
        boolean bl;
        block14: {
            block11: {
                block13: {
                    String string2;
                    block12: {
                        block10: {
                            if (object == null) {
                                return false;
                            }
                            if (object == this) {
                                return true;
                            }
                            try {
                                if (object.getClass().equals(this.getClass())) break block10;
                                return false;
                            }
                            catch (Exception exception) {
                                LOGGER.log(Level.WARNING, "Exception" + exception);
                                return false;
                            }
                        }
                        AbstractImageInfo abstractImageInfo = this;
                        object = (AbstractImageInfo)object;
                        if (!Arrays.equals(abstractImageInfo.getImageBytes(), super.getImageBytes())) break block11;
                        string2 = this.mimeType;
                        if (string2 != null) break block12;
                        if (((AbstractImageInfo)object).mimeType == null) break block13;
                    }
                    if (string2 == null) break block11;
                    if (!string2.equals(((AbstractImageInfo)object).mimeType)) break block11;
                }
                if (this.type != ((AbstractImageInfo)object).type) break block11;
                bl = true;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream;
        AbstractImageInfo abstractImageInfo = byteArrayOutputStream2;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        try {
            abstractImageInfo.writeObject(new ByteArrayOutputStream());
            return byteArrayOutputStream2.toByteArray();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception", iOException);
            return null;
        }
    }

    @Override
    public InputStream getImageInputStream() {
        SplittableInputStream splittableInputStream = this.splittableInputStream;
        if (splittableInputStream != null) {
            return splittableInputStream.getInputStream(this.imagePositionInInputStream);
        }
        if (this.imageBytes != null) {
            return new ByteArrayInputStream(this.imageBytes);
        }
        throw new IllegalStateException("Both the byte buffer and the stream are null");
    }

    public void readImage(InputStream inputStream, long l) {
        this.splittableInputStream = null;
        this.imageBytes = new byte[(int)l];
        new DataInputStream(inputStream).readFully(this.imageBytes);
    }

    public void writeImage(OutputStream outputStream) {
        outputStream.write(this.getImageBytes());
    }

    public final void setMimeType(String string2) {
        this.mimeType = string2;
    }

    public final void setType(int n) {
        this.type = n;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final void setImageBytes(byte[] byArray) {
        if (byArray != null) {
            AbstractImageInfo abstractImageInfo = this;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            long l = byArray.length;
            try {
                abstractImageInfo.readImage(byteArrayInputStream, l);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Exception", iOException);
            }
            return;
        }
        throw new IllegalArgumentException("Cannot set null image bytes");
    }

    public abstract void readObject(InputStream var1);

    public abstract void writeObject(OutputStream var1);
}

