/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.icao;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.eidparser.lds.DataGroup;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVOutputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import com.fis.ekyc.nfc.build_in.scuba.util.Hex;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DG11File
extends DataGroup {
    private static final long serialVersionUID = 8566312538928662937L;
    public static final int TAG_LIST_TAG = 92;
    public static final int FULL_NAME_TAG = 24334;
    public static final int OTHER_NAME_TAG = 24335;
    public static final int PERSONAL_NUMBER_TAG = 24336;
    public static final int FULL_DATE_OF_BIRTH_TAG = 24363;
    public static final int PLACE_OF_BIRTH_TAG = 24337;
    public static final int PERMANENT_ADDRESS_TAG = 24386;
    public static final int TELEPHONE_TAG = 24338;
    public static final int PROFESSION_TAG = 24339;
    public static final int TITLE_TAG = 24340;
    public static final int PERSONAL_SUMMARY_TAG = 24341;
    public static final int PROOF_OF_CITIZENSHIP_TAG = 24342;
    public static final int OTHER_VALID_TD_NUMBERS_TAG = 24343;
    public static final int CUSTODY_INFORMATION_TAG = 24344;
    public static final int CONTENT_SPECIFIC_CONSTRUCTED_TAG = 160;
    public static final int COUNT_TAG = 2;
    private static final String SDF = "yyyyMMdd";
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private String nameOfHolder;
    private List<String> otherNames;
    private String personalNumber;
    private String fullDateOfBirth;
    private List<String> placeOfBirth;
    private List<String> permanentAddress;
    private String telephone;
    private String profession;
    private String title;
    private String personalSummary;
    private byte[] proofOfCitizenship;
    private List<String> otherValidTDNumbers;
    private String custodyInformation;
    private List<Integer> tagPresenceList;

    public DG11File(InputStream inputStream) {
        super(107, inputStream);
    }

    public DG11File(String string2, List<String> list, String string3, Date date, List<String> list2, List<String> list3, String string4, String string5, String string6, String string7, byte[] byArray, List<String> list4, String string8) {
        DG11File dG11File = string9;
        String string9 = new SimpleDateFormat(SDF).format(date);
        dG11File(string2, list, string3, string9, list2, list3, string4, string5, string6, string7, byArray, list4, string8);
    }

    public DG11File(String object, List<String> list, String string2, String string3, List<String> list2, List<String> list3, String string4, String string5, String string6, String string7, byte[] byArray, List<String> list4, String string8) {
        super(107);
        this.nameOfHolder = object;
        if (list == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            ArrayList<String> arrayList;
            object = arrayList;
            arrayList = new ArrayList<String>(list);
        }
        DG11File dG11File = this;
        dG11File.otherNames = object;
        dG11File.personalNumber = string2;
        dG11File.fullDateOfBirth = string3;
        if (list2 == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            ArrayList<String> arrayList;
            object = arrayList;
            arrayList = new ArrayList<String>(list2);
        }
        DG11File dG11File2 = this;
        dG11File2.placeOfBirth = object;
        dG11File2.permanentAddress = list3;
        dG11File2.telephone = string4;
        dG11File2.profession = string5;
        dG11File2.title = string6;
        dG11File2.personalSummary = string7;
        dG11File2.proofOfCitizenship = byArray;
        if (list4 == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            ArrayList<String> arrayList;
            object = arrayList;
            arrayList = new ArrayList<String>(list4);
        }
        DG11File dG11File3 = this;
        dG11File3.otherValidTDNumbers = object;
        dG11File3.custodyInformation = string8;
    }

    private void parseCustodyInformation(byte[] byArray) {
        try {
            this.custodyInformation = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.custodyInformation = new String(byArray).trim();
        }
    }

    private void parseOtherValidTDNumbers(byte[] object) {
        StringTokenizer stringTokenizer;
        ArrayList arrayList;
        String string2;
        String string3 = new String((byte[])object).trim();
        String string4 = string2;
        try {
            string2 = new String((byte[])object, "UTF-8");
            string3 = string4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
        }
        object = arrayList;
        arrayList = new ArrayList();
        this.otherValidTDNumbers = object;
        object = stringTokenizer;
        stringTokenizer = new StringTokenizer(string3, "<");
        while (((StringTokenizer)object).hasMoreTokens()) {
            string3 = ((StringTokenizer)object).nextToken().trim();
            this.otherValidTDNumbers.add(string3);
        }
    }

    private void parseProofOfCitizenShip(byte[] byArray) {
        this.proofOfCitizenship = byArray;
    }

    private void parsePersonalSummary(byte[] byArray) {
        try {
            this.personalSummary = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.personalSummary = new String(byArray).trim();
        }
    }

    private void parseTitle(byte[] byArray) {
        try {
            this.title = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.title = new String(byArray).trim();
        }
    }

    private void parseProfession(byte[] byArray) {
        String string2;
        String string3;
        String string4 = string3;
        string3 = new String(byArray);
        String string5 = string2;
        try {
            string2 = new String(byArray, "UTF-8");
            string4 = string5;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
        }
        this.profession = string4.trim();
    }

    private void parseTelephone(byte[] byArray) {
        String string2;
        String string3;
        String string4 = string3;
        string3 = new String(byArray);
        String string5 = string2;
        try {
            string2 = new String(byArray, "UTF-8");
            string4 = string5;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
        }
        this.telephone = string4.replace("<", " ").trim();
    }

    private void parsePermanentAddress(byte[] object) {
        ArrayList arrayList;
        StringTokenizer stringTokenizer;
        String string2;
        String string3;
        Object object2 = string3;
        string3 = new String((byte[])object);
        String string4 = string2;
        try {
            string2 = new String((byte[])object, "UTF-8");
            object2 = string4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
        }
        object = stringTokenizer;
        stringTokenizer = new StringTokenizer((String)object2, "<");
        object2 = arrayList;
        arrayList = new ArrayList();
        this.permanentAddress = object2;
        while (((StringTokenizer)object).hasMoreTokens()) {
            object2 = ((StringTokenizer)object).nextToken().trim();
            this.permanentAddress.add((String)object2);
        }
    }

    private void parsePlaceOfBirth(byte[] object) {
        ArrayList arrayList;
        StringTokenizer stringTokenizer;
        String string2;
        String string3;
        Object object2 = string3;
        string3 = new String((byte[])object);
        String string4 = string2;
        try {
            string2 = new String((byte[])object, "UTF-8");
            object2 = string4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
        }
        object = stringTokenizer;
        stringTokenizer = new StringTokenizer((String)object2, "<");
        object2 = arrayList;
        arrayList = new ArrayList();
        this.placeOfBirth = object2;
        while (((StringTokenizer)object).hasMoreTokens()) {
            object2 = ((StringTokenizer)object).nextToken().trim();
            this.placeOfBirth.add((String)object2);
        }
    }

    private void parseFullDateOfBirth(byte[] object) {
        if (((Object)object).length == 4) {
            object = Hex.bytesToHexString((byte[])object);
        } else {
            String string2;
            String string3;
            String string22 = string3;
            string3 = new String((byte[])object);
            String string5 = string2;
            try {
                string2 = new String((byte[])object, "UTF-8");
                object = string5;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
                object = string22;
            }
        }
        this.fullDateOfBirth = object;
    }

    private synchronized void parseOtherName(byte[] byArray) {
        String string2;
        Object object;
        if (this.otherNames == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            this.otherNames = object;
        }
        DG11File dG11File = this;
        object = string2;
        try {
            string2 = new String(byArray, "UTF-8");
            dG11File.otherNames.add(((String)object).trim());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.otherNames.add(new String(byArray).trim());
        }
    }

    private void parsePersonalNumber(byte[] byArray) {
        String string2;
        String string3;
        String string4 = string3;
        string3 = new String(byArray);
        String string5 = string2;
        try {
            string2 = new String(byArray, "UTF-8");
            string4 = string5;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
        }
        this.personalNumber = string4.trim();
    }

    private void parseNameOfHolder(byte[] byArray) {
        String string2;
        String string3;
        String string4 = string3;
        string3 = new String(byArray);
        String string5 = string2;
        try {
            string2 = new String(byArray, "UTF-8");
            string4 = string5;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
        }
        this.nameOfHolder = string4.trim();
    }

    private void readField(int n, TLVInputStream tLVInputStream) {
        int n2;
        block27: {
            block26: {
                block22: {
                    block23: {
                        block24: {
                            byte[] byArray;
                            block25: {
                                n2 = tLVInputStream.readTag();
                                if (n2 != 160) break block22;
                                TLVInputStream tLVInputStream2 = tLVInputStream;
                                tLVInputStream2.readLength();
                                n = tLVInputStream2.readTag();
                                if (n != 2) break block23;
                                n = tLVInputStream.readLength();
                                if (n != 1) break block24;
                                byArray = tLVInputStream.readValue();
                                if (byArray == null || byArray.length != 1) break block25;
                                int n3 = byArray[0] & 0xFF;
                                for (n2 = 0; n2 < n3; ++n2) {
                                    int n4 = tLVInputStream.readTag();
                                    if (n4 == 24335) {
                                        TLVInputStream tLVInputStream3 = tLVInputStream;
                                        tLVInputStream3.readLength();
                                        this.parseOtherName(tLVInputStream3.readValue());
                                        continue;
                                    }
                                    throw new IllegalArgumentException(h.a(n4, h.a.a(24335, b.b.a("Expected "), ", found ")));
                                }
                                break block26;
                            }
                            throw new IllegalArgumentException(b.b.a("Number of content specific fields should be encoded in single byte, found ").append(Arrays.toString(byArray)).toString());
                        }
                        throw new IllegalArgumentException(a.a("Expected length 1 count length, found ", n));
                    }
                    throw new IllegalArgumentException(h.a(n, h.a.a(2, b.b.a("Expected "), ", found ")));
                }
                if (n2 != n) break block27;
                TLVInputStream tLVInputStream4 = tLVInputStream;
                tLVInputStream4.readLength();
                byte[] byArray = tLVInputStream4.readValue();
                if (n2 != 24363) {
                    if (n2 != 24386) {
                        switch (n2) {
                            default: {
                                throw new IllegalArgumentException(h.a(n2, b.b.a("Unknown field tag in DG11: ")));
                            }
                            case 24344: {
                                this.parseCustodyInformation(byArray);
                                break;
                            }
                            case 24343: {
                                this.parseOtherValidTDNumbers(byArray);
                                break;
                            }
                            case 24342: {
                                this.parseProofOfCitizenShip(byArray);
                                break;
                            }
                            case 24341: {
                                this.parsePersonalSummary(byArray);
                                break;
                            }
                            case 24340: {
                                this.parseTitle(byArray);
                                break;
                            }
                            case 24339: {
                                this.parseProfession(byArray);
                                break;
                            }
                            case 24338: {
                                this.parseTelephone(byArray);
                                break;
                            }
                            case 24337: {
                                this.parsePlaceOfBirth(byArray);
                                break;
                            }
                            case 24336: {
                                this.parsePersonalNumber(byArray);
                                break;
                            }
                            case 24335: {
                                this.parseOtherName(byArray);
                                break;
                            }
                            case 24334: {
                                this.parseNameOfHolder(byArray);
                                break;
                            }
                        }
                    } else {
                        this.parsePermanentAddress(byArray);
                    }
                } else {
                    this.parseFullDateOfBirth(byArray);
                }
            }
            return;
        }
        throw new IllegalArgumentException(h.a(n2, h.a.a(n, b.b.a("Expected "), ", but found ")));
    }

    @Override
    public int getTag() {
        return 107;
    }

    public List<Integer> getTagPresenceList() {
        ArrayList<Integer> arrayList;
        List<Object> list = this.tagPresenceList;
        if (list != null) {
            return list;
        }
        list = arrayList;
        this.tagPresenceList = new ArrayList<Integer>(12);
        if (this.nameOfHolder != null) {
            list.add(24334);
        }
        if ((list = this.otherNames) != null && !list.isEmpty()) {
            this.tagPresenceList.add(24335);
        }
        if (this.personalNumber != null) {
            this.tagPresenceList.add(24336);
        }
        if (this.fullDateOfBirth != null) {
            this.tagPresenceList.add(24363);
        }
        if ((list = this.placeOfBirth) != null && !list.isEmpty()) {
            this.tagPresenceList.add(24337);
        }
        if ((list = this.permanentAddress) != null && !list.isEmpty()) {
            this.tagPresenceList.add(24386);
        }
        if (this.telephone != null) {
            this.tagPresenceList.add(24338);
        }
        if (this.profession != null) {
            this.tagPresenceList.add(24339);
        }
        if (this.title != null) {
            this.tagPresenceList.add(24340);
        }
        if (this.personalSummary != null) {
            this.tagPresenceList.add(24341);
        }
        if (this.proofOfCitizenship != null) {
            this.tagPresenceList.add(24342);
        }
        if ((list = this.otherValidTDNumbers) != null && !list.isEmpty()) {
            this.tagPresenceList.add(24343);
        }
        if (this.custodyInformation != null) {
            this.tagPresenceList.add(24344);
        }
        return this.tagPresenceList;
    }

    public String getNameOfHolder() {
        return this.nameOfHolder;
    }

    public List<String> getOtherNames() {
        Serializable serializable;
        if (serializable.otherNames == null) {
            ArrayList arrayList;
            serializable = arrayList;
            arrayList = new ArrayList();
        } else {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(serializable.otherNames);
            serializable = arrayList2;
        }
        return serializable;
    }

    public String getPersonalNumber() {
        return this.personalNumber;
    }

    public String getFullDateOfBirth() {
        return this.fullDateOfBirth;
    }

    public List<String> getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public List<String> getPermanentAddress() {
        return this.permanentAddress;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getProfession() {
        return this.profession;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPersonalSummary() {
        return this.personalSummary;
    }

    public byte[] getProofOfCitizenship() {
        return this.proofOfCitizenship;
    }

    public List<String> getOtherValidTDNumbers() {
        return this.otherValidTDNumbers;
    }

    public String getCustodyInformation() {
        return this.custodyInformation;
    }

    @Override
    public String toString() {
        CharSequence charSequence = b.b.a("DG11File [");
        Object object = serializable.nameOfHolder;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.otherNames;
        object = object != null && !object.isEmpty() ? serializable.otherNames : "[]";
        charSequence = charSequence.append(object).append(", ");
        object = serializable.personalNumber;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.fullDateOfBirth;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.placeOfBirth;
        object = object != null && !object.isEmpty() ? serializable.placeOfBirth.toString() : "[]";
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.permanentAddress;
        object = object != null && !object.isEmpty() ? serializable.permanentAddress.toString() : "[]";
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.telephone;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.profession;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.title;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.personalSummary;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.proofOfCitizenship == null ? "" : b.a(b.b.a("image ("), serializable.proofOfCitizenship.length, ")");
        charSequence = charSequence.append((String)object).append(", ");
        object = serializable.otherValidTDNumbers;
        object = object != null && !object.isEmpty() ? serializable.otherValidTDNumbers.toString() : "[]";
        DG11File dG11File = serializable;
        Serializable serializable = charSequence.append((String)object).append(", ");
        charSequence = dG11File.custodyInformation;
        if (charSequence == null) {
            charSequence = "";
        }
        return d.a.a((StringBuilder)serializable, (String)charSequence, "]");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == dG11File2) {
            return true;
        }
        if (!object.getClass().equals(dG11File2.getClass())) {
            return false;
        }
        DG11File dG11File = dG11File2;
        DG11File dG11File2 = (DG11File)object;
        return dG11File.toString().equals(dG11File2.toString());
    }

    public int hashCode() {
        return this.toString().hashCode() * 13 + 111;
    }

    @Override
    public void readContent(InputStream inputStream) {
        if (inputStream instanceof TLVInputStream) {
            inputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream;
            TLVInputStream tLVInputStream2 = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
            inputStream = tLVInputStream2;
        }
        if (((TLVInputStream)inputStream).readTag() == 92) {
            Iterator iterator;
            ArrayList<Integer> arrayList;
            ByteArrayInputStream byteArrayInputStream;
            int n = ((TLVInputStream)inputStream).readLength();
            int n2 = 0;
            int n3 = n / 2;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            byteArrayInputStream = new ByteArrayInputStream(((TLVInputStream)inputStream).readValue());
            ArrayList<Integer> arrayList2 = arrayList;
            arrayList = new ArrayList<Integer>(n3 + 1);
            while (n2 < n) {
                ArrayList<Integer> arrayList3 = arrayList2;
                int n4 = n2;
                n2 = new TLVInputStream(byteArrayInputStream2).readTag();
                n3 = n4 + TLVUtil.getTagLength(n2);
                arrayList3.add(n2);
                n2 = n3;
            }
            try {
                iterator = arrayList2.iterator();
            }
            catch (Throwable throwable) {
                byteArrayInputStream2.close();
                throw throwable;
            }
            while (true) {
                if (!iterator.hasNext()) break;
                this.readField((Integer)iterator.next(), (TLVInputStream)inputStream);
                continue;
                break;
            }
            byteArrayInputStream2.close();
            return;
        }
        throw new IllegalArgumentException("Expected tag list in DG11");
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        DataOutputStream dataOutputStream;
        Object object;
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            object = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
            outputStream = object;
        }
        ((TLVOutputStream)outputStream).writeTag(92);
        object = dataOutputStream;
        dataOutputStream = new DataOutputStream(outputStream);
        List<Integer> list = this.getTagPresenceList();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            ((DataOutputStream)object).writeShort(object2.next());
        }
        ((DataOutputStream)object).flush();
        ((TLVOutputStream)outputStream).writeValueEnd();
        object = list.iterator();
        while (object.hasNext()) {
            int n;
            block28: {
                block30: {
                    block29: {
                        n = (Integer)object.next();
                        if (n == 24363) break block28;
                        if (n == 24386) break block29;
                        switch (n) {
                            default: {
                                throw new IllegalStateException(h.a(n, b.b.a("Unknown tag in DG11: ")));
                            }
                            case 24344: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.custodyInformation.trim().replace(' ', '<').getBytes("UTF-8"));
                                break;
                            }
                            case 24343: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                n = 1;
                                for (String string2 : this.otherValidTDNumbers) {
                                    if (string2 == null) continue;
                                    if (n != 0) {
                                        n = 0;
                                    } else {
                                        ((TLVOutputStream)outputStream).write(60);
                                    }
                                    ((TLVOutputStream)outputStream).write(string2.trim().replace(' ', '<').getBytes("UTF-8"));
                                }
                                break block30;
                            }
                            case 24342: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.proofOfCitizenship);
                                break;
                            }
                            case 24341: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.personalSummary.trim().replace(' ', '<').getBytes("UTF-8"));
                                break;
                            }
                            case 24340: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.title.trim().replace(' ', '<').getBytes("UTF-8"));
                                break;
                            }
                            case 24339: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.profession.trim().replace(' ', '<').getBytes("UTF-8"));
                                break;
                            }
                            case 24338: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.telephone.trim().replace(' ', '<').getBytes("UTF-8"));
                                break;
                            }
                            case 24337: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                n = 1;
                                for (String string2 : this.placeOfBirth) {
                                    if (string2 == null) continue;
                                    if (n != 0) {
                                        n = 0;
                                    } else {
                                        ((TLVOutputStream)outputStream).write(60);
                                    }
                                    ((TLVOutputStream)outputStream).write(string2.trim().getBytes("UTF-8"));
                                }
                                break block30;
                            }
                            case 24336: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.personalNumber.trim().getBytes("UTF-8"));
                                break;
                            }
                            case 24335: {
                                if (this.otherNames == null) {
                                    ArrayList<String> arrayList;
                                    ArrayList<String> arrayList2 = arrayList;
                                    arrayList = new ArrayList<String>();
                                    this.otherNames = arrayList2;
                                }
                                OutputStream outputStream2 = outputStream;
                                OutputStream outputStream3 = outputStream;
                                ((TLVOutputStream)outputStream3).writeTag(160);
                                ((TLVOutputStream)outputStream3).writeTag(2);
                                ((TLVOutputStream)outputStream2).write(this.otherNames.size());
                                ((TLVOutputStream)outputStream2).writeValueEnd();
                                Iterator<String> iterator = this.otherNames.iterator();
                                while (iterator.hasNext()) {
                                    OutputStream outputStream4 = outputStream;
                                    object2 = iterator.next();
                                    ((TLVOutputStream)outputStream4).writeTag(24335);
                                    ((TLVOutputStream)outputStream4).writeValue(((String)object2).trim().getBytes("UTF-8"));
                                }
                                break block30;
                            }
                            case 24334: {
                                ((TLVOutputStream)outputStream).writeTag(n);
                                ((TLVOutputStream)outputStream).writeValue(this.nameOfHolder.trim().getBytes("UTF-8"));
                                break;
                            }
                        }
                        continue;
                    }
                    ((TLVOutputStream)outputStream).writeTag(n);
                    n = 1;
                    for (String string2 : this.permanentAddress) {
                        if (string2 == null) continue;
                        if (n != 0) {
                            n = 0;
                        } else {
                            ((TLVOutputStream)outputStream).write(60);
                        }
                        ((TLVOutputStream)outputStream).write(string2.trim().getBytes("UTF-8"));
                    }
                }
                ((TLVOutputStream)outputStream).writeValueEnd();
                continue;
            }
            ((TLVOutputStream)outputStream).writeTag(n);
            ((TLVOutputStream)outputStream).writeValue(this.fullDateOfBirth.getBytes("UTF-8"));
        }
    }
}

