/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.protocol;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.eidparser.APDULevelBACCapable;
import com.fis.ekyc.nfc.build_in.eidparser.AccessKeySpec;
import com.fis.ekyc.nfc.build_in.eidparser.BACKeySpec;
import com.fis.ekyc.nfc.build_in.eidparser.CardServiceProtocolException;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.BACResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.DESedeSecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.SecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CardServiceException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.SecretKey;

public class BACProtocol {
    private APDULevelBACCapable service;
    private Random random;
    private int maxTranceiveLength;
    private boolean shouldCheckMAC;

    public BACProtocol(APDULevelBACCapable aPDULevelBACCapable, int n, boolean bl) {
        SecureRandom secureRandom;
        ((BACProtocol)((Object)secureRandom2)).service = aPDULevelBACCapable;
        ((BACProtocol)((Object)secureRandom2)).maxTranceiveLength = n;
        ((BACProtocol)((Object)secureRandom2)).shouldCheckMAC = bl;
        SecureRandom secureRandom2 = secureRandom;
        secureRandom = new SecureRandom();
        v1.random = secureRandom2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecureMessagingWrapper doBACStep(SecretKey object, SecretKey object2) {
        byte[] byArray;
        byte[] byArray2;
        BACProtocol bACProtocol;
        BACProtocol bACProtocol2;
        BACProtocol bACProtocol3;
        try {
            BACProtocol bACProtocol4 = this;
            bACProtocol3 = bACProtocol4;
            bACProtocol2 = bACProtocol4;
            bACProtocol = bACProtocol4;
            byArray2 = bACProtocol4.service.sendGetChallenge();
        }
        catch (Exception exception) {
            throw new CardServiceProtocolException("BAC failed in GET CHALLENGE", 1, exception);
        }
        byte[] byArray3 = new byte[8];
        bACProtocol3.random.nextBytes(byArray3);
        byte[] byArray4 = new byte[16];
        bACProtocol2.random.nextBytes(byArray4);
        try {
            byArray = bACProtocol.service.sendMutualAuth(byArray3, byArray2, byArray4, (SecretKey)object, (SecretKey)object2);
        }
        catch (Exception exception) {
            throw new CardServiceProtocolException("BAC failed in MUTUAL AUTH", 2, exception);
        }
        object = new byte[16];
        System.arraycopy(byArray, 16, object, 0, 16);
        object2 = new byte[16];
        int k = 0;
        while (true) {
            if (k >= 16) {
                Object object3 = object2;
                object = Util.deriveKey((byte[])object3, 1);
                object2 = Util.deriveKey((byte[])object3, 2);
                long l = BACProtocol.computeSendSequenceCounter(byArray2, byArray3);
                BACProtocol bACProtocol5 = this;
                int n = bACProtocol5.maxTranceiveLength;
                boolean bl = bACProtocol5.shouldCheckMAC;
                return new DESedeSecureMessagingWrapper((SecretKey)object, (SecretKey)object2, n, bl, l);
            }
            object2[k] = (byte)(byArray4[k] & 0xFF ^ object[k] & 0xFF);
            ++k;
        }
    }

    public static byte[] computeKeySeedForBAC(BACKeySpec object) {
        BACKeySpec bACKeySpec = object;
        String string2 = bACKeySpec.getDocumentNumber();
        String string3 = bACKeySpec.getDateOfBirth();
        object = object.getDateOfExpiry();
        if (string3 != null && string3.length() == 6) {
            if (object != null && ((String)object).length() == 6) {
                if (string2 != null) {
                    return BACProtocol.computeKeySeedForBAC(BACProtocol.fixDocumentNumber(string2), string3, (String)object);
                }
                throw new IllegalArgumentException(i.a("Wrong document number. Found ", string2));
            }
            throw new IllegalArgumentException(i.a("Wrong date format used for date of expiry. Expected yyMMdd, found ", (String)object));
        }
        throw new IllegalArgumentException(i.a("Wrong date format used for date of birth. Expected yyMMdd, found ", string3));
    }

    public static long computeSendSequenceCounter(byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray.length == 8 && byArray2 != null && byArray2.length == 8) {
            long l = 0L;
            for (int k = 4; k < 8; ++k) {
                l = (l << 8) + (long)(byArray[k] & 0xFF);
            }
            for (int k = 4; k < 8; ++k) {
                l = (l << 8) + (long)(byArray2[k] & 0xFF);
            }
            return l;
        }
        throw new IllegalStateException("Wrong length input");
    }

    private static byte[] computeKeySeedForBAC(String string2, String string3, String string4) {
        return Util.computeKeySeed(string2, string3, string4, "SHA-1", true);
    }

    private static String fixDocumentNumber(String string2) {
        string2 = string2 == null ? "" : string2.replace('<', ' ').trim().replace(' ', '<');
        StringBuilder stringBuilder = new StringBuilder(string2);
        while (stringBuilder.length() < 9) {
            stringBuilder.append('<');
        }
        return stringBuilder.toString();
    }

    public BACResult doBAC(AccessKeySpec accessKeySpec) {
        Object object;
        byte[] byArray;
        BACProtocol bACProtocol;
        try {
            bACProtocol = object;
            byte[] byArray2 = accessKeySpec.getKey();
            byArray = byArray2;
            object = Util.deriveKey(byArray2, 1);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CardServiceException("Error during BAC", generalSecurityException);
        }
        object = bACProtocol.doBACStep((SecretKey)object, Util.deriveKey(byArray, 2));
        return new BACResult(accessKeySpec, (SecureMessagingWrapper)object);
    }

    public BACResult doBAC(SecretKey secretKey, SecretKey secretKey2) {
        return new BACResult(this.doBACStep(secretKey, secretKey2));
    }
}

