/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.protocol;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.eidparser.APDULevelEACCACapable;
import com.fis.ekyc.nfc.build_in.eidparser.CardServiceProtocolException;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.lds.ChipAuthenticationInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SecurityInfo;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.AESSecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.DESedeSecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.EACCAResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.SecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CardServiceException;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;

public class EACCAProtocol {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final Provider BC_PROVIDER = Util.getBouncyCastleProvider();
    private static final int COMMAND_CHAINING_CHUNK_SIZE = 223;
    private APDULevelEACCACapable service;
    private SecureMessagingWrapper wrapper;
    private int maxTranceiveLength;
    private boolean shouldCheckMAC;

    public EACCAProtocol(APDULevelEACCACapable aPDULevelEACCACapable, SecureMessagingWrapper secureMessagingWrapper, int n, boolean bl) {
        this.service = aPDULevelEACCACapable;
        this.wrapper = secureMessagingWrapper;
        this.maxTranceiveLength = n;
        this.shouldCheckMAC = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendPublicKey(APDULevelEACCACapable aPDULevelEACCACapable, SecureMessagingWrapper secureMessagingWrapper, String object, BigInteger bigInteger, PublicKey object2) {
        APDULevelEACCACapable aPDULevelEACCACapable2;
        Object object3 = object;
        String string2 = ChipAuthenticationInfo.toKeyAgreementAlgorithm((String)object3);
        String string3 = ChipAuthenticationInfo.toCipherAlgorithm((String)object3);
        object2 = EACCAProtocol.getKeyData(string2, (PublicKey)object2);
        if (string3.startsWith("DESede")) {
            object = null;
            if (bigInteger != null) {
                object = TLVUtil.wrapDO(132, Util.i2os(bigInteger));
            }
            try {
                aPDULevelEACCACapable.sendMSEKAT(secureMessagingWrapper, TLVUtil.wrapDO(145, (byte[])object2), (byte[])object);
                return;
            }
            catch (Exception exception) {
                throw new CardServiceProtocolException("Exception during MSE KAT", 1, exception);
            }
        }
        if (!string3.startsWith("AES")) throw new IllegalStateException(i.a("Cannot set up secure channel with cipher ", string3));
        try {
            APDULevelEACCACapable aPDULevelEACCACapable3 = aPDULevelEACCACapable;
            aPDULevelEACCACapable2 = aPDULevelEACCACapable3;
            aPDULevelEACCACapable3.sendMSESetATIntAuth(secureMessagingWrapper, (String)object, bigInteger);
        }
        catch (Exception exception) {
            throw new CardServiceProtocolException("Exception during MSE Set AT Int Auth", 1, exception);
        }
        try {
            EACCAProtocol.sendGeneralAuthenticate(aPDULevelEACCACapable2, secureMessagingWrapper, TLVUtil.wrapDO(128, (byte[])object2));
            return;
        }
        catch (Exception exception) {
            throw new CardServiceProtocolException("Exception during General Authenticate", 2, exception);
        }
    }

    public static byte[] computeSharedSecret(String string2, PublicKey publicKey, PrivateKey privateKey) {
        KeyAgreement keyAgreement = KeyAgreement.getInstance(string2, BC_PROVIDER);
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement.generateSecret();
    }

    public static SecureMessagingWrapper restartSecureMessaging(String string2, byte[] object, int n, boolean bl) {
        String string3 = ChipAuthenticationInfo.toCipherAlgorithm(string2);
        byte[] byArray = object;
        int n2 = ChipAuthenticationInfo.toKeyLength(string2);
        object = Util.deriveKey(object, string3, n2, 1);
        SecretKey secretKey = Util.deriveKey(byArray, string3, n2, 2);
        if (string3.startsWith("DESede")) {
            return new DESedeSecureMessagingWrapper((SecretKey)object, secretKey, n, bl, 0L);
        }
        if (string3.startsWith("AES")) {
            return new AESSecureMessagingWrapper((SecretKey)object, secretKey, n, bl, 0L);
        }
        throw new IllegalStateException(i.a("Unsupported cipher algorithm ", string3));
    }

    public static byte[] getKeyHash(String object, PublicKey publicKey) {
        if (!"DH".equals(object) && !(publicKey instanceof DHPublicKey)) {
            if (!"ECDH".equals(object) && !(publicKey instanceof ECPublicKey)) {
                throw new IllegalArgumentException(i.a("Unsupported agreement algorithm ", (String)object));
            }
            object = (com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey)publicKey;
            return Util.alignKeyDataToSize(Util.i2os(object.getQ().getAffineXCoord().toBigInteger()), (int)Math.ceil((double)object.getParameters().getCurve().getFieldSize() / 8.0));
        }
        return MessageDigest.getInstance("SHA-1").digest(EACCAProtocol.getKeyData((String)object, publicKey));
    }

    private static void sendGeneralAuthenticate(APDULevelEACCACapable aPDULevelEACCACapable, SecureMessagingWrapper secureMessagingWrapper, byte[] object) {
        try {
            aPDULevelEACCACapable.sendGeneralAuthenticate(secureMessagingWrapper, (byte[])object, true);
        }
        catch (CardServiceException cardServiceException) {
            LOGGER.log(Level.WARNING, "Failed to send GENERAL AUTHENTICATE, falling back to command chaining", cardServiceException);
            List<byte[]> list = Util.partition(223, (byte[])object);
            object = list;
            int n = 0;
            for (byte[] byArray : list) {
                boolean bl = ++n >= object.size();
                aPDULevelEACCACapable.sendGeneralAuthenticate(secureMessagingWrapper, byArray, bl);
            }
        }
    }

    private static byte[] getKeyData(String string2, PublicKey publicKey) {
        if ("DH".equals(string2)) {
            return Util.i2os(((DHPublicKey)publicKey).getY());
        }
        if ("ECDH".equals(string2)) {
            return ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey)publicKey).getQ().getEncoded(false);
        }
        throw new IllegalArgumentException(i.a("Unsupported agreement algorithm ", string2));
    }

    private static String inferChipAuthenticationOIDfromPublicKeyOID(String string2) {
        if (SecurityInfo.ID_PK_ECDH.equals(string2)) {
            LOGGER.warning("Could not determine ChipAuthentication algorithm, defaulting to id-CA-ECDH-3DES-CBC-CBC");
            return SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC;
        }
        if (SecurityInfo.ID_PK_DH.equals(string2)) {
            LOGGER.warning("Could not determine ChipAuthentication algorithm, defaulting to id-CA-DH-3DES-CBC-CBC");
            return SecurityInfo.ID_CA_DH_3DES_CBC_CBC;
        }
        LOGGER.warning("No ChipAuthenticationInfo and unsupported ChipAuthenticationPublicKeyInfo public key OID " + string2);
        return null;
    }

    public EACCAResult doCA(BigInteger bigInteger, String object, String object2, PublicKey publicKey) {
        if (publicKey != null) {
            Object object3 = ChipAuthenticationInfo.toKeyAgreementAlgorithm((String)object);
            if (object3 != null) {
                block18: {
                    block17: {
                        if (!"ECDH".equals(object3) && !"DH".equals(object3)) {
                            throw new IllegalArgumentException(i.a("Unsupported agreement algorithm, expected ECDH or DH, found ", (String)object3));
                        }
                        if (object == null) {
                            object = EACCAProtocol.inferChipAuthenticationOIDfromPublicKeyOID((String)object2);
                        }
                        object2 = null;
                        try {
                            if (!"DH".equals(object3)) break block17;
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            throw new CardServiceException("Security exception during Chip Authentication", generalSecurityException);
                        }
                        object2 = ((DHPublicKey)publicKey).getParams();
                    }
                    if (!"ECDH".equals(object3)) break block18;
                    object2 = ((ECPublicKey)publicKey).getParams();
                }
                EACCAProtocol eACCAProtocol = object4;
                String string2 = object;
                EACCAProtocol eACCAProtocol2 = object4;
                EACCAProtocol eACCAProtocol3 = eACCAProtocol2;
                EACCAProtocol eACCAProtocol4 = eACCAProtocol2;
                String string3 = object3;
                PublicKey publicKey2 = publicKey;
                String string4 = object3;
                String string5 = string4;
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string4, BC_PROVIDER);
                keyPairGenerator.initialize((AlgorithmParameterSpec)object2);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                KeyPair keyPair2 = keyPair;
                object2 = keyPair.getPublic();
                object3 = keyPair2.getPrivate();
                EACCAProtocol.sendPublicKey(((EACCAProtocol)object4).service, ((EACCAProtocol)object4).wrapper, (String)object, bigInteger, (PublicKey)object2);
                Object object4 = EACCAProtocol.getKeyHash(string5, (PublicKey)object2);
                object = EACCAProtocol.computeSharedSecret(string3, publicKey2, (PrivateKey)object3);
                int n = eACCAProtocol3.maxTranceiveLength;
                boolean bl = eACCAProtocol4.shouldCheckMAC;
                object = EACCAProtocol.restartSecureMessaging(string2, (byte[])object, n, bl);
                eACCAProtocol.wrapper = object;
                return new EACCAResult(bigInteger, publicKey, (byte[])object4, (PublicKey)object2, (PrivateKey)object3, (SecureMessagingWrapper)object);
            }
            throw new IllegalArgumentException("Unknown agreement algorithm");
        }
        throw new IllegalArgumentException("PICC public key is null");
    }

    public SecureMessagingWrapper getWrapper() {
        return this.wrapper;
    }
}

