/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.protocol;

import b.b;
import com.fis.ekyc.nfc.build_in.eidparser.AccessKeySpec;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.lds.PACEInfo;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACEMappingResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.SecureMessagingWrapper;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.PublicKey;

public class PACEResult
implements Serializable {
    private static final long serialVersionUID = -6819675856205885052L;
    private PACEInfo.MappingType mappingType;
    private String agreementAlg;
    private String cipherAlg;
    private String digestAlg;
    private int keyLength;
    private AccessKeySpec paceKey;
    private PACEMappingResult mappingResult;
    private PublicKey piccPublicKey;
    private KeyPair pcdKeyPair;
    private SecureMessagingWrapper wrapper;

    public PACEResult(AccessKeySpec accessKeySpec, PACEInfo.MappingType mappingType, String string2, String string3, String string4, int n, PACEMappingResult pACEMappingResult, KeyPair keyPair, PublicKey publicKey, SecureMessagingWrapper secureMessagingWrapper) {
        this.paceKey = accessKeySpec;
        this.mappingType = mappingType;
        this.agreementAlg = string2;
        this.cipherAlg = string3;
        this.digestAlg = string4;
        this.keyLength = n;
        this.mappingResult = pACEMappingResult;
        this.pcdKeyPair = keyPair;
        this.piccPublicKey = publicKey;
        this.wrapper = secureMessagingWrapper;
    }

    public AccessKeySpec getPACEKey() {
        return this.paceKey;
    }

    public PACEMappingResult getMappingResult() {
        return this.mappingResult;
    }

    public SecureMessagingWrapper getWrapper() {
        return this.wrapper;
    }

    public PACEInfo.MappingType getMappingType() {
        return this.mappingType;
    }

    public String getAgreementAlg() {
        return this.agreementAlg;
    }

    public String getCipherAlg() {
        return this.cipherAlg;
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public KeyPair getPCDKeyPair() {
        return this.pcdKeyPair;
    }

    public PublicKey getPICCPublicKey() {
        return this.piccPublicKey;
    }

    public String toString() {
        return b.a("PACEResult [paceKey: ").append(this.paceKey).append(", mappingType: ").append((Object)this.mappingType).append(", agreementAlg: ").append(this.agreementAlg).append(", cipherAlg: ").append(this.cipherAlg).append(", digestAlg: ").append(this.digestAlg).append(", keyLength: ").append(this.keyLength).append(", mappingResult: ").append(this.mappingResult).append(", piccPublicKey: ").append(Util.getDetailedPublicKeyAlgorithm(this.piccPublicKey)).append(", pcdPrivateKey: ").append(Util.getDetailedPrivateKeyAlgorithm(this.pcdKeyPair.getPrivate())).append(", pcdPublicKey: ").append(Util.getDetailedPublicKeyAlgorithm(this.pcdKeyPair.getPublic())).toString();
    }

    public int hashCode() {
        int n = 21901;
        AccessKeySpec accessKeySpec = this.paceKey;
        int n2 = accessKeySpec == null ? 0 : accessKeySpec.hashCode();
        n = (n + n2) * 1991;
        String string2 = this.agreementAlg;
        int n3 = string2 == null ? 0 : string2.hashCode();
        n = (n + n3) * 1991;
        String string3 = this.cipherAlg;
        int n4 = string3 == null ? 0 : string3.hashCode();
        n = (n + n4) * 1991;
        String string4 = this.digestAlg;
        int n5 = string4 == null ? 0 : string4.hashCode();
        n = (n + n5) * 1991;
        PACEMappingResult pACEMappingResult = this.mappingResult;
        int n6 = pACEMappingResult == null ? 0 : pACEMappingResult.hashCode();
        n = ((n + n6) * 1991 + this.keyLength) * 1991;
        PACEInfo.MappingType mappingType = this.mappingType;
        int n7 = mappingType == null ? 0 : ((Object)((Object)mappingType)).hashCode();
        n = (n + n7) * 1991;
        KeyPair keyPair = this.pcdKeyPair;
        int n8 = keyPair == null ? 0 : keyPair.hashCode();
        n = (n + n8) * 1991;
        PublicKey publicKey = this.piccPublicKey;
        int n9 = publicKey == null ? 0 : publicKey.hashCode();
        int n10 = (n + n9) * 1991;
        SecureMessagingWrapper secureMessagingWrapper = this.wrapper;
        int n11 = secureMessagingWrapper == null ? 0 : secureMessagingWrapper.hashCode();
        return n10 + n11;
    }

    public boolean equals(Object object) {
        if (serializable == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (serializable.getClass() != object.getClass()) {
            return false;
        }
        object = (PACEResult)object;
        Object object2 = ((PACEResult)serializable).paceKey;
        if (object2 == null ? ((PACEResult)object).paceKey != null : !object2.equals(((PACEResult)object).paceKey)) {
            return false;
        }
        object2 = ((PACEResult)serializable).agreementAlg;
        if (object2 == null ? ((PACEResult)object).agreementAlg != null : !((String)object2).equals(((PACEResult)object).agreementAlg)) {
            return false;
        }
        object2 = ((PACEResult)serializable).cipherAlg;
        if (object2 == null ? ((PACEResult)object).cipherAlg != null : !((String)object2).equals(((PACEResult)object).cipherAlg)) {
            return false;
        }
        object2 = ((PACEResult)serializable).digestAlg;
        if (object2 == null ? ((PACEResult)object).digestAlg != null : !((String)object2).equals(((PACEResult)object).digestAlg)) {
            return false;
        }
        object2 = ((PACEResult)serializable).mappingResult;
        if (object2 == null ? ((PACEResult)object).mappingResult != null : !((PACEMappingResult)object2).equals(((PACEResult)object).mappingResult)) {
            return false;
        }
        if (((PACEResult)serializable).keyLength != ((PACEResult)object).keyLength) {
            return false;
        }
        if (((PACEResult)serializable).mappingType != ((PACEResult)object).mappingType) {
            return false;
        }
        object2 = ((PACEResult)serializable).pcdKeyPair;
        if (object2 == null ? ((PACEResult)object).pcdKeyPair != null : !object2.equals(((PACEResult)object).pcdKeyPair)) {
            return false;
        }
        object2 = ((PACEResult)serializable).piccPublicKey;
        if (object2 == null ? ((PACEResult)object).piccPublicKey != null : !object2.equals(((PACEResult)object).piccPublicKey)) {
            return false;
        }
        Serializable serializable = ((PACEResult)serializable).wrapper;
        return !(serializable == null ? ((PACEResult)object).wrapper != null : !((SecureMessagingWrapper)serializable).equals(((PACEResult)object).wrapper));
    }
}

