/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.capturesdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.Size;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.core.resolutionselector.ResolutionStrategy;
import androidx.camera.view.PreviewView;
import androidx.fragment.app.Fragment;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.R;
import vn.kalapa.ekyc.KalapaCaptureHandler;
import vn.kalapa.ekyc.KalapaHandler;
import vn.kalapa.ekyc.KalapaSDK;
import vn.kalapa.ekyc.KalapaSDKMediaType;
import vn.kalapa.ekyc.a;
import vn.kalapa.ekyc.activity.BaseActivity;
import vn.kalapa.ekyc.activity.CameraXActivity;
import vn.kalapa.ekyc.activity.b;
import vn.kalapa.ekyc.capturesdk.tflite.BoundingBox;
import vn.kalapa.ekyc.capturesdk.tflite.KLPDetector;
import vn.kalapa.ekyc.capturesdk.tflite.OnImageDetectedListener;
import vn.kalapa.ekyc.extension.ViewUtils;
import vn.kalapa.ekyc.fragment.BottomGuideFragment;
import vn.kalapa.ekyc.fragment.GuideType;
import vn.kalapa.ekyc.managers.KLPLanguageManager;
import vn.kalapa.ekyc.utils.BitmapUtil;
import vn.kalapa.ekyc.utils.Common;
import vn.kalapa.ekyc.utils.Helpers;
import vn.kalapa.ekyc.utils.KALAPA_LOG_ACTION;
import vn.kalapa.ekyc.utils.KALAPA_LOG_LEVEL;
import vn.kalapa.ekyc.utils.LogUtil;
import vn.kalapa.ekyc.views.ProgressView;

@SourceDebugExtension(value={"SMAP\nCameraXAutoCaptureActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraXAutoCaptureActivity.kt\nvn/kalapa/ekyc/capturesdk/CameraXAutoCaptureActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,636:1\n1549#2:637\n1620#2,3:638\n1855#2,2:641\n1#3:643\n*S KotlinDebug\n*F\n+ 1 CameraXAutoCaptureActivity.kt\nvn/kalapa/ekyc/capturesdk/CameraXAutoCaptureActivity\n*L\n374#1:637\n374#1:638,3\n380#1:641,2\n*E\n"})
public final class CameraXAutoCaptureActivity
extends CameraXActivity
implements OnImageDetectedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SHOULD_TURN_ON_QR_ANALYZER = "should_turn_on_qr_analyzer";
    @NotNull
    private final String modelString;
    private ImageView ivPreviewImage;
    private TextView tvTitle;
    private TextView tvGuide1;
    private ImageView ivGuide;
    private long latestMessageTimestamp;
    private boolean isScannerReady;
    @Nullable
    private volatile KLPDetector detector;
    private ImageView ivCardInMask;
    private TextView tvAutoCapture;
    @NotNull
    private final Lazy previewView$delegate;
    @NotNull
    private final Lazy loadingProgressBar$delegate;
    private KalapaSDKMediaType documentType;
    private String captureGuide;
    @NotNull
    private String qrCodeResult;
    private boolean shouldTurnOnQRAnalyzer;
    @NotNull
    private String currError;
    private boolean showingGuide;
    private boolean inFrameAtLeastOnce;

    public CameraXAutoCaptureActivity(@NotNull String string2) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"modelString");
        super(R.layout.activity_camera_x_id_card, null, false, 0, 10, null);
        cameraXAutoCaptureActivity.modelString = string2;
        cameraXAutoCaptureActivity.latestMessageTimestamp = System.currentTimeMillis();
        cameraXAutoCaptureActivity.previewView$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)new Function0<PreviewView>(this){
            public final /* synthetic */ CameraXAutoCaptureActivity this$0;
            {
                this.this$0 = cameraXAutoCaptureActivity;
                super(0);
            }

            public final PreviewView invoke() {
                return (PreviewView)this.this$0.findViewById(R.id.viewFinder);
            }
        });
        cameraXAutoCaptureActivity.loadingProgressBar$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)new Function0<ProgressBar>(this){
            public final /* synthetic */ CameraXAutoCaptureActivity this$0;
            {
                this.this$0 = cameraXAutoCaptureActivity;
                super(0);
            }

            public final ProgressBar invoke() {
                return (ProgressBar)this.this$0.findViewById(R.id.progress_bar);
            }
        });
        cameraXAutoCaptureActivity.qrCodeResult = "";
        cameraXAutoCaptureActivity.currError = "";
    }

    public /* synthetic */ CameraXAutoCaptureActivity(String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "klp_model_16";
        }
        this(string2);
    }

    private final PreviewView getPreviewView() {
        Object object = this.previewView$delegate.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-previewView>(...)");
        return (PreviewView)object;
    }

    private final ProgressBar getLoadingProgressBar() {
        Object object = this.loadingProgressBar$delegate.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-loadingProgressBar>(...)");
        return (ProgressBar)object;
    }

    private final void updateErrorUI(String string2, boolean bl) {
        Long l;
        long l2;
        long l3;
        boolean bl2 = string2 == null || Intrinsics.areEqual((Object)this.currError, (Object)string2) || System.currentTimeMillis() - this.latestMessageTimestamp < 1000L || (l3 = System.currentTimeMillis()) - (l2 = (l = this.getManualCaptureTime()) != null ? l : 0L) < 1000L;
        if (!bl && bl2) {
            return;
        }
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        this.latestMessageTimestamp = System.currentTimeMillis();
        cameraXAutoCaptureActivity.runOnUiThread(() -> CameraXAutoCaptureActivity.updateErrorUI$lambda$1(cameraXAutoCaptureActivity, string2));
    }

    public static /* synthetic */ void updateErrorUI$default(CameraXAutoCaptureActivity cameraXAutoCaptureActivity, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        cameraXAutoCaptureActivity.updateErrorUI(string2, bl);
    }

    private final String getQRCodeStringFromBitmap(Bitmap bitmap) {
        BinaryBitmap binaryBitmap;
        RGBLuminanceSource rGBLuminanceSource;
        Bitmap bitmap2 = bitmap;
        int n = bitmap2.getWidth();
        int n2 = bitmap.getHeight();
        int[] nArray = new int[n * n2];
        bitmap2.getPixels(nArray, 0, n, 0, 0, n, n2);
        RGBLuminanceSource rGBLuminanceSource2 = rGBLuminanceSource;
        rGBLuminanceSource = new RGBLuminanceSource(n, n2, nArray);
        BinaryBitmap binaryBitmap2 = binaryBitmap;
        binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)rGBLuminanceSource2));
        try {
            return new MultiFormatReader().decode(binaryBitmap2, MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)DecodeHintType.TRY_HARDER, (Object)Boolean.TRUE), TuplesKt.to((Object)DecodeHintType.POSSIBLE_FORMATS, (Object)CollectionsKt.listOf((Object)BarcodeFormat.QR_CODE))})).getText();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private final void errorToast() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = this;
        KALAPA_LOG_LEVEL kALAPA_LOG_LEVEL = KALAPA_LOG_LEVEL.WARN;
        KALAPA_LOG_ACTION kALAPA_LOG_ACTION = KALAPA_LOG_ACTION.CAPTURE_ERROR;
        String string2 = cameraXAutoCaptureActivity2.getSCREEN_ID();
        LogUtil.logEvent$kalapa_release$default(LogUtil.INSTANCE, (Context)cameraXAutoCaptureActivity2, kALAPA_LOG_LEVEL, kALAPA_LOG_ACTION, string2, null, false, 48, null);
        String string3 = this.getResources().getString(R.string.klp_id_capture_ac_corners);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resources.getString(R.st\u2026lp_id_capture_ac_corners)");
        Toast.makeText((Context)cameraXAutoCaptureActivity, (CharSequence)KLPLanguageManager.INSTANCE.get(string3), (int)0).show();
        cameraXAutoCaptureActivity.getBtnRetry().performClick();
    }

    private final Bitmap cropDetectedIdCard(Bitmap bitmap, List<BoundingBox> object, float f2) {
        Canvas canvas;
        Canvas canvas2;
        Matrix matrix;
        Matrix matrix2;
        PointF pointF;
        PointF pointF2;
        PointF pointF3;
        PointF pointF4;
        PointF pointF5;
        if (object.size() < 4) {
            float f3 = (float)this.getViewFinder().getHeight() * 1.0f / (float)this.getViewFinder().getWidth();
            BitmapUtil.Companion companion = BitmapUtil.Companion;
            Bitmap bitmap2 = bitmap;
            Bitmap bitmap3 = bitmap;
            int n = bitmap3.getWidth();
            this.setTmpBitmap(companion.crop(bitmap3, n, (int)((float)bitmap3.getWidth() * f3), 0.5f, 0.5f));
            n = bitmap2.getWidth();
            return companion.crop(bitmap2, n, (int)((float)bitmap2.getWidth() * f3), 0.5f, 0.5f);
        }
        Bitmap bitmap4 = bitmap;
        float f4 = bitmap4.getWidth();
        float f5 = bitmap4.getHeight();
        PointF pointF6 = pointF5;
        pointF5 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            BoundingBox boundingBox = (BoundingBox)object.next();
            pointF6.add(new PointF(boundingBox.getCx() * f4, boundingBox.getCy() * f5));
        }
        PointF pointF7 = pointF6;
        object = pointF4;
        pointF4 = new PointF(Float.MAX_VALUE, Float.MAX_VALUE);
        PointF pointF8 = pointF3;
        pointF3 = new PointF(Float.MIN_VALUE, Float.MAX_VALUE);
        PointF pointF9 = pointF2;
        pointF2 = new PointF(Float.MIN_VALUE, Float.MIN_VALUE);
        pointF6 = pointF;
        pointF = new PointF(Float.MAX_VALUE, Float.MIN_VALUE);
        for (PointF pointF10 : pointF7) {
            float f6;
            float f7 = pointF10.x;
            float f8 = pointF10.y;
            float f9 = f7 + f8;
            float f10 = f7 - f8;
            if (f6 < ((PointF)object).x + ((PointF)object).y) {
                object.set(f7, f8);
            }
            if (f10 > pointF8.x - pointF8.y) {
                PointF pointF11 = pointF10;
                f7 = pointF11.x;
                pointF8.set(f7, pointF11.y);
            }
            if (f9 > pointF9.x + pointF9.y) {
                PointF pointF12 = pointF10;
                f7 = pointF12.x;
                pointF9.set(f7, pointF12.y);
            }
            if (!(f10 < pointF6.x - pointF6.y)) continue;
            PointF pointF13 = pointF10;
            float f11 = pointF13.x;
            pointF6.set(f11, pointF13.y);
        }
        float f12 = Math.max(pointF8.x - ((PointF)object).x, pointF9.x - pointF6.x);
        float f13 = Math.max(pointF6.y - ((PointF)object).y, pointF9.y - pointF8.y);
        int n = (int)(Math.max(pointF8.x - ((PointF)object).x, pointF9.x - pointF6.x) + f2);
        int n2 = (int)(Math.max(pointF6.y - ((PointF)object).y, pointF9.y - pointF8.y) + f2);
        float[] fArray = new float[8];
        float[] fArray2 = fArray;
        fArray2[0] = ((PointF)object).x;
        fArray2[1] = ((PointF)object).y;
        fArray2[2] = pointF8.x;
        fArray2[3] = pointF8.y;
        fArray2[4] = pointF9.x;
        fArray2[5] = pointF9.y;
        fArray2[6] = pointF6.x;
        fArray[7] = pointF6.y;
        float[] fArray3 = new float[8];
        Object object2 = object = (Object)fArray3;
        Object object3 = object;
        float f14 = f2 / (float)2;
        object3[0] = f14;
        object3[1] = f14;
        float f15 = (float)n - f14;
        object2[2] = f15;
        object2[3] = f14;
        object2[4] = f15;
        fArray3[5] = f14 = (float)n2 - f14;
        fArray3[6] = f2;
        fArray3[7] = f14;
        float[] fArray4 = new float[8];
        Object object4 = fArray4;
        fArray4[0] = 0.0f;
        fArray4[1] = 0.0f;
        fArray4[2] = f12;
        fArray4[3] = 0.0f;
        fArray4[4] = f12;
        fArray4[5] = f13;
        fArray4[6] = 0.0f;
        fArray4[7] = f13;
        Matrix matrix3 = matrix2;
        matrix3();
        matrix2.setPolyToPoly(fArray2, 0, object4, 0, 4);
        object4 = matrix;
        object4();
        matrix.setPolyToPoly(fArray2, 0, (float[])object, 0, 4);
        object = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas3 = canvas2;
        canvas3((Bitmap)object);
        canvas2.drawBitmap(bitmap, (Matrix)object4, null);
        this.setTmpBitmap((Bitmap)object);
        Bitmap bitmap5 = Bitmap.createBitmap((int)((int)f12), (int)((int)f13), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap5, (String)"createBitmap(\n          \u2026g.ARGB_8888\n            )");
        object = canvas;
        object(bitmap5);
        canvas.drawBitmap(bitmap, matrix3, null);
        return bitmap5;
    }

    public static /* synthetic */ Bitmap cropDetectedIdCard$default(CameraXAutoCaptureActivity cameraXAutoCaptureActivity, Bitmap bitmap, List list, float f2, int n, Object object) {
        if ((n & 4) != 0) {
            f2 = 200.0f;
        }
        return cameraXAutoCaptureActivity.cropDetectedIdCard(bitmap, list, f2);
    }

    private final void renewSession() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        cameraXAutoCaptureActivity.currError = "";
        cameraXAutoCaptureActivity.postSetupCamera();
        ViewUtils viewUtils = ViewUtils.INSTANCE;
        viewUtils.visible((View)this.getPreviewView());
        Object object = cameraXAutoCaptureActivity.ivPreviewImage;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivPreviewImage");
            object = null;
        }
        viewUtils.gone((View)object);
        object = this.ivCardInMask;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivCardInMask");
            object = null;
        }
        viewUtils.scaleIn((View)object);
        if (this.isAutoCapturing()) {
            object = this.ivCardInMask;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ivCardInMask");
                object = null;
            }
            viewUtils.visible((View)object);
            viewUtils.visible((View)this.getTvError());
        }
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = this;
        cameraXAutoCaptureActivity2.getTvError().setTextColor(Color.parseColor((String)KalapaSDK.Companion.getConfig$kalapa_release().getMainTextColor()));
        viewUtils = cameraXAutoCaptureActivity2.getTvError();
        object = cameraXAutoCaptureActivity2.captureGuide;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"captureGuide");
            object = null;
        }
        viewUtils.setText((CharSequence)object);
        this.setTmpBitmap(null);
    }

    private final void fillBytes(ImageProxy.PlaneProxy[] planeProxyArray, byte[][] byArray) {
        int n = planeProxyArray.length;
        for (int k = 0; k < n; ++k) {
            Object[] objectArray;
            ByteBuffer byteBuffer = planeProxyArray[k].getBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"planes[i].buffer");
            if (byArray[k] == null) {
                Object[] objectArray2 = new Object[3];
                objectArray = objectArray2;
                objectArray[0] = (byte)"Initializing buffer %d at size %d";
                objectArray[1] = (byte)k;
                objectArray2[2] = byteBuffer.capacity();
                Helpers.Companion.printLog(objectArray2);
                byArray[k] = new byte[byteBuffer.capacity()];
            }
            if ((objectArray = byArray[k]) == null) {
                return;
            }
            byteBuffer.get((byte[])objectArray);
        }
    }

    private final void hideLoadingProcess() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        cameraXAutoCaptureActivity.runOnUiThread(() -> CameraXAutoCaptureActivity.hideLoadingProcess$lambda$25(cameraXAutoCaptureActivity));
    }

    private static final void postSetupCamera$lambda$0(CameraXAutoCaptureActivity cameraXAutoCaptureActivity) {
        KLPDetector kLPDetector;
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity, (String)"this$0");
        KLPDetector kLPDetector2 = kLPDetector;
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = cameraXAutoCaptureActivity;
        String string2 = cameraXAutoCaptureActivity2.modelString;
        boolean bl = cameraXAutoCaptureActivity2.isAutoCapturing();
        kLPDetector = new KLPDetector((Activity)cameraXAutoCaptureActivity, string2, "klp_label.txt", bl, cameraXAutoCaptureActivity);
        cameraXAutoCaptureActivity.detector = kLPDetector2;
    }

    private static final void updateErrorUI$lambda$1(CameraXAutoCaptureActivity cameraXAutoCaptureActivity, String string2) {
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity, (String)"this$0");
        String string3 = string2 == null ? "" : string2;
        cameraXAutoCaptureActivity.currError = string3;
        string3 = cameraXAutoCaptureActivity.getTvError();
        int n = string2 == null || string2.length() == 0 ? Color.parseColor((String)KalapaSDK.Companion.getConfig$kalapa_release().getMainTextColor()) : cameraXAutoCaptureActivity.getResources().getColor(R.color.ekyc_red, null);
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = cameraXAutoCaptureActivity;
        string3.setTextColor(n);
        cameraXAutoCaptureActivity2.getTvError().setText((CharSequence)cameraXAutoCaptureActivity.currError);
        if (!Intrinsics.areEqual((Object)cameraXAutoCaptureActivity2.currError, (Object)"")) {
            cameraXAutoCaptureActivity.getBtnNext().setVisibility(4);
        }
    }

    private static final void sendDone$lambda$2() {
        ProgressView.Companion.hideProgress$default(ProgressView.Companion, false, 1, null);
    }

    private static final void setupAnalyzer$lambda$8$lambda$7(CameraXAutoCaptureActivity cameraXAutoCaptureActivity, ImageProxy imageProxy) {
        Unit unit;
        Matrix matrix;
        Bitmap bitmap;
        Bitmap bitmap2;
        ImageProxy imageProxy2 = imageProxy;
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"imageProxy");
        Bitmap bitmap3 = Bitmap.createBitmap((int)imageProxy2.getWidth(), (int)imageProxy.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Bitmap bitmap4 = bitmap2 = bitmap3;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(\n          \u2026888\n                    )");
        bitmap2 = null;
        try {
            bitmap4.copyPixelsFromBuffer((Buffer)imageProxy.getPlanes()[0].getBuffer());
            bitmap = bitmap2;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                AutoCloseableKt.closeFinally((AutoCloseable)imageProxy, (Throwable)throwable);
                throw throwable2;
            }
        }
        AutoCloseableKt.closeFinally((AutoCloseable)imageProxy, (Throwable)bitmap);
        bitmap2 = matrix;
        bitmap2();
        matrix.postRotate((float)imageProxy.getImageInfo().getRotationDegrees());
        int n = bitmap3.getWidth();
        int n2 = bitmap3.getHeight();
        bitmap2 = Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)0, (int)n, (int)n2, (Matrix)bitmap2, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(\n          \u2026rue\n                    )");
        KLPDetector kLPDetector = cameraXAutoCaptureActivity.detector;
        if (kLPDetector != null) {
            Function0<Unit> function0;
            if (cameraXAutoCaptureActivity.shouldTurnOnQRAnalyzer) {
                String string2 = cameraXAutoCaptureActivity.getQRCodeStringFromBitmap(bitmap2);
                Log.d((String)"QRCode123123213123132123", (String)("QRCode: " + string2));
                if (string2 != null) {
                    cameraXAutoCaptureActivity.qrCodeResult = string2;
                }
            }
            cameraXAutoCaptureActivity = function0;
            function0 = new Function0<Unit>(bitmap2){
                public final /* synthetic */ Bitmap $rotatedBitmap;
                {
                    this.$rotatedBitmap = bitmap;
                    super(0);
                }

                public final void invoke() {
                    this.$rotatedBitmap.recycle();
                }
            };
            kLPDetector.detect(bitmap2, (Function0<Unit>)cameraXAutoCaptureActivity);
            imageProxy.close();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            bitmap2.recycle();
            imageProxy.close();
        }
    }

    private static final void onCaptureSuccess$lambda$10$lambda$9(CameraXAutoCaptureActivity cameraXAutoCaptureActivity, Bitmap bitmap) {
        List<BoundingBox> list;
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"$rotatedBitmap");
        ViewUtils viewUtils = ViewUtils.INSTANCE;
        ImageView imageView = cameraXAutoCaptureActivity.ivCardInMask;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivCardInMask");
            imageView = null;
        }
        viewUtils.gone((View)imageView);
        viewUtils.gone((View)cameraXAutoCaptureActivity.getLoadingProgressBar());
        viewUtils.visible((View)cameraXAutoCaptureActivity.getTvError());
        int n = RangesKt.random((IntRange)new IntRange(1, 2), (Random)Random.Default);
        if (n != 1) {
            if (n == 2) {
                ImageView imageView2 = cameraXAutoCaptureActivity.ivPreviewImage;
                if (imageView2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"ivPreviewImage");
                    imageView2 = null;
                }
                viewUtils.appearAnimSpin((View)imageView2);
            }
        } else {
            ImageView imageView3 = cameraXAutoCaptureActivity.ivPreviewImage;
            if (imageView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ivPreviewImage");
                imageView3 = null;
            }
            viewUtils.appearAnimZoom((View)imageView3);
        }
        if ((viewUtils = cameraXAutoCaptureActivity.ivPreviewImage) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivPreviewImage");
            viewUtils = null;
        }
        if ((list = cameraXAutoCaptureActivity.detector) == null || (list = ((KLPDetector)((Object)list)).getCurrentBoundingBoxes(bitmap)) == null) {
            list = CollectionsKt.emptyList();
        }
        viewUtils.setImageBitmap(CameraXAutoCaptureActivity.cropDetectedIdCard$default(cameraXAutoCaptureActivity, bitmap, list, 0.0f, 4, null));
        bitmap.recycle();
    }

    private static final void onImageDetected$lambda$19$lambda$18(CameraXAutoCaptureActivity cameraXAutoCaptureActivity) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = cameraXAutoCaptureActivity;
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity2, (String)"this$0");
        Object object = ViewUtils.INSTANCE;
        ((ViewUtils)object).visible((View)cameraXAutoCaptureActivity.getLoadingProgressBar());
        ImageView imageView = cameraXAutoCaptureActivity2.ivCardInMask;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivCardInMask");
            imageView = null;
        }
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity3 = cameraXAutoCaptureActivity;
        ((ViewUtils)object).gone((View)imageView);
        cameraXAutoCaptureActivity3.getTvError().setTextColor(cameraXAutoCaptureActivity.getResources().getColor(R.color.ekyc_green, null));
        cameraXAutoCaptureActivity3.getTvError().setTextColor(cameraXAutoCaptureActivity.getResources().getColor(R.color.ekyc_green));
        cameraXAutoCaptureActivity = cameraXAutoCaptureActivity3.getTvError();
        object = KLPLanguageManager.INSTANCE;
        vn.kalapa.ekyc.activity.a.a(cameraXAutoCaptureActivity3.getResources(), R.string.klp_id_capture_ac_success, "resources.getString(R.st\u2026lp_id_capture_ac_success)", (KLPLanguageManager)object, (TextView)cameraXAutoCaptureActivity);
    }

    private static final void onImageDetected$lambda$19(CameraXAutoCaptureActivity cameraXAutoCaptureActivity) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = cameraXAutoCaptureActivity;
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity2, (String)"this$0");
        Common.Companion.vibratePhone((Context)cameraXAutoCaptureActivity);
        cameraXAutoCaptureActivity2.runOnUiThread(() -> CameraXAutoCaptureActivity.onImageDetected$lambda$19$lambda$18(cameraXAutoCaptureActivity2));
    }

    private static final void onImageOutOfMask$lambda$20(CameraXAutoCaptureActivity object) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = object;
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity, (String)"this$0");
        cameraXAutoCaptureActivity.inFrameAtLeastOnce = false;
        Object object2 = KLPLanguageManager.INSTANCE;
        CameraXAutoCaptureActivity.updateErrorUI$default(cameraXAutoCaptureActivity, a.a(cameraXAutoCaptureActivity.getResources(), R.string.klp_id_capture_ac_corners, "resources.getString(R.st\u2026lp_id_capture_ac_corners)", (KLPLanguageManager)object2), false, 2, null);
        object2 = Helpers.Companion;
        ImageView imageView = cameraXAutoCaptureActivity.ivCardInMask;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivCardInMask");
            imageView = null;
        }
        object = object.getResources().getString(R.color.ekyc_red);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resources.getString(R.color.ekyc_red)");
        ((Helpers.Companion)object2).setBackgroundColorTintList((View)imageView, (String)object);
    }

    private static final void onImageInMask$lambda$21(CameraXAutoCaptureActivity cameraXAutoCaptureActivity) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = cameraXAutoCaptureActivity;
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity2, (String)"this$0");
        CameraXAutoCaptureActivity.updateErrorUI$default(cameraXAutoCaptureActivity2, "", false, 2, null);
        if (cameraXAutoCaptureActivity2.inFrameAtLeastOnce) {
            Object object = Helpers.Companion;
            ImageView imageView = cameraXAutoCaptureActivity.ivCardInMask;
            if (imageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ivCardInMask");
                imageView = null;
            }
            Helpers.Companion companion = object;
            object = cameraXAutoCaptureActivity.getResources().getString(R.color.ekyc_green);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resources.getString(R.color.ekyc_green)");
            companion.setBackgroundColorTintList((View)imageView, (String)object);
        }
        cameraXAutoCaptureActivity.inFrameAtLeastOnce = true;
    }

    private static final void onImageNotDetected$lambda$22(CameraXAutoCaptureActivity object) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = object;
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity, (String)"this$0");
        cameraXAutoCaptureActivity.inFrameAtLeastOnce = false;
        if (Intrinsics.areEqual((Object)cameraXAutoCaptureActivity.currError, (Object)"")) {
            Helpers.Companion companion = Helpers.Companion;
            ImageView imageView = ((CameraXAutoCaptureActivity)object).ivCardInMask;
            if (imageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ivCardInMask");
                imageView = null;
            }
            object = object.getResources().getString(R.color.white);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resources.getString(R.color.white)");
            companion.setBackgroundColorTintList((View)imageView, (String)object);
        }
    }

    private static final void onImageTooSmall$lambda$23(CameraXAutoCaptureActivity object) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = object;
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity, (String)"this$0");
        cameraXAutoCaptureActivity.inFrameAtLeastOnce = false;
        Object object2 = KLPLanguageManager.INSTANCE;
        CameraXAutoCaptureActivity.updateErrorUI$default(cameraXAutoCaptureActivity, a.a(cameraXAutoCaptureActivity.getResources(), R.string.klp_id_capture_ac_too_small, "resources.getString(R.st\u2026_id_capture_ac_too_small)", (KLPLanguageManager)object2), false, 2, null);
        object2 = Helpers.Companion;
        ImageView imageView = cameraXAutoCaptureActivity.ivCardInMask;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivCardInMask");
            imageView = null;
        }
        object = object.getResources().getString(R.color.ekyc_red);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resources.getString(R.color.ekyc_red)");
        ((Helpers.Companion)object2).setBackgroundColorTintList((View)imageView, (String)object);
    }

    private static final void showLoadingProcess$lambda$24(CameraXAutoCaptureActivity cameraXAutoCaptureActivity) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = cameraXAutoCaptureActivity;
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity2, (String)"this$0");
        cameraXAutoCaptureActivity2.getLoadingProgressBar().setVisibility(0);
    }

    private static final void hideLoadingProcess$lambda$25(CameraXAutoCaptureActivity cameraXAutoCaptureActivity) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = cameraXAutoCaptureActivity;
        Intrinsics.checkNotNullParameter((Object)cameraXAutoCaptureActivity2, (String)"this$0");
        cameraXAutoCaptureActivity2.getLoadingProgressBar().setVisibility(8);
    }

    public CameraXAutoCaptureActivity() {
        this(null, 1, null);
    }

    @Override
    public void getIntentData() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity;
        Object object;
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = companion;
        cameraXAutoCaptureActivity2.shouldTurnOnQRAnalyzer = cameraXAutoCaptureActivity2.getIntent().getBooleanExtra(SHOULD_TURN_ON_QR_ANALYZER, false);
        Object[] objectArray = KalapaSDKMediaType.Companion;
        String string2 = cameraXAutoCaptureActivity2.getIntent().getStringExtra("document_type");
        if (string2 == null) {
            string2 = "BACK";
        }
        objectArray = objectArray.fromName(string2);
        ((CameraXAutoCaptureActivity)((Object)companion)).documentType = objectArray;
        if (objectArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"documentType");
            objectArray = null;
        }
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity3 = companion;
        cameraXAutoCaptureActivity3.setExtraInfo(objectArray.name());
        objectArray = cameraXAutoCaptureActivity3.documentType;
        if (objectArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"documentType");
            objectArray = null;
        }
        if (objectArray != KalapaSDKMediaType.PASSPORT) {
            CameraXAutoCaptureActivity cameraXAutoCaptureActivity4 = companion;
            objectArray = KLPLanguageManager.INSTANCE;
            string2 = a.a(cameraXAutoCaptureActivity4.getResources(), R.string.klp_id_capture_subtitle, "resources.getString(R.st\u2026.klp_id_capture_subtitle)", (KLPLanguageManager)objectArray);
            object = cameraXAutoCaptureActivity4.getResources();
            KalapaSDKMediaType kalapaSDKMediaType = cameraXAutoCaptureActivity4.documentType;
            if (kalapaSDKMediaType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"documentType");
                kalapaSDKMediaType = null;
            }
            int n = kalapaSDKMediaType == KalapaSDKMediaType.FRONT ? R.string.klp_id_capture_subtitle_front : R.string.klp_id_capture_subtitle_back;
            objectArray = string2 + a.a(object, n, "resources.getString(if (\u2026id_capture_subtitle_back)", (KLPLanguageManager)objectArray);
        } else {
            String string3 = companion.getString(R.string.klp_passport_capture_subtitle);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(R.string.klp_passport_capture_subtitle)");
            objectArray = KLPLanguageManager.INSTANCE.get(string3);
        }
        ((CameraXAutoCaptureActivity)((Object)companion)).captureGuide = objectArray;
        Helpers.Companion companion = Helpers.Companion;
        objectArray = new Object[1];
        int n = 0;
        object = cameraXAutoCaptureActivity.documentType;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"documentType");
            object = null;
        }
        objectArray[n] = "DocumentType: " + (KalapaSDKMediaType)((Object)object);
        companion.printLog(objectArray);
    }

    @Override
    public void onAutoCaptureToggle(@Nullable Boolean bl) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = companion;
        super.onAutoCaptureToggle(bl);
        Object[] objectArray = LogUtil.INSTANCE;
        KALAPA_LOG_LEVEL kALAPA_LOG_LEVEL = KALAPA_LOG_LEVEL.INFO;
        KALAPA_LOG_ACTION kALAPA_LOG_ACTION = cameraXAutoCaptureActivity.isAutoCapturing() ? KALAPA_LOG_ACTION.CAPTURE_AUTO_ON : KALAPA_LOG_ACTION.CAPTURE_AUTO_OFF;
        LogUtil logUtil = objectArray;
        objectArray = ((BaseActivity)((Object)companion)).getSCREEN_ID();
        LogUtil.logEvent$kalapa_release$default(logUtil, (Context)companion, kALAPA_LOG_LEVEL, kALAPA_LOG_ACTION, (String)objectArray, null, false, 48, null);
        objectArray = ((CameraXAutoCaptureActivity)((Object)companion)).detector;
        if (objectArray != null) {
            objectArray.setAutoCaptureOn(((CameraXActivity)((Object)companion)).isAutoCapturing());
        }
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = companion;
        Helpers.Companion companion = Helpers.Companion;
        objectArray = new Object[1];
        int n = 0;
        boolean bl2 = cameraXAutoCaptureActivity2.isAutoCapturing();
        Object object = cameraXAutoCaptureActivity2.detector;
        object = object != null ? Boolean.valueOf(((KLPDetector)object).isAutoCaptureOn()) : null;
        objectArray[n] = "onAutoCaptureToggle isAutoCapturing " + bl2 + "  forceValue " + bl + " " + (Boolean)object;
        companion.printLog(objectArray);
    }

    @Override
    public void setupCustomUI() {
        KalapaSDKMediaType kalapaSDKMediaType;
        Object object;
        Object object2;
        int n;
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = cameraXAutoCaptureActivity5;
        Object object3 = cameraXAutoCaptureActivity.getTvError();
        Object object4 = cameraXAutoCaptureActivity.captureGuide;
        if (object4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"captureGuide");
            object4 = null;
        }
        object3.setText((CharSequence)object4);
        View view = cameraXAutoCaptureActivity5.findViewById(R.id.iv_action);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.iv_action)");
        object3 = (ImageView)view;
        cameraXAutoCaptureActivity5.ivGuide = object3;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivGuide");
            object3 = null;
        }
        if ((object4 = cameraXAutoCaptureActivity5.documentType) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"documentType");
            object4 = null;
        }
        n = (n = WhenMappings.$EnumSwitchMapping$0[((Enum)object4).ordinal()]) != 1 ? (n != 2 ? R.drawable.ic_passport_black : R.drawable.klp_ic_footer_back) : R.drawable.klp_ic_footer_front;
        object3.setImageResource(n);
        View view2 = cameraXAutoCaptureActivity5.findViewById(R.id.tv_title);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.tv_title)");
        cameraXAutoCaptureActivity5.tvTitle = object3 = (TextView)view2;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tvTitle");
            object3 = null;
        }
        if ((object2 = cameraXAutoCaptureActivity5.documentType) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"documentType");
            object2 = null;
        }
        if (object2 != (object2 = KalapaSDKMediaType.PASSPORT)) {
            String string2 = cameraXAutoCaptureActivity5.getString(R.string.klp_id_capture_title);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.klp_id_capture_title)");
            object = KLPLanguageManager.INSTANCE.get(string2);
        } else {
            object = KLPLanguageManager.INSTANCE;
            object = a.a(cameraXAutoCaptureActivity5.getResources(), R.string.klp_title_passport, "resources.getString(R.string.klp_title_passport)", (KLPLanguageManager)object);
        }
        object3.setText((CharSequence)object);
        View view3 = cameraXAutoCaptureActivity5.findViewById(R.id.iv_preview_image);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.iv_preview_image)");
        object3 = (ImageView)view3;
        cameraXAutoCaptureActivity5.ivPreviewImage = object3;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivPreviewImage");
            object3 = null;
        }
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = cameraXAutoCaptureActivity5;
        object3.setDrawingCacheEnabled(false);
        View view4 = cameraXAutoCaptureActivity2.findViewById(R.id.tv_guide);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.tv_guide)");
        cameraXAutoCaptureActivity2.tvGuide1 = (TextView)view4;
        object3 = cameraXAutoCaptureActivity2.ivGuide;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivGuide");
            object3 = null;
        }
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity3 = cameraXAutoCaptureActivity5;
        TextView textView = object3;
        object3 = KalapaSDK.Companion;
        textView.setColorFilter(Color.parseColor((String)object3.getConfig$kalapa_release().getMainColor()));
        View view5 = cameraXAutoCaptureActivity3.findViewById(R.id.iv_card_in_mask);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(R.id.iv_card_in_mask)");
        cameraXAutoCaptureActivity3.ivCardInMask = (ImageView)view5;
        View view6 = cameraXAutoCaptureActivity3.findViewById(R.id.klp_auto_capture);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(R.id.klp_auto_capture)");
        object = (TextView)view6;
        cameraXAutoCaptureActivity5.tvAutoCapture = object;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tvAutoCapture");
            object = null;
        }
        b.a((KalapaSDK.Companion)object3, (TextView)object);
        object = cameraXAutoCaptureActivity5.tvAutoCapture;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tvAutoCapture");
            object = null;
        }
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity4 = cameraXAutoCaptureActivity5;
        KLPLanguageManager kLPLanguageManager = KLPLanguageManager.INSTANCE;
        vn.kalapa.ekyc.activity.a.a(cameraXAutoCaptureActivity4.getResources(), R.string.klp_id_capture_ac, "resources.getString(R.string.klp_id_capture_ac)", kLPLanguageManager, (TextView)object);
        object = cameraXAutoCaptureActivity4.tvTitle;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tvTitle");
            object = null;
        }
        b.a((KalapaSDK.Companion)object3, (TextView)object);
        object = cameraXAutoCaptureActivity5.tvGuide1;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tvGuide1");
            object = null;
        }
        if ((kalapaSDKMediaType = cameraXAutoCaptureActivity5.documentType) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"documentType");
            kalapaSDKMediaType = null;
        }
        object2 = kalapaSDKMediaType != object2 ? cameraXAutoCaptureActivity5.getString(R.string.klp_id_capture_note) : cameraXAutoCaptureActivity5.getString(R.string.klp_passport_capture_note);
        Object object5 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"if (documentType != Kala\u2026pture_note)\n            }");
        object.setText((CharSequence)kLPLanguageManager.get((String)object5));
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity5 = cameraXAutoCaptureActivity5.tvGuide1;
        if (cameraXAutoCaptureActivity5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tvGuide1");
            cameraXAutoCaptureActivity5 = null;
        }
        b.a((KalapaSDK.Companion)object3, (TextView)cameraXAutoCaptureActivity5);
    }

    @Override
    public void postSetupCamera() {
        this.getCameraExecutor().execute(() -> CameraXAutoCaptureActivity.postSetupCamera$lambda$0(this));
    }

    @Override
    public void previewViewLayerMode(boolean bl) {
        super.previewViewLayerMode(bl);
        if (bl) {
            if (this.isScannerReady) {
                ViewUtils.INSTANCE.fadeIn(this.getHolderAutoCapture());
            }
            ViewUtils viewUtils = ViewUtils.INSTANCE;
            ImageView imageView = this.ivGuide;
            if (imageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ivGuide");
                imageView = null;
            }
            viewUtils.fadeIn((View)imageView);
            viewUtils.fadeIn((View)this.getTvGuide());
        } else if (KalapaSDK.Companion.isFoldOpen((Context)this)) {
            ViewUtils viewUtils = ViewUtils.INSTANCE;
            viewUtils.gone(this.getHolderAutoCapture());
            ImageView imageView = this.ivGuide;
            if (imageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ivGuide");
                imageView = null;
            }
            viewUtils.gone((View)imageView);
            viewUtils.gone((View)this.getTvGuide());
        }
    }

    @Override
    public void sendError(@Nullable String object) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = object2;
        String string2 = object;
        ProgressView.Companion.hideProgress$default(ProgressView.Companion, false, 1, null);
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = object2;
        Object object2 = KALAPA_LOG_LEVEL.ERROR;
        KALAPA_LOG_ACTION kALAPA_LOG_ACTION = KALAPA_LOG_ACTION.CAPTURE_FAIL;
        String string3 = cameraXAutoCaptureActivity2.getSCREEN_ID();
        object = MapsKt.mapOf((Pair)TuplesKt.to((Object)"error", (Object)object));
        LogUtil.logEvent$kalapa_release$default(LogUtil.INSTANCE, (Context)cameraXAutoCaptureActivity2, (KALAPA_LOG_LEVEL)((Object)object2), kALAPA_LOG_ACTION, string3, (Map)object, false, 32, null);
        cameraXAutoCaptureActivity.updateErrorUI(string2, true);
    }

    @Override
    public void sendDone(@NotNull Function0<Unit> object) {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = object2;
        Function0<Unit> function0 = object;
        Intrinsics.checkNotNullParameter(function0, (String)"nextAction");
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = object2;
        Object object2 = KALAPA_LOG_LEVEL.INFO;
        object = KALAPA_LOG_ACTION.CAPTURE_SUCCESS;
        String string2 = cameraXAutoCaptureActivity2.getSCREEN_ID();
        LogUtil.logEvent$kalapa_release$default(LogUtil.INSTANCE, (Context)cameraXAutoCaptureActivity2, (KALAPA_LOG_LEVEL)((Object)object2), object, string2, null, false, 48, null);
        function0.invoke();
        cameraXAutoCaptureActivity.runOnUiThread(CameraXAutoCaptureActivity::sendDone$lambda$2);
        cameraXAutoCaptureActivity.finish();
    }

    @Override
    public void onRetryClicked() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        super.onRetryClicked();
        cameraXAutoCaptureActivity.renewSession();
    }

    @Override
    @NotNull
    public ImageAnalysis setupAnalyzer() {
        ImageAnalysis imageAnalysis = new ImageAnalysis.Builder().setResolutionSelector(new ResolutionSelector.Builder().setResolutionStrategy(new ResolutionStrategy(new Size(1600, 900), 1)).build()).setBackpressureStrategy(0).setOutputImageFormat(2).build();
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = executorService;
        Intrinsics.checkNotNullExpressionValue((Object)imageAnalysis, (String)"Builder()\n            .s\u2026888)\n            .build()");
        ExecutorService executorService = cameraXAutoCaptureActivity.getCameraExecutor();
        imageAnalysis.setAnalyzer((Executor)executorService, arg_0 -> CameraXAutoCaptureActivity.setupAnalyzer$lambda$8$lambda$7(cameraXAutoCaptureActivity, arg_0));
        return imageAnalysis;
    }

    public void onPause() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        super.onPause();
        KLPDetector kLPDetector = cameraXAutoCaptureActivity.detector;
        if (kLPDetector != null) {
            kLPDetector.close();
        }
        this.detector = null;
    }

    @Override
    public void onCaptureSuccess(int n) {
        Unit unit;
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        cameraXAutoCaptureActivity.hideLoadingProcess();
        int n2 = cameraXAutoCaptureActivity.getCameraRotationDegree();
        n2 = n != n2 ? (n2 - n + 270) % 360 : n;
        Object[] objectArray = new Object[1];
        int n3 = n;
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity2 = this;
        n = cameraXAutoCaptureActivity2.getCameraRotationDegree();
        Bitmap bitmap = cameraXAutoCaptureActivity2.getTmpBitmap();
        objectArray[0] = "onCaptureSuccess " + n3 + " " + n + " " + n2 + " " + bitmap;
        Helpers.Companion.printLog(objectArray);
        Bitmap bitmap2 = this.getTmpBitmap();
        if (bitmap2 != null) {
            CameraXAutoCaptureActivity cameraXAutoCaptureActivity3 = this;
            cameraXAutoCaptureActivity3.runOnUiThread(() -> CameraXAutoCaptureActivity.onCaptureSuccess$lambda$10$lambda$9(cameraXAutoCaptureActivity3, BitmapUtil.Companion.rotateBitmapToStraight(bitmap2, n2, false)));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            this.errorToast();
        }
    }

    @Override
    public void onResume() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        super.onResume();
        Helpers.Companion.printLog(CameraXAutoCaptureActivity.class + " - Locale: " + Locale.getDefault());
        cameraXAutoCaptureActivity.renewSession();
    }

    @Override
    public void verifyImage() {
        ProgressView.Companion.showProgress$default(ProgressView.Companion, (Context)this, null, null, null, null, null, 62, null);
        KalapaSDK.Companion companion = KalapaSDK.Companion;
        companion.setRawQRCodeScanned(this.qrCodeResult);
        KalapaHandler kalapaHandler = companion.getHandler$kalapa_release();
        Intrinsics.checkNotNull((Object)kalapaHandler, (String)"null cannot be cast to non-null type vn.kalapa.ekyc.KalapaCaptureHandler");
        KalapaCaptureHandler kalapaCaptureHandler = (KalapaCaptureHandler)kalapaHandler;
        Bitmap bitmap = this.getTmpBitmap();
        Intrinsics.checkNotNull((Object)bitmap);
        String string2 = BitmapUtil.Companion.convertBitmapToBase64(bitmap);
        KalapaSDKMediaType kalapaSDKMediaType = this.documentType;
        if (kalapaSDKMediaType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"documentType");
            kalapaSDKMediaType = null;
        }
        kalapaCaptureHandler.process(string2, kalapaSDKMediaType, this);
    }

    @Override
    public void onBackBtnClicked() {
        if (object.showingGuide) {
            object.getSupportFragmentManager().popBackStack();
            CameraXAutoCaptureActivity cameraXAutoCaptureActivity = object;
            Object object = KALAPA_LOG_LEVEL.INFO;
            KALAPA_LOG_ACTION kALAPA_LOG_ACTION = KALAPA_LOG_ACTION.GUIDE_TAP_CLOSE;
            String string2 = cameraXAutoCaptureActivity.getSCREEN_ID();
            LogUtil.logEvent$kalapa_release$default(LogUtil.INSTANCE, (Context)cameraXAutoCaptureActivity, (KALAPA_LOG_LEVEL)((Object)object), kALAPA_LOG_ACTION, string2, null, false, 48, null);
            v1.showingGuide = false;
        } else {
            BaseActivity.showEndEKYC$default(object, null, 1, null);
        }
    }

    /*
     * Handled duff style switch with additional control
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void onInfoBtnClicked() {
        void var2_12;
        this.showingGuide = true;
        Helpers.Companion companion = Helpers.Companion;
        Object[] objectArray = new Object[1];
        int n = 0;
        KalapaSDKMediaType kalapaSDKMediaType = this.documentType;
        if (kalapaSDKMediaType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"documentType");
            kalapaSDKMediaType = null;
        }
        objectArray[n] = "On Info Btn Clicked " + kalapaSDKMediaType;
        companion.printLog(objectArray);
        KalapaSDKMediaType kalapaSDKMediaType2 = this.documentType;
        if (kalapaSDKMediaType2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"documentType");
            Object var2_6 = null;
        }
        int n2 = 0;
        block6: do {
            void var2_7;
            switch (n2 == 0 ? WhenMappings.$EnumSwitchMapping$0[var2_7.ordinal()] : n2) {
                default: {
                    n2 = 1;
                    continue block6;
                }
                case 4: {
                    GuideType guideType = GuideType.SELFIE;
                    break;
                }
                case 3: {
                    GuideType guideType = GuideType.PASSPORT;
                    break;
                }
                case 2: {
                    GuideType guideType = GuideType.BACK;
                    break;
                }
                case 1: {
                    GuideType guideType = GuideType.FRONT;
                }
            }
            break;
        } while (true);
        BottomGuideFragment bottomGuideFragment = new BottomGuideFragment((GuideType)var2_12);
        int n3 = R.anim.slide_in_bottom;
        int n4 = R.anim.slide_out_bottom;
        int n5 = n3;
        this.getSupportFragmentManager().beginTransaction().setCustomAnimations(n3, n5, n5, n4).replace(R.id.fragment_container, (Fragment)bottomGuideFragment).addToBackStack(null).commit();
    }

    @Override
    public void onSetupModelComplete(boolean bl) {
        Helpers.Companion.printLog("onSetupModelComplete " + bl);
        this.isScannerReady = bl;
        if (!bl) {
            CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
            cameraXAutoCaptureActivity.onAutoCaptureToggle(Boolean.FALSE);
            cameraXAutoCaptureActivity.getHolderAutoCapture().setVisibility(4);
        }
    }

    @Override
    public void onImageDetected() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        KALAPA_LOG_LEVEL kALAPA_LOG_LEVEL = KALAPA_LOG_LEVEL.INFO;
        KALAPA_LOG_ACTION kALAPA_LOG_ACTION = KALAPA_LOG_ACTION.CAPTURE_AUTO_SUCCESS;
        String string2 = cameraXAutoCaptureActivity.getSCREEN_ID();
        LogUtil.logEvent$kalapa_release$default(LogUtil.INSTANCE, (Context)cameraXAutoCaptureActivity, kALAPA_LOG_LEVEL, kALAPA_LOG_ACTION, string2, null, false, 48, null);
        this.takePhoto();
        new Handler(Looper.getMainLooper()).postDelayed(() -> CameraXAutoCaptureActivity.onImageDetected$lambda$19(this), 200L);
    }

    @Override
    @SuppressLint(value={"ResourceType"})
    public void onImageOutOfMask() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        cameraXAutoCaptureActivity.runOnUiThread(() -> CameraXAutoCaptureActivity.onImageOutOfMask$lambda$20(cameraXAutoCaptureActivity));
    }

    @Override
    @SuppressLint(value={"ResourceType"})
    public void onImageInMask() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        cameraXAutoCaptureActivity.runOnUiThread(() -> CameraXAutoCaptureActivity.onImageInMask$lambda$21(cameraXAutoCaptureActivity));
    }

    @Override
    @SuppressLint(value={"ResourceType"})
    public void onImageNotDetected() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        cameraXAutoCaptureActivity.runOnUiThread(() -> CameraXAutoCaptureActivity.onImageNotDetected$lambda$22(cameraXAutoCaptureActivity));
    }

    @Override
    @SuppressLint(value={"ResourceType"})
    public void onImageTooSmall() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = this;
        cameraXAutoCaptureActivity.runOnUiThread(() -> CameraXAutoCaptureActivity.onImageTooSmall$lambda$23(cameraXAutoCaptureActivity));
    }

    public final void showLoadingProcess() {
        CameraXAutoCaptureActivity cameraXAutoCaptureActivity = viewUtils;
        cameraXAutoCaptureActivity.runOnUiThread(() -> CameraXAutoCaptureActivity.showLoadingProcess$lambda$24(cameraXAutoCaptureActivity));
        ViewUtils viewUtils = ViewUtils.INSTANCE;
        ImageView imageView = cameraXAutoCaptureActivity.ivCardInMask;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivCardInMask");
            imageView = null;
        }
        viewUtils.gone((View)imageView);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KalapaSDKMediaType.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[KalapaSDKMediaType.FRONT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[KalapaSDKMediaType.BACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[KalapaSDKMediaType.PASSPORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[KalapaSDKMediaType.PORTRAIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

