/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.iproov.component;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.KalapaSDK;

public final class CircularProgressView
extends View {
    private final int progressColor;
    private final int backgroundColor;
    private final float progressWidth;
    private final int textColor;
    private final float textSize;
    @NotNull
    private final Paint backgroundPaint;
    @NotNull
    private final Paint progressPaint;
    @NotNull
    private final Paint textPaint;
    private double animatedProgress;

    @JvmOverloads
    public CircularProgressView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        int n2;
        int n3;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        this.progressColor = n3 = Color.parseColor((String)KalapaSDK.Companion.getConfig$kalapa_release().getMainColor());
        this.backgroundColor = n2 = Color.parseColor((String)"#E0E0E0");
        this.progressWidth = 20.0f;
        this.textColor = -16777216;
        this.textSize = 40.0f;
        Paint paint = new Paint(1);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setColor(n2);
        paint.setStrokeWidth(20.0f);
        this.backgroundPaint = paint;
        Paint paint2 = new Paint(1);
        paint2.setStyle(Paint.Style.STROKE);
        paint2.setStrokeCap(Paint.Cap.ROUND);
        paint2.setColor(n3);
        paint2.setStrokeWidth(20.0f);
        this.progressPaint = paint2;
        Paint paint3 = new Paint(1);
        paint3.setTextAlign(Paint.Align.CENTER);
        paint3.setColor(-16777216);
        paint3.setTextSize(40.0f);
        this.textPaint = paint3;
    }

    public /* synthetic */ CircularProgressView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public static /* synthetic */ void setProgressAnimated$default(CircularProgressView circularProgressView, double d2, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 300L;
        }
        circularProgressView.setProgressAnimated(d2, l);
    }

    @JvmOverloads
    public CircularProgressView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public CircularProgressView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void setProgressAnimated$lambda$4$lambda$3(CircularProgressView circularProgressView, ValueAnimator valueAnimator) {
        ValueAnimator valueAnimator2 = valueAnimator;
        Intrinsics.checkNotNullParameter((Object)((Object)circularProgressView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)valueAnimator2, (String)"animator");
        Object object = valueAnimator2.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        circularProgressView.animatedProgress = ((Float)object).floatValue();
        circularProgressView.invalidate();
    }

    public void onDraw(@NotNull Canvas canvas) {
        RectF rectF;
        Canvas canvas2 = canvas;
        CircularProgressView circularProgressView = this;
        Canvas canvas3 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas3, (String)"canvas");
        super.onDraw(canvas3);
        float f2 = Math.min(circularProgressView.getWidth(), this.getHeight());
        float f3 = (float)circularProgressView.getWidth() / 2.0f;
        float f4 = (float)circularProgressView.getHeight() / 2.0f;
        float f5 = f4;
        CircularProgressView circularProgressView2 = this;
        Canvas canvas4 = canvas;
        CircularProgressView circularProgressView3 = this;
        Canvas canvas5 = canvas;
        float f6 = f2 / 2.0f - this.progressWidth / 2.0f;
        canvas = this.backgroundPaint;
        canvas5.drawCircle(f3, f5, f6, (Paint)canvas);
        canvas = rectF;
        float f7 = f5;
        float f8 = f6;
        float f9 = f6;
        float f10 = f6;
        f6 = f3 - f6;
        f2 = f5 - f10;
        f5 = f3 + f9;
        float f11 = f7 + f8;
        rectF = new RectF(f6, f2, f5, f11);
        f6 = (float)(circularProgressView3.animatedProgress * (double)360);
        Paint paint = circularProgressView3.progressPaint;
        canvas4.drawArc((RectF)canvas, -90.0f, f6, false, paint);
        String string2 = (int)(circularProgressView2.animatedProgress * (double)100) + "%";
        float f12 = circularProgressView2.textPaint.descent();
        f12 = f4 - (circularProgressView2.textPaint.ascent() + f12) / 2.0f;
        paint = circularProgressView.textPaint;
        canvas2.drawText(string2, f3, f12, paint);
    }

    public final void setProgressAnimated(double d2, long l) {
        d2 = RangesKt.coerceIn((double)d2, (double)0.0, (double)1.0);
        float[] fArray = new float[2];
        float[] fArray2 = fArray;
        fArray2[0] = (float)this.animatedProgress;
        fArray[1] = (float)d2;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])fArray);
        valueAnimator.setDuration(l);
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.addUpdateListener(arg_0 -> CircularProgressView.setProgressAnimated$lambda$4$lambda$3(this, arg_0));
        valueAnimator.start();
    }
}

