/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.views;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.R;
import vn.kalapa.ekyc.KalapaSDK;
import vn.kalapa.ekyc.utils.BitmapUtil;
import vn.kalapa.ekyc.utils.Helpers;
import vn.kalapa.ekyc.views.MaskView;

public final class CardMaskView
extends MaskView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ID_CARD_WIDTH_SIZE = 860;
    private static final int ID_CARD_HEIGHT_SIZE = 540;
    private float roundRadius;
    private float ovalTop;
    private float ovalFrameTop;
    private final float foldOpenConst;
    private final float foldClosedConst;
    private float normalWidth;
    private float normalHeight;
    private float smallWidth;
    private float smallHeight;
    private boolean isLivenessMode;

    @JvmOverloads
    public CardMaskView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        CardMaskView cardMaskView = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, n);
        cardMaskView.foldOpenConst = 1.5f;
        cardMaskView.foldClosedConst = 0.8f;
        cardMaskView.init(context, attributeSet, n, 0);
    }

    public /* synthetic */ CardMaskView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @TargetApi(value=21)
    public CardMaskView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n, int n2) {
        CardMaskView cardMaskView = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, n, n2);
        cardMaskView.foldOpenConst = 1.5f;
        cardMaskView.foldClosedConst = 0.8f;
        cardMaskView.init(context, attributeSet, n, n2);
    }

    @SuppressLint(value={"Recycle"})
    private final void init(Context context, AttributeSet attributeSet, int n, int n2) {
        CardMaskView cardMaskView = this;
        cardMaskView.setWillNotDraw(false);
        cardMaskView.setLayerType(2, null);
        if (attributeSet != null) {
            PorterDuffColorFilter porterDuffColorFilter;
            CardMaskView cardMaskView2 = this;
            CardMaskView cardMaskView3 = this;
            DisplayMetrics displayMetrics = cardMaskView3.getResources().getDisplayMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"resources.displayMetrics");
            cardMaskView3.setMetrics(displayMetrics);
            AttributeSet attributeSet2 = attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.CardMaskView, n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)attributeSet2, (String)"context.obtainStyledAttr\u2026defStyleRes\n            )");
            this.isLivenessMode = attributeSet2.getBoolean(R.styleable.CardMaskView_liveness_mode, false);
            this.setMaskColor(attributeSet.getInt(R.styleable.CardMaskView_maskColor, R.color.maskColor));
            this.setDashColor(attributeSet.getInt(R.styleable.CardMaskView_dashColor, R.color.colorPrimary));
            this.setCenterX(attributeSet.getDimension(R.styleable.CardMaskView_centerX, (float)this.getMetrics().widthPixels / 2.0f));
            cardMaskView2.setCenterY(attributeSet.getDimension(R.styleable.CardMaskView_centerY, (float)this.getMetrics().heightPixels / 2.0f));
            cardMaskView2.getTransparentPaint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            cardMaskView2.getDashPaint().setStyle(Paint.Style.STROKE);
            cardMaskView2.getDashPaint().setColor(attributeSet.getInt(R.styleable.CardMaskView_dashColor, R.color.colorPrimary));
            float f2 = 2;
            cardMaskView2.getDashPaint().setStrokeWidth(attributeSet.getDimension(R.styleable.FaceDetectionView_strokeWidth, f2 * this.getMetrics().density));
            cardMaskView2.getDashPaint().setPathEffect((PathEffect)new DashPathEffect(new float[]{20.0f, 20.0f}, 0.0f));
            float f3 = cardMaskView2.getMetrics().density * 18.0f;
            f3 = cardMaskView2.isLivenessMode ? (float)(this.getMetrics().widthPixels / 5) * 4.0f : (float)this.getMetrics().widthPixels * 1.0f - f2 * f3;
            if (f3 > (float)(this.getMetrics().heightPixels / 2) || KalapaSDK.Companion.isFoldOpen(context)) {
                f3 = (float)this.getMetrics().widthPixels / this.foldOpenConst;
            }
            Helpers.Companion.printLog("CardMaskView " + this.getMetrics().widthPixels + " - Height: " + this.getMetrics().heightPixels);
            boolean bl = this.isLivenessMode;
            float f4 = bl ? f3 : f3 / (float)ID_CARD_WIDTH_SIZE * (float)ID_CARD_HEIGHT_SIZE;
            float f5 = bl ? f3 / f2 : attributeSet.getDimension(R.styleable.CardMaskView_radius, 0.0f) * this.getMetrics().density;
            CardMaskView cardMaskView4 = this;
            CardMaskView cardMaskView5 = this;
            this.roundRadius = f5;
            this.normalWidth = attributeSet.getDimension(R.styleable.CardMaskView_frameWidth, f3);
            float f6 = attributeSet.getDimension(R.styleable.CardMaskView_frameHeight, f4);
            this.normalHeight = f5 = f6;
            f5 = this.normalWidth;
            this.smallWidth = f5 * 0.8f;
            cardMaskView5.smallHeight = f6 * 0.8f;
            cardMaskView5.setFrameWidth(f5);
            cardMaskView5.setFrameHeight(cardMaskView5.normalHeight);
            this.setTransOff(attributeSet.getDimension(R.styleable.CardMaskView_transOff, this.getMetrics().density * 0.0f));
            this.setTransOffY(attributeSet.getDimension(R.styleable.CardMaskView_transOffY, this.getMetrics().density * 0.0f));
            cardMaskView4.setCornerColor(attributeSet.getColor(R.styleable.CardMaskView_cornerColor, -1));
            PorterDuffColorFilter porterDuffColorFilter2 = porterDuffColorFilter;
            porterDuffColorFilter = new PorterDuffColorFilter(this.getCornerColor(), PorterDuff.Mode.DST_IN);
            if (cardMaskView4.getCornerColor() != -1) {
                PorterDuffColorFilter porterDuffColorFilter3;
                porterDuffColorFilter2 = porterDuffColorFilter3;
                porterDuffColorFilter3 = new PorterDuffColorFilter(this.getCornerColor(), PorterDuff.Mode.SRC_IN);
            }
            CardMaskView cardMaskView6 = this;
            cardMaskView6.getCornerPaint().setColorFilter((ColorFilter)porterDuffColorFilter2);
            cardMaskView6.setFrame();
            cardMaskView6.setConner(null);
        }
    }

    private final void draw4Corners(Canvas canvas, RectF rectF, Paint paint) {
        canvas.drawBitmap(BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.drawable.frame_exclude_png), null, rectF, paint);
    }

    @JvmOverloads
    public CardMaskView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public CardMaskView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public final float getNormalWidth() {
        return this.normalWidth;
    }

    public final void setNormalWidth(float f2) {
        this.normalWidth = f2;
    }

    public final float getNormalHeight() {
        return this.normalHeight;
    }

    public final void setNormalHeight(float f2) {
        this.normalHeight = f2;
    }

    public final float getSmallWidth() {
        return this.smallWidth;
    }

    public final void setSmallWidth(float f2) {
        this.smallWidth = f2;
    }

    public final float getSmallHeight() {
        return this.smallHeight;
    }

    public final void setSmallHeight(float f2) {
        this.smallHeight = f2;
    }

    public final boolean isLivenessMode() {
        return this.isLivenessMode;
    }

    public final void setLivenessMode(boolean bl) {
        this.isLivenessMode = bl;
    }

    @Override
    public void setFrame() {
        CardMaskView cardMaskView = this;
        Helpers.Companion.printLog("setFrame transOffY " + this.getTransOffY());
        CardMaskView cardMaskView2 = this;
        float f2 = 2;
        float f3 = cardMaskView2.getCenterX() - this.getFrameWidth() / f2;
        float f4 = cardMaskView2.getCenterY();
        f4 = cardMaskView2.getTransOffY() + f4 - this.getFrameHeight() / f2;
        float f5 = cardMaskView2.getCenterX();
        f5 = cardMaskView2.getFrameWidth() / f2 + f5;
        float f6 = cardMaskView2.getCenterY();
        float f7 = f3;
        CardMaskView cardMaskView3 = this;
        f3 = cardMaskView3.getTransOffY() + f6;
        cardMaskView.setFrame(new RectF(f7, f4, f5, cardMaskView3.getFrameHeight() / f2 + f3));
        CardMaskView cardMaskView4 = this;
        f2 = cardMaskView4.getFrame().left;
        float f8 = cardMaskView4.getTransOff() + f2;
        CardMaskView cardMaskView5 = this;
        f2 = cardMaskView5.getFrame().top;
        f2 = cardMaskView5.getTransOff() + f2;
        f3 = cardMaskView5.getFrame().right - this.getTransOff();
        float f9 = cardMaskView5.getFrame().bottom - this.getTransOff();
        cardMaskView.setTransparentFrame(new RectF(f8, f2, f3, f9));
    }

    public final void switchIntoFarModeLiveness() {
        CardMaskView cardMaskView = this;
        cardMaskView.setFrameWidth(cardMaskView.smallWidth);
        cardMaskView.setFrameHeight(cardMaskView.smallWidth);
        cardMaskView.setFrame();
    }

    public final void resetToDefault() {
        CardMaskView cardMaskView = this;
        cardMaskView.setFrameWidth(cardMaskView.normalWidth);
        cardMaskView.setFrameHeight(cardMaskView.normalWidth);
        cardMaskView.setFrame();
    }

    public void draw(@NotNull Canvas canvas) {
        float f2;
        CardMaskView cardMaskView = this;
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        super.draw(canvas2);
        if (!cardMaskView.isLivenessMode) {
            CardMaskView cardMaskView2 = this;
            CardMaskView cardMaskView3 = this;
            RectF rectF = cardMaskView3.getTransparentFrame();
            float f3 = cardMaskView3.roundRadius;
            Paint paint = cardMaskView3.getTransparentPaint();
            float f4 = f3;
            canvas.drawRoundRect(rectF, f4, f4, paint);
            rectF = cardMaskView2.getFrame();
            Paint paint2 = cardMaskView2.getDashPaint();
            cardMaskView2.draw4Corners(canvas, rectF, paint2);
        } else {
            if (this.ovalTop == 0.0f) {
                this.ovalTop = this.getTransparentFrame().top - this.getTransparentFrame().bottom * 0.0618f;
            }
            if (this.ovalFrameTop == 0.0f) {
                this.ovalFrameTop = this.getFrame().top - this.getFrame().bottom * 0.0618f;
            }
            CardMaskView cardMaskView4 = this;
            CardMaskView cardMaskView5 = this;
            float f5 = cardMaskView5.getTransparentFrame().left;
            float f6 = cardMaskView5.ovalTop;
            float f7 = cardMaskView5.getTransparentFrame().right;
            f2 = cardMaskView5.getTransparentFrame().bottom;
            Paint paint = cardMaskView5.getTransparentPaint();
            canvas.drawOval(f5, f6, f7, f2, paint);
            f5 = cardMaskView4.getFrame().left;
            f6 = cardMaskView4.ovalFrameTop;
            f7 = cardMaskView4.getFrame().right;
            f2 = cardMaskView4.getFrame().bottom;
            paint = cardMaskView4.getDashPaint();
            canvas.drawOval(f5, f6, f7, f2, paint);
        }
        Bitmap bitmap = this.getConner();
        if (bitmap != null) {
            RectF rectF;
            Matrix matrix;
            RectF rectF2;
            Matrix matrix2;
            RectF rectF3;
            Matrix matrix3;
            RectF rectF4;
            Bitmap bitmap2 = bitmap;
            Bitmap bitmap3 = bitmap;
            Bitmap bitmap4 = bitmap;
            Bitmap bitmap5 = bitmap;
            CardMaskView cardMaskView6 = this;
            float f8 = cardMaskView6.getConnerSize() / 2.0f;
            bitmap = rectF4;
            CardMaskView cardMaskView7 = this;
            float f9 = cardMaskView7.getFrame().top - f8;
            float f10 = cardMaskView7.getFrame().left - f8;
            f10 = cardMaskView7.getConnerSize() + f10;
            f2 = cardMaskView7.getFrame().top - f8;
            f2 = cardMaskView7.getConnerSize() + f2;
            rectF4 = new RectF(this.getFrame().left - f8, f9, f10, f2);
            Paint paint = cardMaskView6.getCornerPaint();
            canvas.drawBitmap(bitmap5, null, (RectF)bitmap, paint);
            bitmap = matrix3;
            new Matrix().setRotate(90.0f);
            int n = bitmap4.getWidth();
            int n2 = bitmap4.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap4, (int)0, (int)0, (int)n, (int)n2, (Matrix)bitmap, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(it, 0, 0, i\u2026 it.height, matrix, true)");
            RectF rectF5 = rectF3;
            CardMaskView cardMaskView8 = this;
            float f11 = cardMaskView8.getFrame().top - f8;
            f2 = cardMaskView8.getFrame().right - f8;
            f2 = cardMaskView8.getConnerSize() + f2;
            float f12 = cardMaskView8.getFrame().top - f8;
            f12 = cardMaskView8.getConnerSize() + f12;
            rectF3 = new RectF(this.getFrame().right - f8, f11, f2, f12);
            Paint paint3 = this.getCornerPaint();
            canvas.drawBitmap(bitmap, null, rectF5, paint3);
            bitmap = matrix2;
            new Matrix().setRotate(-90.0f);
            int n3 = bitmap3.getWidth();
            int n4 = bitmap3.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)0, (int)n3, (int)n4, (Matrix)bitmap, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(it, 0, 0, i\u2026 it.height, matrix, true)");
            RectF rectF6 = rectF2;
            CardMaskView cardMaskView9 = this;
            float f13 = cardMaskView9.getFrame().bottom - f8;
            f2 = cardMaskView9.getFrame().left - f8;
            f2 = cardMaskView9.getConnerSize() + f2;
            f12 = cardMaskView9.getFrame().bottom - f8;
            f12 = cardMaskView9.getConnerSize() + f12;
            rectF2 = new RectF(this.getFrame().left - f8, f13, f2, f12);
            Paint paint4 = this.getCornerPaint();
            canvas.drawBitmap(bitmap, null, rectF6, paint4);
            bitmap = matrix;
            new Matrix().setRotate(180.0f);
            int n5 = bitmap2.getWidth();
            int n6 = bitmap2.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n5, (int)n6, (Matrix)bitmap, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(it, 0, 0, i\u2026 it.height, matrix, true)");
            RectF rectF7 = rectF;
            float f14 = this.getFrame().right - f8;
            CardMaskView cardMaskView10 = this;
            float f15 = cardMaskView10.getFrame().bottom - f8;
            float f16 = cardMaskView10.getFrame().right - f8;
            f16 = cardMaskView10.getConnerSize() + f16;
            f8 = cardMaskView10.getFrame().bottom - f8;
            f8 = cardMaskView10.getConnerSize() + f8;
            rectF = new RectF(f14, f15, f16, f8);
            Paint paint5 = this.getCornerPaint();
            canvas.drawBitmap(bitmap, null, rectF7, paint5);
        }
    }

    @Override
    @NotNull
    public Bitmap crop(@NotNull Bitmap bitmap, int n) {
        CardMaskView cardMaskView = this;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"inputImage");
        bitmap = BitmapUtil.Companion.rotateBitmapToStraight$default(BitmapUtil.Companion, bitmap, n, false, 4, null);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        float f2 = (float)bitmap.getWidth() / (float)this.getWidth();
        float f3 = (float)bitmap.getHeight() / (float)this.getHeight();
        float f4 = Math.min(f2, f3);
        float f5 = cardMaskView.getTransparentFrame().left - this.getTransOffY();
        f5 = (cardMaskView.getTransOff() * (float)2 + f5) * f2;
        float f6 = cardMaskView.getTransparentFrame().top * f3;
        float f7 = cardMaskView.getTransparentFrame().width() * f4;
        f4 = cardMaskView.getTransparentFrame().height() * f4;
        Helpers.Companion companion = Helpers.Companion;
        Object[] objectArray = new Object[1];
        int n2 = n;
        CardMaskView cardMaskView2 = this;
        DisplayMetrics displayMetrics2 = displayMetrics;
        n = displayMetrics2.densityDpi;
        float f8 = displayMetrics2.density;
        float f9 = cardMaskView2.getTransOffY();
        float f10 = cardMaskView2.getTransOff();
        objectArray[0] = "Camera Degree: cameraDegree " + n2 + " " + n + " " + f8 + " scaleW " + f2 + " scaleH " + f3 + " transOffY " + f9 + " transOff " + f10;
        companion.printLog(objectArray);
        Object[] objectArray2 = new Object[1];
        CardMaskView cardMaskView3 = this;
        Bitmap bitmap2 = bitmap;
        CardMaskView cardMaskView4 = this;
        float f11 = cardMaskView4.getFrameHeight();
        f8 = cardMaskView4.getFrame().centerX();
        f9 = cardMaskView4.getFrame().centerY();
        int n3 = bitmap2.getWidth();
        int n4 = bitmap2.getHeight();
        int n5 = cardMaskView3.getWidth();
        int n6 = cardMaskView3.getHeight();
        float f12 = cardMaskView3.getCenterX();
        float f13 = cardMaskView3.getCenterY();
        float f14 = f11;
        CardMaskView cardMaskView5 = this;
        f11 = cardMaskView5.getFrame().width();
        float f15 = cardMaskView5.getFrame().height();
        float f16 = cardMaskView5.getFrame().top;
        float f17 = cardMaskView5.getFrame().left;
        float f18 = cardMaskView5.getFrame().centerX();
        float f19 = cardMaskView5.getFrame().centerY();
        objectArray2[0] = "frameWidth " + this.getFrameWidth() + " frameHeight " + f14 + " frame centerX " + f8 + " frame center Y " + f9 + " \n image.width " + n3 + " image.height " + n4 + " \n width " + n5 + " height " + n6 + " centerX " + f12 + " centerY " + f13 + "\n frame " + f11 + " height() " + f15 + " top() " + f16 + "  left() " + f17 + " center X " + f18 + " center Y " + f19;
        companion.printLog(objectArray2);
        KalapaSDK.Companion companion2 = KalapaSDK.Companion;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        if (companion2.isFoldOpen(context)) {
            companion.printLog("Crop on Foldable is open");
            float f20 = f6 + f4;
            if (Math.abs(this.getTransOffY()) + f20 <= (float)bitmap.getHeight()) {
                f4 = Math.abs(this.getTransOffY()) + f4;
            }
            if (f6 + f4 > (float)bitmap.getHeight()) {
                f4 = (float)bitmap.getHeight() - f6;
            }
            int n7 = (int)f6;
            int n8 = bitmap.getWidth();
            int n9 = (int)f4;
            Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)n7, (int)n8, (int)n9);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(\n          \u2026rop.toInt()\n            )");
            return bitmap3;
        }
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        if (companion2.isTablet(context2)) {
            float f21;
            float f22;
            float f23;
            companion.printLog("Crop on Tablet");
            float f24 = 40;
            f8 = f5 - f24 * f2;
            if (f23 > 0.0f) {
                f5 = f8;
            }
            f24 = f6 - f24 * f3;
            if (f22 > 0.0f) {
                f6 = f24;
            }
            float f25 = this.getTransparentFrame().width();
            f25 = Math.max(f2, f3) * f25;
            f24 = this.getTransparentFrame().height();
            f24 = Math.max(f2, f3) * f24;
            if (f6 + f21 > (float)bitmap.getHeight()) {
                f24 = (float)bitmap.getHeight() - f6;
            }
            if (f5 + f25 > (float)bitmap.getWidth()) {
                f25 = (float)bitmap.getWidth() - f5;
            }
            int n10 = (int)f5;
            int n11 = (int)f6;
            int n12 = (int)f25;
            int n13 = (int)f24;
            Bitmap bitmap4 = Bitmap.createBitmap((Bitmap)bitmap, (int)n10, (int)n11, (int)n12, (int)n13);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"createBitmap(\n          \u2026rop.toInt()\n            )");
            return bitmap4;
        }
        float f26 = f5 - 0.0f;
        float f27 = f26 == 0.0f ? 0 : (f26 < 0.0f ? -1 : 1);
        int n14 = f27 >= 0 && !(f5 + f7 > (float)bitmap.getWidth()) ? 0 : 1;
        float f28 = f6 - 0.0f;
        float f29 = f28 == 0.0f ? 0 : (f28 < 0.0f ? -1 : 1);
        boolean bl = f29 < 0 || f6 + f4 > (float)bitmap.getHeight();
        if (n14 == 0 && !bl) {
            f27 = (int)f5;
            int n15 = (int)f6;
            n14 = (int)f7;
            f29 = (int)f4;
            Bitmap bitmap5 = Bitmap.createBitmap((Bitmap)bitmap, (int)f27, (int)n15, (int)n14, (int)f29);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap5, (String)"createBitmap(\n          \u2026rop.toInt()\n            )");
            return bitmap5;
        }
        if (n14 != 0) {
            if (f29 < 0) {
                f6 = 0.0f;
            }
            int n16 = (int)((float)bitmap.getWidth() * 1.0f * (float)ID_CARD_HEIGHT_SIZE / (float)ID_CARD_WIDTH_SIZE);
            f27 = n16;
            if (f6 + (float)n16 > (float)bitmap.getHeight()) {
                f27 = bitmap.getHeight();
            }
            Bitmap bitmap6 = bitmap;
            int n17 = (int)f6;
            n14 = bitmap6.getWidth();
            Bitmap bitmap7 = Bitmap.createBitmap((Bitmap)bitmap6, (int)0, (int)n17, (int)n14, (int)f27);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap7, (String)"createBitmap(image, 0, y\u2026, image.width, newHeight)");
            return bitmap7;
        }
        if (f27 < 0) {
            f5 = 0.0f;
        }
        int n18 = (int)((float)bitmap.getHeight() * 1.0f * (float)ID_CARD_WIDTH_SIZE / (float)ID_CARD_HEIGHT_SIZE);
        f27 = n18;
        if (f6 + (float)n18 > (float)bitmap.getWidth()) {
            f27 = bitmap.getWidth();
        }
        Bitmap bitmap8 = bitmap;
        int n19 = (int)f5;
        n14 = bitmap8.getHeight();
        Bitmap bitmap9 = Bitmap.createBitmap((Bitmap)bitmap8, (int)n19, (int)0, (int)f27, (int)n14);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap9, (String)"createBitmap(image, xCro\u2026, newWidth, image.height)");
        return bitmap9;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final int getID_CARD_WIDTH_SIZE() {
            return ID_CARD_WIDTH_SIZE;
        }

        public final int getID_CARD_HEIGHT_SIZE() {
            return ID_CARD_HEIGHT_SIZE;
        }
    }
}

