package vn.kalapa.ekyc.handlers

import android.content.Context
import android.os.AsyncTask
import vn.kalapa.ekyc.models.KalapaAllLanguageModel
import vn.kalapa.ekyc.utils.Common
import vn.kalapa.ekyc.utils.Helpers
import java.io.BufferedReader
import java.io.InputStreamReader
import java.lang.ref.WeakReference
import java.net.HttpURLConnection
import java.net.URL

class GetDynamicLanguageHandler() : AsyncTask<String, Void, KalapaAllLanguageModel?>() {

    @Deprecated("Deprecated in Java")
    override fun doInBackground(vararg params: String?): KalapaAllLanguageModel? {
        return try {
            getDynamicLanguage(params[0]!!)?.let { it1 -> KalapaAllLanguageModel.fromJson(it1) }
        } catch (exception: Exception) {
            null
        }
    }

    private fun getDynamicLanguage(baseUrl: String): String? {
        val url = URL("$baseUrl/api/language")
        var body = ""
        Helpers.printLog("\nSent 'GET' request to URL : $url")
        with(url.openConnection() as HttpURLConnection) {
            requestMethod = "GET"
            connect()
            Helpers.printLog("\nSent 'GET' request to URL : $url; Response Code : $responseCode")
            if (responseCode == 200) {
                val reader = BufferedReader(InputStreamReader(inputStream))
                body = reader.readText()
                reader.close()
            } else {
                Helpers.printLog("GET request not worked")
            }
        }
        return body.ifEmpty { null }
    }


}