/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.Salsa20Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SCrypt {
    private SCrypt() {
    }

    public static byte[] generate(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
        if (byArray != null) {
            if (byArray2 != null) {
                if (n > 1 && SCrypt.isPowerOf2(n)) {
                    if (n2 == 1 && n >= 65536) {
                        throw new IllegalArgumentException("Cost parameter N must be > 1 and < 65536.");
                    }
                    if (n2 >= 1) {
                        int n5 = Integer.MAX_VALUE / (n2 * 128 * 8);
                        if (n3 >= 1 && n3 <= n5) {
                            if (n4 >= 1) {
                                return SCrypt.MFcrypt(byArray, byArray2, n, n2, n3, n4);
                            }
                            throw new IllegalArgumentException("Generated key length dkLen must be >= 1.");
                        }
                        throw new IllegalArgumentException("Parallelisation parameter p must be >= 1 and <= " + n5 + " (based on block size r of " + n2 + ")");
                    }
                    throw new IllegalArgumentException("Block size r must be >= 1.");
                }
                throw new IllegalArgumentException("Cost parameter N must be > 1 and a power of 2");
            }
            throw new IllegalArgumentException("Salt S must be provided.");
        }
        throw new IllegalArgumentException("Passphrase P must be provided.");
    }

    private static byte[] MFcrypt(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
        byte[] byArray3;
        int n5;
        int n6 = n2 * 128;
        byte[] byArray4 = SCrypt.SingleIterationPBKDF2(byArray, byArray2, n3 * n6);
        int[] nArray = null;
        int n7 = byArray4.length >>> 2;
        nArray = new int[n7];
        Pack.littleEndianToInt(byArray4, 0, nArray);
        int n8 = 0;
        for (n5 = n * n2; n - n8 > 2 && n5 > 1024; n5 >>>= 1) {
            ++n8;
        }
        n6 >>>= 2;
        for (n5 = 0; n5 < n7; n5 += n6) {
            SCrypt.SMix(nArray, n5, n, n8, n2);
            continue;
        }
        try {
            Pack.intToLittleEndian(nArray, byArray4, 0);
            byArray3 = SCrypt.SingleIterationPBKDF2(byArray, byArray4, n4);
        }
        catch (Throwable throwable) {
            SCrypt.Clear(byArray4);
            SCrypt.Clear(nArray);
            throw throwable;
        }
        SCrypt.Clear(byArray4);
        SCrypt.Clear(nArray);
        return byArray3;
    }

    private static byte[] SingleIterationPBKDF2(byte[] byArray, byte[] byArray2, int n) {
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator2 = pKCS5S2ParametersGenerator;
        pKCS5S2ParametersGenerator2(new SHA256Digest());
        pKCS5S2ParametersGenerator2.init(byArray, byArray2, 1);
        return ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedMacParameters(n * 8)).getKey();
    }

    private static void SMix(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n2;
        int n7 = Integers.numberOfTrailingZeros(n6);
        int n8 = n6 >>> n3;
        int n9 = 1 << n3;
        int n10 = n3;
        n3 = n8 - 1;
        n7 -= n10;
        int n11 = n4 * 32;
        int[] nArray2 = new int[16];
        int[] nArray3 = new int[16];
        int[] nArray4 = new int[n11];
        int[] nArray5 = new int[n11];
        int[][] nArrayArray = new int[n9][];
        System.arraycopy(nArray, n, nArray5, 0, n11);
        for (n5 = 0; n5 < n9; ++n5) {
            int[] nArray6 = new int[n8 * n11];
            nArrayArray[n5] = nArray6;
            int n12 = 0;
            for (int k = 0; k < n8; k += 2) {
                int[] nArray7 = nArray4;
                int[] nArray8 = nArray2;
                System.arraycopy(nArray5, 0, nArray6, n12, n11);
                n12 += n11;
                SCrypt.BlockMix(nArray5, nArray2, nArray3, nArray4, n4);
                System.arraycopy(nArray4, 0, nArray6, n12, n11);
                n12 += n11;
                SCrypt.BlockMix(nArray7, nArray8, nArray3, nArray5, n4);
                continue;
            }
        }
        n8 = n2 - 1;
        for (n9 = 0; n9 < n2; ++n9) {
            n5 = nArray5[n11 - 16] & n8;
            int[] nArray9 = nArrayArray[n5 >>> n7];
            System.arraycopy(nArray9, (n5 & n3) * n11, nArray4, 0, n11);
            SCrypt.Xor(nArray4, nArray5, 0, nArray4);
            SCrypt.BlockMix(nArray4, nArray2, nArray3, nArray5, n4);
            continue;
        }
        try {
            System.arraycopy(nArray5, 0, nArray, n, n11);
            SCrypt.ClearAll(nArrayArray);
        }
        catch (Throwable throwable) {
            SCrypt.ClearAll(nArrayArray);
            SCrypt.ClearAll(new int[][]{nArray5, nArray2, nArray3, nArray4});
            throw throwable;
        }
        SCrypt.ClearAll(new int[][]{nArray5, nArray2, nArray3, nArray4});
    }

    private static void BlockMix(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n) {
        int n2 = n;
        int[] nArray5 = nArray;
        System.arraycopy(nArray5, nArray5.length - 16, nArray2, 0, 16);
        n = 0;
        int n3 = 0;
        int n4 = nArray.length >>> 1;
        for (int k = (v341477) * 2; k > 0; --k) {
            SCrypt.Xor(nArray2, nArray, n, nArray3);
            Salsa20Engine.salsaCore(8, nArray3, nArray2);
            System.arraycopy(nArray2, 0, nArray4, n3, 16);
            n3 = n4 + n - n3;
            n += 16;
        }
    }

    private static void Xor(int[] nArray, int[] nArray2, int n, int[] nArray3) {
        for (int k = nArray3.length - 1; k >= 0; --k) {
            nArray3[k] = nArray[k] ^ nArray2[n + k];
        }
    }

    private static void Clear(byte[] byArray) {
        if (byArray != null) {
            Arrays.fill(byArray, (byte)0);
        }
    }

    private static void Clear(int[] nArray) {
        if (nArray != null) {
            Arrays.fill(nArray, 0);
        }
    }

    private static void ClearAll(int[][] nArray) {
        for (int k = 0; k < nArray.length; ++k) {
            SCrypt.Clear(nArray[k]);
        }
    }

    private static boolean isPowerOf2(int n) {
        int n2 = n;
        return (n2 & n2 - 1) == 0;
    }
}

