/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.ElGamalParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ElGamalParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ElGamalPrivateKeySpec;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Enumeration;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;

public class JCEElGamalPrivateKey
implements ElGamalPrivateKey,
DHPrivateKey,
PKCS12BagAttributeCarrier {
    public static final long serialVersionUID = 4819350091141529678L;
    public BigInteger x;
    public ElGamalParameterSpec elSpec;
    private PKCS12BagAttributeCarrierImpl attrCarrier;

    public JCEElGamalPrivateKey() {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        v1.attrCarrier = pKCS12BagAttributeCarrier;
    }

    public JCEElGamalPrivateKey(ElGamalPrivateKey elGamalPrivateKey) {
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.x = elGamalPrivateKey.getX();
        this.elSpec = elGamalPrivateKey.getParameters();
    }

    public JCEElGamalPrivateKey(DHPrivateKey dHPrivateKey) {
        JCEElGamalPrivateKey jCEElGamalPrivateKey = this;
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        jCEElGamalPrivateKey.x = dHPrivateKey.getX();
        jCEElGamalPrivateKey.elSpec = new ElGamalParameterSpec(dHPrivateKey.getParams().getP(), dHPrivateKey.getParams().getG());
    }

    public JCEElGamalPrivateKey(ElGamalPrivateKeySpec elGamalPrivateKeySpec) {
        JCEElGamalPrivateKey jCEElGamalPrivateKey = this;
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        jCEElGamalPrivateKey.x = elGamalPrivateKeySpec.getX();
        jCEElGamalPrivateKey.elSpec = new ElGamalParameterSpec(elGamalPrivateKeySpec.getParams().getP(), elGamalPrivateKeySpec.getParams().getG());
    }

    public JCEElGamalPrivateKey(DHPrivateKeySpec dHPrivateKeySpec) {
        JCEElGamalPrivateKey jCEElGamalPrivateKey = serializable;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        jCEElGamalPrivateKey.x = dHPrivateKeySpec.getX();
        DHPrivateKeySpec dHPrivateKeySpec2 = dHPrivateKeySpec;
        Serializable serializable = dHPrivateKeySpec2.getP();
        jCEElGamalPrivateKey.elSpec = new ElGamalParameterSpec((BigInteger)serializable, dHPrivateKeySpec2.getG());
    }

    public JCEElGamalPrivateKey(PrivateKeyInfo privateKeyInfo) {
        JCEElGamalPrivateKey jCEElGamalPrivateKey = object;
        PrivateKeyInfo privateKeyInfo2 = privateKeyInfo;
        ((JCEElGamalPrivateKey)object).attrCarrier = new PKCS12BagAttributeCarrierImpl();
        Object object = ElGamalParameter.getInstance(privateKeyInfo2.getPrivateKeyAlgorithm().getParameters());
        jCEElGamalPrivateKey.x = ASN1Integer.getInstance(privateKeyInfo2.parsePrivateKey()).getValue();
        Object object2 = object;
        object = ((ElGamalParameter)object2).getP();
        jCEElGamalPrivateKey.elSpec = new ElGamalParameterSpec((BigInteger)object, ((ElGamalParameter)object2).getG());
    }

    public JCEElGamalPrivateKey(ElGamalPrivateKeyParameters elGamalPrivateKeyParameters) {
        JCEElGamalPrivateKey jCEElGamalPrivateKey = this;
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        jCEElGamalPrivateKey.x = elGamalPrivateKeyParameters.getX();
        jCEElGamalPrivateKey.elSpec = new ElGamalParameterSpec(elGamalPrivateKeyParameters.getParameters().getP(), elGamalPrivateKeyParameters.getParameters().getG());
    }

    private void readObject(ObjectInputStream objectInputStream) {
        JCEElGamalPrivateKey jCEElGamalPrivateKey = this;
        jCEElGamalPrivateKey.x = (BigInteger)objectInputStream.readObject();
        jCEElGamalPrivateKey.elSpec = new ElGamalParameterSpec((BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.getX());
        objectOutputStream.writeObject(this.elSpec.getP());
        objectOutputStream.writeObject(this.elSpec.getG());
    }

    @Override
    public String getAlgorithm() {
        return "ElGamal";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return KeyUtil.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(this.elSpec.getP(), this.elSpec.getG())), new ASN1Integer(this.getX()));
    }

    @Override
    public ElGamalParameterSpec getParameters() {
        return this.elSpec;
    }

    @Override
    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.elSpec.getP(), this.elSpec.getG());
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }
}

