/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat160;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP160R1Field {
    private static final long M = 0xFFFFFFFFL;
    public static final int[] P = new int[]{Integer.MAX_VALUE, -1, -1, -1, -1};
    private static final int[] PExt = new int[]{1, 0x40000001, 0, 0, 0, -2, -2, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-1, -1073741826, -1, -1, -1, 1, 1};
    private static final int P4 = -1;
    private static final int PExt9 = -1;
    private static final int PInv = -2147483647;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat160.add(nArray, nArray2, nArray3) != 0 || nArray3[4] == -1 && Nat160.gte(nArray3, P)) {
            Nat.addWordTo(5, -2147483647, nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat.add(10, nArray, nArray2, nArray3) != 0 || nArray3[9] == -1 && Nat.gte(10, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.incAt(10, nArray3, n);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(5, nArray, nArray2) != 0 || nArray2[4] == -1 && Nat160.gte(nArray2, P)) {
            Nat.addWordTo(5, -2147483647, nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray = Nat160.fromBigInteger((BigInteger)object);
        object = nArray;
        if (nArray[4] == -1) {
            int[] nArray2 = P;
            if (Nat160.gte((int[])object, P)) {
                Nat160.subFrom(nArray2, (int[])object);
            }
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(5, nArray, 0, nArray2);
        } else {
            int n = Nat160.add(nArray, P, nArray2);
            Nat.shiftDownBit(5, nArray2, n);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int k = 0; k < 5; ++k) {
            n |= nArray[k];
        }
        return (n >>> 1 | n & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat160.createExt();
        Nat160.mul(nArray, nArray2, nArray4);
        SecP160R1Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat160.mulAddTo(nArray, nArray2, nArray3) != 0 || nArray3[9] == -1 && Nat.gte(10, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.incAt(10, nArray3, n);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP160R1Field.isZero(nArray) != 0) {
            Nat160.sub(P, P, nArray2);
        } else {
            Nat160.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[20];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 5);
        } while (Nat.lessThan(5, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP160R1Field.random(secureRandom, nArray);
        } while (SecP160R1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l = (long)nArray[5] & 0xFFFFFFFFL;
        long l2 = (long)nArray[6] & 0xFFFFFFFFL;
        long l3 = (long)nArray[7] & 0xFFFFFFFFL;
        long l4 = (long)nArray[8] & 0xFFFFFFFFL;
        long l5 = (long)nArray[9] & 0xFFFFFFFFL;
        l = ((long)nArray[0] & 0xFFFFFFFFL) + l + (l << 31) + 0L;
        nArray2[0] = (int)l;
        l >>>= 32;
        l = ((long)nArray[1] & 0xFFFFFFFFL) + l2 + (l2 << 31) + l;
        nArray2[1] = (int)l;
        l >>>= 32;
        l = ((long)nArray[2] & 0xFFFFFFFFL) + l3 + (l3 << 31) + l;
        nArray2[2] = (int)l;
        l >>>= 32;
        l = ((long)nArray[3] & 0xFFFFFFFFL) + l4 + (l4 << 31) + l;
        nArray2[3] = (int)l;
        l >>>= 32;
        l = ((long)nArray[4] & 0xFFFFFFFFL) + l5 + (l5 << 31) + l;
        nArray2[4] = (int)l;
        SecP160R1Field.reduce32((int)(l >>> 32), nArray2);
    }

    public static void reduce32(int n, int[] nArray) {
        if (n != 0 && Nat160.mulWordsAdd(-2147483647, n, nArray, 0) != 0 || nArray[4] == -1 && Nat160.gte(nArray, P)) {
            Nat.addWordTo(5, -2147483647, nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat160.createExt();
        Nat160.square(nArray, nArray3);
        SecP160R1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat160.createExt();
        Nat160.square(nArray, nArray3);
        SecP160R1Field.reduce(nArray3, nArray2);
        while ((n += -1) > 0) {
            Nat160.square(nArray2, nArray3);
            SecP160R1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat160.sub(nArray, nArray2, nArray3) != 0) {
            Nat.subWordFrom(5, -2147483647, nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(10, nArray, nArray2, nArray3) != 0 && Nat.subFrom(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.decAt(10, nArray3, n);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(5, nArray, 0, nArray2) != 0 || nArray2[4] == -1 && Nat160.gte(nArray2, P)) {
            Nat.addWordTo(5, -2147483647, nArray2);
        }
    }
}

