/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.qtesla;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.QTESLAParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static final Map catLookup = new HashMap<String, Integer>();
    private QTESLAKeyGenerationParameters param;
    private QTESLAKeyPairGenerator engine = new QTESLAKeyPairGenerator();
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("qTESLA");
    }

    static {
        catLookup.put(QTESLASecurityCategory.getName(5), Integers.valueOf(5));
        catLookup.put(QTESLASecurityCategory.getName(6), Integers.valueOf(6));
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec object, SecureRandom secureRandom) {
        if (object instanceof QTESLAParameterSpec) {
            QTESLAKeyGenerationParameters qTESLAKeyGenerationParameters;
            KeyPairGeneratorSpi keyPairGeneratorSpi = qTESLAParameterSpec;
            QTESLAParameterSpec qTESLAParameterSpec = (QTESLAParameterSpec)object;
            object = qTESLAKeyGenerationParameters;
            keyPairGeneratorSpi.param = new QTESLAKeyGenerationParameters((Integer)catLookup.get(qTESLAParameterSpec.getSecurityCategory()), secureRandom);
            keyPairGeneratorSpi.engine.init((KeyGenerationParameters)object);
            keyPairGeneratorSpi.initialised = true;
            return;
        }
        throw new InvalidAlgorithmParameterException("parameter object not a QTESLAParameterSpec");
    }

    @Override
    public KeyPair generateKeyPair() {
        BCqTESLAPrivateKey bCqTESLAPrivateKey;
        Object object;
        if (!((KeyPairGeneratorSpi)object2).initialised) {
            QTESLAKeyGenerationParameters qTESLAKeyGenerationParameters;
            object = qTESLAKeyGenerationParameters;
            ((KeyPairGeneratorSpi)object2).param = new QTESLAKeyGenerationParameters(6, ((KeyPairGeneratorSpi)object2).random);
            ((KeyPairGeneratorSpi)object2).engine.init((KeyGenerationParameters)object);
            ((KeyPairGeneratorSpi)object2).initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = ((KeyPairGeneratorSpi)object2).engine.generateKeyPair();
        Object object2 = (QTESLAPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        object = (QTESLAPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BCqTESLAPublicKey bCqTESLAPublicKey = new BCqTESLAPublicKey((QTESLAPublicKeyParameters)object2);
        object2 = bCqTESLAPrivateKey;
        bCqTESLAPrivateKey = new BCqTESLAPrivateKey((QTESLAPrivateKeyParameters)object);
        return new KeyPair(bCqTESLAPublicKey, (PrivateKey)object2);
    }
}

