/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import b.b;
import com.fis.ekyc.nfc.build_in.cvc.AbstractDataField;
import com.fis.ekyc.nfc.build_in.cvc.CVCTagEnum;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateField
extends AbstractDataField {
    private static final long serialVersionUID = 6092901788235446614L;
    private static final int DATE_ARRAY_SIZE = 6;
    private static final TimeZone GMTTIMEZONE;
    private static final DateFormat FORMAT_PRINTABLE;
    private Date date;

    public DateField(CVCTagEnum cVCTagEnum) {
        super(cVCTagEnum);
    }

    public DateField(CVCTagEnum cVCTagEnum, Date date) {
        this(cVCTagEnum);
        Calendar calendar = Calendar.getInstance(GMTTIMEZONE);
        calendar.setTimeInMillis(date.getTime());
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        calendar.clear();
        calendar.set(n, n2, n3);
        this.date = calendar.getTime();
    }

    public DateField(CVCTagEnum object, byte[] byArray) {
        this((CVCTagEnum)((Object)object));
        if (byArray != null && byArray.length == 6) {
            int n = byArray[0] * 10 + 2000 + byArray[1];
            int n2 = byArray[2] * 10 + byArray[3] - 1;
            int n3 = byArray[4] * 10 + byArray[5];
            Calendar calendar = Calendar.getInstance(GMTTIMEZONE);
            calendar.clear();
            if (object == CVCTagEnum.EFFECTIVE_DATE) {
                calendar.set(n, n2, n3, 0, 0, 0);
            } else {
                calendar.set(n, n2, n3, 23, 59, 59);
            }
            this.date = calendar.getTime();
            return;
        }
        StringBuilder stringBuilder = b.a("data argument must have length 6, was ");
        int n = byArray == null ? 0 : byArray.length;
        Object object2 = object;
        super(stringBuilder.append(n).toString());
        throw object2;
    }

    static {
        TimeZone timeZone;
        GMTTIMEZONE = timeZone = TimeZone.getTimeZone("GMT");
        FORMAT_PRINTABLE = new SimpleDateFormat("yyyy-MM-dd");
        FORMAT_PRINTABLE.setTimeZone(timeZone);
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public byte[] getEncoded() {
        byte[] byArray = new byte[6];
        byte[] byArray2 = byArray;
        Calendar calendar = Calendar.getInstance(GMTTIMEZONE);
        calendar.setTimeInMillis(this.date.getTime());
        int n = calendar.get(1) - 2000;
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        byArray2[0] = (byte)(n / 10);
        byArray2[1] = (byte)(n % 10);
        byArray2[2] = (byte)(n2 / 10);
        byArray2[3] = (byte)(n2 % 10);
        byArray2[4] = (byte)(n3 / 10);
        byArray[5] = (byte)(n3 % 10);
        return byArray;
    }

    @Override
    public String valueAsText() {
        return FORMAT_PRINTABLE.format(this.date);
    }
}

